/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Console$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t]w!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00027pORR'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\r1{wmZ3s\u0011\u0019\u0019\u0013\u0002)A\u00051\u00059An\\4hKJ\u0004\u0003\"B\u0013\n\t\u00031\u0013\u0001B7bS:$\"a\n\u0016\u0011\u00055A\u0013BA\u0015\u000f\u0005\u0011)f.\u001b;\t\u000b-\"\u0003\u0019\u0001\u0017\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005\u0015\t%O]1z!\t\u0001tG\u0004\u00022kA\u0011!GD\u0007\u0002g)\u0011AGB\u0001\u0007yI|w\u000e\u001e \n\u0005Yr\u0011A\u0002)sK\u0012,g-\u0003\u00029s\t11\u000b\u001e:j]\u001eT!A\u000e\b\t\rmJA\u0011\u0001\u0002=\u0003-\u0001(/\u001b8u\u0011\u0016\fG-\u001a:\u0015\u0007\u001dj$\tC\u0003?u\u0001\u0007q(A\ttQ><H)\u001a;bS2,Gm\u0015;biN\u0004\"!\u0004!\n\u0005\u0005s!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0007j\u0002\raP\u0001\u000fkN,w\n\u001c3D_:\u001cX/\\3s\u0011\u0015)\u0015\u0002\"\u0001G\u0003\u001d\u0019wN\\:v[\u0016$bbJ$VA\u0016<'1\u0001B\f\u00057\u0011y\u0002C\u0003I\t\u0002\u0007\u0011*\u0001\u0005d_:\u001cX/\\3s!\u0011Qu*U)\u000e\u0003-S!\u0001\u0013'\u000b\u00055s\u0015aB2mS\u0016tGo\u001d\u0006\u0003\u000bqI!\u0001U&\u0003\u001b-\u000bgm[1D_:\u001cX/\\3s!\riQF\u0015\t\u0003\u001bMK!\u0001\u0016\b\u0003\t\tKH/\u001a\u0005\u0006-\u0012\u0003\raV\u0001\u0007i>\u0004\u0018nY:\u0011\u0007akvF\u0004\u0002Z7:\u0011!GW\u0005\u0002\u001f%\u0011ALD\u0001\ba\u0006\u001c7.Y4f\u0013\tqvL\u0001\u0003MSN$(B\u0001/\u000f\u0011\u0015\tG\t1\u0001c\u0003\u0015\u0019w.\u001e8u!\ti1-\u0003\u0002e\u001d\t!Aj\u001c8h\u0011\u00151G\t1\u0001c\u0003\u001d!\u0018.\\3pkRDQ\u0001\u001b#A\u0002%\faaY8oM&<\u0007C\u00016l\u001b\u0005Ia\u0001\u00027\n\u00015\u0014!cQ8ogVlWM\u001d)fe\u001a\u001cuN\u001c4jON\u00111N\u001c\t\u0003\u0011=L!\u0001\u001d\u0002\u0003\u0015A+'OZ\"p]\u001aLw\r\u0003\u0005,W\n\u0005\t\u0015!\u0003-\u0011\u0015\u00192\u000e\"\u0001t)\tIG\u000fC\u0003,e\u0002\u0007A\u0006C\u0004wW\n\u0007I\u0011A<\u0002\u0019i\\7i\u001c8oK\u000e$x\n\u001d;\u0016\u0003a\u00042!\u001f?0\u001b\u0005Q(\"A>\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002~u\nY\u0012I]4v[\u0016tG/Q2dKB$\u0018N\\4PaRLwN\\*qK\u000eDaa`6!\u0002\u0013A\u0018!\u0004>l\u0007>tg.Z2u\u001fB$\b\u0005\u0003\u0005\u0002\u0004-\u0014\r\u0011\"\u0001x\u0003M\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148o\u00149u\u0011\u001d\t9a\u001bQ\u0001\na\fACY8piN$(/\u00199TKJ4XM]:PaR\u0004\u0003\u0002CA\u0006W\n\u0007I\u0011A<\u0002\u0011Q|\u0007/[2PaRDq!a\u0004lA\u0003%\u00010A\u0005u_BL7m\u00149uA!A\u00111C6C\u0002\u0013\u0005q/\u0001\u0006he>,\b/\u00133PaRDq!a\u0006lA\u0003%\u00010A\u0006he>,\b/\u00133PaR\u0004\u0003\"CA\u000eW\n\u0007I\u0011AA\u000f\u000311W\r^2i'&TXm\u00149u+\t\ty\u0002\u0005\u0003zy\u0006\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0005Y\u0006twM\u0003\u0002\u0002,\u0005!!.\u0019<b\u0013\u0011\ty#!\n\u0003\u000f%sG/Z4fe\"A\u00111G6!\u0002\u0013\ty\"A\u0007gKR\u001c\u0007nU5{K>\u0003H\u000f\t\u0005\n\u0003oY'\u0019!C\u0001\u0003s\tqC]3tKR\u0014UmZ5o]&twm\u00144gg\u0016$x\n\u001d;\u0016\u0005\u0005m\u0002cA=\u0002>%\u0019\u0011q\b>\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'\u000f\u0003\u0005\u0002D-\u0004\u000b\u0011BA\u001e\u0003a\u0011Xm]3u\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fi>\u0003H\u000f\t\u0005\n\u0003\u000fZ'\u0019!C\u0001\u0003;\t1c]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3PaRD\u0001\"a\u0013lA\u0003%\u0011qD\u0001\u0015g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016|\u0005\u000f\u001e\u0011\t\u0013\u0005=3N1A\u0005\u0002\u0005u\u0011!\u00048v[RC'/Z1eg>\u0003H\u000f\u0003\u0005\u0002T-\u0004\u000b\u0011BA\u0010\u00039qW/\u001c+ie\u0016\fGm](qi\u0002B\u0011\"a\u0016l\u0005\u0004%\t!!\b\u0002\u001d9,XNR3uG\",'o](qi\"A\u00111L6!\u0002\u0013\ty\"A\bok64U\r^2iKJ\u001cx\n\u001d;!\u0011%\tyf\u001bb\u0001\n\u0003\tI$\u0001\boK^\u001cuN\\:v[\u0016\u0014x\n\u001d;\t\u0011\u0005\r4\u000e)A\u0005\u0003w\tqB\\3x\u0007>t7/^7fe>\u0003H\u000f\t\u0005\t\u0003OZ'\u0019!C\u0001o\u0006\t2m\u001c8tk6,'oQ8oM&<w\n\u001d;\t\u000f\u0005-4\u000e)A\u0005q\u0006\u00112m\u001c8tk6,'oQ8oM&<w\n\u001d;!\u0011%\tyg\u001bb\u0001\n\u0003\tI$A\bqe&tG/T3ue&\u001c7o\u00149u\u0011!\t\u0019h\u001bQ\u0001\n\u0005m\u0012\u0001\u00059sS:$X*\u001a;sS\u000e\u001cx\n\u001d;!\u0011%\t9h\u001bb\u0001\n\u0003\tI$\u0001\u000btQ><H)\u001a;bS2,Gm\u0015;biN|\u0005\u000f\u001e\u0005\t\u0003wZ\u0007\u0015!\u0003\u0002<\u0005)2\u000f[8x\t\u0016$\u0018-\u001b7fIN#\u0018\r^:PaR\u0004\u0003\"CA@W\n\u0007I\u0011AAA\u0003\u001dy\u0007\u000f^5p]N,\"!a!\u0011\u0007e\f))C\u0002\u0002\bj\u0014\u0011b\u00149uS>t7+\u001a;\t\u0011\u0005-5\u000e)A\u0005\u0003\u0007\u000b\u0001b\u001c9uS>t7\u000f\t\u0005\t\u0007.\u0014\r\u0011\"\u0001\u0002\u0010V\tq\bC\u0004\u0002\u0014.\u0004\u000b\u0011B \u0002\u001fU\u001cXm\u00147e\u0007>t7/^7fe\u0002B\u0011\"a&l\u0005\u0004%\t!a$\u0002\u0019A\u0014\u0018N\u001c;NKR\u0014\u0018nY:\t\u000f\u0005m5\u000e)A\u0005\u007f\u0005i\u0001O]5oi6+GO]5dg\u0002B\u0011\"a(l\u0005\u0004%\t!!)\u0002\u000bA\u0014x\u000e]:\u0016\u0005\u0005\r\u0006\u0003BAS\u0003Wk!!a*\u000b\t\u0005%\u0016\u0011F\u0001\u0005kRLG.\u0003\u0003\u0002.\u0006\u001d&A\u0003)s_B,'\u000f^5fg\"A\u0011\u0011W6!\u0002\u0013\t\u0019+\u0001\u0004qe>\u00048\u000f\t\u0005\n\u0003k['\u0019!C\u0001\u0003o\u000b!B\\;n)\"\u0014X-\u00193t+\t\tI\fE\u0002\u000e\u0003wK1!!0\u000f\u0005\rIe\u000e\u001e\u0005\t\u0003\u0003\\\u0007\u0015!\u0003\u0002:\u0006Ya.^7UQJ,\u0017\rZ:!\u0011%\t)m\u001bb\u0001\n\u0003\t9-A\u0003u_BL7-F\u00010\u0011\u001d\tYm\u001bQ\u0001\n=\na\u0001^8qS\u000e\u0004\u0003\"CAhW\n\u0007I\u0011AAi\u0003-qW/\\'fgN\fw-Z:\u0016\u0003\tDq!!6lA\u0003%!-\u0001\u0007ok6lUm]:bO\u0016\u001c\b\u0005C\u0005\u0002Z.\u0014\r\u0011\"\u0001\u00028\u0006\t\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197\t\u0011\u0005u7\u000e)A\u0005\u0003s\u000b!C]3q_J$\u0018N\\4J]R,'O^1mA!Aah\u001bb\u0001\n\u0003\ty\tC\u0004\u0002d.\u0004\u000b\u0011B \u0002%MDwn\u001e#fi\u0006LG.\u001a3Ti\u0006$8\u000f\t\u0005\n\u0003O\\'\u0019!C\u0001\u0003S\f!\u0002Z1uK\u001a{'/\\1u+\t\tY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\u0011\t\t0!\u000b\u0002\tQ,\u0007\u0010^\u0005\u0005\u0003k\fyO\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\"A\u0011\u0011`6!\u0002\u0013\tY/A\u0006eCR,gi\u001c:nCR\u0004\u0003\"CA\u007fW\n\u0007I\u0011AAH\u0003)A\u0017\u000eZ3IK\u0006$WM\u001d\u0005\b\u0005\u0003Y\u0007\u0015!\u0003@\u0003-A\u0017\u000eZ3IK\u0006$WM\u001d\u0011\t\u000f\t\u0015A\t1\u0001\u0003\b\u0005\tBo\u001c;bY6+7o]1hKN\u0014V-\u00193\u0011\t\t%!1C\u0007\u0003\u0005\u0017QAA!\u0004\u0003\u0010\u00051\u0011\r^8nS\u000eTAA!\u0005\u0002(\u0006Q1m\u001c8dkJ\u0014XM\u001c;\n\t\tU!1\u0002\u0002\u000b\u0003R|W.[2M_:<\u0007b\u0002B\r\t\u0002\u0007!qA\u0001\u000fi>$\u0018\r\u001c\"zi\u0016\u001c(+Z1e\u0011\u001d\u0011i\u0002\u0012a\u0001\u0005\u000f\t\u0001B[8j]RKW.\u001a\u0005\u0007\u0005C!\u0005\u0019\u00012\u0002\u001bQ,7\u000f^*uCJ$H+[7f\u0011\u001d\u0011)#\u0003C\u0001\u0005O\t\u0001\u0004\u001d:j]R|E\u000eZ\"p]N,X.\u001a:Qe><'/Z:t)E9#\u0011\u0006B\u0017\u0005c\u0011)D!\u000f\u0003>\t\u0005#Q\t\u0005\t\u0005W\u0011\u0019\u00031\u0001\u0002:\u0006\u0011\u0011\u000e\u001a\u0005\b\u0005_\u0011\u0019\u00031\u0001c\u0003%\u0011\u0017\u0010^3t%\u0016\fG\rC\u0004\u00034\t\r\u0002\u0019\u00012\u0002\u001b1\f7\u000f\u001e\"zi\u0016\u001c(+Z1e\u0011\u001d\u00119Da\tA\u0002\t\fA\"\\3tg\u0006<Wm\u001d*fC\u0012DqAa\u000f\u0003$\u0001\u0007!-\u0001\tmCN$X*Z:tC\u001e,7OU3bI\"9!q\bB\u0012\u0001\u0004\u0011\u0017aB:uCJ$Xj\u001d\u0005\b\u0005\u0007\u0012\u0019\u00031\u0001c\u0003\u0015)g\u000eZ't\u0011!\t9Oa\tA\u0002\u0005-\bb\u0002B%\u0013\u0011\u0005!1J\u0001\u0019aJLg\u000e\u001e(fo\u000e{gn];nKJ\u0004&o\\4sKN\u001cHcE\u0014\u0003N\t=#\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\\tu\u0003\u0002\u0003B\u0016\u0005\u000f\u0002\r!!/\t\u000f\t=\"q\ta\u0001E\"9!1\u0007B$\u0001\u0004\u0011\u0007b\u0002B\u001c\u0005\u000f\u0002\rA\u0019\u0005\b\u0005w\u00119\u00051\u0001c\u0011\u001d\u0011yDa\u0012A\u0002\tDqAa\u0011\u0003H\u0001\u0007!\r\u0003\u0005\u0002h\n\u001d\u0003\u0019AAv\u0011\u001d\u0011yFa\u0012A\u0002\t\fA\u0003]3sS>$\u0017n\u0019&pS:$\u0016.\\3J]6\u001b\bb\u0002B2\u0013\u0011%!QM\u0001\u0013aJLg\u000e\u001e\"bg&\u001c\u0007K]8he\u0016\u001c8\u000fF\t(\u0005O\u0012IGa\u001b\u0003n\t=$\u0011\u000fB:\u0005kB\u0001Ba\u000b\u0003b\u0001\u0007\u0011\u0011\u0018\u0005\b\u0005_\u0011\t\u00071\u0001c\u0011\u001d\u0011\u0019D!\u0019A\u0002\tDqAa\u000e\u0003b\u0001\u0007!\rC\u0004\u0003<\t\u0005\u0004\u0019\u00012\t\u000f\t}\"\u0011\ra\u0001E\"9!1\tB1\u0001\u0004\u0011\u0007\u0002CAt\u0005C\u0002\r!a;\t\u000f\te\u0014\u0002\"\u0003\u0003|\u0005)\u0002O]5oi\u0016CH/\u001a8eK\u0012\u0004&o\\4sKN\u001cHcD\u0014\u0003~\t}$\u0011\u0011BB\u0005\u000b\u00139I!#\t\u000f\t=\"q\u000fa\u0001E\"9!1\u0007B<\u0001\u0004\u0011\u0007b\u0002B\u001c\u0005o\u0002\rA\u0019\u0005\b\u0005w\u00119\b1\u0001c\u0011\u001d\u0011yDa\u001eA\u0002\tDqAa\u0011\u0003x\u0001\u0007!\rC\u0004\u0003`\t]\u0004\u0019\u00012\u0007\r\t5\u0015\u0002\u0001BH\u0005I\u0019uN\\:v[\u0016\u0014\b+\u001a:g)\"\u0014X-\u00193\u0014\t\t-%\u0011\u0013\t\u0005\u0003G\u0011\u0019*\u0003\u0003\u0003\u0016\u0006\u0015\"A\u0002+ie\u0016\fG\rC\u0006\u0003\u001a\n-%\u0011!Q\u0001\n\u0005e\u0016\u0001\u0003;ie\u0016\fG-\u00133\t\u0015\tu%1\u0012B\u0001B\u0003%q&\u0001\u0003oC6,\u0007b\u0003BQ\u0005\u0017\u0013\t\u0011)A\u0005\u0005G\u000baa\u001d;sK\u0006l\u0007C\u0002BS\u0005S\u000b\u0016+\u0004\u0002\u0003(*\u0011\u0001\nB\u0005\u0005\u0005W\u00139KA\u0006LC\u001a\\\u0017m\u0015;sK\u0006l\u0007\"\u00035\u0003\f\n\u0005\t\u0015!\u0003j\u0011-\u0011)Aa#\u0003\u0002\u0003\u0006IAa\u0002\t\u0017\te!1\u0012B\u0001B\u0003%!q\u0001\u0005\f\u0005k\u0013YI!A!\u0002\u0013\u00119,A\bd_:\u001cX/\\3s)&lWm\\;u!\u0011\u0011IA!/\n\t\tm&1\u0002\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u000fM\u0011Y\t\"\u0001\u0003@R\u0001\"\u0011\u0019Bb\u0005\u000b\u00149M!3\u0003L\n5'q\u001a\t\u0004U\n-\u0005\u0002\u0003BM\u0005{\u0003\r!!/\t\u000f\tu%Q\u0018a\u0001_!A!\u0011\u0015B_\u0001\u0004\u0011\u0019\u000b\u0003\u0004i\u0005{\u0003\r!\u001b\u0005\t\u0005\u000b\u0011i\f1\u0001\u0003\b!A!\u0011\u0004B_\u0001\u0004\u00119\u0001\u0003\u0005\u00036\nu\u0006\u0019\u0001B\\\u0011!\u0011\u0019Na#\u0005B\tU\u0017a\u0001:v]R\tq\u0005")
public final class ConsumerPerformance {
    public static void printNewConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat, long l7) {
        ConsumerPerformance$.MODULE$.printNewConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat, l7);
    }

    public static void printOldConsumerProgress(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printOldConsumerProgress(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2, AtomicLong atomicLong3, long l3) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list, l, l2, consumerPerfConfig, atomicLong, atomicLong2, atomicLong3, l3);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED (only when using old consumer): The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "REQUIRED (unless old consumer is used): A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)("perf-consumer-" + new Random().nextInt(100000)), (Object[])new String[0]).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10), (Object[])new Integer[0]);
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(1), (Object[])new Integer[0]);
        private final OptionSpecBuilder newConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation. This is the default, so this option is deprecated and will be removed in a future release.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSpecBuilder printMetricsOpt = this.parser().accepts("print-metrics", "Print out the metrics. This only applies to new consumer.");
        private final OptionSpecBuilder showDetailedStatsOpt = this.parser().accepts("show-detailed-stats", "If set, stats are reported for each reporting interval as configured by reporting-interval");
        private final OptionSet options;
        private final boolean useOldConsumer;
        private final boolean printMetrics;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder newConsumerOpt() {
            return this.newConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSpecBuilder printMetricsOpt() {
            return this.printMetricsOpt;
        }

        public OptionSpecBuilder showDetailedStatsOpt() {
            return this.showDetailedStatsOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldConsumer() {
            return this.useOldConsumer;
        }

        public boolean printMetrics() {
            return this.printMetrics;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useOldConsumer = this.options().has(this.zkConnectOpt());
            this.printMetrics = this.options().has((OptionSpec)this.printMetricsOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps((String)((String)this.options().valueOf(this.consumerConfigOpt()))) : new Properties();
            if (!this.useOldConsumer()) {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServersOpt()}));
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    Console$.MODULE$.err().println("The --new-consumer option is deprecated and will be removed in a future major release.The new consumer is used by default if the --bootstrap-server option is provided.");
                }
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("max.partition.fetch.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            } else {
                if (this.options().has(this.bootstrapServersOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.bootstrapServersOpt(), this.zkConnectOpt()})));
                }
                if (this.options().has((OptionSpec)this.newConsumerOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newConsumerOpt(), this.zkConnectOpt()})));
                }
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", ((Integer)this.options().valueOf(this.socketBufferSizeOpt())).toString());
                this.props().put("fetch.message.max.bytes", ((Integer)this.options().valueOf(this.fetchSizeOpt())).toString());
                this.props().put("auto.offset.reset", this.options().has((OptionSpec)this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", ((Integer)this.options().valueOf(this.numFetchersOpt())).toString());
            }
            this.numThreads = (Integer)this.options().valueOf(this.numThreadsOpt());
            this.topic = (String)this.options().valueOf(this.topicOpt());
            this.numMessages = (Long)this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = (Integer)this.options().valueOf(this.reportingIntervalOpt());
            if (this.reportingInterval() <= 0) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            this.showDetailedStats = this.options().has((OptionSpec)this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat((String)this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has((OptionSpec)this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            block7: {
                long startMs;
                long bytesRead = 0L;
                long messagesRead = 0L;
                long lastReportTime = startMs = System.currentTimeMillis();
                long lastBytesRead = 0L;
                long lastMessagesRead = 0L;
                try {
                    Iterator iter = this.stream.iterator();
                    while (iter.hasNext() && messagesRead < this.config.numMessages()) {
                        Object messageAndMetadata = iter.next();
                        ++messagesRead;
                        bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                        long currentTimeMillis = System.currentTimeMillis();
                        if (currentTimeMillis - lastReportTime < (long)this.config.reportingInterval()) continue;
                        if (this.config.showDetailedStats()) {
                            ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, currentTimeMillis, this.config.dateFormat());
                        }
                        lastReportTime = currentTimeMillis;
                        lastMessagesRead = messagesRead;
                        lastBytesRead = bytesRead;
                    }
                }
                catch (InterruptedException interruptedException) {
                }
                catch (ClosedByInterruptException closedByInterruptException) {
                }
                catch (ConsumerTimeoutException consumerTimeoutException) {
                    this.consumerTimeout.set(true);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                this.totalMessagesRead.addAndGet(messagesRead);
                this.totalBytesRead.addAndGet(bytesRead);
                if (!this.config.showDetailedStats()) break block7;
                ConsumerPerformance$.MODULE$.printOldConsumerProgress(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

