/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.log.ValidationType$EpochOnly$;
import kafka.log.ValidationType$Full$;
import kafka.log.ValidationType$None$;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\r%t!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\tq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003a\u0001\"!D\r\n\u0005iq!!B*i_J$\bB\u0002\u000f\nA\u0003%\u0001$\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002BqAH\u0005C\u0002\u0013%q$\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001%A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\r\t\u0005\bW%\u0011\r\u0011\"\u0003 \u0003!\u0019%o\u0019$jK2$\u0007BB\u0017\nA\u0003%\u0001%A\u0005De\u000e4\u0015.\u001a7eA!9q&\u0003b\u0001\n\u0013y\u0012a\u0004)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3\t\rEJ\u0001\u0015!\u0003!\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007\u0005C\u00044\u0013\t\u0007I\u0011B\u0010\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG\r\u0003\u00046\u0013\u0001\u0006I\u0001I\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007\u0005C\u00048\u0013\t\u0007I\u0011B\u0010\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0005\u0007s%\u0001\u000b\u0011\u0002\u0011\u0002'A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0011\t\u000fmJ!\u0019!C\u0005?\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG\r\u0003\u0004>\u0013\u0001\u0006I\u0001I\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002BqaP\u0005C\u0002\u0013%q$\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\"1\u0011)\u0003Q\u0001\n\u0001\n\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u0011\u001d\u0019\u0015B1A\u0005\n}\ta\u0002V5nKN$\u0018-\u001c9GS\u0016dG\r\u0003\u0004F\u0013\u0001\u0006I\u0001I\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA!9q)\u0003b\u0001\n\u0013y\u0012\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\r\u0003\u0004J\u0013\u0001\u0006I\u0001I\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0011\u001dY\u0015B1A\u0005\n}\tQcQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\r\u0003\u0004N\u0013\u0001\u0006I\u0001I\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA!9q*\u0003b\u0001\n\u0013y\u0012AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007BB)\nA\u0003%\u0001%A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\r\t\u0005\b'&\u0011\r\u0011\"\u0003U\u000351VM]:j_:|eMZ:fiV\tQ\u000b\u0005\u0002\u000e-&\u0011qK\u0004\u0002\u0004\u0013:$\bBB-\nA\u0003%Q+\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\t\u000fmK!\u0019!C\u0005)\u0006I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007;&\u0001\u000b\u0011B+\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004`\u0013\t\u0007I\u0011\u0002+\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\"1\u0011-\u0003Q\u0001\nU\u000ba\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000f\t\u0005\bG&\u0011\r\u0011\"\u0001e\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\tQ\r\u0005\u0002ge6\tqM\u0003\u0002iS\u0006)A/\u001f9fg*\u0011!n[\u0001\taJ|Go\\2pY*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]4\u0003\rM\u001b\u0007.Z7b\u0011\u0019)\u0018\u0002)A\u0005K\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0003bB<\n\u0005\u0004%\t\u0001Z\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\t\reL\u0001\u0015!\u0003f\u0003U\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0002BQa_\u0005\u0005\u0002q\fAB]3bINs\u0017\r]:i_R$2!`A\r!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0006\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017q\u0001c\u0001\u0005\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\b\u00037Q\b\u0019AA\u000f\u0003\u00111\u0017\u000e\\3\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t%\u0003\tIw.\u0003\u0003\u0002(\u0005\u0005\"\u0001\u0002$jY\u0016Dq!a\u000b\n\t\u0013\ti#A\u0007xe&$Xm\u00158baNDw\u000e\u001e\u000b\u0007\u0003_\t)$a\u000e\u0011\u00075\t\t$C\u0002\u000249\u0011A!\u00168ji\"A\u00111DA\u0015\u0001\u0004\ti\u0002\u0003\u0005\u0002:\u0005%\u0002\u0019AA\u001e\u0003\u001d)g\u000e\u001e:jKN\u0004\u0002\"!\u0010\u0002H\u0005-\u00131C\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u00059Q.\u001e;bE2,'bAA#\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u0013q\b\u0002\u0004\u001b\u0006\u0004\bcA\u0007\u0002N%\u0019\u0011q\n\b\u0003\t1{gn\u001a\u0005\b\u0003'JA\u0011BA+\u00039I7o\u00158baNDw\u000e\u001e$jY\u0016$B!a\u0016\u0002^A\u0019Q\"!\u0017\n\u0007\u0005mcBA\u0004C_>dW-\u00198\t\u0011\u0005m\u0011\u0011\u000ba\u0001\u0003;A\u0001\"!\u0019\n\t\u0003\u0011\u00111M\u0001\u0012Y&\u001cHo\u00158baNDw\u000e\u001e$jY\u0016\u001cH\u0003BA3\u0003W\u0002RA`A4\u0003;IA!!\u001b\u0002\u0012\t\u00191+Z9\t\u0011\u00055\u0014q\fa\u0001\u0003;\t1\u0001Z5s\u0011!\t\t(\u0003C\u0001\u0005\u0005M\u0014!\u00063fY\u0016$Xm\u00158baNDw\u000e^:CK\u001a|'/\u001a\u000b\u0007\u0003_\t)(a\u001e\t\u0011\u00055\u0014q\u000ea\u0001\u0003;A\u0001\"!\u001f\u0002p\u0001\u0007\u00111J\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005u\u0014\u0002\"\u0003\u0002\u0000\u0005\u0019B-\u001a7fi\u0016\u001cf.\u00199tQ>$h)\u001b7fgR1\u0011qFAA\u0003\u0007C\u0001\"!\u001c\u0002|\u0001\u0007\u0011Q\u0004\u0005\u000b\u0003\u000b\u000bY\b%AA\u0002\u0005\u001d\u0015!\u00039sK\u0012L7-\u0019;f!\u001di\u0011\u0011RA&\u0003/J1!a#\u000f\u0005%1UO\\2uS>t\u0017\u0007C\u0005\u0002\u0010&\t\n\u0011\"\u0001\u0002\u0012\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!a%+\u0007U\u000b)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\tKD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tI+CI\u0001\n\u0013\tY+A\u000feK2,G/Z*oCB\u001c\bn\u001c;GS2,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiK\u000b\u0003\u0002\b\u0006Ue!\u0002\u0006\u0003\u0001\u0005E6#BAX\u0019\u0005M\u0006\u0003BA[\u0003wk!!a.\u000b\u0007\u0005eF!A\u0003vi&d7/\u0003\u0003\u0002>\u0006]&a\u0002'pO\u001eLgn\u001a\u0005\f\u0003\u0003\fyK!b\u0001\n\u0003\t\u0019-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005\u0015\u0007\u0003BAd\u0003\u0013l\u0011a[\u0005\u0004\u0003\u0017\\'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\f\u0003\u001f\fyK!A!\u0002\u0013\t)-A\bu_BL7\rU1si&$\u0018n\u001c8!\u0011-\t\u0019.a,\u0003\u0006\u0004%\t!!6\u0002\r1|w\rR5s+\t\ti\u0002C\u0006\u0002Z\u0006=&\u0011!Q\u0001\n\u0005u\u0011a\u00027pO\u0012K'\u000f\t\u0005\u000b\u0003;\fyK!b\u0001\n\u0003!\u0016!G7bqB\u0013x\u000eZ;dKJLE-\u0012=qSJ\fG/[8o\u001bND!\"!9\u00020\n\u0005\t\u0015!\u0003V\u0003ii\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:!\u0011\u001d\u0019\u0012q\u0016C\u0001\u0003K$\u0002\"a:\u0002j\u0006-\u0018Q\u001e\t\u0004\u0011\u0005=\u0006\u0002CAa\u0003G\u0004\r!!2\t\u0011\u0005M\u00171\u001da\u0001\u0003;A\u0011\"!8\u0002dB\u0005\t\u0019A+\t\u0015\u0005E\u0018q\u0016b\u0001\n\u0013\t\u00190A\u0005qe>$WoY3sgV\u0011\u00111\b\u0005\n\u0003o\fy\u000b)A\u0005\u0003w\t!\u0002\u001d:pIV\u001cWM]:!\u0011)\tY0a,A\u0002\u0013%\u0011Q`\u0001\u000eY\u0006\u001cH/T1q\u001f\u001a47/\u001a;\u0016\u0005\u0005-\u0003B\u0003B\u0001\u0003_\u0003\r\u0011\"\u0003\u0003\u0004\u0005\tB.Y:u\u001b\u0006\u0004xJ\u001a4tKR|F%Z9\u0015\t\u0005=\"Q\u0001\u0005\u000b\u0005\u000f\ty0!AA\u0002\u0005-\u0013a\u0001=%c!I!1BAXA\u0003&\u00111J\u0001\u000fY\u0006\u001cH/T1q\u001f\u001a47/\u001a;!\u0011)\u0011y!a,A\u0002\u0013%\u0011Q`\u0001\u000fY\u0006\u001cHo\u00158ba>3gm]3u\u0011)\u0011\u0019\"a,A\u0002\u0013%!QC\u0001\u0013Y\u0006\u001cHo\u00158ba>3gm]3u?\u0012*\u0017\u000f\u0006\u0003\u00020\t]\u0001B\u0003B\u0004\u0005#\t\t\u00111\u0001\u0002L!I!1DAXA\u0003&\u00111J\u0001\u0010Y\u0006\u001cHo\u00158ba>3gm]3uA!Q!qDAX\u0005\u0004%IA!\t\u0002\u0017=twm\\5oORChn]\u000b\u0003\u0005G\u0001\u0002B!\n\u0003,\u0005-#qF\u0007\u0003\u0005OQ1A!\u000b%\u0003\u0011)H/\u001b7\n\t\t5\"q\u0005\u0002\b)J,W-T1q!\rA!\u0011G\u0005\u0004\u0005g\u0011!a\u0003+y]6+G/\u00193bi\u0006D\u0011Ba\u000e\u00020\u0002\u0006IAa\t\u0002\u0019=twm\\5oORChn\u001d\u0011\t\u0015\tm\u0012q\u0016b\u0001\n\u0013\u0011\t#\u0001\tv]J,\u0007\u000f\\5dCR,G\r\u0016=og\"I!qHAXA\u0003%!1E\u0001\u0012k:\u0014X\r\u001d7jG\u0006$X\r\u001a+y]N\u0004\u0003\u0002\u0003B\"\u0003_#\tA!\u0012\u0002'\u0019L'o\u001d;V]N$\u0018M\u00197f\u001f\u001a47/\u001a;\u0016\u0005\t\u001d\u0003#B\u0007\u0003J\t5\u0013b\u0001B&\u001d\t1q\n\u001d;j_:\u0004BAa\u0014\u0003V5\u0011!\u0011\u000b\u0006\u0004\u0005'\"\u0011AB:feZ,'/\u0003\u0003\u0003X\tE#!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"A!1LAX\t\u0003\u0011i&\u0001\fp]\"Kw\r[,bi\u0016\u0014X.\u0019:l+B$\u0017\r^3e)\u0011\tyCa\u0018\t\u0011\t\u0005$\u0011\fa\u0001\u0003\u0017\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\\u0007\u0002\u0003B3\u0003_#\tAa\u001a\u0002)\u0019L'o\u001d;V]\u0012,7-\u001b3fI>3gm]3u+\t\u0011I\u0007E\u0003\u000e\u0005\u0013\nY\u0005\u0003\u0005\u0003n\u0005=F\u0011AA\u007f\u00031i\u0017\r]#oI>3gm]3u\u0011!\u0011\t(a,\u0005\u0002\tM\u0014aD1di&4X\r\u0015:pIV\u001cWM]:\u0016\u0005\tU\u0004\u0003\u0003B<\u0005{\nY%a\u0005\u000e\u0005\te$\u0002\u0002B>\u0003\u0007\n\u0011\"[7nkR\f'\r\\3\n\t\u0005%#\u0011\u0010\u0005\t\u0005\u0003\u000by\u000b\"\u0001\u0003\u0004\u00069\u0011n]#naRLXCAA,\u0011!\u00119)a,\u0005\n\t%\u0015\u0001\u00057pC\u00124%o\\7T]\u0006\u00048\u000f[8u)\u0019\tyCa#\u0003\u0010\"A!Q\u0012BC\u0001\u0004\tY%\u0001\bm_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;\t\u0011\tE%Q\u0011a\u0001\u0003\u0017\n1bY;se\u0016tG\u000fV5nK\"I!QSAX\t\u0003\u0011!qS\u0001\u0012Y>\fG\r\u0015:pIV\u001cWM]#oiJLH\u0003BA\u0018\u00053C\u0001Ba'\u0003\u0014\u0002\u0007\u00111C\u0001\u0006K:$(/\u001f\u0005\t\u0005?\u000by\u000b\"\u0003\u0003\"\u0006\t\u0012n\u001d)s_\u0012,8-\u001a:FqBL'/\u001a3\u0015\r\u0005]#1\u0015BT\u0011!\u0011)K!(A\u0002\u0005-\u0013!D2veJ,g\u000e\u001e+j[\u0016l5\u000f\u0003\u0005\u0003*\nu\u0005\u0019AA\n\u00035\u0001(o\u001c3vG\u0016\u00148\u000b^1uK\"A!QVAX\t\u0003\u0011y+\u0001\fsK6|g/Z#ya&\u0014X\r\u001a)s_\u0012,8-\u001a:t)\u0011\tyC!-\t\u0011\t\u0015&1\u0016a\u0001\u0003\u0017B\u0001B!.\u00020\u0012\u0005!qW\u0001\u0012iJ,hnY1uK\u0006sGMU3m_\u0006$G\u0003CA\u0018\u0005s\u0013YLa0\t\u0011\t5%1\u0017a\u0001\u0003\u0017B\u0001B!0\u00034\u0002\u0007\u00111J\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u0005\t\u0005K\u0013\u0019\f1\u0001\u0002L!A!1YAX\t\u0003\u0011)-A\u0007qe\u0016\u0004\u0018M]3Va\u0012\fG/\u001a\u000b\u0007\u0005\u000f\u0014iM!5\u0011\u0007!\u0011I-C\u0002\u0003L\n\u0011!\u0003\u0015:pIV\u001cWM]!qa\u0016tG-\u00138g_\"A!q\u001aBa\u0001\u0004\tY%\u0001\u0006qe>$WoY3s\u0013\u0012D\u0001Ba5\u0003B\u0002\u0007\u0011qK\u0001\rSN4%o\\7DY&,g\u000e\u001e\u0005\t\u0005/\fy\u000b\"\u0001\u0003Z\u00061Q\u000f\u001d3bi\u0016$B!a\f\u0003\\\"A!Q\u001cBk\u0001\u0004\u00119-\u0001\u0006baB,g\u000eZ%oM>D\u0001B!9\u00020\u0012\u0005!1]\u0001\u0013kB$\u0017\r^3NCB,e\u000eZ(gMN,G\u000f\u0006\u0003\u00020\t\u0015\b\u0002\u0003Bt\u0005?\u0004\r!a\u0013\u0002\u00151\f7\u000f^(gMN,G\u000f\u0003\u0005\u0003l\u0006=F\u0011\u0001Bw\u0003%a\u0017m\u001d;F]R\u0014\u0018\u0010\u0006\u0003\u0003p\nE\b#B\u0007\u0003J\u0005M\u0001\u0002\u0003Bh\u0005S\u0004\r!a\u0013\t\u0011\tU\u0018q\u0016C\u0001\u0005o\fA\u0002^1lKNs\u0017\r]:i_R$\"!a\f\t\u0011\tm\u0018q\u0016C\u0001\u0005O\nA\u0003\\1uKN$8K\\1qg\"|Go\u00144gg\u0016$\b\u0002\u0003B\u0000\u0003_#\tAa\u001a\u0002)=dG-Z:u':\f\u0007o\u001d5pi>3gm]3u\u0011!\u0019\u0019!a,\u0005\n\r\u0015\u0011AE5t!J|G-^2feJ+G/Y5oK\u0012$b!a\u0016\u0004\b\r-\u0001\u0002CB\u0005\u0007\u0003\u0001\r!a\u0005\u0002%A\u0014x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\t\u0005\u001b\u001b\t\u00011\u0001\u0002L!A1qBAX\t\u0003\u0019\t\"\u0001\u0007ueVt7-\u0019;f\u0011\u0016\fG\r\u0006\u0003\u00020\rM\u0001\u0002\u0003BG\u0007\u001b\u0001\r!a\u0013\t\u0011\r]\u0011q\u0016C\u0005\u00073\t\u0001E]3n_Z,WI^5di\u0016$wJ\\4pS:<GK]1og\u0006\u001cG/[8ogR!\u0011qFB\u000e\u0011!\u0019ib!\u0006A\u0002\r}\u0011AE3ya&\u0014X\r\u001a)s_\u0012,8-\u001a:JIN\u0004ba!\t\u0004$\u0005-SBAA\"\u0013\u0011\u0019)#a\u0011\u0003\u0007M+G\u000f\u0003\u0005\u0004*\u0005=F\u0011BB\u0016\u0003y\u0011X-\\8wKVs'/\u001a9mS\u000e\fG/\u001a3Ue\u0006t7/Y2uS>t7\u000f\u0006\u0003\u00020\r5\u0002\u0002CA=\u0007O\u0001\r!a\u0013\t\u0011\rE\u0012q\u0016C\u0001\u0005o\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0005\t\u0007k\ty\u000b\"\u0001\u00048\u0005Y1m\\7qY\u0016$X\r\u0016=o)\u0011\tYe!\u000f\t\u0011\rm21\u0007a\u0001\u0007{\tAbY8na2,G/\u001a3Uq:\u00042\u0001CB \u0013\r\u0019\tE\u0001\u0002\r\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0005\t\u0003c\ny\u000b\"\u0001\u0004FQ!\u0011qFB$\u0011!\tIha\u0011A\u0002\u0005-\u0003\u0006BB\"\u0007\u0017\u0002B!!.\u0004N%!1qJA\\\u0005)!\bN]3bIN\fg-\u001a\u0005\t\u0007'\ny\u000b\"\u0003\u0004V\u0005\u0011r\u000e\u001c3fgR\u001cf.\u00199tQ>$h)\u001b7f+\t\u00199\u0006E\u0003\u000e\u0005\u0013\ni\u0002\u0003\u0005\u0004\\\u0005=F\u0011BB+\u0003Ia\u0017\r^3tiNs\u0017\r]:i_R4\u0015\u000e\\3\t\u0011\u0005\u0005\u0014q\u0016C\u0005\u0007?*\"!!\u001a)\t\u0005=61\r\t\u0005\u0003k\u001b)'\u0003\u0003\u0004h\u0005]&!\u00048p]RD'/Z1eg\u00064W\r")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private final File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    private long lastMapOffset() {
        return this.lastMapOffset;
    }

    private void lastMapOffset_$eq(long x$1) {
        this.lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    private TreeMap<Object, TxnMetadata> ongoingTxns() {
        return this.ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    /*
     * WARNING - void declaration
     */
    public Option<LogOffsetMetadata> firstUnstableOffset() {
        void var1_1;
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$4 -> ((TxnMetadata)x$4.getValue()).firstOffset());
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$5 -> ((TxnMetadata)x$5.getValue()).firstOffset());
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : var1_1));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.ongoingTxns().firstEntry()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)ProducerStateManager.$anonfun$firstUndecidedOffset$1(x$6)));
    }

    public long mapEndOffset() {
        return this.lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    private void loadFromSnapshot(long logStartOffset, long currentTime) {
        while (true) {
            Option<File> option;
            if ((option = this.latestSnapshotFile()) instanceof Some) {
                Some some = (Some)option;
                File file = (File)some.value();
                try {
                    this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading producer state from snapshot file '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                    Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1 & Serializable & scala.Serializable)producerEntry -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$loadFromSnapshot$2(this, logStartOffset, currentTime, producerEntry)));
                    loadedProducers.foreach((Function1 & Serializable & scala.Serializable)entry -> {
                        this.loadProducerEntry(entry);
                        return BoxedUnit.UNIT;
                    });
                    this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                    this.lastMapOffset_$eq(this.lastSnapOffset());
                    return;
                }
                catch (CorruptSnapshotException e) {
                    this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load producer snapshot from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file, e.getMessage()})));
                    boolean bl = Files.deleteIfExists(file.toPath());
                }
            } else {
                if (None$.MODULE$.equals(option)) {
                    this.lastSnapOffset_$eq(logStartOffset);
                    this.lastMapOffset_$eq(logStartOffset);
                    return;
                }
                throw new MatchError(option);
            }
        }
    }

    public void loadProducerEntry(ProducerStateEntry entry) {
        long producerId = entry.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry);
        entry.currentTxnFirstOffset().foreach((Function1 & Serializable & scala.Serializable)offset -> ProducerStateManager.$anonfun$loadProducerEntry$1(this, producerId, BoxesRunTime.unboxToLong((Object)offset)));
    }

    private boolean isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$removeExpiredProducers$1(this, currentTimeMs, BoxesRunTime.unboxToLong((Object)x0$2), x1$1)));
    }

    public void truncateAndReload(long logStartOffset, long logEndOffset, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)snapOffset -> snapOffset > logEndOffset || snapOffset <= logStartOffset);
        if (logEndOffset != this.mapEndOffset()) {
            this.producers().clear();
            this.ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset);
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, boolean isFromClient) {
        Product product;
        if (!isFromClient) {
            product = ValidationType$None$.MODULE$;
        } else {
            String string = this.topicPartition().topic();
            String string2 = "__consumer_offsets";
            product = !(string != null ? !string.equals(string2) : string2 != null) ? ValidationType$EpochOnly$.MODULE$ : ValidationType$Full$.MODULE$;
        }
        ValidationType$None$ validationToPerform = product;
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0 & Serializable & scala.Serializable)() -> ProducerStateEntry$.MODULE$.empty(producerId));
        return new ProducerAppendInfo(producerId, currentEntry, validationToPerform);
    }

    public void update(ProducerAppendInfo appendInfo) {
        BoxedUnit boxedUnit;
        if (appendInfo.producerId() == -1L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer id ", " passed to update "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()})));
        }
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated producer ", " state to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId()), appendInfo})));
        ProducerStateEntry updatedEntry = appendInfo.toEntry();
        Option option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
        if (option instanceof Some) {
            Some some = (Some)option;
            ProducerStateEntry currentEntry = (ProducerStateEntry)some.value();
            currentEntry.update(updatedEntry);
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
        } else {
            throw new MatchError((Object)option);
        }
        appendInfo.startedTransactions().foreach((Function1 & Serializable & scala.Serializable)txn -> this.ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), (TxnMetadata)txn));
    }

    public void updateMapEndOffset(long lastOffset) {
        this.lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        block0: {
            if (this.lastMapOffset() <= this.lastSnapOffset()) break block0;
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.lastMapOffset());
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing producer snapshot at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.lastMapOffset())})));
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)));
    }

    private boolean isProducerRetained(ProducerStateEntry producerStateEntry, long logStartOffset) {
        producerStateEntry.removeBatchesOlderThan(logStartOffset);
        return producerStateEntry.lastDataOffset() >= logStartOffset;
    }

    public void truncateHead(long logStartOffset) {
        Map evictedProducerEntries = (Map)this.producers().filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager.$anonfun$truncateHead$1(this, logStartOffset, x0$3)));
        Set evictedProducerIds = evictedProducerEntries.keySet();
        this.producers().$minus$minus$eq((TraversableOnce)evictedProducerIds);
        this.removeEvictedOngoingTransactions((Set<Object>)evictedProducerIds);
        this.removeUnreplicatedTransactions(logStartOffset);
        if (this.lastMapOffset() < logStartOffset) {
            this.lastMapOffset_$eq(logStartOffset);
        }
        this.deleteSnapshotsBefore(logStartOffset);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> logStartOffset)));
    }

    private void removeEvictedOngoingTransactions(Set<Object> expiredProducerIds) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.ongoingTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            if (!expiredProducerIds.contains((Object)BoxesRunTime.boxToLong((long)txnEntry.getValue().producerId()))) continue;
            iterator.remove();
        }
    }

    private void removeUnreplicatedTransactions(long offset) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator = this.unreplicatedTxns().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 < offset)) continue;
            iterator.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.lastMapOffset_$eq(0L);
    }

    /*
     * WARNING - void declaration
     */
    public long completeTxn(CompletedTxn completedTxn) {
        void var3_3;
        TxnMetadata txnMetadata = this.ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to complete transaction ", " on partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completedTxn, this.topicPartition()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which was not started"})).s((Seq)Nil$.MODULE$));
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
        long lastStableOffset = BoxesRunTime.unboxToLong((Object)this.firstUndecidedOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> completedTxn.lastOffset() + 1L));
        return (long)var3_3;
    }

    public void deleteSnapshotsBefore(long offset) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)Log$.MODULE$.offsetFromFile(file)), (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public static final /* synthetic */ long $anonfun$firstUndecidedOffset$1(Map.Entry x$6) {
        return ((TxnMetadata)x$6.getValue()).firstOffset().messageOffset();
    }

    public static final /* synthetic */ boolean $anonfun$loadFromSnapshot$2(ProducerStateManager $this, long logStartOffset$3, long currentTime$1, ProducerStateEntry producerEntry) {
        return $this.isProducerRetained(producerEntry, logStartOffset$3) && !$this.isProducerExpired(currentTime$1, producerEntry);
    }

    public static final /* synthetic */ TxnMetadata $anonfun$loadProducerEntry$1(ProducerStateManager $this, long producerId$2, long offset) {
        return $this.ongoingTxns().put(BoxesRunTime.boxToLong((long)offset), new TxnMetadata(producerId$2, offset));
    }

    public static final /* synthetic */ boolean $anonfun$removeExpiredProducers$1(ProducerStateManager $this, long currentTimeMs$1, long x0$2, ProducerStateEntry x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerStateEntry lastEntry = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerExpired(currentTimeMs$1, lastEntry);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$truncateHead$1(ProducerStateManager $this, long logStartOffset$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ProducerStateEntry producerState = (ProducerStateEntry)tuple2._2();
        boolean bl = !$this.isProducerRetained(producerState, logStartOffset$2);
        return bl;
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ProducerStateManager partition=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
        this.producers = Map$.MODULE$.empty();
        this.lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

