/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.common.KafkaException;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.TransactionLog$KeySchema$;
import kafka.coordinator.transaction.TransactionLog$ValueSchema$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnKey;
import kafka.coordinator.transaction.TxnTransitMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.record.CompressionType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class TransactionLog$ {
    public static TransactionLog$ MODULE$;
    private final int DefaultNumPartitions;
    private final int DefaultSegmentBytes;
    private final short DefaultReplicationFactor;
    private final int DefaultMinInSyncReplicas;
    private final int DefaultLoadBufferSize;
    private final CompressionType EnforcedCompressionType;
    private final short EnforcedRequiredAcks;

    static {
        new TransactionLog$();
    }

    public int DefaultNumPartitions() {
        return this.DefaultNumPartitions;
    }

    public int DefaultSegmentBytes() {
        return this.DefaultSegmentBytes;
    }

    public short DefaultReplicationFactor() {
        return this.DefaultReplicationFactor;
    }

    public int DefaultMinInSyncReplicas() {
        return this.DefaultMinInSyncReplicas;
    }

    public int DefaultLoadBufferSize() {
        return this.DefaultLoadBufferSize;
    }

    public CompressionType EnforcedCompressionType() {
        return this.EnforcedCompressionType;
    }

    public short EnforcedRequiredAcks() {
        return this.EnforcedRequiredAcks;
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForKey(int version) {
        return (Schema)TransactionLog$KeySchema$.MODULE$.ofVersion(version).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown transaction log message key schema version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
        });
    }

    public Schema kafka$coordinator$transaction$TransactionLog$$schemaForValue(int version) {
        return (Schema)TransactionLog$ValueSchema$.MODULE$.ofVersion(version).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown transaction log message value schema version ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)version)})));
        });
    }

    public byte[] keyToBytes(String transactionalId) {
        Struct key = new Struct(TransactionLog$KeySchema$.MODULE$.CURRENT());
        key.set(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD(), (Object)transactionalId);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + key.sizeOf());
        byteBuffer.putShort(TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION());
        key.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public byte[] valueToBytes(TxnTransitMetadata txnMetadata) {
        Struct struct;
        Struct value = new Struct(TransactionLog$ValueSchema$.MODULE$.Current());
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerIdField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.producerId()));
        value.set(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField(), (Object)BoxesRunTime.boxToShort((short)txnMetadata.producerEpoch()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField(), (Object)BoxesRunTime.boxToInteger((int)txnMetadata.txnTimeoutMs()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStatusField(), (Object)BoxesRunTime.boxToByte((byte)txnMetadata.txnState().byte()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnLastUpdateTimestamp()));
        value.set(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField(), (Object)BoxesRunTime.boxToLong((long)txnMetadata.txnStartTimestamp()));
        TransactionState transactionState = txnMetadata.txnState();
        Empty$ empty$ = Empty$.MODULE$;
        if (!(transactionState != null ? !transactionState.equals(empty$) : empty$ != null)) {
            if (txnMetadata.topicPartitions().nonEmpty()) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction is not expected to have any partitions since its state is ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMetadata.txnState(), txnMetadata})));
            }
            struct = value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), null);
        } else {
            Map topicAndPartitions = txnMetadata.topicPartitions().groupBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topic());
            Iterable partitionArray = (Iterable)topicAndPartitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String topic = (String)tuple2._1();
                scala.collection.immutable.Set partitions = (scala.collection.immutable.Set)tuple2._2();
                Struct topicPartitionsStruct = value.instance(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                Integer[] partitionIds = (Integer[])((TraversableOnce)partitions.map((Function1 & Serializable & scala.Serializable)topicPartition -> topicPartition.partition(), scala.collection.immutable.Set$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Integer.class));
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField(), (Object)topic);
                topicPartitionsStruct.set(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField(), (Object)partitionIds);
                Struct struct = topicPartitionsStruct;
                return struct;
            }, Iterable$.MODULE$.canBuildFrom());
            struct = value.set(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField(), partitionArray.toArray(ClassTag$.MODULE$.apply(Struct.class)));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + value.sizeOf());
        byteBuffer.putShort(TransactionLog$ValueSchema$.MODULE$.CurrentVersion());
        value.writeTo(byteBuffer);
        return byteBuffer.array();
    }

    public TxnKey readTxnRecordKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        Schema keySchema = this.kafka$coordinator$transaction$TransactionLog$$schemaForKey(version);
        Struct key = keySchema.read(buffer);
        if (version != TransactionLog$KeySchema$.MODULE$.CURRENT_VERSION()) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown version ", " from the transaction log message"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)version)})));
        }
        String transactionalId = key.getString(TransactionLog$KeySchema$.MODULE$.TXN_ID_FIELD());
        return new TxnKey(version, transactionalId);
    }

    public TransactionMetadata readTxnRecordValue(String transactionalId, ByteBuffer buffer) {
        TransactionMetadata transactionMetadata;
        if (buffer == null) {
            transactionMetadata = null;
        } else {
            short version = buffer.getShort();
            Schema valueSchema = this.kafka$coordinator$transaction$TransactionLog$$schemaForValue(version);
            Struct value = valueSchema.read(buffer);
            if (version == TransactionLog$ValueSchema$.MODULE$.CurrentVersion()) {
                Long producerId = value.getLong(TransactionLog$ValueSchema$.MODULE$.ProducerIdField());
                Short epoch = value.getShort(TransactionLog$ValueSchema$.MODULE$.ProducerEpochField());
                Integer timeout = value.getInt(TransactionLog$ValueSchema$.MODULE$.TxnTimeoutField());
                Byte stateByte = value.getByte(TransactionLog$ValueSchema$.MODULE$.TxnStatusField());
                TransactionState state = TransactionMetadata$.MODULE$.byteToState(Predef$.MODULE$.Byte2byte(stateByte));
                Long entryTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnEntryTimestampField());
                Long startTimestamp = value.getLong(TransactionLog$ValueSchema$.MODULE$.TxnStartTimestampField());
                TransactionMetadata transactionMetadata2 = new TransactionMetadata(transactionalId, Predef$.MODULE$.Long2long(producerId), Predef$.MODULE$.Short2short(epoch), Predef$.MODULE$.Integer2int(timeout), state, (scala.collection.mutable.Set<TopicPartition>)Set$.MODULE$.empty(), Predef$.MODULE$.Long2long(startTimestamp), Predef$.MODULE$.Long2long(entryTimestamp));
                if (!state.equals(Empty$.MODULE$)) {
                    Object[] topicPartitionArray = value.getArray(TransactionLog$ValueSchema$.MODULE$.TxnPartitionsField());
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(topicPartitionArray)).foreach((Function1 & Serializable & scala.Serializable)memberMetadataObj -> {
                        TransactionLog$.$anonfun$readTxnRecordValue$1(transactionMetadata2, memberMetadataObj);
                        return BoxedUnit.UNIT;
                    });
                }
                transactionMetadata = transactionMetadata2;
            } else {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown version ", " from the transaction log message value"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)version)})));
            }
        }
        return transactionMetadata;
    }

    public static final /* synthetic */ void $anonfun$readTxnRecordValue$1(TransactionMetadata transactionMetadata$1, Object memberMetadataObj) {
        Struct memberMetadata = (Struct)memberMetadataObj;
        String topic = memberMetadata.getString(TransactionLog$ValueSchema$.MODULE$.PartitionsTopicField());
        Object[] partitionIdArray = memberMetadata.getArray(TransactionLog$ValueSchema$.MODULE$.PartitionIdsField());
        TopicPartition[] topicPartitions = (TopicPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(partitionIdArray)).map((Function1 & Serializable & scala.Serializable)partitionIdObj -> {
            Integer partitionId = (Integer)partitionIdObj;
            return new TopicPartition(topic, Predef$.MODULE$.Integer2int(partitionId));
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TopicPartition.class)));
        transactionMetadata$1.addPartitions((Set<TopicPartition>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topicPartitions)).toSet());
    }

    private TransactionLog$() {
        MODULE$ = this;
        this.DefaultNumPartitions = 50;
        this.DefaultSegmentBytes = 0x6400000;
        this.DefaultReplicationFactor = (short)3;
        this.DefaultMinInSyncReplicas = 2;
        this.DefaultLoadBufferSize = 0x500000;
        this.EnforcedCompressionType = CompressionType.NONE;
        this.EnforcedRequiredAcks = (short)-1;
    }
}

