/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.KafkaApis;
import kafka.utils.Exit$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001\u000f\t\u00192*\u00194lCJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u0011A\u0019\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%\t\u0012B\u0001\n\u000b\u0005!\u0011VO\u001c8bE2,\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0005\u0003\u0015)H/\u001b7t\u0013\tARCA\u0004M_\u001e<\u0017N\\4\t\u0011i\u0001!\u0011!Q\u0001\nm\t!!\u001b3\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\u0007%sG\u000f\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001c\u0003!\u0011'o\\6fe&#\u0007\u0002\u0003\u0013\u0001\u0005\u000b\u0007I\u0011A\u0013\u0002%\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM]\u000b\u0002MA\u0011q\u0005M\u0007\u0002Q)\u0011\u0011FK\u0001\u0005G>\u0014XM\u0003\u0002,Y\u00059Q.\u001a;sS\u000e\u001c(BA\u0017/\u0003\u0019I\u0018-\\7fe*\tq&A\u0002d_6L!!\r\u0015\u0003\u000b5+G/\u001a:\t\u0011M\u0002!\u0011!Q\u0001\n\u0019\n1#Y4he\u0016<\u0017\r^3JI2,W*\u001a;fe\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u0014i>$\u0018\r\u001c%b]\u0012dWM\u001d+ie\u0016\fGm]\u000b\u00027!A\u0001\b\u0001B\u0001B\u0003%1$\u0001\u000bu_R\fG\u000eS1oI2,'\u000f\u00165sK\u0006$7\u000f\t\u0005\tu\u0001\u0011)\u0019!C\u0001w\u0005q!/Z9vKN$8\t[1o]\u0016dW#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\"\u0011a\u00028fi^|'o[\u0005\u0003\u0003z\u0012aBU3rk\u0016\u001cHo\u00115b]:,G\u000e\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003=\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0003\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\t\u0005\u0004\u0018n\u001d\t\u0003\u000f\"k\u0011AA\u0005\u0003\u0013\n\u0011\u0011bS1gW\u0006\f\u0005/[:\t\u0011-\u0003!\u0011!Q\u0001\n1\u000bA\u0001^5nKB\u0011QJV\u0007\u0002\u001d*\u0011ac\u0014\u0006\u0003!F\u000baaY8n[>t'BA\u0003S\u0015\t\u0019F+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002+\u0006\u0019qN]4\n\u0005]s%\u0001\u0002+j[\u0016DQ!\u0017\u0001\u0005\u0002i\u000ba\u0001P5oSRtD\u0003C.];z{\u0006-\u00192\u0011\u0005\u001d\u0003\u0001\"\u0002\u000eY\u0001\u0004Y\u0002\"\u0002\u0012Y\u0001\u0004Y\u0002\"\u0002\u0013Y\u0001\u00041\u0003\"B\u001bY\u0001\u0004Y\u0002\"\u0002\u001eY\u0001\u0004a\u0004\"B#Y\u0001\u00041\u0005\"B&Y\u0001\u0004a\u0005b\u00023\u0001\u0005\u0004%I!Z\u0001\u0006Y\u0006$8\r[\u000b\u0002MB\u0011q\r\\\u0007\u0002Q*\u0011\u0011N[\u0001\u000bG>t7-\u001e:sK:$(BA6\r\u0003\u0011)H/\u001b7\n\u00055D'AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\u0007_\u0002\u0001\u000b\u0011\u00024\u0002\r1\fGo\u00195!\u0011\u0015\t\b\u0001\"\u0001s\u0003\r\u0011XO\u001c\u000b\u0002gB\u0011A\u0004^\u0005\u0003kv\u0011A!\u00168ji\")q\u000f\u0001C\u0001e\u0006\u0001\u0012N\\5uS\u0006$Xm\u00155vi\u0012|wO\u001c\u0005\u0006s\u0002!\tA]\u0001\u000eC^\f\u0017\u000e^*ikR$wn\u001e8")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final int totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final KafkaApis apis;
    private final Time time;
    private final CountDownLatch latch;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        KafkaRequestHandler kafkaRequestHandler = this;
        synchronized (kafkaRequestHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public int totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch latch() {
        return this.latch;
    }

    @Override
    public void run() {
        RequestChannel.BaseRequest baseRequest;
        while (true) {
            BoxedUnit boxedUnit;
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads());
            baseRequest = req;
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(baseRequest)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka request handler ", " on broker ", " received shut down command"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.id), BoxesRunTime.boxToInteger((int)$this.brokerId)})));
                this.latch().countDown();
                return;
            }
            if (baseRequest instanceof RequestChannel.Request) {
                BoxedUnit boxedUnit2;
                RequestChannel.Request request = (RequestChannel.Request)baseRequest;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Kafka request handler ", " on broker ", " handling request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.id), BoxesRunTime.boxToInteger((int)$this.brokerId), request})));
                        this.apis.handle(request);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    catch (FatalExitError e) {
                        this.latch().countDown();
                        throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                }
                finally {
                    request.releaseBuffer();
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (baseRequest != null) break;
            boxedUnit = BoxedUnit.UNIT;
        }
        throw new MatchError((Object)baseRequest);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.latch().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, int totalHandlerThreads, RequestChannel requestChannel, KafkaApis apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq("[Kafka Request Handler " + id + " on Broker " + brokerId + "], ");
        this.latch = new CountDownLatch(1);
    }
}

