/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u001dd\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00027pO\u0012K'o]\u000b\u0002MA\u0019qe\f\u001a\u000f\u0005!jcBA\u0015-\u001b\u0005Q#BA\u0016\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002/\u0015\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00192\u0005\r\u0019V-\u001d\u0006\u0003])\u0001\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u0005%|'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012AAR5mK\"A1\b\u0001B\u0001B\u0003%a%\u0001\u0005m_\u001e$\u0015N]:!\u0011!i\u0004A!b\u0001\n\u0003q\u0014\u0001\u00027pON,\u0012a\u0010\t\u0005\u001f\u0001\u0013U*\u0003\u0002B!\t!\u0001k\\8m!\t\u00195*D\u0001E\u0015\t)e)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dS!\u0001S%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0015aA8sO&\u0011A\n\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tqb*\u0003\u0002P\u0005\t\u0019Aj\\4\t\u0011E\u0003!\u0011!Q\u0001\n}\nQ\u0001\\8hg\u0002B\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001V\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0003\u0002\rM,'O^3s\u0013\tQvK\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0005\t9\u0002\u0011\t\u0011)A\u0005+\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0003\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\u0002\tQLW.\u001a\t\u0003A\nl\u0011!\u0019\u0006\u0003#\u0011K!aY1\u0003\tQKW.\u001a\u0005\u0006K\u0002!\tAZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u001dD\u0017N[6m!\tq\u0002\u0001C\u0003\u001cI\u0002\u0007Q\u0004C\u0003%I\u0002\u0007a\u0005C\u0003>I\u0002\u0007q\bC\u0003TI\u0002\u0007Q\u000bC\u0004_IB\u0005\t\u0019A0\t\u00119\u0004!\u0019!C\u0001\u0005=\fab\u00197fC:,'/T1oC\u001e,'/F\u0001q!\tq\u0012/\u0003\u0002s\u0005\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\t\rQ\u0004\u0001\u0015!\u0003q\u0003=\u0019G.Z1oKJl\u0015M\\1hKJ\u0004\u0003b\u0002<\u0001\u0005\u0004%Ia^\u0001\ni\"\u0014x\u000e\u001e;mKJ,\u0012\u0001\u001f\t\u0003\u001feL!A\u001f\t\u0003\u0013QC'o\u001c;uY\u0016\u0014\bB\u0002?\u0001A\u0003%\u00010\u0001\u0006uQJ|G\u000f\u001e7fe\u0002BqA \u0001C\u0002\u0013%q0\u0001\u0005dY\u0016\fg.\u001a:t+\t\t\t\u0001\u0005\u0004\u0002\u0004\u00055\u0011\u0011C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017Q\u0011AC2pY2,7\r^5p]&!\u0011qBA\u0003\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0005\u0003'\t)\"D\u0001\u0001\r\u0019\t9\u0002\u0001\u0003\u0002\u001a\ti1\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001cB!!\u0006\u0002\u001cA\u0019q\"!\b\n\u0007\u0005}\u0001C\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007bCA\u0012\u0003+\u0011\t\u0011)A\u0005\u0003K\t\u0001\u0002\u001e5sK\u0006$\u0017\n\u001a\t\u0004\u0013\u0005\u001d\u0012bAA\u0015\u0015\t\u0019\u0011J\u001c;\t\u000f\u0015\f)\u0002\"\u0001\u0002.Q!\u0011\u0011CA\u0018\u0011!\t\u0019#a\u000bA\u0002\u0005\u0015\u0002BCA\u001a\u0003+\u0011\r\u0011\"\u0011\u00026\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ub'\u0001\u0003mC:<\u0017\u0002BA!\u0003w\u0011aa\u0015;sS:<\u0007\"CA#\u0003+\u0001\u000b\u0011BA\u001c\u0003-awnZ4fe:\u000bW.\u001a\u0011\t\u0015\u0005%\u0013Q\u0003b\u0001\n\u0003\tY%A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u00055\u0003c\u0001\u0010\u0002P%\u0019\u0011\u0011\u000b\u0002\u0003\u000f\rcW-\u00198fe\"I\u0011QKA\u000bA\u0003%\u0011QJ\u0001\tG2,\u0017M\\3sA!Q\u0011\u0011LA\u000b\u0001\u0004%\t!a\u0017\u0002\u00131\f7\u000f^*uCR\u001cXCAA/!\rq\u0012qL\u0005\u0004\u0003C\u0012!\u0001D\"mK\u0006tWM]*uCR\u001c\bBCA3\u0003+\u0001\r\u0011\"\u0001\u0002h\u0005iA.Y:u'R\fGo]0%KF$B!!\u001b\u0002pA\u0019\u0011\"a\u001b\n\u0007\u00055$B\u0001\u0003V]&$\bBCA9\u0003G\n\t\u00111\u0001\u0002^\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005U\u0014Q\u0003Q!\n\u0005u\u0013A\u00037bgR\u001cF/\u0019;tA!\"\u00111OA=!\rI\u00111P\u0005\u0004\u0003{R!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0015\u0005\u0005\u0015Q\u0003b\u0001\n\u0013\t\u0019)\u0001\tcC\u000e\\wJ\u001a4XC&$H*\u0019;dQV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u001f3\u0014\u0001B;uS2LA!a%\u0002\n\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0007\"CAL\u0003+\u0001\u000b\u0011BAC\u0003E\u0011\u0017mY6PM\u001a<\u0016-\u001b;MCR\u001c\u0007\u000e\t\u0005\t\u00037\u000b)\u0002\"\u0003\u0002\u001e\u0006I1\r[3dW\u0012{g.\u001a\u000b\u0005\u0003S\ny\nC\u0004\u0002\"\u0006e\u0005\u0019\u0001\"\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"A\u0011QUA\u000b\t\u0003\n9+\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003SB\u0001\"a+\u0002\u0016\u0011\u0005\u0013qU\u0001\tg\",H\u000fZ8x]\"A\u0011qVA\u000b\t\u0013\t9+\u0001\u0007dY\u0016\fgn\u0014:TY\u0016,\u0007\u000f\u0003\u0005\u00024\u0006UA\u0011AA[\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005%\u0014qWA^\u0003\u001b\f9.a7\t\u0011\u0005e\u0016\u0011\u0017a\u0001\u0003K\t!!\u001b3\t\u0011\u0005u\u0016\u0011\u0017a\u0001\u0003\u007f\u000bAA\\1nKB!\u0011\u0011YAe\u001d\u0011\t\u0019-!2\u0011\u0005%R\u0011bAAd\u0015\u00051\u0001K]3eK\u001aLA!!\u0011\u0002L*\u0019\u0011q\u0019\u0006\t\u0011\u0005=\u0017\u0011\u0017a\u0001\u0003#\fAA\u001a:p[B\u0019\u0011\"a5\n\u0007\u0005U'B\u0001\u0003M_:<\u0007\u0002CAm\u0003c\u0003\r!!5\u0002\u0005Q|\u0007\u0002CAo\u0003c\u0003\r!!\u0018\u0002\u000bM$\u0018\r^:\t\u0011\u0005\u0005\b\u0001)A\u0005\u0003\u0003\t\u0011b\u00197fC:,'o\u001d\u0011\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002(\u000691\u000f^1siV\u0004\bbBAV\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003W\u0004A\u0011AAw\u00035\t'm\u001c:u\u00072,\u0017M\\5oOR!\u0011\u0011NAx\u0011\u001d\t\t+!;A\u0002\tCq!a=\u0001\t\u0003\t)0A\tva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$B!!\u001b\u0002x\"9\u0011\u0011`Ay\u0001\u0004\u0011\u0014a\u00023bi\u0006$\u0015N\u001d\u0005\b\u0003{\u0004A\u0011AA\u0000\u0003MA\u0017M\u001c3mK2{w\rR5s\r\u0006LG.\u001e:f)\u0011\tIG!\u0001\t\u0011\t\r\u00111 a\u0001\u0003\u007f\u000b1\u0001Z5s\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013\tq#\\1zE\u0016$&/\u001e8dCR,7\t[3dWB|\u0017N\u001c;\u0015\u0011\u0005%$1\u0002B\u0007\u0005\u001fAq!!?\u0003\u0006\u0001\u0007!\u0007C\u0004\u0002\"\n\u0015\u0001\u0019\u0001\"\t\u0011\tE!Q\u0001a\u0001\u0003#\faa\u001c4gg\u0016$\bb\u0002B\u000b\u0001\u0011\u0005!qC\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\tIG!\u0007\t\u000f\u0005\u0005&1\u0003a\u0001\u0005\"9!Q\u0004\u0001\u0005\u0002\t}\u0011A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003S\u0012\t\u0003C\u0004\u0002\"\nm\u0001\u0019\u0001\"\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(\u0005a\u0011m^1ji\u000ecW-\u00198fIRA!\u0011\u0006B\u0018\u0005c\u0011\u0019\u0004E\u0002\n\u0005WI1A!\f\u000b\u0005\u001d\u0011un\u001c7fC:Dq!!)\u0003$\u0001\u0007!\t\u0003\u0005\u0003\u0012\t\r\u0002\u0019AAi\u0011)\u0011)Da\t\u0011\u0002\u0003\u0007\u0011\u0011[\u0001\n[\u0006Dx+Y5u\u001bND\u0011B!\u000f\u0001#\u0003%\tAa\u000f\u0002-\u0005<\u0018-\u001b;DY\u0016\fg.\u001a3%I\u00164\u0017-\u001e7uIM*\"A!\u0010+\t\u0005E'qH\u0016\u0003\u0005\u0003\u0002BAa\u0011\u0003N5\u0011!Q\t\u0006\u0005\u0005\u000f\u0012I%A\u0005v]\u000eDWmY6fI*\u0019!1\n\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003P\t\u0015#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI!1\u000b\u0002\u0002\u0002#\u0005!QK\u0001\u000b\u0019><7\t\\3b]\u0016\u0014\bc\u0001\u0010\u0003X\u0019A\u0011AAA\u0001\u0012\u0003\u0011IfE\u0002\u0003X!Aq!\u001aB,\t\u0003\u0011i\u0006\u0006\u0002\u0003V!Q!\u0011\rB,#\u0003%\tAa\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011)GK\u0002`\u0005\u007f\u0001")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public CleanerConfig config() {
        return this.config;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting the log cleaner");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.start();
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down the log cleaner.");
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            x$10.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        this.cleanerManager().resumeCleaning(topicPartition);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public static final /* synthetic */ CleanerThread $anonfun$cleaners$1(LogCleaner $this, int x$1) {
        return $this.new CleanerThread(x$1);
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$11 -> x$11 >= offset$1));
    }

    public LogCleaner(CleanerConfig config, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map((Function1 & Serializable & scala.Serializable)x$1 -> LogCleaner.$anonfun$cleaners$1(this, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.lastStats(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToDouble((double)$anon$2.$anonfun$value$2(x$3)), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$2(CleanerStats x$3) {
                return (double)100 * x$3.bufferUtilization();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$2$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.lastStats(), IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)$anon$3.$anonfun$value$4(x$5)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)$anon$3.$anonfun$value$5(x$6)), IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }

            public static final /* synthetic */ long $anonfun$value$4(CleanerStats x$5) {
                return x$5.bytesWritten();
            }

            public static final /* synthetic */ long $anonfun$value$5(CleanerStats x$6) {
                return x$6.bytesRead();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$4$adapted(kafka.log.CleanerStats ), $anonfun$value$5$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.lastStats(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToDouble((double)$anon$4.$anonfun$value$7(x$8)), IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }

            public static final /* synthetic */ double $anonfun$value$7(CleanerStats x$8) {
                return x$8.elapsedSecs();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$6(kafka.log.LogCleaner$CleanerThread ), $anonfun$value$7$adapted(kafka.log.CleanerStats )}, serializedLambda);
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        private void checkDone(TopicPartition topicPartition) {
            if (!this.isRunning().get()) {
                throw new ThreadShutdownException();
            }
            this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        @Override
        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        private void cleanOrSleep() {
            block13: {
                boolean bl;
                Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time);
                if (None$.MODULE$.equals(option)) {
                    bl = false;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.value();
                    long endOffset = cleanable.firstDirtyOffset();
                    try {
                        try {
                            Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                            if (tuple2 == null) {
                                throw new MatchError(tuple2);
                            }
                            long nextDirtyOffset = tuple2._1$mcJ$sp();
                            CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                            Tuple2 tuple23 = tuple22;
                            long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                            CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                            this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                            endOffset = nextDirtyOffset2;
                        }
                        catch (LogCleaningAbortedException logCleaningAbortedException) {
                        }
                        catch (KafkaStorageException kafkaStorageException) {
                        }
                        catch (IOException e) {
                            String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to clean up log for ", " in dir ", " due to IOException"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.topicPartition(), cleanable.log().dir().getParent()}));
                            this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(cleanable.log().dir().getParent(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, e);
                        }
                    }
                    finally {
                        this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                    }
                    bl = true;
                } else {
                    throw new MatchError(option);
                }
                boolean cleaned = bl;
                Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                deletable.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)CleanerThread.$anonfun$cleanOrSleep$2(this, x0$1)));
                if (cleaned) break block13;
                this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            block0: {
                this.lastStats_$eq(stats);
                String message = new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)})) + new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)CleanerThread.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))})) + new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(CleanerThread.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))})) + new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())})) + new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)CleanerThread.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())})) + new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}));
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                if (stats.invalidMessagesRead() <= 0L) break block0;
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)stats.invalidMessagesRead())})));
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        public static final /* synthetic */ int $anonfun$cleanOrSleep$2(CleanerThread $this, Tuple2 x0$1) {
            int n;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Log log = (Log)tuple2._2();
                try {
                    n = log.deleteOldSegments();
                }
                finally {
                    $this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting(topicPartition);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            int n2 = n;
            return n2;
        }

        private static final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super("kafka-log-cleaner-thread-" + threadId, false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...");
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)(Function1 & Serializable & scala.Serializable)topicPartition -> {
                this.checkDone(topicPartition);
                return BoxedUnit.UNIT;
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

