/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.CleanedTransactionMetadata$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetMap;
import kafka.log.TimeIndex;
import kafka.log.TimeIndex$;
import kafka.log.TransactionIndex;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t]c!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005b\u0002.\u0001\u0005\u0004%\teW\u0001\u000bY><w-\u001a:OC6,W#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001eDa!\u001a\u0001!\u0002\u0013a\u0016a\u00037pO\u001e,'OT1nK\u0002Bqa\u001a\u0001A\u0002\u0013%\u0001.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0002\f1A\\5p\u0013\tq7N\u0001\u0006CsR,')\u001e4gKJDq\u0001\u001d\u0001A\u0002\u0013%\u0011/\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005)\u0013\bbB:p\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0004BB;\u0001A\u0003&\u0011.A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003bB<\u0001\u0001\u0004%I\u0001[\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\u0002\u001f]\u0014\u0018\u000e^3Ck\u001a4WM]0%KF$\"AS>\t\u000fMD\u0018\u0011!a\u0001S\"1Q\u0010\u0001Q!\n%\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002B\u0001b \u0001C\u0002\u0013%\u0011\u0011A\u0001\u001cI\u0016\u001cw.\u001c9sKN\u001c\u0018n\u001c8Ck\u001a4WM]*vaBd\u0017.\u001a:\u0016\u0005\u0005\r\u0001\u0003BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%\u0001(\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u001b\t9A\u0001\bCk\u001a4WM]*vaBd\u0017.\u001a:\t\u0011\u0005E\u0001\u0001)A\u0005\u0003\u0007\tA\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014\b\u0005\u0003\u0005\u0002\u0016\u0001!\tAAA\f\u0003\u0015\u0019G.Z1o)\u0011\tI\"a\u000b\u0011\u000f!\tY\"a\b\u0002&%\u0019\u0011QD\u0005\u0003\rQ+\b\u000f\\33!\rA\u0011\u0011E\u0005\u0004\u0003GI!\u0001\u0002'p]\u001e\u00042\u0001IA\u0014\u0013\r\tIC\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\t\u0003[\t\u0019\u00021\u0001\u00020\u0005I1\r\\3b]\u0006\u0014G.\u001a\t\u0004A\u0005E\u0012bAA\u001a\u0005\tQAj\\4U_\u000ecW-\u00198\t\u0011\u0005]\u0002\u0001\"\u0001\u0003\u0003s\tq\u0001Z8DY\u0016\fg\u000e\u0006\u0004\u0002\u001a\u0005m\u0012Q\b\u0005\t\u0003[\t)\u00041\u0001\u00020!A\u0011qHA\u001b\u0001\u0004\ty\"A\beK2,G/\u001a%pe&TxN\\'t\u0011!\t\u0019\u0005\u0001C\u0001\u0005\u0005\u0015\u0013!D2mK\u0006t7+Z4nK:$8\u000fF\u0006K\u0003\u000f\ny%!\u001d\u0002v\u0005]\u0004bB\u0002\u0002B\u0001\u0007\u0011\u0011\n\t\u0004A\u0005-\u0013bAA'\u0005\t\u0019Aj\\4\t\u0011\u0005E\u0013\u0011\ta\u0001\u0003'\n\u0001b]3h[\u0016tGo\u001d\t\u0007\u0003+\n)'a\u001b\u000f\t\u0005]\u0013\u0011\r\b\u0005\u00033\ny&\u0004\u0002\u0002\\)\u0019\u0011QL\u000b\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0011bAA2\u0013\u00059\u0001/Y2lC\u001e,\u0017\u0002BA4\u0003S\u00121aU3r\u0015\r\t\u0019'\u0003\t\u0004A\u00055\u0014bAA8\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005M\u0014\u0011\ta\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005}\u0012\u0011\ta\u0001\u0003?A\u0001\"!\u001f\u0002B\u0001\u0007\u0011QE\u0001\u0006gR\fGo\u001d\u0005\t\u0003{\u0002A\u0011\u0001\u0002\u0002\u0000\u0005I1\r\\3b]&sGo\u001c\u000b\u0014\u0015\u0006\u0005\u0015QQAH\u0003'\u000b)*a(\u0002$\u00065\u0016\u0011\u0019\u0005\b\u0003\u0007\u000bY\b1\u0001G\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001\"a\"\u0002|\u0001\u0007\u0011\u0011R\u0001\u000eg>,(oY3SK\u000e|'\u000fZ:\u0011\t\u0005\u0015\u00111R\u0005\u0005\u0003\u001b\u000b9AA\u0006GS2,'+Z2pe\u0012\u001c\b\u0002CAI\u0003w\u0002\r!a\u001b\u0002\t\u0011,7\u000f\u001e\u0005\b\u0003g\nY\b1\u0001 \u0011!\t9*a\u001fA\u0002\u0005e\u0015!\u0004:fi\u0006Lg\u000eR3mKR,7\u000fE\u0002\t\u00037K1!!(\n\u0005\u001d\u0011un\u001c7fC:Dq!!)\u0002|\u0001\u0007q#A\tnCbdunZ'fgN\fw-Z*ju\u0016D\u0001\"!*\u0002|\u0001\u0007\u0011qU\u0001\u0014iJ\fgn]1di&|g.T3uC\u0012\fG/\u0019\t\u0004A\u0005%\u0016bAAV\u0005\tQ2\t\\3b]\u0016$GK]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\"A\u0011qVA>\u0001\u0004\t\t,A\bbGRLg/\u001a)s_\u0012,8-\u001a:t!\u001d\t\u0019,a/\u0002 ]qA!!.\u00028B\u0019\u0011\u0011L\u0005\n\u0007\u0005e\u0016\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\u000byLA\u0002NCBT1!!/\n\u0011!\tI(a\u001fA\u0002\u0005\u0015\u0002bBAc\u0001\u0011%\u0011qY\u0001\u0013g\"|W\u000f\u001c3ESN\u001c\u0017M\u001d3CCR\u001c\u0007\u000e\u0006\u0005\u0002\u001a\u0006%\u00171[Ak\u0011!\tY-a1A\u0002\u00055\u0017!\u00022bi\u000eD\u0007\u0003BA\u0003\u0003\u001fLA!!5\u0002\b\tY!+Z2pe\u0012\u0014\u0015\r^2i\u0011!\t)+a1A\u0002\u0005\u001d\u0006\u0002CAl\u0003\u0007\u0004\r!!'\u0002!I,G/Y5o)btW*\u0019:lKJ\u001c\bbBAn\u0001\u0011%\u0011Q\\\u0001\u0013g\"|W\u000f\u001c3SKR\f\u0017N\u001c*fG>\u0014H\r\u0006\u0007\u0002\u001a\u0006}\u0017\u0011]Ar\u0003K\fi\u000fC\u0004\u0002t\u0005e\u0007\u0019A\u0010\t\u0011\u0005]\u0015\u0011\u001ca\u0001\u00033C\u0001\"a3\u0002Z\u0002\u0007\u0011Q\u001a\u0005\t\u0003\u0013\tI\u000e1\u0001\u0002hB!\u0011QAAu\u0013\u0011\tY/a\u0002\u0003\rI+7m\u001c:e\u0011!\tI(!7A\u0002\u0005\u0015\u0002bBAy\u0001\u0011\u0005\u00111_\u0001\fOJ|wOQ;gM\u0016\u00148\u000fF\u0002K\u0003kDq!!)\u0002p\u0002\u0007q\u0003C\u0004\u0002z\u0002!\t!a?\u0002\u001dI,7\u000f^8sK\n+hMZ3sgR\t!\n\u0003\u0005\u0002\u0000\u0002!\tA\u0001B\u0001\u0003M9'o\\;q'\u0016<W.\u001a8ug\nK8+\u001b>f))\u0011\u0019A!\u0003\u0003\u0012\tU!\u0011\u0004\t\u0007\u0003+\u0012)!a\u0015\n\t\t\u001d\u0011\u0011\u000e\u0002\u0005\u0019&\u001cH\u000f\u0003\u0005\u0002R\u0005u\b\u0019\u0001B\u0006!\u0019\t)F!\u0004\u0002l%!!qBA5\u0005!IE/\u001a:bE2,\u0007b\u0002B\n\u0003{\u0004\raF\u0001\b[\u0006D8+\u001b>f\u0011\u001d\u00119\"!@A\u0002]\tA\"\\1y\u0013:$W\r_*ju\u0016D\u0001Ba\u0007\u0002~\u0002\u0007\u0011qD\u0001\u0017M&\u00148\u000f^+oG2,\u0017M\\1cY\u0016|eMZ:fi\"9!q\u0004\u0001\u0005\n\t\u0005\u0012!\u00077bgR|eMZ:fi\u001a{'OR5sgR\u001cVmZ7f]R$b!a\b\u0003$\t%\u0002\u0002\u0003B\u0013\u0005;\u0001\rAa\n\u0002\tM,wm\u001d\t\u0007\u0003+\u0012)!a\u001b\t\u0011\tm!Q\u0004a\u0001\u0003?A\u0001B!\f\u0001\t\u0003\u0011!qF\u0001\u000fEVLG\u000eZ(gMN,G/T1q)-Q%\u0011\u0007B\u001a\u0005o\u0011YD!\u0010\t\u000f\r\u0011Y\u00031\u0001\u0002J!A!Q\u0007B\u0016\u0001\u0004\ty\"A\u0003ti\u0006\u0014H\u000f\u0003\u0005\u0003:\t-\u0002\u0019AA\u0010\u0003\r)g\u000e\u001a\u0005\b\u0003g\u0012Y\u00031\u0001 \u0011!\tIHa\u000bA\u0002\u0005\u0015\u0002b\u0002B!\u0001\u0011%!1I\u0001\u0019EVLG\u000eZ(gMN,G/T1q\r>\u00148+Z4nK:$H\u0003EAM\u0005\u000b\u00129Ea\u0013\u0003N\tE#1\u000bB+\u0011\u001d\t\u0019Ia\u0010A\u0002\u0019C\u0001B!\u0013\u0003@\u0001\u0007\u00111N\u0001\bg\u0016<W.\u001a8u\u0011\u001d\t\u0019Ha\u0010A\u0002}A\u0001Ba\u0014\u0003@\u0001\u0007\u0011qD\u0001\fgR\f'\u000f^(gMN,G\u000fC\u0004\u0002\"\n}\u0002\u0019A\f\t\u0011\u0005\u0015&q\ba\u0001\u0003OC\u0001\"!\u001f\u0003@\u0001\u0007\u0011Q\u0005")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    private final Function1<TopicPartition, BoxedUnit> checkDone;
    private final String loggerName;
    private ByteBuffer readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private ByteBuffer readBuffer() {
        return this.readBuffer;
    }

    private void readBuffer_$eq(ByteBuffer x$1) {
        this.readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        long l;
        Option option = cleanable.log().logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
        if (None$.MODULE$.equals(option)) {
            l = 0L;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LogSegment seg = (LogSegment)some.value();
            l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
        } else {
            throw new MatchError((Object)option);
        }
        long deleteHorizonMs = l;
        return this.doClean(cleanable, deleteHorizonMs);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        Log log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.log().name()})));
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.lastModified())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), new Date(cleanableHorizonMs), new Date(deleteHorizonMs)})));
        this.groupSegmentsBySize(log.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.cleanSegments(log, (Seq<LogSegment>)group, this.offsetMap(), deleteHorizonMs, stats);
            return BoxedUnit.UNIT;
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    public void cleanSegments(Log log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats) {
        LogSegment firstSegment = (LogSegment)segments.head();
        File logFile = Cleaner.deleteAndGetCleanedFile$1(firstSegment.log().file());
        File indexFile = Cleaner.deleteAndGetCleanedFile$1(firstSegment.index().file());
        File timeIndexFile = Cleaner.deleteAndGetCleanedFile$1(firstSegment.timeIndex().file());
        File txnIndexFile = Cleaner.deleteAndGetCleanedFile$1(firstSegment.txnIndex().file());
        long startOffset = firstSegment.baseOffset();
        FileRecords records = FileRecords.open((File)logFile, (boolean)false, (int)log.initFileSize(), (boolean)Predef$.MODULE$.Boolean2boolean(log.config().preallocate()));
        OffsetIndex index = new OffsetIndex(indexFile, startOffset, firstSegment.index().maxIndexSize(), OffsetIndex$.MODULE$.$lessinit$greater$default$4());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, startOffset, firstSegment.timeIndex().maxIndexSize(), TimeIndex$.MODULE$.$lessinit$greater$default$4());
        TransactionIndex txnIndex = new TransactionIndex(startOffset, txnIndexFile);
        LogSegment cleaned = new LogSegment(records, index, timeIndex, txnIndex, startOffset, firstSegment.indexIntervalBytes(), log.config().randomSegmentJitter(), this.time);
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset2 = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> map.latestOffset() + 1L));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset2, upperBoundOffset);
                CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, (Option<TransactionIndex>)new Some((Object)txnIndex));
                boolean retainDeletes = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning segment ", " in log ", " (largest timestamp ", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)startOffset2), log.name(), new Date(currentSegment.largestTimestamp())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"into ", ", ", " deletes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)cleaned.baseOffset()), retainDeletes ? "retaining" : "discarding"})));
                this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletes, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, log.activeProducersWithLastSequence(), stats);
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.log().trim();
            index.trimToValidSize();
            cleaned.onBecomeInactiveSegment();
            timeIndex.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)cleaned.baseOffset()), ((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.baseOffset()), Seq$.MODULE$.canBuildFrom())).mkString(","), log.name()})));
            log.replaceSegments(cleaned, segments, log.replaceSegments$default$3());
        }
        catch (LogCleaningAbortedException e) {
            cleaned.delete();
            throw e;
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletes, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, Object> activeProducers, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, map, retainDeletes, transactionMetadata, activeProducers, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanedTransactionMetadata transactionMetadata$1;
            private final Map activeProducers$1;
            private final CleanerStats stats$4;

            public boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            public void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$1, this.retainDeletes$2));
                return batch.hasProducerId() && this.activeProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch.producerId())).contains((Object)BoxesRunTime.boxToInteger((int)batch.lastSequence())) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$3, this.retainDeletes$2, batch, record, this.stats$4);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.transactionMetadata$1 = transactionMetadata$1;
                this.activeProducers$1 = activeProducers$1;
                this.stats$4 = stats$4;
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.checkDone.apply((Object)topicPartition);
            this.readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead, result.bytesRead);
            stats.recopyMessages(result.messagesRetained, result.bytesRetained);
            position += result.bytesRead;
            ByteBuffer outputBuffer = result.output;
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(((RecordBatch)retained.batches().iterator().next()).baseOffset(), result.maxOffset, result.maxTimestamp, result.shallowOffsetOfMaxTimestamp, retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.readBuffer().limit() <= 0 || result.bytesRead != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record.hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = record.key();
            long foundOffset = map.get(key);
            boolean redundant = foundOffset >= 0L && record.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && !record.hasValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Growing cleaner I/O buffers from " + this.readBuffer().capacity() + "bytes to " + newSize + " bytes.");
        this.readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        block1: {
            if (this.readBuffer().capacity() > this.ioBufferSize) {
                this.readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
            }
            if (this.writeBuffer().capacity() <= this.ioBufferSize) break block1;
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).index().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).index().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? ((LogSegment)segs.apply(1)).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(Log log, long start, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.logSegments(start, end).toBuffer();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name(), BoxesRunTime.boxToInteger((int)dirty.size()), BoxesRunTime.boxToLong((long)start), BoxesRunTime.boxToLong((long)end)})));
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start, end);
        CleanedTransactionMetadata transactionMetadata = CleanedTransactionMetadata$.MODULE$.apply(abortedTransactions, CleanedTransactionMetadata$.MODULE$.apply$default$2());
        BooleanRef full = BooleanRef.create((boolean)false);
        dirty.withFilter((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)Cleaner.$anonfun$buildOffsetMap$2(full, segment))).foreach((Function1 & Serializable & scala.Serializable)segment -> {
            Cleaner.$anonfun$buildOffsetMap$3(this, log, start, map, stats, dirty, transactionMetadata, full, segment);
            return BoxedUnit.UNIT;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{log.name()})));
    }

    private boolean buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        boolean bl;
        Object object = new Object();
        try {
            int position = segment.index().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (position < segment.log().sizeInBytes()) {
                this.checkDone.apply((Object)topicPartition);
                this.readBuffer().clear();
                segment.log().readInto(this.readBuffer(), position);
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    Cleaner.$anonfun$buildOffsetMapForSegment$1(map, startOffset, transactionMetadata, stats, maxDesiredMapSize, object, batch);
                    return BoxedUnit.UNIT;
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffers(maxLogMessageSize);
            }
            this.restoreBuffers();
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static final File deleteAndGetCleanedFile$1(File file) {
        void var1_1;
        File f = new File(file.getPath() + Log$.MODULE$.CleanedFileSuffix());
        f.delete();
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$buildOffsetMap$2(BooleanRef full$1, LogSegment segment) {
        return !full$1.elem;
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMap$3(Cleaner $this, Log log$2, long start$1, OffsetMap map$1, CleanerStats stats$3, Buffer dirty$1, CleanedTransactionMetadata transactionMetadata$2, BooleanRef full$1, LogSegment segment) {
        block0: {
            $this.checkDone.apply((Object)log$2.topicPartition());
            full$1.elem = $this.buildOffsetMapForSegment(log$2.topicPartition(), segment, map$1, start$1, Predef$.MODULE$.Integer2int(log$2.config().maxMessageSize()), transactionMetadata$2, stats$3);
            if (!full$1.elem) break block0;
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)dirty$1.indexOf((Object)segment)), BoxesRunTime.boxToLong((long)segment.baseOffset())})));
        }
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$2(OffsetMap map$4, long startOffset$2, CleanerStats stats$5, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, Record record) {
        if (record.hasKey() && record.offset() >= startOffset$2) {
            if (map$4.size() < maxDesiredMapSize$1) {
                map$4.put(record.key(), record.offset());
            } else {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
            }
        }
        stats$5.indexMessagesRead(1);
    }

    public static final /* synthetic */ void $anonfun$buildOffsetMapForSegment$1(OffsetMap map$4, long startOffset$2, CleanedTransactionMetadata transactionMetadata$3, CleanerStats stats$5, int maxDesiredMapSize$1, Object nonLocalReturnKey1$1, MutableRecordBatch batch) {
        block4: {
            if (batch.isControlBatch()) {
                transactionMetadata$3.onControlBatchRead((RecordBatch)batch);
                stats$5.indexMessagesRead(1);
            } else {
                boolean isAborted = transactionMetadata$3.onBatchRead((RecordBatch)batch);
                if (isAborted) {
                    stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                } else {
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable & scala.Serializable)record -> {
                        Cleaner.$anonfun$buildOffsetMapForSegment$2(map$4, startOffset$2, stats$5, maxDesiredMapSize$1, nonLocalReturnKey1$1, record);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            if (batch.lastOffset() < startOffset$2) break block4;
            map$4.updateLatestOffset(batch.lastOffset());
        }
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.checkDone = checkDone;
        Logging.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq("Cleaner " + id + ": ");
        this.readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0 & Serializable & scala.Serializable)() -> "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads");
    }
}

