/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tools;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import kafka.log.Log;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.serdes.TierKafkaKey;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.tools.DumpTierPartitionState;
import kafka.tier.tools.TierTopicMaterializationToolConfig;
import kafka.tier.topic.TierMessageFormatter;
import kafka.tier.topic.TierTopicManager;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;

public class TierTopicMaterializationUtils {
    private final String topic = "_confluent-tier-state";
    public KafkaConsumer<byte[], byte[]> consumer;
    private ConsumerRecords<byte[], byte[]> records;
    public TierTopicMaterializationToolConfig config;
    private HashMap<TopicIdPartition, Long> offsetMap = null;
    public HashMap<TopicIdPartition, FileTierPartitionState> stateMap = new HashMap();
    private UserTierPartition targetTierPartition;
    private Set<TopicIdPartition> doneConsumption = null;
    private static final int SAMPLING_INTERVAL = 1000;

    public TierTopicMaterializationUtils(TierTopicMaterializationToolConfig config, HashMap<TopicIdPartition, Long> offsetMap) {
        this(config);
        this.offsetMap = offsetMap;
    }

    TierTopicMaterializationUtils(TierTopicMaterializationToolConfig config) {
        this.config = config;
        this.consumer = new KafkaConsumer(this.getConsumerProperties(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.targetTierPartition = new UserTierPartition(null, config.userTopicId, config.userPartition);
        this.doneConsumption = new HashSet<TopicIdPartition>();
    }

    public void setupConsumer(TierTopicMaterializationToolConfig config) {
        if (config.partition != -1) {
            this.seek(this.topic, config.partition, config.startOffset);
        } else {
            List partitions = this.consumer.partitionsFor(this.topic);
            Set<TopicPartition> tierTopicPartitions = TierTopicManager.partitions(this.topic, partitions.size());
            System.out.println("Listening on all " + partitions.size() + " partitions of tier topic");
            this.consumer.assign(tierTopicPartitions);
            this.consumer.seekToBeginning(tierTopicPartitions);
        }
    }

    private void fetchRecords() {
        this.records = this.consumer.poll(Duration.ofSeconds(30L));
        if (this.records.isEmpty()) {
            throw new TimeoutException();
        }
    }

    private File getStateFolder(TopicIdPartition id) {
        return new File(this.config.materializationPath + "/" + id.topic() + "-" + id.partition());
    }

    public void run() throws IOException {
        boolean materialize = this.config.getBoolean("materialize");
        int recordCount = 0;
        int currentOffset = this.config.startOffset;
        TierMessageFormatter writer = new TierMessageFormatter();
        this.setupConsumer(this.config);
        System.out.println("Materializing from " + this.config.startOffset + " till  " + this.config.endOffset);
        try {
            while (this.config.endOffset == -1 || currentOffset <= this.config.endOffset) {
                this.fetchRecords();
                for (ConsumerRecord record2 : this.records) {
                    currentOffset = (int)record2.offset();
                    TopicIdPartition id = AbstractTierMetadata.deserializeKey((byte[])record2.key());
                    if (!this.doMaterialize(id, record2.offset())) continue;
                    if (this.config.dumpEvents.booleanValue() || ++recordCount % 1000 == 0) {
                        writer.writeTo((ConsumerRecord<byte[], byte[]>)record2, System.out);
                    }
                    if (!materialize) continue;
                    this.materializeRecord((ConsumerRecord<byte[], byte[]>)record2, id);
                }
                if (!this.exitLoop()) continue;
                System.out.println("Done reading events for all configured source topic partitions.");
                break;
            }
        }
        catch (TimeoutException | WakeupException we) {
            System.out.println("Timeout after processing " + recordCount + " messages.");
        }
        this.saveMaterializedStates();
        this.dumpMaterializedState();
    }

    private boolean exitLoop() {
        return this.offsetMap != null && this.offsetMap.isEmpty();
    }

    private void saveMaterializedStates() throws IOException {
        for (TopicIdPartition id : this.stateMap.keySet()) {
            System.out.println("Closing state file " + id);
            this.stateMap.get(id).close();
        }
    }

    private boolean doMaterialize(TopicIdPartition tpid, Long offset2) {
        if (this.offsetMap != null) {
            if (!this.offsetMap.containsKey(tpid)) {
                return false;
            }
            if (this.offsetMap.get(tpid) >= offset2) {
                return true;
            }
            this.offsetMap.remove(tpid);
            return false;
        }
        return this.targetTierPartition.filter(tpid.topic(), tpid.partition(), tpid.topicId());
    }

    private void materializeRecord(ConsumerRecord<byte[], byte[]> record2, TopicIdPartition id) throws IOException {
        AbstractTierMetadata entry2;
        TierPartitionState.AppendResult result;
        FileTierPartitionState state = this.getStateIfRequired(record2, id);
        Optional<AbstractTierMetadata> entryOpt = AbstractTierMetadata.deserialize((byte[])record2.key(), (byte[])record2.value());
        if (entryOpt.isPresent() && !(result = state.append(entry2 = entryOpt.get(), record2.offset())).equals((Object)TierPartitionState.AppendResult.ACCEPTED)) {
            System.out.println((Object)((Object)state.append(entry2, record2.offset())) + " offset " + record2.offset());
        }
    }

    private FileTierPartitionState getStateIfRequired(ConsumerRecord<byte[], byte[]> record2, TopicIdPartition id) throws IOException {
        if (!this.stateMap.containsKey(id)) {
            TierKafkaKey tierKey = TierKafkaKey.getRootAsTierKafkaKey(ByteBuffer.wrap((byte[])record2.key()));
            File path = this.getStateFolder(id);
            if (!path.exists()) {
                path.mkdirs();
            }
            FileTierPartitionState state = new FileTierPartitionState(path, new TopicPartition(tierKey.topicName(), tierKey.partition()), true);
            state.setTopicId(new UUID(tierKey.topicId().mostSignificantBits(), tierKey.topicId().leastSignificantBits()));
            this.stateMap.put(id, state);
            this.stateMap.get(id).onCatchUpComplete();
        }
        return this.stateMap.get(id);
    }

    private void dumpMaterializedState() {
        if (!this.config.dumpRecords.booleanValue() && !this.config.dumpHeader.booleanValue()) {
            return;
        }
        for (TopicIdPartition id : this.stateMap.keySet()) {
            File basePath = this.getStateFolder(id);
            for (File file : basePath.listFiles()) {
                if (!file.isFile() || !Log.isTierStateFile(file)) continue;
                System.out.println("Dumping for " + basePath);
                if (this.config.dumpHeader.booleanValue()) {
                    DumpTierPartitionState.dumpTierState(id.topicPartition(), file, true);
                    continue;
                }
                DumpTierPartitionState.dumpTierState(id.topicPartition(), file, false);
            }
        }
    }

    public Path getTierStateFile(TopicIdPartition id) {
        File basePath = this.getStateFolder(id);
        for (File file : basePath.listFiles()) {
            if (!file.isFile() || !Log.isTierStateFile(file)) continue;
            return file.toPath();
        }
        return null;
    }

    private void seek(String topic, Integer partition, Integer offset2) {
        TopicPartition topicPartition = new TopicPartition(topic, partition.intValue());
        this.consumer.assign(Collections.singletonList(topicPartition));
        this.consumer.seek(topicPartition, (long)offset2.intValue());
    }

    private Properties getConsumerProperties() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.config.server);
        props.put("session.timeout.ms", "30000");
        props.put("group.id", "tier-topic-materialization-tool");
        return props;
    }

    private class UserTierPartition {
        final String name;
        final UUID id;
        final Integer partitionId;

        UserTierPartition(String name, UUID id, Integer partitionId) {
            this.name = name;
            this.id = id;
            this.partitionId = partitionId;
        }

        public boolean filter(String name, Integer partitonId, UUID id) {
            return !(this.name != null && !this.name.equals(name) || !this.id.equals(TierTopicMaterializationToolConfig.EMPTY_UUID) && !this.id.equals(id) || !this.partitionId.equals(-1) && !this.partitionId.equals(partitonId));
        }
    }
}

