/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import java.util.concurrent.CancellationException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.tier.tasks.UpdatableQueueEntry;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0003\u0013\tqQ\u000b\u001d3bi\u0006\u0014G.Z)vKV,'BA\u0002\u0005\u0003\u0015!\u0018m]6t\u0015\t)a!\u0001\u0003uS\u0016\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001U\u0011!\u0002G\n\u0003\u0001-\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007\"\u0002\n\u0001\t\u0003\u0019\u0012A\u0002\u001fj]&$h\bF\u0001\u0015!\r)\u0002AF\u0007\u0002\u0005A\u0011q\u0003\u0007\u0007\u0001\t\u0015I\u0002A1\u0001\u001b\u0005\u0005!\u0016CA\u000e\u001f!\taA$\u0003\u0002\u001e\u001b\t9aj\u001c;iS:<\u0007CA\u000b \u0013\t\u0001#AA\nVa\u0012\fG/\u00192mKF+X-^3F]R\u0014\u0018\u0010C\u0004#\u0001\t\u0007I\u0011B\u0012\u0002\t1|7m[\u000b\u0002IA\u0011QEL\u0007\u0002M)\u0011q\u0005K\u0001\u0006Y>\u001c7n\u001d\u0006\u0003S)\n!bY8oGV\u0014(/\u001a8u\u0015\tYC&\u0001\u0003vi&d'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_\u0019\u0012A\u0001T8dW\"1\u0011\u0007\u0001Q\u0001\n\u0011\nQ\u0001\\8dW\u0002Bqa\r\u0001C\u0002\u0013%A'\u0001\u0003d_:$W#A\u001b\u0011\u0005\u00152\u0014BA\u001c'\u0005%\u0019uN\u001c3ji&|g\u000e\u0003\u0004:\u0001\u0001\u0006I!N\u0001\u0006G>tG\r\t\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0003\u0015IG/Z7t+\u0005i\u0004\u0003\u0002 D\u000bZi\u0011a\u0010\u0006\u0003\u0001\u0006\u000bq!\\;uC\ndWM\u0003\u0002C\u001b\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011{$aA'baB\u0011aCR\u0005\u0003\u000f~\u00111aS3z\u0011\u0019I\u0005\u0001)A\u0005{\u00051\u0011\u000e^3ng\u0002Bqa\u0013\u0001C\u0002\u0013%A*A\u0003rk\u0016,X-F\u0001N!\rqd*R\u0005\u0003\u001f~\u0012Q!U;fk\u0016Da!\u0015\u0001!\u0002\u0013i\u0015AB9vKV,\u0007\u0005C\u0004T\u0001\u0001\u0007I\u0011\u0002+\u0002\r\rdwn]3e+\u0005)\u0006C\u0001\u0007W\u0013\t9VBA\u0004C_>dW-\u00198\t\u000fe\u0003\u0001\u0019!C\u00055\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0005ms\u0006C\u0001\u0007]\u0013\tiVB\u0001\u0003V]&$\bbB0Y\u0003\u0003\u0005\r!V\u0001\u0004q\u0012\n\u0004BB1\u0001A\u0003&Q+A\u0004dY>\u001cX\r\u001a\u0011\t\u000b\r\u0004A\u0011\u00013\u0002\tA,8\u000f\u001b\u000b\u00037\u0016DQA\u001a2A\u0002Y\tA!\u001b;f[\")\u0001\u000e\u0001C\u0001S\u0006\u0001\u0002/^:i\u0013\u001atu\u000e\u001e)sKN,g\u000e\u001e\u000b\u00037*DQAZ4A\u0002YAQ\u0001\u001c\u0001\u0005\u00025\fA\u0001]8mYR\ta\u000eE\u0002\r_ZI!\u0001]\u0007\u0003\r=\u0003H/[8o\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0011!\u0018m[3\u0015\u0003YAQ!\u001e\u0001\u0005\u0002Y\fQa\u00197pg\u0016$\u0012a\u0017")
public final class UpdatableQueue<T extends UpdatableQueueEntry> {
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock().newCondition();
    private final Map<Object, T> items = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final Queue<Object> queue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
    private boolean closed = false;

    private Lock lock() {
        return this.lock;
    }

    private Condition cond() {
        return this.cond;
    }

    private Map<Object, T> items() {
        return this.items;
    }

    private Queue<Object> queue() {
        return this.queue;
    }

    private boolean closed() {
        return this.closed;
    }

    private void closed_$eq(boolean x$1) {
        this.closed = x$1;
    }

    public void push(T item) {
        Object key = item.key();
        this.lock().lock();
        try {
            if (this.closed()) {
                throw new CancellationException("queue closed");
            }
            if (!this.items().contains(key)) {
                this.queue().enqueue((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}));
            }
            this.items().update(key, item);
            this.cond().signal();
            return;
        }
        finally {
            this.lock().unlock();
        }
    }

    public void pushIfNotPresent(T item) {
        Object key = item.key();
        this.lock().lock();
        try {
            if (!this.items().contains(key)) {
                this.queue().enqueue((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}));
                this.items().update(key, item);
                this.cond().signal();
            }
            return;
        }
        finally {
            this.lock().unlock();
        }
    }

    public Option<T> poll() {
        this.lock().lock();
        try {
            Option option;
            block11: {
                None$ none$;
                block10: {
                    block9: {
                        if (this.closed()) {
                            throw new CancellationException("queue closed");
                        }
                        if (!this.queue().isEmpty()) break block9;
                        none$ = None$.MODULE$;
                        break block10;
                    }
                    Object key = this.queue().dequeue();
                    option = this.items().remove(key);
                    if (!(option instanceof Some)) break block11;
                    Some some = (Some)option;
                    UpdatableQueueEntry item = (UpdatableQueueEntry)some.x();
                    Some some2 = new Some((Object)item);
                    none$ = some2;
                }
                return none$;
            }
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException("Illegal queue state");
            }
            throw new MatchError((Object)option);
        }
        finally {
            this.lock().unlock();
        }
    }

    public T take() {
        this.lock().lock();
        try {
            while (!this.closed() && this.queue().isEmpty()) {
                this.cond().await();
            }
            if (this.closed()) {
                throw new CancellationException("queue closed");
            }
            return (T)((UpdatableQueueEntry)this.poll().get());
        }
        finally {
            this.lock().unlock();
        }
    }

    public void close() {
        this.lock().lock();
        try {
            this.closed_$eq(true);
            this.cond().signalAll();
            return;
        }
        finally {
            this.lock().unlock();
        }
    }
}

