/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks;

import com.typesafe.scalalogging.Logger;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.TierReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.ChangeMetadata;
import kafka.tier.tasks.StartChangeMetadata;
import kafka.tier.tasks.StartLeadership;
import kafka.tier.tasks.StartPartitionDeletion;
import kafka.tier.tasks.StopChangeMetadata;
import kafka.tier.tasks.StopLeadership;
import kafka.tier.tasks.StopPartitionDeletion;
import kafka.tier.tasks.TierTaskQueue;
import kafka.tier.tasks.UpdatableQueue;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001%\u0011Qb\u00115b]\u001e,W*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003\u0015!\u0018m]6t\u0015\t)a!\u0001\u0003uS\u0016\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0004\u0001M1\u0001A\u0003\n\u001b;\r\u0002\"a\u0003\t\u000e\u00031Q!!\u0004\b\u0002\t1\fgn\u001a\u0006\u0002\u001f\u0005!!.\u0019<b\u0013\t\tBB\u0001\u0004PE*,7\r\u001e\t\u0003']q!\u0001F\u000b\u000e\u0003\u0011I!A\u0006\u0003\u0002%QKWM\u001d*fa2L7-Y'b]\u0006<WM]\u0005\u00031e\u0011ab\u00115b]\u001e,G*[:uK:,'O\u0003\u0002\u0017\tA\u0011AcG\u0005\u00039\u0011\u0011q\u0004R3mKR,G\rU1si&$\u0018n\u001c8t\u0007\"\fgnZ3MSN$XM\\3s!\tq\u0012%D\u0001 \u0015\t\u0001c!A\u0003vi&d7/\u0003\u0002#?\t9Aj\\4hS:<\u0007CA\u0006%\u0013\t)CBA\u0007BkR|7\t\\8tK\u0006\u0014G.\u001a\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005\u00191\r\u001e=\u0011\u0005%bS\"\u0001\u0016\u000b\u0005-\"\u0011a\u00024fi\u000eDWM]\u0005\u0003[)\u00121cQ1oG\u0016dG.\u0019;j_:\u001cuN\u001c;fqRD\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001M\u0001\u000bi\u0006\u001c8.U;fk\u0016\u001c\bcA\u0019<}9\u0011!\u0007\u000f\b\u0003gYj\u0011\u0001\u000e\u0006\u0003k!\ta\u0001\u0010:p_Rt\u0014\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005eR\u0014a\u00029bG.\fw-\u001a\u0006\u0002o%\u0011A(\u0010\u0002\u0004'\u0016\f(BA\u001d;a\tyT\tE\u0002A\u0003\u000ek\u0011AA\u0005\u0003\u0005\n\u0011Q\u0002V5feR\u000b7o[)vKV,\u0007C\u0001#F\u0019\u0001!\u0011B\u0012\u0018\u0002\u0002\u0003\u0005)\u0011A$\u0003\u0007}#\u0013'\u0005\u0002I\u0019B\u0011\u0011JS\u0007\u0002u%\u00111J\u000f\u0002\b\u001d>$\b.\u001b8h!\tIU*\u0003\u0002Ou\t\u0019\u0011I\\=\t\u0011A\u0003!\u0011!Q\u0001\nE\u000bA\u0001^5nKB\u0011!kW\u0007\u0002'*\u0011\u0001\u0005\u0016\u0006\u0003+Z\u000baaY8n[>t'BA\u0004X\u0015\tA\u0016,\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0006\u0019qN]4\n\u0005q\u001b&\u0001\u0002+j[\u0016DQA\u0018\u0001\u0005\u0002}\u000ba\u0001P5oSRtD\u0003\u00021bE\"\u0004\"\u0001\u0011\u0001\t\u000b\u001dj\u0006\u0019\u0001\u0015\t\u000b=j\u0006\u0019A2\u0011\u0007EZD\r\r\u0002fOB\u0019\u0001)\u00114\u0011\u0005\u0011;G!\u0003$c\u0003\u0003\u0005\tQ!\u0001H\u0011\u0015\u0001V\f1\u0001R\u0011\u0015Q\u0007\u0001\"\u0011l\u0003)awnZ4fe:\u000bW.Z\u000b\u0002YB\u0011Q\u000e\u001d\b\u0003\u0013:L!a\u001c\u001e\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_jBq\u0001\u001e\u0001C\u0002\u0013%Q/A\u0006dQ\u0006tw-Z)vKV,W#\u0001<\u0011\u0007\u0001;\u00180\u0003\u0002y\u0005\tqQ\u000b\u001d3bi\u0006\u0014G.Z)vKV,\u0007C\u0001!{\u0013\tY(A\u0001\bDQ\u0006tw-Z'fi\u0006$\u0017\r^1\t\ru\u0004\u0001\u0015!\u0003w\u00031\u0019\u0007.\u00198hKF+X-^3!\u0011\u0019y\b\u0001\"\u0011\u0002\u0002\u0005qqN\u001c\"fG>lW\rT3bI\u0016\u0014HCBA\u0002\u0003\u0013\t\u0019\u0002E\u0002J\u0003\u000bI1!a\u0002;\u0005\u0011)f.\u001b;\t\u000f\u0005-a\u00101\u0001\u0002\u000e\u0005\u0001Bo\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\t\u0004)\u0005=\u0011bAA\t\t\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003+q\b\u0019AA\f\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0007%\u000bI\"C\u0002\u0002\u001ci\u00121!\u00138u\u0011\u001d\ty\u0002\u0001C!\u0003C\t\u0001c\u001c8CK\u000e|W.\u001a$pY2|w/\u001a:\u0015\t\u0005\r\u00111\u0005\u0005\t\u0003\u0017\ti\u00021\u0001\u0002\u000e!9\u0011q\u0005\u0001\u0005B\u0005%\u0012\u0001C8o\t\u0016dW\r^3\u0015\t\u0005\r\u00111\u0006\u0005\t\u0003\u0017\t)\u00031\u0001\u0002\u000e!9\u0011q\u0006\u0001\u0005B\u0005E\u0012!G5oSRL\u0017\r^3QCJ$\u0018\u000e^5p]\u0012+G.\u001a;j_:$b!a\u0001\u00024\u0005U\u0002\u0002CA\u0006\u0003[\u0001\r!!\u0004\t\u0011\u0005]\u0012Q\u0006a\u0001\u0003s\tQ\u0002^5fe\u0016$wJ\u00196fGR\u001c\b#B\u0019\u0002<\u0005}\u0012bAA\u001f{\t!A*[:u!\u0011\t\t%!\u0014\u000f\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012\u0005\u0003\u0015\u0019Ho\u001c:f\u0013\u0011\tY%!\u0012\u0002\u001fQKWM](cU\u0016\u001cGo\u0015;pe\u0016LA!a\u0014\u0002R\tqqJ\u00196fGRlU\r^1eCR\f'\u0002BA&\u0003\u000bBq!!\u0016\u0001\t\u0003\n9&A\u000bti>\u0004\b+\u0019:uSRLwN\u001c#fY\u0016$\u0018n\u001c8\u0015\t\u0005\r\u0011\u0011\f\u0005\t\u0003\u0017\t\u0019\u00061\u0001\u0002\u000e!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013!\u00059s_\u000e,7o]!u\u0019\u0016\f7\u000f^(oKR\u0011\u00111\u0001\u0005\b\u0003G\u0002A\u0011AA0\u0003\u001d\u0001(o\\2fgNDq!a\u001a\u0001\t\u0003\ny&A\u0003dY>\u001cX\rC\u0004\u0002l\u0001!I!!\u001c\u0002\u001bA\u0014xnY3tg\u000eC\u0017M\\4f)\u0011\t\u0019!a\u001c\t\u000f\u0005E\u0014\u0011\u000ea\u0001s\u000611\r[1oO\u0016\u0004")
public class ChangeManager
implements TierReplicaManager.ChangeListener,
DeletedPartitionsChangeListener,
Logging,
AutoCloseable {
    private final CancellationContext ctx;
    private final Seq<TierTaskQueue<?>> taskQueues;
    private final UpdatableQueue<ChangeMetadata> changeQueue;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ChangeManager changeManager = this;
        synchronized (changeManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    @Override
    public String loggerName() {
        return ChangeManager.class.getName();
    }

    private UpdatableQueue<ChangeMetadata> changeQueue() {
        return this.changeQueue;
    }

    @Override
    public void onBecomeLeader(TopicIdPartition topicIdPartition, int leaderEpoch) {
        this.changeQueue().push(new StartLeadership(topicIdPartition, leaderEpoch));
    }

    @Override
    public void onBecomeFollower(TopicIdPartition topicIdPartition) {
        this.changeQueue().push(new StopLeadership(topicIdPartition));
    }

    @Override
    public void onDelete(TopicIdPartition topicIdPartition) {
        this.changeQueue().push(new StopLeadership(topicIdPartition));
    }

    @Override
    public void initiatePartitionDeletion(TopicIdPartition topicIdPartition, List<TierObjectStore.ObjectMetadata> tieredObjects) {
        this.changeQueue().push(new StartPartitionDeletion(topicIdPartition, tieredObjects));
    }

    @Override
    public void stopPartitionDeletion(TopicIdPartition topicIdPartition) {
        this.changeQueue().push(new StopPartitionDeletion(topicIdPartition));
    }

    public void processAtLeastOne() {
        ChangeMetadata change = this.changeQueue().take();
        this.processChange(change);
        this.process();
    }

    public void process() {
        Option<ChangeMetadata> option;
        boolean done2 = false;
        while (true) {
            BoxedUnit boxedUnit;
            if (this.ctx.isCancelled() || done2) {
                return;
            }
            option = this.changeQueue().poll();
            if (option instanceof Some) {
                Some some = (Some)option;
                ChangeMetadata change = (ChangeMetadata)some.x();
                this.processChange(change);
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (!None$.MODULE$.equals(option)) break;
            done2 = true;
            boxedUnit = BoxedUnit.UNIT;
        }
        throw new MatchError(option);
    }

    @Override
    public void close() {
        this.ctx.cancel();
        this.changeQueue().close();
    }

    private void processChange(ChangeMetadata change) {
        ChangeMetadata changeMetadata;
        block4: {
            block3: {
                block2: {
                    changeMetadata = change;
                    if (!(changeMetadata instanceof StartChangeMetadata)) break block2;
                    StartChangeMetadata startChangeMetadata = (StartChangeMetadata)changeMetadata;
                    this.taskQueues.foreach((Function1)new Serializable(this, startChangeMetadata){
                        public static final long serialVersionUID = 0L;
                        private final StartChangeMetadata x2$1;

                        public final void apply(TierTaskQueue<?> x$1) {
                            x$1.maybeAddTask(this.x2$1);
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!(changeMetadata instanceof StopChangeMetadata)) break block4;
                StopChangeMetadata stopChangeMetadata = (StopChangeMetadata)changeMetadata;
                this.taskQueues.foreach((Function1)new Serializable(this, stopChangeMetadata){
                    public static final long serialVersionUID = 0L;
                    private final StopChangeMetadata x3$1;

                    public final void apply(TierTaskQueue<?> x$2) {
                        x$2.maybeRemoveTask(this.x3$1);
                    }
                    {
                        this.x3$1 = x3$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)changeMetadata);
    }

    public ChangeManager(CancellationContext ctx, Seq<TierTaskQueue<?>> taskQueues, Time time) {
        this.ctx = ctx;
        this.taskQueues = taskQueues;
        Logging$class.$init$(this);
        this.changeQueue = new UpdatableQueue();
    }
}

