/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

public enum TierPartitionStatus {
    CLOSED(0),
    INIT(1),
    CATCHUP(2),
    ONLINE(3),
    DISK_OFFLINE(4);

    final byte value;

    private TierPartitionStatus(byte value2) {
        this.value = value2;
    }

    public boolean isOpen() {
        return this == INIT || this == CATCHUP || this == ONLINE;
    }

    public boolean isOpenForWrite() {
        return this == INIT || this == CATCHUP || this == ONLINE;
    }

    public static byte toByte(TierPartitionStatus status) {
        return status.value;
    }

    public static TierPartitionStatus fromByte(byte value2) {
        if (value2 == TierPartitionStatus.CLOSED.value) {
            return CLOSED;
        }
        if (value2 == TierPartitionStatus.INIT.value) {
            return INIT;
        }
        if (value2 == TierPartitionStatus.CATCHUP.value) {
            return CATCHUP;
        }
        if (value2 == TierPartitionStatus.ONLINE.value) {
            return ONLINE;
        }
        if (value2 == TierPartitionStatus.DISK_OFFLINE.value) {
            return DISK_OFFLINE;
        }
        throw new IllegalArgumentException("Unrecognized TierPartitionStatus byte value " + value2);
    }
}

