/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Map;
import kafka.network.SocketServer$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class RequestQueueSizePercentiles$ {
    public static final RequestQueueSizePercentiles$ MODULE$;
    private final String MetricGroup;
    private final String PercentileNamePrefix;
    private final int Buckets;
    private final scala.collection.immutable.Map<String, String> Tags;

    static {
        new RequestQueueSizePercentiles$();
    }

    public String MetricGroup() {
        return this.MetricGroup;
    }

    public String PercentileNamePrefix() {
        return this.PercentileNamePrefix;
    }

    public int Buckets() {
        return this.Buckets;
    }

    public scala.collection.immutable.Map<String, String> Tags() {
        return this.Tags;
    }

    public Percentiles createPercentiles(Metrics metrics, int queueSize, String metricNamePrefix) {
        String prefix = metricNamePrefix.concat(this.PercentileNamePrefix());
        return new Percentiles(this.Buckets() * 4, 0.0, (double)queueSize, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(this.queueSizeMetricName(metrics, new StringBuilder().append((Object)prefix).append((Object)"p80").toString()), 80.0), new Percentile(this.queueSizeMetricName(metrics, new StringBuilder().append((Object)prefix).append((Object)"p90").toString()), 90.0), new Percentile(this.queueSizeMetricName(metrics, new StringBuilder().append((Object)prefix).append((Object)"p95").toString()), 95.0), new Percentile(this.queueSizeMetricName(metrics, new StringBuilder().append((Object)prefix).append((Object)"p99").toString()), 99.0)});
    }

    public double dataPlaneQueueSize(Metrics metrics, String percentileSuffix) {
        double d;
        String name = SocketServer$.MODULE$.DataPlaneMetricPrefix().concat(this.PercentileNamePrefix()).concat(percentileSuffix);
        Option metricOpt = Option$.MODULE$.apply((Object)metrics.metric(this.queueSizeMetricName(metrics, name)));
        Option option = metricOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            KafkaMetric metric = (KafkaMetric)some.x();
            d = BoxesRunTime.unboxToDouble((Object)metric.metricValue());
        } else {
            d = 0.0;
        }
        return d;
    }

    public MetricName queueSizeMetricName(Metrics metrics, String name) {
        return metrics.metricName(name, this.MetricGroup(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.Tags()).asJava());
    }

    private RequestQueueSizePercentiles$() {
        MODULE$ = this;
        this.MetricGroup = "request-queue-metrics";
        this.PercentileNamePrefix = "request-queue-size-";
        this.Buckets = 1000;
        this.Tags = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"io-confluent-jmx-ignore"), (Object)"")}));
    }
}

