/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Function;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.FailedPartitions;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaFetcherBlockingSend;
import kafka.server.ReplicaFetcherThread$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.TierState;
import kafka.server.epoch.EpochEntry;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.CompletableFutureUtil$;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.TierListOffsetRequestData;
import org.apache.kafka.common.message.TierListOffsetResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.requests.TierListOffsetRequest;
import org.apache.kafka.common.requests.TierListOffsetResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0005f\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\r\u0002\t9\fW.\u001a\t\u0003\u001fUq!\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\ta\u0001\u0015:fI\u00164\u0017B\u0001\f\u0018\u0005\u0019\u0019FO]5oO*\u0011A#E\u0005\u0003\u001beI!AG\u000e\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u00039\u0011\tQ!\u001e;jYND\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\"I1\u0005\u0001B\u0001B\u0003%AEK\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\tqa\u00197vgR,'/\u0003\u0002*M\tq!I]8lKJ,e\u000e\u001a)pS:$\u0018BA\u0012\u000b\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u00042s_.,'oQ8oM&<\u0007CA\u0005/\u0013\ty#AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bCA\u00054\u0013\t!$A\u0001\tGC&dW\r\u001a)beRLG/[8og\"Aa\u0007\u0001B\u0001B\u0003%q'\u0001\u0006sKBd\u0017nY1NOJ\u0004\"!\u0003\u001d\n\u0005e\u0012!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005y\u00059Q.\u001a;sS\u000e\u001c\bCA\u001fG\u001b\u0005q$BA\u001e@\u0015\t\u0001\u0015)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\tS!a\u0011#\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0015aA8sO&\u0011qI\u0010\u0002\b\u001b\u0016$(/[2t\u0011!I\u0005A!A!\u0002\u0013Q\u0015\u0001\u0002;j[\u0016\u0004\"aS'\u000e\u00031S!\u0001H \n\u00059c%\u0001\u0002+j[\u0016D\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!U\u0001\u0006cV|G/\u0019\t\u0003\u0013IK!a\u0015\u0002\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\t\u0011U\u0003!\u0011!Q\u0001\nY\u000b\u0001\u0003^5feN#\u0018\r^3GKR\u001c\u0007.\u001a:\u0011\u0007A9\u0016,\u0003\u0002Y#\t1q\n\u001d;j_:\u0004\"AW0\u000e\u0003mS!\u0001X/\u0002\u000f\u0019,Go\u00195fe*\u0011a\fB\u0001\u0005i&,'/\u0003\u0002a7\n\u0001B+[3s'R\fG/\u001a$fi\u000eDWM\u001d\u0005\tE\u0002\u0011\t\u0011)A\u0005G\u0006QB.Z1eKJ,e\u000e\u001a9pS:$(\t\\8dW&twmU3oIB\u0019\u0001c\u00163\u0011\u0005%)\u0017B\u00014\u0003\u00051\u0011En\\2lS:<7+\u001a8e\u0011\u0015A\u0007\u0001\"\u0001j\u0003\u0019a\u0014N\\5u}Qa!n\u001b7n]>\u0004\u0018O]:ukB\u0011\u0011\u0002\u0001\u0005\u0006\u001b\u001d\u0004\rA\u0004\u0005\u0006=\u001d\u0004\ra\b\u0005\u0006G\u001d\u0004\r\u0001\n\u0005\u0006Y\u001d\u0004\r!\f\u0005\u0006c\u001d\u0004\rA\r\u0005\u0006m\u001d\u0004\ra\u000e\u0005\u0006w\u001d\u0004\r\u0001\u0010\u0005\u0006\u0013\u001e\u0004\rA\u0013\u0005\u0006!\u001e\u0004\r!\u0015\u0005\u0006+\u001e\u0004\rA\u0016\u0005\bE\u001e\u0004\n\u00111\u0001d\u0011\u001d9\bA1A\u0005\na\f\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0003}AaA\u001f\u0001!\u0002\u0013y\u0012A\u0003:fa2L7-Y%eA!9A\u0010\u0001b\u0001\n\u0013i\u0018A\u00037pO\u000e{g\u000e^3yiV\ta\u0010\u0005\u0002L\u007f&\u0019\u0011\u0011\u0001'\u0003\u00151{wmQ8oi\u0016DH\u000fC\u0004\u0002\u0006\u0001\u0001\u000b\u0011\u0002@\u0002\u00171|wmQ8oi\u0016DH\u000f\t\u0005\n\u0003\u0013\u0001!\u0019!C\u0005\u0003\u0017\ta\u0002\\3bI\u0016\u0014XI\u001c3q_&tG/F\u0001e\u0011\u001d\ty\u0001\u0001Q\u0001\n\u0011\fq\u0002\\3bI\u0016\u0014XI\u001c3q_&tG\u000f\t\u0005\u000b\u0003'\u0001!\u0019!C\u0001\u0005\u0005U\u0011a\u00054fi\u000eD'+Z9vKN$h+\u001a:tS>tWCAA\f!\r\u0001\u0012\u0011D\u0005\u0004\u00037\t\"!B*i_J$\b\u0002CA\u0010\u0001\u0001\u0006I!a\u0006\u0002)\u0019,Go\u00195SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8!\u0011)\t\u0019\u0003\u0001b\u0001\n\u0003\u0011\u0011QC\u0001#_\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;WKJ\u001c\u0018n\u001c8\t\u0011\u0005\u001d\u0002\u0001)A\u0005\u0003/\t1e\u001c4gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z9vKN$h+\u001a:tS>t\u0007\u0005\u0003\u0006\u0002,\u0001\u0011\r\u0011\"\u0001\u0003\u0003+\t\u0001\u0004\\5ti>3gm]3u%\u0016\fX/Z:u-\u0016\u00148/[8o\u0011!\ty\u0003\u0001Q\u0001\n\u0005]\u0011!\u00077jgR|eMZ:fiJ+\u0017/^3tiZ+'o]5p]\u0002B\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\u0002\u000f5\f\u0007pV1jiV\u0011\u0011q\u0007\t\u0005\u0003s\t\u0019%\u0004\u0002\u0002<)!\u0011QHA \u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0013\u0001\u00026bm\u0006LA!!\u0012\u0002<\t9\u0011J\u001c;fO\u0016\u0014\b\u0002CA%\u0001\u0001\u0006I!a\u000e\u0002\u00115\f\u0007pV1ji\u0002B\u0011\"!\u0014\u0001\u0005\u0004%I!!\u000e\u0002\u00115LgNQ=uKND\u0001\"!\u0015\u0001A\u0003%\u0011qG\u0001\n[&t')\u001f;fg\u0002B\u0011\"!\u0016\u0001\u0005\u0004%I!!\u000e\u0002\u00115\f\u0007PQ=uKND\u0001\"!\u0017\u0001A\u0003%\u0011qG\u0001\n[\u0006D()\u001f;fg\u0002B\u0011\"!\u0018\u0001\u0005\u0004%I!!\u000e\u0002\u0013\u0019,Go\u00195TSj,\u0007\u0002CA1\u0001\u0001\u0006I!a\u000e\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h\u0005\u0001#M]8lKJ\u001cV\u000f\u001d9peR\u001cH*Z1eKJ,\u0005o\\2i%\u0016\fX/Z:u+\t\tI\u0007E\u0002\u0011\u0003WJ1!!\u001c\u0012\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u001d\u0001A\u0003%\u0011\u0011N\u0001\"EJ|7.\u001a:TkB\u0004xN\u001d;t\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NU3rk\u0016\u001cH\u000f\t\u0005\n\u0003k\u0002!\u0019!C\u0001\u0003o\n1CZ3uG\"\u001cVm]:j_:D\u0015M\u001c3mKJ,\"!!\u001f\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a B\u0003\u001d\u0019G.[3oiNLA!a!\u0002~\t\u0019b)\u001a;dQN+7o]5p]\"\u000bg\u000e\u001a7fe\"A\u0011q\u0011\u0001!\u0002\u0013\tI(\u0001\u000bgKR\u001c\u0007nU3tg&|g\u000eS1oI2,'\u000f\t\u0005\b\u0003\u0017\u0003A\u0011KAG\u0003-a\u0017\r^3ti\u0016\u0003xn\u00195\u0015\t\u0005=\u0015\u0011\u0013\t\u0004!]{\u0002\u0002CAJ\u0003\u0013\u0003\r!!&\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011qSAM\u001b\u0005y\u0014bAAN\u007f\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAP\u0001\u0011E\u0013\u0011U\u0001\u000fY><7\u000b^1si>3gm]3u)\u0011\t\u0019+!+\u0011\u0007A\t)+C\u0002\u0002(F\u0011A\u0001T8oO\"A\u00111SAO\u0001\u0004\t)\nC\u0004\u0002.\u0002!\t&a,\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0015\t\u0005\r\u0016\u0011\u0017\u0005\t\u0003'\u000bY\u000b1\u0001\u0002\u0016\"9\u0011Q\u0017\u0001\u0005R\u0005]\u0016!E3oI>3gm]3u\r>\u0014X\t]8dQR1\u0011\u0011XAa\u0003\u0007\u0004B\u0001E,\u0002<B\u0019\u0011\"!0\n\u0007\u0005}&A\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\u0011\u0005M\u00151\u0017a\u0001\u0003+Cq!!2\u00024\u0002\u0007q$A\u0003fa>\u001c\u0007\u000eC\u0004\u0002J\u0002!\t%a3\u0002!%t\u0017\u000e^5bi\u0016\u001c\u0006.\u001e;e_^tGCAA5\u0011\u001d\ty\r\u0001C!\u0003#\fQ\"Y<bSR\u001c\u0006.\u001e;e_^tGCAAj!\r\u0001\u0012Q[\u0005\u0004\u0003/\f\"\u0001B+oSRDq!a7\u0001\t\u0003\ni.\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003?\fi/a<\u0002tB!\u0001cVAq!\u0011\t\u0019/!;\u000e\u0005\u0005\u0015(bAAt\t\u0005\u0019An\\4\n\t\u0005-\u0018Q\u001d\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u0011\u0005M\u0015\u0011\u001ca\u0001\u0003+C\u0001\"!=\u0002Z\u0002\u0007\u00111U\u0001\fM\u0016$8\r[(gMN,G\u000f\u0003\u0005\u0002v\u0006e\u0007\u0019AA|\u00035\u0001\u0018M\u001d;ji&|g\u000eR1uCB!\u0011\u0011`A~\u001b\u0005\u0001\u0011bAA\u007f\u0015\tIa)\u001a;dQ\u0012\u000bG/\u0019\u0005\b\u0005\u0003\u0001A\u0011\tB\u0002\u0003IygNU3ti>\u0014X\rV5feN#\u0018\r^3\u0015\u0011\u0005M'Q\u0001B\u0004\u0005\u0017A\u0001\"a%\u0002\u0000\u0002\u0007\u0011Q\u0013\u0005\t\u0005\u0013\ty\u00101\u0001\u0002$\u0006)\u0002O]8q_N,G\rT8dC2dunZ*uCJ$\b\u0002\u0003B\u0007\u0003\u007f\u0004\rAa\u0004\u0002\u0013QLWM]*uCR,\u0007cA\u0005\u0003\u0012%\u0019!1\u0003\u0002\u0003\u0013QKWM]*uCR,\u0007b\u0002B\f\u0001\u0011\u0005#\u0011D\u0001\u000fM\u0016$8\r\u001b+jKJ\u001cF/\u0019;f)\u0019\u0011YBa\u000b\u0003.A1!Q\u0004B\u0014\u0005\u001fi!Aa\b\u000b\t\t\u0005\"1E\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002B\u0013\u0003\u007f\tA!\u001e;jY&!!\u0011\u0006B\u0010\u0005\u00191U\u000f^;sK\"A\u00111\u0013B\u000b\u0001\u0004\t)\n\u0003\u0005\u00030\tU\u0001\u0019\u0001B\u0019\u0003I!\u0018.\u001a:PE*,7\r^'fi\u0006$\u0017\r^1\u0011\t\tM\"\u0011H\u0007\u0003\u0005kQ1Aa\u000e^\u0003\u0019!w.\\1j]&!!1\bB\u001b\u0005I!\u0016.\u001a:PE*,7\r^'fi\u0006$\u0017\r^1\t\u000f\t}\u0002\u0001\"\u0011\u0003B\u0005yR.\u0019;fe&\fG.\u001b>f)&,'o\u0015;bi\u0016,f\u000e^5m\u001f\u001a47/\u001a;\u0015\r\t\r#Q\tB$!\u0019\u0011iBa\n\u00032!A\u00111\u0013B\u001f\u0001\u0004\t)\n\u0003\u0005\u0003J\tu\u0002\u0019AAR\u00031!\u0018M]4fi>3gm]3u\u0011\u001d\u0011i\u0005\u0001C\u0001\u0005\u001f\n1$\\1zE\u0016<\u0016M\u001d8JM>3XM]:ju\u0016$'+Z2pe\u0012\u001cHCBAj\u0005#\u0012\t\u0007\u0003\u0005\u0003T\t-\u0003\u0019\u0001B+\u0003\u001d\u0011XmY8sIN\u0004BAa\u0016\u0003^5\u0011!\u0011\f\u0006\u0004\u00057z\u0014A\u0002:fG>\u0014H-\u0003\u0003\u0003`\te#!D'f[>\u0014\u0018PU3d_J$7\u000f\u0003\u0005\u0002\u0014\n-\u0003\u0019AAK\u0011\u001d\u0011)\u0007\u0001C)\u0005O\nqBZ3uG\"4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0005S\u0012)\b\u0005\u0005\u0003l\tE\u0014QSA|\u001b\t\u0011iGC\u0002\u0003pE\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011\u0019H!\u001c\u0003\u00075\u000b\u0007\u000f\u0003\u0005\u0003x\t\r\u0004\u0019\u0001B=\u000311W\r^2i%\u0016\fX/Z:u!\u0011\u0011YHa\"\u000f\t\tu$1Q\u0007\u0003\u0005\u007fR1A!!@\u0003!\u0011X-];fgR\u001c\u0018\u0002\u0002BC\u0005\u007f\nABR3uG\"\u0014V-];fgRLAA!#\u0003\f\n9!)^5mI\u0016\u0014(\u0002\u0002BC\u0005\u007fBqAa$\u0001\t#\u0012\t*A\u000fgKR\u001c\u0007.R1sY&,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\t\u0019Ka%\u0003\u0016\"A\u00111\u0013BG\u0001\u0004\t)\nC\u0004\u0003\u0018\n5\u0005\u0019A\u0010\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0005\b\u00057\u0003A\u0011\u000bBO\u0003\t2W\r^2i\u000b\u0006\u0014H.[3ti2{7-\u00197PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u00111\u0015BP\u0005CC\u0001\"a%\u0003\u001a\u0002\u0007\u0011Q\u0013\u0005\b\u0005/\u0013I\n1\u0001 \u0011\u001d\u0011)\u000b\u0001C)\u0005O\u000b1DZ3uG\"d\u0015\r^3ti>3gm]3u\rJ|W\u000eT3bI\u0016\u0014HCBAR\u0005S\u0013Y\u000b\u0003\u0005\u0002\u0014\n\r\u0006\u0019AAK\u0011\u001d\u00119Ja)A\u0002}AqAa,\u0001\t\u0013\u0011\t,\u0001\u000egKR\u001c\u0007\u000eT8dC2|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0005\u0002$\nM&Q\u0017B\\\u0011!\t\u0019J!,A\u0002\u0005U\u0005b\u0002BL\u0005[\u0003\ra\b\u0005\t\u0005s\u0013i\u000b1\u0001\u0003<\u0006QqN\u001a4tKR$\u0016\u0010]3\u0011\t\tu&Q\u001c\b\u0005\u0005\u007f\u0013IN\u0004\u0003\u0003B\n]g\u0002\u0002Bb\u0005+tAA!2\u0003T:!!q\u0019Bi\u001d\u0011\u0011IMa4\u000e\u0005\t-'b\u0001Bg\r\u00051AH]8pizJ\u0011!R\u0005\u0003\u0007\u0012K!!\u0002\"\n\u0005\u0001\u000b\u0015b\u0001BA\u007f%!!1\u001cB@\u0003U!\u0016.\u001a:MSN$xJ\u001a4tKR\u0014V-];fgRLAAa8\u0003b\nQqJ\u001a4tKR$\u0016\u0010]3\u000b\t\tm'q\u0010\u0005\b\u0005K\u0004A\u0011\u0002Bt\u0003U1W\r^2i\u001f\u001a47/\u001a;Ge>lG*Z1eKJ$\u0002\"a)\u0003j\n-(Q\u001e\u0005\t\u0003'\u0013\u0019\u000f1\u0001\u0002\u0016\"9!q\u0013Br\u0001\u0004y\u0002\u0002\u0003Bx\u0005G\u0004\r!a)\u0002!\u0015\f'\u000f\\5fgR|%\u000fT1uKN$\bb\u0002Bz\u0001\u0011\u0005#Q_\u0001\u000bEVLG\u000e\u001a$fi\u000eDG\u0003\u0002B|\u0007+\u0001bA!?\u0004\b\r5a\u0002\u0002B~\u0007\u0007qAA!@\u0004\u00029!!\u0011\u001aB\u0000\u0013\u0005)\u0011BA\u0002\u0005\u0013\r\u0019)AA\u0001\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0013\u0011\u0019Iaa\u0003\u0003)I+7/\u001e7u/&$\b\u000eU1si&$\u0018n\u001c8t\u0015\r\u0019)A\u0001\t\u0005!]\u001by\u0001\u0005\u0003\u0003z\u000eE\u0011\u0002BB\n\u0007\u0017\u0011ABU3qY&\u001c\u0017MR3uG\"D\u0001ba\u0006\u0003r\u0002\u00071\u0011D\u0001\ra\u0006\u0014H/\u001b;j_:l\u0015\r\u001d\t\t\u0005W\u0012\t(!&\u0004\u001cA\u0019\u0011b!\b\n\u0007\r}!AA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X\rC\u0004\u0004$\u0001!\te!\n\u0002\u0011Q\u0014XO\\2bi\u0016$b!a5\u0004(\r-\u0002\u0002CB\u0015\u0007C\u0001\r!!&\u0002\u0005Q\u0004\b\u0002CB\u0017\u0007C\u0001\raa\f\u0002+=4gm]3u)J,hnY1uS>t7\u000b^1uKB\u0019\u0011b!\r\n\u0007\rM\"AA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\t\u000f\r]\u0002\u0001\"\u0015\u0004:\u00059BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003'\u001cYd!\u0010\t\u0011\u0005M5Q\u0007a\u0001\u0003+C\u0001ba\u0010\u00046\u0001\u0007\u00111U\u0001\u0007_\u001a47/\u001a;\t\u000f\r\r\u0003\u0001\"\u0011\u0004F\u0005!b-\u001a;dQ\u0016\u0003xn\u00195F]\u0012|eMZ:fiN$Baa\u0012\u0004PAA!1\u000eB9\u0003+\u001bI\u0005\u0005\u0003\u0003~\r-\u0013\u0002BB'\u0005\u007f\u0012a\"\u00129pG\",e\u000eZ(gMN,G\u000f\u0003\u0005\u0004R\r\u0005\u0003\u0019AB*\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\t\u0005W\u0012\t(!&\u0004VA!\u0011\u0011`B,\u0013\r\u0019IF\u0003\u0002\n\u000bB|7\r\u001b#bi\u0006Dqa!\u0018\u0001\t\u0003\n9'A\u0010jg>3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i'V\u0004\bo\u001c:uK\u0012Dqa!\u0019\u0001\t\u0013\u0019\u0019'\u0001\ftQ>,H\u000e\u001a$pY2|w/\u001a:UQJ|G\u000f\u001e7f)!\tIg!\u001a\u0004h\r-\u0004B\u0002)\u0004`\u0001\u0007\u0011\u000b\u0003\u0005\u0004j\r}\u0003\u0019AB\u000e\u0003)1W\r^2i'R\fG/\u001a\u0005\t\u0003'\u001by\u00061\u0001\u0002\u0016\"i1q\u000e\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0004r)\n!c];qKJ$3o\\;sG\u0016\u0014%o\\6feV\tAeB\u0005\u0004v\t\t\t\u0011#\u0001\u0004x\u0005!\"+\u001a9mS\u000e\fg)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\u00042!CB=\r!\t!!!A\t\u0002\rm4\u0003BB=\u0007{\u00022\u0001EB@\u0013\r\u0019\t)\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000f!\u001cI\b\"\u0001\u0004\u0006R\u00111q\u000f\u0005\u000b\u0007\u0013\u001bI(%A\u0005\u0002\r-\u0015\u0001\b\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'M\u000b\u0003\u0007\u001bS3aYBHW\t\u0019\t\n\u0005\u0003\u0004\u0014\u000euUBABK\u0015\u0011\u00199j!'\u0002\u0013Ut7\r[3dW\u0016$'bABN#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\r}5Q\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final int kafka$server$ReplicaFetcherThread$$fetcherId;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    private final ReplicaManager replicaMgr;
    public final Metrics kafka$server$ReplicaFetcherThread$$metrics;
    public final Time kafka$server$ReplicaFetcherThread$$time;
    public final ReplicaQuota kafka$server$ReplicaFetcherThread$$quota;
    private final Option<TierStateFetcher> tierStateFetcher;
    private final int kafka$server$ReplicaFetcherThread$$replicaId;
    private final LogContext kafka$server$ReplicaFetcherThread$$logContext;
    private final BlockingSend kafka$server$ReplicaFetcherThread$$leaderEndpoint;
    private final short fetchRequestVersion;
    private final short offsetForLeaderEpochRequestVersion;
    private final short listOffsetRequestVersion;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer kafka$server$ReplicaFetcherThread$$fetchSize;
    private final boolean brokerSupportsLeaderEpochRequest;
    private final FetchSessionHandler fetchSessionHandler;

    public static Option<BlockingSend> $lessinit$greater$default$11() {
        return ReplicaFetcherThread$.MODULE$.$lessinit$greater$default$11();
    }

    public /* synthetic */ BrokerEndPoint kafka$server$ReplicaFetcherThread$$super$sourceBroker() {
        return super.sourceBroker();
    }

    public int kafka$server$ReplicaFetcherThread$$replicaId() {
        return this.kafka$server$ReplicaFetcherThread$$replicaId;
    }

    public LogContext kafka$server$ReplicaFetcherThread$$logContext() {
        return this.kafka$server$ReplicaFetcherThread$$logContext;
    }

    public BlockingSend kafka$server$ReplicaFetcherThread$$leaderEndpoint() {
        return this.kafka$server$ReplicaFetcherThread$$leaderEndpoint;
    }

    public short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    public short offsetForLeaderEpochRequestVersion() {
        return this.offsetForLeaderEpochRequestVersion;
    }

    public short listOffsetRequestVersion() {
        return this.listOffsetRequestVersion;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer kafka$server$ReplicaFetcherThread$$fetchSize() {
        return this.kafka$server$ReplicaFetcherThread$$fetchSize;
    }

    private boolean brokerSupportsLeaderEpochRequest() {
        return this.brokerSupportsLeaderEpochRequest;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.localLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.localLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown) {
            try {
                this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().initiateClose();
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcherThread $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to initiate shutdown of leader endpoint ", " after initiating replica fetcher thread shutdown"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicaFetcherThread$$leaderEndpoint()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID = 0L;
                    private final Throwable t$1;

                    public final Throwable apply() {
                        return this.t$1;
                    }
                    {
                        this.t$1 = t$1;
                    }
                });
            }
        }
        return (boolean)var1_1;
    }

    @Override
    public void awaitShutdown() {
        super.awaitShutdown();
        try {
            this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().close();
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close leader endpoint ", " after shutting down replica fetcher thread"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$server$ReplicaFetcherThread$$leaderEndpoint()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$2;

                public final Throwable apply() {
                    return this.t$2;
                }
                {
                    this.t$2 = t$2;
                }
            });
        }
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        AbstractLog log = partition.localLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        this.maybeWarnIfOversizedRecords(records, topicPartition);
        if (fetchOffset != log.logEndOffset()) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)log.logEndOffset())})));
        }
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, partitionData, log, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final FetchResponse.PartitionData partitionData$1;
                private final AbstractLog log$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.log$1.logEndOffset()), this.topicPartition$1, BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), BoxesRunTime.boxToLong((long)this.partitionData$1.highWatermark)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.partitionData$1 = partitionData$1;
                    this.log$1 = log$1;
                    this.records$1 = records$1;
                }
            });
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, false);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, log, records){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final AbstractLog log$1;
                private final MemoryRecords records$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Follower has replica log end offset %d after appending %d bytes of messages for partition %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.log$1.logEndOffset()), BoxesRunTime.boxToInteger((int)this.records$1.sizeInBytes()), this.topicPartition$1}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.log$1 = log$1;
                    this.records$1 = records$1;
                }
            });
        }
        long leaderLogStartOffset = partitionData.logStartOffset;
        long followerHighWatermark = log.updateHighWatermark(partitionData.highWatermark);
        log.maybeIncrementLogStartOffset(leaderLogStartOffset);
        if (this.isTraceEnabled()) {
            this.trace((Function0<String>)new Serializable(this, topicPartition, followerHighWatermark){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;
                private final long followerHighWatermark$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower set replica high watermark for partition ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$1, BoxesRunTime.boxToLong((long)this.followerHighWatermark$1)}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                    this.followerHighWatermark$1 = followerHighWatermark$1;
                }
            });
        }
        if (this.kafka$server$ReplicaFetcherThread$$quota.isThrottled(topicPartition)) {
            this.kafka$server$ReplicaFetcherThread$$quota.record(records.sizeInBytes());
        }
        if (partition.isReassigning() && partition.isAddingLocalReplica()) {
            this.brokerTopicStats().updateReassignmentBytesIn(records.sizeInBytes());
        }
        this.brokerTopicStats().updateReplicationBytesIn(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public void onRestoreTierState(TopicPartition topicPartition, long proposedLocalLogStart, TierState tierState) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        this.debug((Function0<String>)new Serializable(this, topicPartition, tierState){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$3;
            private final TierState tierState$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Restoring tier state ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$3, this.tierState$1}));
            }
            {
                this.topicPartition$3 = topicPartition$3;
                this.tierState$1 = tierState$1;
            }
        });
        log.onRestoreTierState(proposedLocalLogStart, tierState);
    }

    @Override
    public Future<TierState> fetchTierState(TopicPartition topicPartition, TierObjectMetadata tierObjectMetadata) {
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(tierObjectMetadata);
        CompletableFuture<List<EpochEntry>> epochStateFut = ((TierStateFetcher)this.tierStateFetcher.get()).fetchLeaderEpochState(metadata);
        CompletableFuture<None$> producerStateFut = tierObjectMetadata.hasProducerState() ? ((TierStateFetcher)this.tierStateFetcher.get()).fetchProducerStateSnapshot(metadata).thenApply(new Function<ByteBuffer, Option<ByteBuffer>>(this){

            public Option<ByteBuffer> apply(ByteBuffer buf) {
                return new Some((Object)buf);
            }
        }) : CompletableFutureUtil$.MODULE$.completed(None$.MODULE$);
        return epochStateFut.thenCombine(producerStateFut, new BiFunction<List<EpochEntry>, Option<ByteBuffer>, TierState>(this){

            public TierState apply(List<EpochEntry> epochEntries, Option<ByteBuffer> producerState) {
                return new TierState(epochEntries, producerState);
            }
        });
    }

    @Override
    public Future<TierObjectMetadata> materializeTierStateUntilOffset(TopicPartition topicPartition, long targetOffset) {
        AbstractLog log = this.replicaMgr.localLogOrException(topicPartition);
        return log.materializeTierStateUntilOffset(targetOffset);
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition$2}))).append((Object)"This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append((Object)"message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append((Object)"equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            });
        }
    }

    @Override
    public Map<TopicPartition, FetchResponse.PartitionData<Records>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        try {
            ClientResponse clientResponse = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
            FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
            return this.fetchSessionHandler().handleResponse(fetchResponse) ? (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData()).asScala() : Map$.MODULE$.empty();
        }
        catch (Throwable throwable) {
            this.fetchSessionHandler().handleError(throwable);
            throw throwable;
        }
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchEarliestLocalOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        if (Predef$.MODULE$.Boolean2boolean(this.kafka$server$ReplicaFetcherThread$$brokerConfig.tierFeature())) {
            return this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_4_IV1$.MODULE$) ? this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -10000L) : this.fetchLocalOffsetFromLeader(topicPartition, currentLeaderEpoch, TierListOffsetRequest.OffsetType.LOCAL_START_OFFSET);
        }
        throw new IllegalStateException("Incompatible configuration for tiered storage");
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffsetFromLeader(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchLocalOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, TierListOffsetRequest.OffsetType offsetType) {
        TierListOffsetRequestData.TierListOffsetTopic tierListOffsetTopic = new TierListOffsetRequestData.TierListOffsetTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new TierListOffsetRequestData.TierListOffsetPartition().setPartitionIndex(topicPartition.partition()).setOffsetType(TierListOffsetRequest.OffsetType.toId((TierListOffsetRequest.OffsetType)offsetType)).setCurrentLeaderEpoch(currentLeaderEpoch)));
        TierListOffsetRequest.Builder request = new TierListOffsetRequest.Builder(new TierListOffsetRequestData().setReplicaId(this.kafka$server$ReplicaFetcherThread$$replicaId()).setTopics(Collections.singletonList(tierListOffsetTopic)));
        ClientResponse clientResponse = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request);
        TierListOffsetResponse response = (TierListOffsetResponse)clientResponse.responseBody();
        if (response.data().topics().size() != 1) {
            throw new IllegalStateException("Unexpected response from TIER_LIST_OFFSET request. Response contains more topics than expected.");
        }
        TierListOffsetResponseData.TierListOffsetTopicResponse topicResponse = (TierListOffsetResponseData.TierListOffsetTopicResponse)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(response.data().topics()).asScala()).last();
        TierListOffsetResponseData.TierListOffsetPartitionResponse partitionResponse = (TierListOffsetResponseData.TierListOffsetPartitionResponse)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(topicResponse.partitions()).asScala()).last();
        if (partitionResponse.errorCode() == Errors.NONE.code()) {
            return partitionResponse.offset();
        }
        throw Errors.forCode((short)partitionResponse.errorCode()).exception();
    }

    private long fetchOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetRequest.PartitionData requestPartitionData = new ListOffsetRequest.PartitionData(earliestOrLatest, Optional.of(Predef$.MODULE$.int2Integer(currentLeaderEpoch)));
        Map requestPartitions = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)requestPartitionData)}));
        ListOffsetRequest.Builder requestBuilder = ListOffsetRequest.Builder.forReplica((short)this.listOffsetRequestVersion(), (int)this.kafka$server$ReplicaFetcherThread$$replicaId()).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(requestPartitions).asJava());
        ClientResponse clientResponse = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData responsePartitionData = (ListOffsetResponse.PartitionData)response.responseData().get(topicPartition);
        Errors errors = responsePartitionData.error;
        if (Errors.NONE.equals(errors)) {
            long l = this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(responsePartitionData.offset) : Predef$.MODULE$.Long2long((Long)responsePartitionData.offsets.get(0));
            return l;
        }
        throw errors.exception();
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        None$ none$;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitionMap.size(), false);
        partitionMap.foreach((Function1)new Serializable(this, partitionsWithError, builder){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final scala.collection.mutable.Set partitionsWithError$1;
            private final FetchSessionHandler.Builder builder$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$1) {
                BoxedUnit boxedUnit;
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState2 = (PartitionFetchState)tuple2._2();
                if (fetchState2.isReadyForFetch() && !this.$outer.kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(this.$outer.kafka$server$ReplicaFetcherThread$$quota, fetchState2, topicPartition)) {
                    try {
                        long logStartOffset2 = this.$outer.logStartOffset(topicPartition);
                        this.builder$1.add(topicPartition, new FetchRequest.PartitionData(fetchState2.fetchOffset(), logStartOffset2, Predef$.MODULE$.Integer2int(this.$outer.kafka$server$ReplicaFetcherThread$$fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState2.currentLeaderEpoch()))));
                        boxedUnit = BoxedUnit.UNIT;
                        return boxedUnit;
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                        boxedUnit = this.partitionsWithError$1.$plus$eq((Object)topicPartition);
                    }
                    return boxedUnit;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionsWithError$1 = partitionsWithError$1;
                this.builder$1 = builder$1;
            }
        });
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)this.fetchRequestVersion(), (int)this.kafka$server$ReplicaFetcherThread$$replicaId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).toForget(fetchData.toForget()).metadata(fetchData.metadata());
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public void truncate(TopicPartition tp, OffsetTruncationState offsetTruncationState) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(tp).get();
        AbstractLog log = partition.localLogOrException();
        partition.truncateTo(offsetTruncationState.offset(), false);
        if (offsetTruncationState.offset() < log.highWatermark()) {
            this.warn((Function0<String>)new Serializable(this, tp, offsetTruncationState, log){
                public static final long serialVersionUID = 0L;
                private final TopicPartition tp$1;
                private final OffsetTruncationState offsetTruncationState$1;
                private final AbstractLog log$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncating ", " to offset ", " below high watermark "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tp$1, BoxesRunTime.boxToLong((long)this.offsetTruncationState$1.offset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.log$2.highWatermark())}))).toString();
                }
                {
                    this.tp$1 = tp$1;
                    this.offsetTruncationState$1 = offsetTruncationState$1;
                    this.log$2 = log$2;
                }
            });
        }
        if (offsetTruncationState.truncationCompleted()) {
            this.replicaMgr.replicaAlterLogDirsManager().markPartitionsForTruncation(this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId(), tp, offsetTruncationState.offset());
        }
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset2) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        partition.truncateFullyAndStartAt(offset2, false);
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        Map map;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Skipping leaderEpoch request since all partitions do not have an epoch";
                }
            });
            return Map$.MODULE$.empty();
        }
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)this.offsetForLeaderEpochRequestVersion(), (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()), (int)this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        this.debug((Function0<String>)new Serializable(this, epochRequest){
            public static final long serialVersionUID = 0L;
            private final OffsetsForLeaderEpochRequest.Builder epochRequest$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending offset for leader epoch request ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.epochRequest$1}));
            }
            {
                this.epochRequest$1 = epochRequest$1;
            }
        });
        try {
            ClientResponse response = this.kafka$server$ReplicaFetcherThread$$leaderEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)new Serializable(this, response){
                public static final long serialVersionUID = 0L;
                private final ClientResponse response$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received leaderEpoch response ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.response$1}));
                }
                {
                    this.response$1 = response$1;
                }
            });
            map = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(responseBody.responses()).asScala();
        }
        catch (Throwable throwable) {
            this.warn((Function0<String>)new Serializable(this, partitions){
                public static final long serialVersionUID = 0L;
                private final Map partitions$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error when sending leader epoch request for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitions$1}));
                }
                {
                    this.partitions$1 = partitions$1;
                }
            }, (Function0<Throwable>)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$3;

                public final Throwable apply() {
                    return this.t$3;
                }
                {
                    this.t$3 = t$3;
                }
            });
            Errors error = Errors.forException((Throwable)throwable);
            map = (Map)partitions.map((Function1)new Serializable(this, error){
                public static final long serialVersionUID = 0L;
                private final Errors error$1;

                public final Tuple2<TopicPartition, EpochEndOffset> apply(Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> x0$2) {
                    Tuple2<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> tuple2 = x0$2;
                    if (tuple2 != null) {
                        TopicPartition tp = (TopicPartition)tuple2._1();
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(this.error$1, -1, -1L));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.error$1 = error$1;
                }
            }, Map$.MODULE$.canBuildFrom());
        }
        return map;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.brokerSupportsLeaderEpochRequest();
    }

    public boolean kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(ReplicaQuota quota, PartitionFetchState fetchState2, TopicPartition topicPartition) {
        return !fetchState2.isReplicaInSync() && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicaQuota quota, Option<TierStateFetcher> tierStateFetcher, Option<BlockingSend> leaderEndpointBlockingSend) {
        this.kafka$server$ReplicaFetcherThread$$fetcherId = fetcherId;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.kafka$server$ReplicaFetcherThread$$metrics = metrics;
        this.kafka$server$ReplicaFetcherThread$$time = time;
        this.kafka$server$ReplicaFetcherThread$$quota = quota;
        this.tierStateFetcher = tierStateFetcher;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), tierStateFetcher, false, replicaMgr.brokerTopicStats());
        this.kafka$server$ReplicaFetcherThread$$replicaId = brokerConfig.brokerId();
        this.kafka$server$ReplicaFetcherThread$$logContext = new LogContext(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ReplicaFetcher replicaId=", ", leaderId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)super.sourceBroker().id())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fetcherId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)fetcherId)}))).toString());
        this.logIdent_$eq(this.kafka$server$ReplicaFetcherThread$$logContext().logPrefix());
        this.kafka$server$ReplicaFetcherThread$$leaderEndpoint = (BlockingSend)leaderEndpointBlockingSend.getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;

            public final ReplicaFetcherBlockingSend apply() {
                return new ReplicaFetcherBlockingSend(this.$outer.kafka$server$ReplicaFetcherThread$$super$sourceBroker(), this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig, this.$outer.kafka$server$ReplicaFetcherThread$$metrics, this.$outer.kafka$server$ReplicaFetcherThread$$time, this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"broker-", "-fetcher-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$replicaId()), BoxesRunTime.boxToInteger((int)this.$outer.kafka$server$ReplicaFetcherThread$$fetcherId)})), this.$outer.kafka$server$ReplicaFetcherThread$$logContext());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 11 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV2$.MODULE$) ? 10 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 8 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_1_1_IV0$.MODULE$) ? 7 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)))))))));
        this.offsetForLeaderEpochRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_3_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV0$.MODULE$) ? 1 : 0)));
        this.listOffsetRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_2_IV1$.MODULE$) ? 5 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_1_IV1$.MODULE$) ? 4 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_2_0_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? 1 : 0)))));
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.kafka$server$ReplicaFetcherThread$$fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.brokerSupportsLeaderEpochRequest = brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_11_0_IV2$.MODULE$);
        this.fetchSessionHandler = new FetchSessionHandler(this.kafka$server$ReplicaFetcherThread$$logContext(), super.sourceBroker().id());
    }
}

