/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import kafka.security.authorizer.AclEntry;
import kafka.utils.Json$;
import kafka.utils.json.DecodeJson$DecodeInt$;
import kafka.utils.json.DecodeJson$DecodeString$;
import kafka.utils.json.JsonObject;
import kafka.utils.json.JsonValue;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.SecurityUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;

public final class AclEntry$ {
    public static final AclEntry$ MODULE$;
    private final KafkaPrincipal WildcardPrincipal;
    private final String WildcardPrincipalString;
    private final String WildcardHost;
    private final String WildcardResource;
    private final String ResourceSeparator;
    private final Set<ResourceType> ResourceTypes;
    private final Set<AclOperation> AclOperations;
    private final String PrincipalKey;
    private final String PermissionTypeKey;
    private final String OperationKey;
    private final String HostsKey;
    private final String VersionKey;
    private final int CurrentVersion;
    private final String AclsKey;

    static {
        new AclEntry$();
    }

    public KafkaPrincipal WildcardPrincipal() {
        return this.WildcardPrincipal;
    }

    public String WildcardPrincipalString() {
        return this.WildcardPrincipalString;
    }

    public String WildcardHost() {
        return this.WildcardHost;
    }

    public String WildcardResource() {
        return this.WildcardResource;
    }

    public String ResourceSeparator() {
        return this.ResourceSeparator;
    }

    public Set<ResourceType> ResourceTypes() {
        return this.ResourceTypes;
    }

    public Set<AclOperation> AclOperations() {
        return this.AclOperations;
    }

    public String PrincipalKey() {
        return this.PrincipalKey;
    }

    public String PermissionTypeKey() {
        return this.PermissionTypeKey;
    }

    public String OperationKey() {
        return this.OperationKey;
    }

    public String HostsKey() {
        return this.HostsKey;
    }

    public String VersionKey() {
        return this.VersionKey;
    }

    public int CurrentVersion() {
        return this.CurrentVersion;
    }

    public String AclsKey() {
        return this.AclsKey;
    }

    public AclEntry apply(KafkaPrincipal principal, AclPermissionType permissionType, String host, AclOperation operation) {
        return new AclEntry(new AccessControlEntry(principal == null ? null : principal.toString(), host, operation, permissionType));
    }

    public Set<AclEntry> fromBytes(byte[] bytes) {
        if (bytes == null || Predef$.MODULE$.byteArrayOps(bytes).isEmpty()) {
            return Set$.MODULE$.empty();
        }
        return (Set)Json$.MODULE$.parseBytes(bytes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final JsonObject apply(JsonValue x$1) {
                return x$1.asJsonObject();
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<AclEntry> apply(JsonObject js) {
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)js.apply(AclEntry$.MODULE$.VersionKey()).to(DecodeJson$DecodeInt$.MODULE$)) == AclEntry$.MODULE$.CurrentVersion());
                return js.apply(AclEntry$.MODULE$.AclsKey()).asJsonArray().iterator().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final JsonObject apply(JsonValue x$2) {
                        return x$2.asJsonObject();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final AclEntry apply(JsonObject itemJs) {
                        KafkaPrincipal principal = SecurityUtils.parseKafkaPrincipal((String)itemJs.apply(AclEntry$.MODULE$.PrincipalKey()).to(DecodeJson$DecodeString$.MODULE$));
                        AclPermissionType permissionType = SecurityUtils.permissionType((String)itemJs.apply(AclEntry$.MODULE$.PermissionTypeKey()).to(DecodeJson$DecodeString$.MODULE$));
                        String host = itemJs.apply(AclEntry$.MODULE$.HostsKey()).to(DecodeJson$DecodeString$.MODULE$);
                        AclOperation operation = SecurityUtils.operation((String)itemJs.apply(AclEntry$.MODULE$.OperationKey()).to(DecodeJson$DecodeString$.MODULE$));
                        return AclEntry$.MODULE$.apply(principal, permissionType, host, operation);
                    }
                }).toSet();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Set<AclEntry> apply() {
                return Predef$.MODULE$.Set().empty();
            }
        });
    }

    public Map<String, Object> toJsonCompatibleMap(Set<AclEntry> acls2) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.VersionKey()), (Object)BoxesRunTime.boxToInteger((int)this.CurrentVersion())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.AclsKey()), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)acls2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final java.util.Map<String, Object> apply(AclEntry acl) {
                return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(acl.toMap()).asJava();
            }
        }, Set$.MODULE$.canBuildFrom())).toList()).asJava())}));
    }

    public Set<AclOperation> supportedOperations(ResourceType resourceType) {
        block7: {
            Set set;
            block3: {
                ResourceType resourceType2;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                resourceType2 = resourceType;
                                if (!ResourceType.TOPIC.equals(resourceType2)) break block2;
                                set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DESCRIBE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS}));
                                break block3;
                            }
                            if (!ResourceType.GROUP.equals(resourceType2)) break block4;
                            set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.DESCRIBE, AclOperation.DELETE}));
                            break block3;
                        }
                        if (!ResourceType.CLUSTER.equals(resourceType2)) break block5;
                        set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.CREATE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE, AclOperation.ALTER, AclOperation.DESCRIBE}));
                        break block3;
                    }
                    if (!ResourceType.TRANSACTIONAL_ID.equals(resourceType2)) break block6;
                    set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE, AclOperation.WRITE}));
                    break block3;
                }
                if (!ResourceType.DELEGATION_TOKEN.equals(resourceType2)) break block7;
                set = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE}));
            }
            return set;
        }
        throw new IllegalArgumentException("Not a concrete resource type");
    }

    public Errors authorizationError(ResourceType resourceType) {
        block7: {
            Errors errors;
            block3: {
                ResourceType resourceType2;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                resourceType2 = resourceType;
                                if (!ResourceType.TOPIC.equals(resourceType2)) break block2;
                                errors = Errors.TOPIC_AUTHORIZATION_FAILED;
                                break block3;
                            }
                            if (!ResourceType.GROUP.equals(resourceType2)) break block4;
                            errors = Errors.GROUP_AUTHORIZATION_FAILED;
                            break block3;
                        }
                        if (!ResourceType.CLUSTER.equals(resourceType2)) break block5;
                        errors = Errors.CLUSTER_AUTHORIZATION_FAILED;
                        break block3;
                    }
                    if (!ResourceType.TRANSACTIONAL_ID.equals(resourceType2)) break block6;
                    errors = Errors.TRANSACTIONAL_ID_AUTHORIZATION_FAILED;
                    break block3;
                }
                if (!ResourceType.DELEGATION_TOKEN.equals(resourceType2)) break block7;
                errors = Errors.DELEGATION_TOKEN_AUTHORIZATION_FAILED;
            }
            return errors;
        }
        throw new IllegalArgumentException("Authorization error type not known");
    }

    private AclEntry$() {
        MODULE$ = this;
        this.WildcardPrincipal = new KafkaPrincipal("User", "*");
        this.WildcardPrincipalString = this.WildcardPrincipal().toString();
        this.WildcardHost = "*";
        this.WildcardResource = "*";
        this.ResourceSeparator = ":";
        this.ResourceTypes = (Set)Predef$.MODULE$.refArrayOps((Object[])ResourceType.values()).toSet().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(ResourceType t) {
                ResourceType resourceType = t;
                ResourceType resourceType2 = ResourceType.UNKNOWN;
                if (resourceType == null) {
                    if (resourceType2 == null) return true;
                } else if (resourceType.equals(resourceType2)) return true;
                ResourceType resourceType3 = t;
                ResourceType resourceType4 = ResourceType.ANY;
                if (resourceType3 != null) {
                    if (!resourceType3.equals(resourceType4)) return false;
                    return true;
                }
                if (resourceType4 == null) return true;
                return false;
            }
        });
        this.AclOperations = (Set)Predef$.MODULE$.refArrayOps((Object[])AclOperation.values()).toSet().filterNot((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(AclOperation t) {
                AclOperation aclOperation = t;
                AclOperation aclOperation2 = AclOperation.UNKNOWN;
                if (aclOperation == null) {
                    if (aclOperation2 == null) return true;
                } else if (aclOperation.equals(aclOperation2)) return true;
                AclOperation aclOperation3 = t;
                AclOperation aclOperation4 = AclOperation.ANY;
                if (aclOperation3 != null) {
                    if (!aclOperation3.equals(aclOperation4)) return false;
                    return true;
                }
                if (aclOperation4 == null) return true;
                return false;
            }
        });
        this.PrincipalKey = "principal";
        this.PermissionTypeKey = "permissionType";
        this.OperationKey = "operation";
        this.HostsKey = "host";
        this.VersionKey = "version";
        this.CurrentVersion = 1;
        this.AclsKey = "acls";
    }
}

