/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import kafka.network.RequestChannel;
import kafka.security.auth.Acl;
import kafka.security.auth.Authorizer;
import kafka.security.auth.Operation;
import kafka.security.auth.Operation$;
import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.SimpleAclAuthorizer$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AuthorizerUtils$;
import kafka.security.authorizer.AuthorizerWrapper$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.SetLike;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\rUs!B\u0001\u0003\u0011\u0003I\u0011aE*j[BdW-Q2m\u0003V$\bn\u001c:ju\u0016\u0014(BA\u0002\u0005\u0003\u0011\tW\u000f\u001e5\u000b\u0005\u00151\u0011\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003\u001d\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QBA\nTS6\u0004H.Z!dY\u0006+H\u000f[8sSj,'o\u0005\u0002\f\u001dA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001aDQ!F\u0006\u0005\u0002Y\ta\u0001P5oSRtD#A\u0005\t\u000faY!\u0019!C\u00013\u0005I!l[+sYB\u0013x\u000e]\u000b\u00025A\u00111D\b\b\u0003\u001fqI!!\b\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0002E\u0001\u0004TiJLgn\u001a\u0006\u0003;AAaAI\u0006!\u0002\u0013Q\u0012A\u0003.l+Jd\u0007K]8qA!9Ae\u0003b\u0001\n\u0003I\u0012a\u0006.l\u0007>tg.Z2uS>tG+[7f\u001fV$\bK]8q\u0011\u001913\u0002)A\u00055\u0005A\"l[\"p]:,7\r^5p]RKW.Z(viB\u0013x\u000e\u001d\u0011\t\u000f!Z!\u0019!C\u00013\u0005!\"l[*fgNLwN\u001c+j[\u0016|U\u000f\u001e)s_BDaAK\u0006!\u0002\u0013Q\u0012!\u0006.l'\u0016\u001c8/[8o)&lWmT;u!J|\u0007\u000f\t\u0005\bY-\u0011\r\u0011\"\u0001\u001a\u0003UQ6.T1y\u0013:4E.[4iiJ+\u0017/^3tiNDaAL\u0006!\u0002\u0013Q\u0012A\u0006.l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\t\u000fAZ!\u0019!C\u0001c\u0005q1+\u001e9feV\u001bXM]:Qe>\u0004X#\u0001\u001a\u0011\u0005MBT\"\u0001\u001b\u000b\u0005U2\u0014\u0001\u00027b]\u001eT\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002 i!1!h\u0003Q\u0001\nI\nqbU;qKJ,6/\u001a:t!J|\u0007\u000f\t\u0005\by-\u0011\r\u0011\"\u00012\u0003}\tE\u000e\\8x\u000bZ,'/_8oK&3gj\\!dY&\u001bhi\\;oIB\u0013x\u000e\u001d\u0005\u0007}-\u0001\u000b\u0011\u0002\u001a\u0002A\u0005cGn\\<Fm\u0016\u0014\u0018p\u001c8f\u0013\u001atu.Q2m\u0013N4u.\u001e8e!J|\u0007\u000f\t\u0004\u0005\u0001.\u0001\u0015IA\u0007WKJ\u001c\u0018n\u001c8fI\u0006\u001bGn]\n\u0005\u007f9\u0011U\t\u0005\u0002\u0010\u0007&\u0011A\t\u0005\u0002\b!J|G-^2u!\tya)\u0003\u0002H!\ta1+\u001a:jC2L'0\u00192mK\"A\u0011j\u0010BK\u0002\u0013\u0005!*\u0001\u0003bG2\u001cX#A&\u0011\u0007mae*\u0003\u0002NA\t\u00191+\u001a;\u0011\u0005)y\u0015B\u0001)\u0003\u0005\r\t5\r\u001c\u0005\t%~\u0012\t\u0012)A\u0005\u0017\u0006)\u0011m\u00197tA!AAk\u0010BK\u0002\u0013\u0005Q+A\u0005{WZ+'o]5p]V\ta\u000b\u0005\u0002\u0010/&\u0011\u0001\f\u0005\u0002\u0004\u0013:$\b\u0002\u0003.@\u0005#\u0005\u000b\u0011\u0002,\u0002\u0015i\\g+\u001a:tS>t\u0007\u0005C\u0003\u0016\u007f\u0011\u0005A\fF\u0002^?\u0002\u0004\"AX \u000e\u0003-AQ!S.A\u0002-CQ\u0001V.A\u0002YCQAY \u0005\u0002\r\fa!\u001a=jgR\u001cX#\u00013\u0011\u0005=)\u0017B\u00014\u0011\u0005\u001d\u0011un\u001c7fC:Dq\u0001[ \u0002\u0002\u0013\u0005\u0011.\u0001\u0003d_BLHcA/kW\"9\u0011j\u001aI\u0001\u0002\u0004Y\u0005b\u0002+h!\u0003\u0005\rA\u0016\u0005\b[~\n\n\u0011\"\u0001o\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a\u001c\u0016\u0003\u0017B\\\u0013!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005Y\u0004\u0012AC1o]>$\u0018\r^5p]&\u0011\u0001p\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007b\u0002>@#\u0003%\ta_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\u0005a(F\u0001,q\u0011\u001dqx(!A\u0005BE\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&D\b\u0002CA\u0001\u007f\u0005\u0005I\u0011A+\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005\u0015q(!A\u0005\u0002\u0005\u001d\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0013\ty\u0001E\u0002\u0010\u0003\u0017I1!!\u0004\u0011\u0005\r\te.\u001f\u0005\n\u0003#\t\u0019!!AA\u0002Y\u000b1\u0001\u001f\u00132\u0011%\t)bPA\u0001\n\u0003\n9\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0002\u0005\u0004\u0002\u001c\u0005\u0005\u0012\u0011B\u0007\u0003\u0003;Q1!a\b\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003G\tiB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t9cPA\u0001\n\u0003\tI#\u0001\u0005dC:,\u0015/^1m)\r!\u00171\u0006\u0005\u000b\u0003#\t)#!AA\u0002\u0005%\u0001\"CA\u0018\u007f\u0005\u0005I\u0011IA\u0019\u0003!A\u0017m\u001d5D_\u0012,G#\u0001,\t\u0013\u0005Ur(!A\u0005B\u0005]\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003IB\u0011\"a\u000f@\u0003\u0003%\t%!\u0010\u0002\r\u0015\fX/\u00197t)\r!\u0017q\b\u0005\u000b\u0003#\tI$!AA\u0002\u0005%q!CA\"\u0017\u0005\u0005\t\u0012AA#\u000351VM]:j_:,G-Q2mgB\u0019a,a\u0012\u0007\u0011\u0001[\u0011\u0011!E\u0001\u0003\u0013\u001aR!a\u0012\u0002L\u0015\u0003r!!\u0014\u0002T-3V,\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\t\u0002\u000fI,h\u000e^5nK&!\u0011QKA(\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\b+\u0005\u001dC\u0011AA-)\t\t)\u0005\u0003\u0006\u00026\u0005\u001d\u0013\u0011!C#\u0003oA!\"a\u0018\u0002H\u0005\u0005I\u0011QA1\u0003\u0015\t\u0007\u000f\u001d7z)\u0015i\u00161MA3\u0011\u0019I\u0015Q\fa\u0001\u0017\"1A+!\u0018A\u0002YC!\"!\u001b\u0002H\u0005\u0005I\u0011QA6\u0003\u001d)h.\u00199qYf$B!!\u001c\u0002zA)q\"a\u001c\u0002t%\u0019\u0011\u0011\u000f\t\u0003\r=\u0003H/[8o!\u0015y\u0011QO&W\u0013\r\t9\b\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\u0005m\u0014qMA\u0001\u0002\u0004i\u0016a\u0001=%a!Q\u0011qPA$\u0003\u0003%I!!!\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0007\u00032aMAC\u0013\r\t9\t\u000e\u0002\u0007\u001f\nTWm\u0019;\t\u0013\u0005-5B1A\u0005\u0002\u00055\u0015A\u0002(p\u0003\u000ed7/F\u0001^\u0011\u001d\t\tj\u0003Q\u0001\nu\u000bqAT8BG2\u001c\bEB\u0004\u0002\u0016.\u0001!!a&\u0003\u001d\t\u000b7/Z!vi\"|'/\u001b>feN!\u00111SAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAP\t\u0005Q\u0011-\u001e;i_JL'0\u001a:\n\t\u0005\r\u0016Q\u0014\u0002\u000e\u0003\u000ed\u0017)\u001e;i_JL'0\u001a:\t\u000fU\t\u0019\n\"\u0001\u0002(R\u0011\u0011\u0011\u0016\t\u0004=\u0006M\u0005\u0002CAW\u0003'#\t%a,\u0002\u001f1|w-Q;eSRlUm]:bO\u0016$\u0002\"!-\u00028\u0006M\u0017Q\u001c\t\u0004\u001f\u0005M\u0016bAA[!\t!QK\\5u\u0011!\tI,a+A\u0002\u0005m\u0016A\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\t\u0005\u0003{\u000by-\u0004\u0002\u0002@*!\u0011qTAa\u0015\u0011\t\u0019-!2\u0002\rM,'O^3s\u0015\r9\u0011q\u0019\u0006\u0005\u0003\u0013\fY-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u001b\f1a\u001c:h\u0013\u0011\t\t.a0\u00035\u0005+H\u000f[8sSj\f'\r\\3SKF,Xm\u001d;D_:$X\r\u001f;\t\u0011\u0005U\u00171\u0016a\u0001\u0003/\fa!Y2uS>t\u0007\u0003BA_\u00033LA!a7\u0002@\n1\u0011i\u0019;j_:Dq!a8\u0002,\u0002\u0007A-\u0001\u0006bkRDwN]5{K\u0012DsaCAr\u0003S\fi\u000fE\u0002\u0010\u0003KL1!a:\u0011\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003W\f1&V:fA-\fgm[1/g\u0016\u001cWO]5us:\nW\u000f\u001e5pe&TXM\u001d\u0018BG2\fU\u000f\u001e5pe&TXM]\u0011\u0003\u0003_\f\u0011bU5oG\u0016\u0004#G\f\u001b)\u000f-\t\u0019/!;\u0002n\":\u0001!a9\u0002j\u00065h!\u0002\u0007\u0003\u0001\u0005]8\u0003CA{\u0003\u0007\u000bI0a@\u0011\u0007)\tY0C\u0002\u0002~\n\u0011!\"Q;uQ>\u0014\u0018N_3s!\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u0003\r\u0005)Q\u000f^5mg&!!\u0011\u0002B\u0002\u0005\u001daunZ4j]\u001eDq!FA{\t\u0003\u0011i\u0001\u0006\u0002\u0003\u0010A\u0019!\"!>\t\u0015\tM\u0011Q\u001fb\u0001\n\u0013\u0011)\"A\u0007bG2\fU\u000f\u001e5pe&TXM]\u000b\u0003\u0005/\u0001BA!\u0007\u0002\u0014:\u0019!1\u0004\u0001\u000f\t\tu!1\u0006\b\u0005\u0005?\u0011IC\u0004\u0003\u0003\"\t\u001dRB\u0001B\u0012\u0015\r\u0011)\u0003C\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dI!!\u0002\u0004\n\u0005\r!\u0001\"\u0003B\u0018\u0003k\u0004\u000b\u0011\u0002B\f\u00039\t7\r\\!vi\"|'/\u001b>fe\u0002B!Ba\r\u0002v\u0002\u0007I\u0011\u0003\u0002V\u0003Ai\u0017\r_+qI\u0006$XMU3ue&,7\u000fC\u0006\u00038\u0005U\b\u0019!C\t\u0005\te\u0012\u0001F7bqV\u0003H-\u0019;f%\u0016$(/[3t?\u0012*\u0017\u000f\u0006\u0003\u00022\nm\u0002\"CA\t\u0005k\t\t\u00111\u0001W\u0011!\u0011y$!>!B\u00131\u0016!E7bqV\u0003H-\u0019;f%\u0016$(/[3tA!A!1IA{\t\u0003\u0012)%A\u0005d_:4\u0017nZ;sKR!\u0011\u0011\u0017B$\u0011!\u0011IE!\u0011A\u0002\t-\u0013a\u00036bm\u0006\u001cuN\u001c4jON\u0004DA!\u0014\u0003^A9!q\nB+5\teSB\u0001B)\u0015\r\u0011\u0019FN\u0001\u0005kRLG.\u0003\u0003\u0003X\tE#aA'baB!!1\fB/\u0019\u0001!ABa\u0018\u0003H\u0005\u0005\t\u0011!B\u0001\u0005C\u00121a\u0018\u00132#\u0011\u0011\u0019'!\u0003\u0011\u0007=\u0011)'C\u0002\u0003hA\u0011qAT8uQ&tw\r\u0003\u0005\u0003l\u0005UH\u0011\tB7\u0003%\tW\u000f\u001e5pe&TX\rF\u0004e\u0005_\u0012IIa%\t\u0011\tE$\u0011\u000ea\u0001\u0005g\nqa]3tg&|g\u000e\u0005\u0003\u0003v\t\re\u0002\u0002B<\u0005{rAAa\b\u0003z%\u0019!1\u0010\u0004\u0002\u000f9,Go^8sW&!!q\u0010BA\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2T1Aa\u001f\u0007\u0013\u0011\u0011)Ia\"\u0003\u000fM+7o]5p]*!!q\u0010BA\u0011!\u0011YI!\u001bA\u0002\t5\u0015!C8qKJ\fG/[8o!\rQ!qR\u0005\u0004\u0005#\u0013!!C(qKJ\fG/[8o\u0011!\u0011)J!\u001bA\u0002\t]\u0015\u0001\u0003:fg>,(oY3\u0011\u0007)\u0011I*C\u0002\u0003\u001c\n\u0011\u0001BU3t_V\u00148-\u001a\u0005\t\u0005?\u000b)\u0010\"\u0001\u0003\"\u0006Y\u0011n]*va\u0016\u0014Xk]3s)%!'1\u0015BS\u0005O\u0013Y\f\u0003\u0005\u0003\f\nu\u0005\u0019\u0001BG\u0011!\u0011)J!(A\u0002\t]\u0005\u0002\u0003BU\u0005;\u0003\rAa+\u0002\u0013A\u0014\u0018N\\2ja\u0006d\u0007\u0003\u0002BW\u0005ok!Aa,\u000b\u0007\r\u0011\tLC\u0002\u0006\u0005gSAA!.\u0002F\u000611m\\7n_:LAA!/\u00030\nq1*\u00194lCB\u0013\u0018N\\2ja\u0006d\u0007b\u0002B_\u0005;\u0003\rAG\u0001\u0005Q>\u001cH\u000f\u0003\u0005\u0003B\u0006UH\u0011\tBb\u0003\u001d\tG\rZ!dYN$b!!-\u0003F\n\u001d\u0007BB%\u0003@\u0002\u00071\n\u0003\u0005\u0003\u0016\n}\u0006\u0019\u0001BL\u0011!\u0011Y-!>\u0005B\t5\u0017A\u0003:f[>4X-Q2mgR)AMa4\u0003T\"9!\u0011\u001bBe\u0001\u0004Y\u0015aD1dYN$vNY3SK6|g/\u001a3\t\u0011\tU%\u0011\u001aa\u0001\u0005/C\u0001Ba3\u0002v\u0012\u0005#q\u001b\u000b\u0004I\ne\u0007\u0002\u0003BK\u0005+\u0004\rAa&\t\u0011\tu\u0017Q\u001fC!\u0005?\fqaZ3u\u0003\u000ed7\u000fF\u0002L\u0005CD\u0001B!&\u0003\\\u0002\u0007!q\u0013\u0005\t\u0005;\f)\u0010\"\u0011\u0003fR!!q\u001dBv!\u0019Y\"\u0011\u001eBL\u0017&\u0019!q\u000b\u0011\t\u0011\t%&1\u001da\u0001\u0005WC\u0001Ba<\u0002v\u0012\u0005!\u0011_\u0001\u0010O\u0016$X*\u0019;dQ&tw-Q2mgR)1Ja=\u0003~\"A!Q\u001fBw\u0001\u0004\u001190\u0001\u0007sKN|WO]2f)f\u0004X\rE\u0002\u000b\u0005sL1Aa?\u0003\u00051\u0011Vm]8ve\u000e,G+\u001f9f\u0011\u001d\u0011yP!<A\u0002i\tAB]3t_V\u00148-\u001a(b[\u0016D\u0001B!8\u0002v\u0012\u000531\u0001\u000b\u0003\u0005OD\u0001ba\u0002\u0002v\u0012\u00051\u0011B\u0001\u0006G2|7/\u001a\u000b\u0003\u0003cC\u0001b!\u0004\u0002v\u0012%1qB\u0001\u000bGJ,\u0017\r^3BG2\u001cH\u0003BAY\u0007#A\u0001ba\u0005\u0004\f\u0001\u00071QC\u0001\tE&tG-\u001b8hgB!1\u0004TB\f!\u0011\u0019Iba\b\u000e\u0005\rm!\u0002BB\u000f\u0005g\u000b1!Y2m\u0013\u0011\u0019\tca\u0007\u0003\u0015\u0005\u001bGNQ5oI&tw\r\u0003\u0005\u0004&\u0005UH\u0011BB\u0014\u0003)!W\r\\3uK\u0006\u001bGn\u001d\u000b\u0004I\u000e%\u0002\u0002CB\u0016\u0007G\u0001\ra!\f\u0002\u000f\u0019LG\u000e^3sgB!1\u0004TB\u0018!\u0011\u0019Ib!\r\n\t\rM21\u0004\u0002\u0011\u0003\u000ed')\u001b8eS:<g)\u001b7uKJDq!SA{\t\u0013\u00199\u0004\u0006\u0003\u0003h\u000ee\u0002\u0002CB\u001e\u0007k\u0001\raa\f\u0002\r\u0019LG\u000e^3s\u0011!\u0019y$!>\u0005\n\r\u0005\u0013A\u0004;ie><X\t_2faRLwN\u001c\u000b\u0005\u0003c\u001b\u0019\u0005\u0003\u0005\u0004F\ru\u0002\u0019AB$\u0003\u0005)\u0007\u0003BB%\u0007\u001fj!aa\u0013\u000b\t\r5#1W\u0001\u0007KJ\u0014xN]:\n\t\rE31\n\u0002\r\u0003BLW\t_2faRLwN\u001c\u0015\t\u0003k\f\u0019/!;\u0002n\u0002")
public class SimpleAclAuthorizer
implements Authorizer,
Logging {
    private final BaseAuthorizer aclAuthorizer;
    private int maxUpdateRetries;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static VersionedAcls NoAcls() {
        return SimpleAclAuthorizer$.MODULE$.NoAcls();
    }

    public static String AllowEveryoneIfNoAclIsFoundProp() {
        return SimpleAclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp();
    }

    public static String SuperUsersProp() {
        return SimpleAclAuthorizer$.MODULE$.SuperUsersProp();
    }

    public static String ZkMaxInFlightRequests() {
        return SimpleAclAuthorizer$.MODULE$.ZkMaxInFlightRequests();
    }

    public static String ZkSessionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkSessionTimeOutProp();
    }

    public static String ZkConnectionTimeOutProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkConnectionTimeOutProp();
    }

    public static String ZkUrlProp() {
        return SimpleAclAuthorizer$.MODULE$.ZkUrlProp();
    }

    private Logger logger$lzycompute() {
        SimpleAclAuthorizer simpleAclAuthorizer = this;
        synchronized (simpleAclAuthorizer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private BaseAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    public int maxUpdateRetries() {
        return this.maxUpdateRetries;
    }

    public void maxUpdateRetries_$eq(int x$1) {
        this.maxUpdateRetries = x$1;
    }

    public void configure(Map<String, ?> javaConfigs) {
        this.aclAuthorizer().configure(javaConfigs);
    }

    @Override
    public boolean authorize(RequestChannel.Session session, Operation operation, Resource resource) {
        AuthorizableRequestContext requestContext = AuthorizerUtils$.MODULE$.sessionToRequestContext(session);
        Action action = new Action(operation.toJava(), resource.toPattern(), 1, true, true);
        Object object = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().authorize(requestContext, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Action[]{action}))).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    public boolean isSuperUser(Operation operation, Resource resource, KafkaPrincipal principal, String host) {
        return this.aclAuthorizer().isSuperUser(principal);
    }

    @Override
    public void addAcls(scala.collection.immutable.Set<Acl> acls2, Resource resource) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        if (acls2 != null && acls2.nonEmpty()) {
            scala.collection.immutable.Set bindings = (scala.collection.immutable.Set)acls2.map((Function1)new Serializable(this, resource){
                public static final long serialVersionUID = 0L;
                private final Resource resource$2;

                public final AclBinding apply(Acl acl) {
                    return AuthorizerWrapper$.MODULE$.convertToAclBinding(this.resource$2, acl);
                }
                {
                    this.resource$2 = resource$2;
                }
            }, Set$.MODULE$.canBuildFrom());
            this.createAcls((scala.collection.immutable.Set<AclBinding>)bindings);
        }
    }

    @Override
    public boolean removeAcls(scala.collection.immutable.Set<Acl> aclsTobeRemoved, Resource resource) {
        scala.collection.immutable.Set filters = (scala.collection.immutable.Set)aclsTobeRemoved.map((Function1)new Serializable(this, resource){
            public static final long serialVersionUID = 0L;
            private final Resource resource$3;

            public final AclBindingFilter apply(Acl acl) {
                return new AclBindingFilter(this.resource$3.toPattern().toFilter(), AuthorizerWrapper$.MODULE$.convertToAccessControlEntry(acl).toFilter());
            }
            {
                this.resource$3 = resource$3;
            }
        }, Set$.MODULE$.canBuildFrom());
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)filters);
    }

    @Override
    public boolean removeAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return this.deleteAcls((scala.collection.immutable.Set<AclBindingFilter>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{filter}))));
    }

    @Override
    public scala.collection.immutable.Set<Acl> getAcls(Resource resource) {
        AclBindingFilter filter = new AclBindingFilter(resource.toPattern().toFilter(), AccessControlEntryFilter.ANY);
        return (scala.collection.immutable.Set)this.acls(filter).getOrElse((Object)resource, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Acl> apply() {
                return Predef$.MODULE$.Set().empty();
            }
        });
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls(KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return this.acls(filter);
    }

    public scala.collection.immutable.Set<Acl> getMatchingAcls(ResourceType resourceType, String resourceName) {
        AclBindingFilter filter = new AclBindingFilter(new ResourcePatternFilter(resourceType.toJava(), resourceName, PatternType.MATCH), AccessControlEntryFilter.ANY);
        return ((TraversableOnce)this.acls(filter).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Acl> apply(Tuple2<Resource, scala.collection.immutable.Set<Acl>> x$1) {
                return (scala.collection.immutable.Set)x$1._2();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    @Override
    public scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> getAcls() {
        return this.acls(AclBindingFilter.ANY);
    }

    @Override
    public void close() {
        this.aclAuthorizer().close();
    }

    private void createAcls(scala.collection.immutable.Set<AclBinding> bindings) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        Buffer results = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().createAcls(null, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclCreateResult apply(CompletionStage x$2) {
                return (AclCreateResult)x$2.toCompletableFuture().get();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        results.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizer $outer;

            public final void apply(AclCreateResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$createAcls$1 $outer;

                    public final void apply(ApiException e) {
                        this.$outer.kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizer$$throwException(e);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private boolean deleteAcls(scala.collection.immutable.Set<AclBindingFilter> filters) {
        this.aclAuthorizer().maxUpdateRetries_$eq(this.maxUpdateRetries());
        Buffer results = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls(null, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters.toList()).asJava())).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AclDeleteResult apply(CompletionStage x$3) {
                return (AclDeleteResult)x$3.toCompletableFuture().get();
            }
        }, Buffer$.MODULE$.canBuildFrom());
        results.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SimpleAclAuthorizer $outer;

            public final void apply(AclDeleteResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteAcls$1 $outer;

                    public final void apply(ApiException e) {
                        this.$outer.kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer().kafka$security$auth$SimpleAclAuthorizer$$throwException(e);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SimpleAclAuthorizer kafka$security$auth$SimpleAclAuthorizer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((IterableLike)results.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<AclDeleteResult.AclBindingDeleteResult> apply(AclDeleteResult x$4) {
                return (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(x$4.aclBindingDeleteResults()).asScala();
            }
        }, Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(AclDeleteResult.AclBindingDeleteResult result) {
                OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(result.exception())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Nothing$ apply(ApiException e) {
                        throw e;
                    }
                });
            }
        });
        return results.exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AclDeleteResult r) {
                return ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(r.aclBindingDeleteResults()).asScala()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AclDeleteResult.AclBindingDeleteResult d) {
                        return !d.exception().isPresent();
                    }
                });
            }
        });
    }

    private scala.collection.immutable.Map<Resource, scala.collection.immutable.Set<Acl>> acls(AclBindingFilter filter) {
        scala.collection.mutable.Map result = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(filter)).asScala()).foreach((Function1)new Serializable(this, result){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map result$1;

            public final boolean apply(AclBinding binding) {
                Resource resource = AuthorizerWrapper$.MODULE$.convertToResource(binding.pattern());
                Acl acl = AuthorizerWrapper$.MODULE$.convertToAcl(binding.entry());
                return ((SetLike)this.result$1.getOrElseUpdate((Object)resource, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<Acl> apply() {
                        return (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                })).add((Object)acl);
            }
            {
                this.result$1 = result$1;
            }
        });
        return result.mapValues((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Set<Acl> apply(Set<Acl> x$5) {
                return x$5.toSet();
            }
        }).toMap(Predef$.MODULE$.$conforms());
    }

    public void kafka$security$auth$SimpleAclAuthorizer$$throwException(ApiException e) {
        if (e.getCause() == null) {
            throw e;
        }
        throw e.getCause();
    }

    public SimpleAclAuthorizer() {
        Logging$class.$init$(this);
        this.aclAuthorizer = new BaseAuthorizer();
        this.maxUpdateRetries = 10;
    }

    public static class VersionedAcls
    implements Product,
    Serializable {
        private final scala.collection.immutable.Set<Acl> acls;
        private final int zkVersion;

        public scala.collection.immutable.Set<Acl> acls() {
            return this.acls;
        }

        public int zkVersion() {
            return this.zkVersion;
        }

        public boolean exists() {
            return this.zkVersion() != ZkVersion$.MODULE$.UnknownVersion();
        }

        public VersionedAcls copy(scala.collection.immutable.Set<Acl> acls2, int zkVersion) {
            return new VersionedAcls(acls2, zkVersion);
        }

        public scala.collection.immutable.Set<Acl> copy$default$1() {
            return this.acls();
        }

        public int copy$default$2() {
            return this.zkVersion();
        }

        public String productPrefix() {
            return "VersionedAcls";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this.zkVersion());
                    break;
                }
                case 0: {
                    object = this.acls();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof VersionedAcls;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash(this.acls()));
            n = Statics.mix((int)n, (int)this.zkVersion());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof VersionedAcls)) return false;
            boolean bl = true;
            if (!bl) return false;
            VersionedAcls versionedAcls = (VersionedAcls)x$1;
            scala.collection.immutable.Set<Acl> set = this.acls();
            scala.collection.immutable.Set<Acl> set2 = versionedAcls.acls();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            if (this.zkVersion() != versionedAcls.zkVersion()) return false;
            if (!versionedAcls.canEqual(this)) return false;
            return true;
        }

        public VersionedAcls(scala.collection.immutable.Set<Acl> acls2, int zkVersion) {
            this.acls = acls2;
            this.zkVersion = zkVersion;
            Product.class.$init$((Product)this);
        }
    }

    public static class BaseAuthorizer
    extends AclAuthorizer {
        @Override
        public void logAuditMessage(AuthorizableRequestContext requestContext, Action action, boolean authorized) {
            BoxedUnit boxedUnit;
            KafkaPrincipal principal = requestContext.principal();
            String host = requestContext.clientAddress().getHostAddress();
            Operation operation = Operation$.MODULE$.fromJava(action.operation());
            Resource resource = AuthorizerWrapper$.MODULE$.convertToResource(action.resourcePattern());
            if (authorized) {
                BoxedUnit boxedUnit2;
                if (this.authorizerLogger().underlying().isDebugEnabled()) {
                    this.authorizerLogger().underlying().debug(this.logMessage$1(authorized, principal, host, operation, resource));
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
            } else if (this.authorizerLogger().underlying().isInfoEnabled()) {
                this.authorizerLogger().underlying().info(this.logMessage$1(authorized, principal, host, operation, resource));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        private final String logMessage$1(boolean authorized$1, KafkaPrincipal principal$1, String host$1, Operation operation$1, Resource resource$1) {
            String authResult = authorized$1 ? "Allowed" : "Denied";
            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Principal = ", " is ", " Operation = ", " from host = ", " on resource = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal$1, authResult, operation$1, host$1, resource$1}));
        }
    }
}

