/*
 * Decompiled with CFR 0.152.
 */
package kafka.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import org.apache.kafka.common.utils.Sanitizer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class KafkaMetricsGroup$class {
    public static MetricName metricName(KafkaMetricsGroup $this, String name, Map tags) {
        Class<?> klass = $this.getClass();
        String pkg = klass.getPackage() == null ? "" : klass.getPackage().getName();
        String simpleName = klass.getSimpleName().replaceAll("\\$$", "");
        return $this.explicitMetricName(pkg, simpleName, name, (Map<String, String>)tags);
    }

    public static MetricName explicitMetricName(KafkaMetricsGroup $this, String group, String typeName, String name, Map tags) {
        BoxedUnit boxedUnit;
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(group);
        nameBuilder.append(":type=");
        nameBuilder.append(typeName);
        if (name.length() > 0) {
            nameBuilder.append(",name=");
            boxedUnit = nameBuilder.append(name);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String scope = (String)KafkaMetricsGroup$class.toScope($this, tags).orNull(Predef$.MODULE$.$conforms());
        Option tagsName = KafkaMetricsGroup$class.toMBeanName($this, tags);
        tagsName.foreach((Function1)new Serializable($this, nameBuilder){
            public static final long serialVersionUID = 0L;
            private final StringBuilder nameBuilder$1;

            public final StringBuilder apply(String x$1) {
                return this.nameBuilder$1.append(",").append(x$1);
            }
            {
                this.nameBuilder$1 = nameBuilder$1;
            }
        });
        return new MetricName(group, typeName, name, scope, nameBuilder.toString());
    }

    public static Gauge newGauge(KafkaMetricsGroup $this, String name, Gauge metric, Map tags) {
        return Metrics.defaultRegistry().newGauge($this.metricName(name, (Map<String, String>)tags), metric);
    }

    public static Map newGauge$default$3(KafkaMetricsGroup $this) {
        return Predef$.MODULE$.Map().empty();
    }

    public static Meter newMeter(KafkaMetricsGroup $this, String name, String eventType, TimeUnit timeUnit, Map tags) {
        return Metrics.defaultRegistry().newMeter($this.metricName(name, (Map<String, String>)tags), eventType, timeUnit);
    }

    public static Map newMeter$default$4(KafkaMetricsGroup $this) {
        return Predef$.MODULE$.Map().empty();
    }

    public static Histogram newHistogram(KafkaMetricsGroup $this, String name, boolean biased, Map tags) {
        return Metrics.defaultRegistry().newHistogram($this.metricName(name, (Map<String, String>)tags), biased);
    }

    public static boolean newHistogram$default$2(KafkaMetricsGroup $this) {
        return true;
    }

    public static Map newHistogram$default$3(KafkaMetricsGroup $this) {
        return Predef$.MODULE$.Map().empty();
    }

    public static Timer newTimer(KafkaMetricsGroup $this, String name, TimeUnit durationUnit, TimeUnit rateUnit, Map tags) {
        return Metrics.defaultRegistry().newTimer($this.metricName(name, (Map<String, String>)tags), durationUnit, rateUnit);
    }

    public static Map newTimer$default$4(KafkaMetricsGroup $this) {
        return Predef$.MODULE$.Map().empty();
    }

    public static void removeMetric(KafkaMetricsGroup $this, String name, Map tags) {
        Metrics.defaultRegistry().removeMetric($this.metricName(name, (Map<String, String>)tags));
    }

    public static Map removeMetric$default$2(KafkaMetricsGroup $this) {
        return Predef$.MODULE$.Map().empty();
    }

    private static Option toMBeanName(KafkaMetricsGroup $this, Map tags) {
        None$ none$;
        Map filteredTags = (Map)tags.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String tagValue;
                    String string = tagValue = (String)tuple2._2();
                    String string2 = "";
                    boolean bl = string != null ? !string.equals(string2) : string2 != null;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)filteredTags.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x0$2) {
                    Tuple2<String, String> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value2 = (String)tuple2._2();
                        String string = new StringOps(Predef$.MODULE$.augmentString("%s=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, Sanitizer.jmxSanitize((String)value2)}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
            none$ = new Some((Object)tagsString);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static Option toScope(KafkaMetricsGroup $this, Map tags) {
        None$ none$;
        Map filteredTags = (Map)tags.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String tagValue;
                    String string = tagValue = (String)tuple2._2();
                    String string2 = "";
                    boolean bl = string != null ? !string.equals(string2) : string2 != null;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (filteredTags.nonEmpty()) {
            String tagsString = ((TraversableOnce)((List)filteredTags.toList().sortWith((Function2)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> t1, Tuple2<String, String> t2) {
                    return new StringOps(Predef$.MODULE$.augmentString((String)t1._1())).$less(t2._1());
                }
            })).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> x0$4) {
                    Tuple2<String, String> tuple2 = x0$4;
                    if (tuple2 != null) {
                        String key = (String)tuple2._1();
                        String value2 = (String)tuple2._2();
                        String string = new StringOps(Predef$.MODULE$.augmentString("%s.%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value2.replaceAll("\\.", "_")}));
                        return string;
                    }
                    throw new MatchError(tuple2);
                }
            }, List$.MODULE$.canBuildFrom())).mkString(".");
            none$ = new Some((Object)tagsString);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static void $init$(KafkaMetricsGroup $this) {
    }
}

