/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager$;
import kafka.log.TxnMetadata;
import kafka.server.LogOffsetMetadata;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.types.Schema;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r}u!B\u0001\u0003\u0011\u00039\u0011\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'O\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001\u0001\u0005\u0002\t\u00135\t!AB\u0003\u000b\u0005!\u00051B\u0001\u000bQe>$WoY3s'R\fG/Z'b]\u0006<WM]\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\tq\u0003\u0015:pIV\u001cWM]*oCB\u001c\bn\u001c;WKJ\u001c\u0018n\u001c8\u0016\u0003a\u0001\"!D\r\n\u0005iq!!B*i_J$\bB\u0002\u000f\nA\u0003%\u0001$\u0001\rQe>$WoY3s':\f\u0007o\u001d5piZ+'o]5p]\u0002BqAH\u0005C\u0002\u0013%q$\u0001\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG-F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u0015;sS:<\u0007BB\u0015\nA\u0003%\u0001%A\u0007WKJ\u001c\u0018n\u001c8GS\u0016dG\r\t\u0005\bW%\u0011\r\u0011\"\u0003 \u0003!\u0019%o\u0019$jK2$\u0007BB\u0017\nA\u0003%\u0001%A\u0005De\u000e4\u0015.\u001a7eA!9q&\u0003b\u0001\n\u0013y\u0012a\u0004)s_\u0012,8-\u001a:JI\u001aKW\r\u001c3\t\rEJ\u0001\u0015!\u0003!\u0003A\u0001&o\u001c3vG\u0016\u0014\u0018\n\u001a$jK2$\u0007\u0005C\u00044\u0013\t\u0007I\u0011B\u0010\u0002#1\u000b7\u000f^*fcV,gnY3GS\u0016dG\r\u0003\u00046\u0013\u0001\u0006I\u0001I\u0001\u0013\u0019\u0006\u001cHoU3rk\u0016t7-\u001a$jK2$\u0007\u0005C\u00048\u0013\t\u0007I\u0011B\u0010\u0002%A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0005\u0007s%\u0001\u000b\u0011\u0002\u0011\u0002'A\u0013x\u000eZ;dKJ,\u0005o\\2i\r&,G\u000e\u001a\u0011\t\u000fmJ!\u0019!C\u0005?\u0005yA*Y:u\u001f\u001a47/\u001a;GS\u0016dG\r\u0003\u0004>\u0013\u0001\u0006I\u0001I\u0001\u0011\u0019\u0006\u001cHo\u00144gg\u0016$h)[3mI\u0002BqaP\u0005C\u0002\u0013%q$\u0001\tPM\u001a\u001cX\r\u001e#fYR\fg)[3mI\"1\u0011)\u0003Q\u0001\n\u0001\n\u0011c\u00144gg\u0016$H)\u001a7uC\u001aKW\r\u001c3!\u0011\u001d\u0019\u0015B1A\u0005\n}\ta\u0002V5nKN$\u0018-\u001c9GS\u0016dG\r\u0003\u0004F\u0013\u0001\u0006I\u0001I\u0001\u0010)&lWm\u001d;b[B4\u0015.\u001a7eA!9q)\u0003b\u0001\n\u0013y\u0012\u0001\u0006)s_\u0012,8-\u001a:F]R\u0014\u0018.Z:GS\u0016dG\r\u0003\u0004J\u0013\u0001\u0006I\u0001I\u0001\u0016!J|G-^2fe\u0016sGO]5fg\u001aKW\r\u001c3!\u0011\u001dY\u0015B1A\u0005\n}\tQcQ8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195GS\u0016dG\r\u0003\u0004N\u0013\u0001\u0006I\u0001I\u0001\u0017\u0007>|'\u000fZ5oCR|'/\u00129pG\"4\u0015.\u001a7eA!9q*\u0003b\u0001\n\u0013y\u0012AG\"veJ,g\u000e\u001e+y]\u001aK'o\u001d;PM\u001a\u001cX\r\u001e$jK2$\u0007BB)\nA\u0003%\u0001%A\u000eDkJ\u0014XM\u001c;Uq:4\u0015N]:u\u001f\u001a47/\u001a;GS\u0016dG\r\t\u0005\b'&\u0011\r\u0011\"\u0003U\u000351VM]:j_:|eMZ:fiV\tQ\u000b\u0005\u0002\u000e-&\u0011qK\u0004\u0002\u0004\u0013:$\bBB-\nA\u0003%Q+\u0001\bWKJ\u001c\u0018n\u001c8PM\u001a\u001cX\r\u001e\u0011\t\u000fmK!\u0019!C\u0005)\u0006I1I]2PM\u001a\u001cX\r\u001e\u0005\u0007;&\u0001\u000b\u0011B+\u0002\u0015\r\u00138m\u00144gg\u0016$\b\u0005C\u0004`\u0013\t\u0007I\u0011\u0002+\u0002+A\u0013x\u000eZ;dKJ,e\u000e\u001e:jKN|eMZ:fi\"1\u0011-\u0003Q\u0001\nU\u000ba\u0003\u0015:pIV\u001cWM]#oiJLWm](gMN,G\u000f\t\u0005\bG&\u0011\r\u0011\"\u0001e\u0003m\u0001&o\u001c3vG\u0016\u00148K\\1qg\"|G/\u00128uef\u001c6\r[3nCV\tQ\r\u0005\u0002ge6\tqM\u0003\u0002iS\u0006)A/\u001f9fg*\u0011!n[\u0001\taJ|Go\\2pY*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015q'BA8q\u0003\u0019\t\u0007/Y2iK*\t\u0011/A\u0002pe\u001eL!a]4\u0003\rM\u001b\u0007.Z7b\u0011\u0019)\u0018\u0002)A\u0005K\u0006a\u0002K]8ek\u000e,'o\u00158baNDw\u000e^#oiJL8k\u00195f[\u0006\u0004\u0003bB<\n\u0005\u0004%\t\u0001Z\u0001\u0015!&$7K\\1qg\"|G/T1q'\u000eDW-\\1\t\reL\u0001\u0015!\u0003f\u0003U\u0001\u0016\u000eZ*oCB\u001c\bn\u001c;NCB\u001c6\r[3nC\u0002BQa_\u0005\u0005\u0002q\fAB]3bINs\u0017\r]:i_R$2!`A\r!\u0015q\u0018QBA\n\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0006\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017q\u0001c\u0001\u0005\u0002\u0016%\u0019\u0011q\u0003\u0002\u0003%A\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000b:$(/\u001f\u0005\b\u00037Q\b\u0019AA\u000f\u0003\u00111\u0017\u000e\\3\u0011\t\u0005}\u0011QE\u0007\u0003\u0003CQ1!a\t%\u0003\tIw.\u0003\u0003\u0002(\u0005\u0005\"\u0001\u0002$jY\u0016Daa_\u0005\u0005\u0002\u0005-BcA?\u0002.!A\u0011qFA\u0015\u0001\u0004\t\t$\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u0013\u0002\u00079Lw.\u0003\u0003\u0002<\u0005U\"A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u0011qH\u0005\u0005\n\u0005\u0005\u0013!D<sSR,7K\\1qg\"|G\u000f\u0006\u0004\u0002D\u0005%\u00131\n\t\u0004\u001b\u0005\u0015\u0013bAA$\u001d\t!QK\\5u\u0011!\tY\"!\u0010A\u0002\u0005u\u0001\u0002CA'\u0003{\u0001\r!a\u0014\u0002\u000f\u0015tGO]5fgBA\u0011\u0011KA.\u0003?\n\u0019\"\u0004\u0002\u0002T)!\u0011QKA,\u0003\u001diW\u000f^1cY\u0016T1!!\u0017\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\n\u0019FA\u0002NCB\u00042!DA1\u0013\r\t\u0019G\u0004\u0002\u0005\u0019>tw\rC\u0004\u0002h%!I!!\u001b\u0002\u001d%\u001c8K\\1qg\"|GOR5mKR!\u00111NA9!\ri\u0011QN\u0005\u0004\u0003_r!a\u0002\"p_2,\u0017M\u001c\u0005\t\u00037\t)\u00071\u0001\u0002\u001e!A\u0011QO\u0005\u0005\u0002\t\t9(A\tmSN$8K\\1qg\"|GOR5mKN$B!!\u001f\u0002\u0000A)a0a\u001f\u0002\u001e%!\u0011QPA\t\u0005\r\u0019V-\u001d\u0005\t\u0003\u0003\u000b\u0019\b1\u0001\u0002\u001e\u0005\u0019A-\u001b:\t\u0011\u0005\u0015\u0015\u0002\"\u0001\u0003\u0003\u000f\u000bQ\u0003Z3mKR,7K\\1qg\"|Go\u001d\"fM>\u0014X\r\u0006\u0004\u0002D\u0005%\u00151\u0012\u0005\t\u0003\u0003\u000b\u0019\t1\u0001\u0002\u001e!A\u0011QRAB\u0001\u0004\ty&\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0003#KA\u0011BAJ\u0003M!W\r\\3uKNs\u0017\r]:i_R4\u0015\u000e\\3t)\u0019\t\u0019%!&\u0002\u0018\"A\u0011\u0011QAH\u0001\u0004\ti\u0002\u0003\u0006\u0002\u001a\u0006=\u0005\u0013!a\u0001\u00037\u000b\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\u000f5\ti*a\u0018\u0002l%\u0019\u0011q\u0014\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004bBAR\u0013\u0011%\u0011QU\u0001\u0016g:\f\u0007o\u001d5pi\u001aKG.\u001a$pe>3gm]3u)\u0019\t9+!,\u00020B)Q\"!+\u0002\u001e%\u0019\u00111\u0016\b\u0003\r=\u0003H/[8o\u0011!\t\t)!)A\u0002\u0005u\u0001\u0002CAG\u0003C\u0003\r!a\u0018\t\u0013\u0005M\u0016\"%A\u0005\u0002\u0005U\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3'\u0006\u0002\u00028*\u001aQ+!/,\u0005\u0005m\u0006\u0003BA_\u0003\u000fl!!a0\u000b\t\u0005\u0005\u00171Y\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!2\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\fyLA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!4\n#\u0003%I!a4\u0002;\u0011,G.\u001a;f':\f\u0007o\u001d5pi\u001aKG.Z:%I\u00164\u0017-\u001e7uII*\"!!5+\t\u0005m\u0015\u0011\u0018\u0004\u0006\u0015\t\u0001\u0011Q[\n\u0006\u0003'd\u0011q\u001b\t\u0005\u00033\fy.\u0004\u0002\u0002\\*\u0019\u0011Q\u001c\u0003\u0002\u000bU$\u0018\u000e\\:\n\t\u0005\u0005\u00181\u001c\u0002\b\u0019><w-\u001b8h\u0011-\t)/a5\u0003\u0006\u0004%\t!a:\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u001e\t\u0005\u0003W\fi/D\u0001l\u0013\r\tyo\u001b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011-\t\u00190a5\u0003\u0002\u0003\u0006I!!;\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002B1\"a>\u0002T\n\u0005\r\u0011\"\u0001\u0002z\u00061An\\4ESJ,\"!!\b\t\u0017\u0005u\u00181\u001bBA\u0002\u0013\u0005\u0011q`\u0001\u000bY><G)\u001b:`I\u0015\fH\u0003BA\"\u0005\u0003A!Ba\u0001\u0002|\u0006\u0005\t\u0019AA\u000f\u0003\rAH%\r\u0005\f\u0005\u000f\t\u0019N!A!B\u0013\ti\"A\u0004m_\u001e$\u0015N\u001d\u0011)\t\t\u0015!1\u0002\t\u0004\u001b\t5\u0011b\u0001B\b\u001d\tAao\u001c7bi&dW\r\u0003\u0006\u0003\u0014\u0005M'Q1A\u0005\u0002Q\u000b\u0011$\\1y!J|G-^2fe&#W\t\u001f9je\u0006$\u0018n\u001c8Ng\"Q!qCAj\u0005\u0003\u0005\u000b\u0011B+\u000255\f\u0007\u0010\u0015:pIV\u001cWM]%e\u000bb\u0004\u0018N]1uS>tWj\u001d\u0011\t\u000fM\t\u0019\u000e\"\u0001\u0003\u001cQA!Q\u0004B\u0010\u0005C\u0011\u0019\u0003E\u0002\t\u0003'D\u0001\"!:\u0003\u001a\u0001\u0007\u0011\u0011\u001e\u0005\t\u0003o\u0014I\u00021\u0001\u0002\u001e!I!1\u0003B\r!\u0003\u0005\r!\u0016\u0005\u000b\u0005O\t\u0019N1A\u0005\n\t%\u0012!\u00039s_\u0012,8-\u001a:t+\t\ty\u0005C\u0005\u0003.\u0005M\u0007\u0015!\u0003\u0002P\u0005Q\u0001O]8ek\u000e,'o\u001d\u0011\t\u0015\tE\u00121\u001ba\u0001\n\u0013\u0011\u0019$A\u0007mCN$X*\u00199PM\u001a\u001cX\r^\u000b\u0003\u0003?B!Ba\u000e\u0002T\u0002\u0007I\u0011\u0002B\u001d\u0003Ea\u0017m\u001d;NCB|eMZ:fi~#S-\u001d\u000b\u0005\u0003\u0007\u0012Y\u0004\u0003\u0006\u0003\u0004\tU\u0012\u0011!a\u0001\u0003?B\u0011Ba\u0010\u0002T\u0002\u0006K!a\u0018\u0002\u001d1\f7\u000f^'ba>3gm]3uA!Q!1IAj\u0001\u0004%IAa\r\u0002\u001d1\f7\u000f^*oCB|eMZ:fi\"Q!qIAj\u0001\u0004%IA!\u0013\u0002%1\f7\u000f^*oCB|eMZ:fi~#S-\u001d\u000b\u0005\u0003\u0007\u0012Y\u0005\u0003\u0006\u0003\u0004\t\u0015\u0013\u0011!a\u0001\u0003?B\u0011Ba\u0014\u0002T\u0002\u0006K!a\u0018\u0002\u001f1\f7\u000f^*oCB|eMZ:fi\u0002B!Ba\u0015\u0002T\n\u0007I\u0011\u0002B+\u0003-ygnZ8j]\u001e$\u0006P\\:\u0016\u0005\t]\u0003\u0003\u0003B-\u0005?\nyFa\u0019\u000e\u0005\tm#b\u0001B/I\u0005!Q\u000f^5m\u0013\u0011\u0011\tGa\u0017\u0003\u000fQ\u0013X-Z'baB\u0019\u0001B!\u001a\n\u0007\t\u001d$AA\u0006Uq:lU\r^1eCR\f\u0007\"\u0003B6\u0003'\u0004\u000b\u0011\u0002B,\u00031ygnZ8j]\u001e$\u0006P\\:!\u0011)\u0011y'a5C\u0002\u0013%!QK\u0001\u0011k:\u0014X\r\u001d7jG\u0006$X\r\u001a+y]ND\u0011Ba\u001d\u0002T\u0002\u0006IAa\u0016\u0002#Ut'/\u001a9mS\u000e\fG/\u001a3Uq:\u001c\b\u0005\u0003\u0005\u0003x\u0005MG\u0011\u0001B=\u0003M1\u0017N]:u+:\u001cH/\u00192mK>3gm]3u+\t\u0011Y\bE\u0003\u000e\u0003S\u0013i\b\u0005\u0003\u0003\u0000\t\u0015UB\u0001BA\u0015\r\u0011\u0019\tB\u0001\u0007g\u0016\u0014h/\u001a:\n\t\t\u001d%\u0011\u0011\u0002\u0012\u0019><wJ\u001a4tKRlU\r^1eCR\f\u0007\u0002\u0003BF\u0003'$\tA!$\u0002-=t\u0007*[4i/\u0006$XM]7be.,\u0006\u000fZ1uK\u0012$B!a\u0011\u0003\u0010\"A!\u0011\u0013BE\u0001\u0004\ty&A\u0007iS\u001eDw+\u0019;fe6\f'o\u001b\u0005\t\u0005+\u000b\u0019\u000e\"\u0001\u0003\u0018\u0006!b-\u001b:tiVsG-Z2jI\u0016$wJ\u001a4tKR,\"A!'\u0011\u000b5\tI+a\u0018\t\u0011\tu\u00151\u001bC\u0001\u0005g\tA\"\\1q\u000b:$wJ\u001a4tKRD\u0001B!)\u0002T\u0012\u0005!1U\u0001\u0010C\u000e$\u0018N^3Qe>$WoY3sgV\u0011!Q\u0015\t\t\u0005O\u0013i+a\u0018\u0002\u00145\u0011!\u0011\u0016\u0006\u0005\u0005W\u000b9&A\u0005j[6,H/\u00192mK&!\u0011Q\fBU\u0011!\u0011\t,a5\u0005\u0002\tM\u0016aB5t\u000b6\u0004H/_\u000b\u0003\u0003WB\u0001Ba.\u0002T\u0012%!\u0011X\u0001\u0011Y>\fGM\u0012:p[Ns\u0017\r]:i_R$b!a\u0011\u0003<\n}\u0006\u0002\u0003B_\u0005k\u0003\r!a\u0018\u0002\u001d1|wm\u0015;beR|eMZ:fi\"A!\u0011\u0019B[\u0001\u0004\ty&A\u0006dkJ\u0014XM\u001c;US6,\u0007\"\u0003Bc\u0003'$\tA\u0001Bd\u0003Eaw.\u00193Qe>$WoY3s\u000b:$(/\u001f\u000b\u0005\u0003\u0007\u0012I\r\u0003\u0005\u0003L\n\r\u0007\u0019AA\n\u0003\u0015)g\u000e\u001e:z\u0011!\u0011y-a5\u0005\n\tE\u0017!E5t!J|G-^2fe\u0016C\b/\u001b:fIR1\u00111\u000eBj\u0005/D\u0001B!6\u0003N\u0002\u0007\u0011qL\u0001\u000eGV\u0014(/\u001a8u)&lW-T:\t\u0011\te'Q\u001aa\u0001\u0003'\tQ\u0002\u001d:pIV\u001cWM]*uCR,\u0007\u0002\u0003Bo\u0003'$\tAa8\u0002-I,Wn\u001c<f\u000bb\u0004\u0018N]3e!J|G-^2feN$B!a\u0011\u0003b\"A!Q\u001bBn\u0001\u0004\ty\u0006\u0003\u0005\u0003f\u0006MG\u0011\u0001Bt\u0003E!(/\u001e8dCR,\u0017I\u001c3SK2|\u0017\r\u001a\u000b\t\u0003\u0007\u0012IOa;\u0003p\"A!Q\u0018Br\u0001\u0004\ty\u0006\u0003\u0005\u0003n\n\r\b\u0019AA0\u00031awnZ#oI>3gm]3u\u0011!\u0011)Na9A\u0002\u0005}\u0003\u0002\u0003Bz\u0003'$\tA!>\u00021I,Gn\\1e\rJ|W\u000eV5fe\u0016$7K\\1qg\"|G\u000f\u0006\u0006\u0002D\t](\u0011 B~\u0005\u007fD\u0001B!0\u0003r\u0002\u0007\u0011q\f\u0005\t\u0005\u0003\u0014\t\u00101\u0001\u0002`!A!Q By\u0001\u0004\t\t$\u0001\bt]\u0006\u00048\u000f[8u\u0005V4g-\u001a:\t\u0011\r\u0005!\u0011\u001fa\u0001\u0003?\nab\u001d8baNDw\u000e^(gMN,G\u000f\u0003\u0005\u0004\u0006\u0005MG\u0011AB\u0004\u00035\u0001(/\u001a9be\u0016,\u0006\u000fZ1uKR11\u0011BB\b\u0007'\u00012\u0001CB\u0006\u0013\r\u0019iA\u0001\u0002\u0013!J|G-^2fe\u0006\u0003\b/\u001a8e\u0013:4w\u000e\u0003\u0005\u0004\u0012\r\r\u0001\u0019AA0\u0003)\u0001(o\u001c3vG\u0016\u0014\u0018\n\u001a\u0005\t\u0007+\u0019\u0019\u00011\u0001\u0004\u0018\u00051qN]5hS:\u00042\u0001CB\r\u0013\r\u0019YB\u0001\u0002\r\u0003B\u0004XM\u001c3Pe&<\u0017N\u001c\u0005\t\u0007?\t\u0019\u000e\"\u0001\u0004\"\u00051Q\u000f\u001d3bi\u0016$B!a\u0011\u0004$!A1QEB\u000f\u0001\u0004\u0019I!\u0001\u0006baB,g\u000eZ%oM>D\u0001b!\u000b\u0002T\u0012\u000511F\u0001\u0013kB$\u0017\r^3NCB,e\u000eZ(gMN,G\u000f\u0006\u0003\u0002D\r5\u0002\u0002CB\u0018\u0007O\u0001\r!a\u0018\u0002\u00151\f7\u000f^(gMN,G\u000f\u0003\u0005\u00044\u0005MG\u0011AB\u001b\u0003%a\u0017m\u001d;F]R\u0014\u0018\u0010\u0006\u0003\u00048\re\u0002#B\u0007\u0002*\u0006M\u0001\u0002CB\t\u0007c\u0001\r!a\u0018\t\u0011\ru\u00121\u001bC\u0001\u0007\u007f\tA\u0002^1lKNs\u0017\r]:i_R$\"!a\u0011\t\u0011\r\r\u00131\u001bC\u0001\u0005/\u000bA\u0003\\1uKN$8K\\1qg\"|Go\u00144gg\u0016$\b\u0002CB$\u0003'$\tAa&\u0002)=dG-Z:u':\f\u0007o\u001d5pi>3gm]3u\u0011!\u0019Y%a5\u0005\u0002\r5\u0013\u0001\u0004;sk:\u001c\u0017\r^3IK\u0006$G\u0003BA\"\u0007\u001fB\u0001B!0\u0004J\u0001\u0007\u0011q\f\u0005\t\u0007'\n\u0019\u000e\"\u0003\u0004V\u0005q\"/Z7pm\u0016,fN]3qY&\u001c\u0017\r^3e)J\fgn]1di&|gn\u001d\u000b\u0005\u0003\u0007\u001a9\u0006\u0003\u0005\u0002\u000e\u000eE\u0003\u0019AA0\u0011!\u0019Y&a5\u0005\u0002\r}\u0012\u0001\u0003;sk:\u001c\u0017\r^3\t\u0011\r}\u00131\u001bC\u0001\u0007C\n\u0001\u0003\\1tiN#\u0018M\u00197f\u001f\u001a47/\u001a;\u0015\t\u0005}31\r\u0005\t\u0007K\u001ai\u00061\u0001\u0004h\u0005a1m\\7qY\u0016$X\r\u001a+y]B\u0019\u0001b!\u001b\n\u0007\r-$A\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000e\u0003\u0005\u0004p\u0005MG\u0011AB9\u0003-\u0019w.\u001c9mKR,G\u000b\u001f8\u0015\t\u0005\r31\u000f\u0005\t\u0007K\u001ai\u00071\u0001\u0004h!A\u0011QQAj\t\u0003\u00199\b\u0006\u0003\u0002D\re\u0004\u0002CAG\u0007k\u0002\r!a\u0018)\t\rU4Q\u0010\t\u0005\u00033\u001cy(\u0003\u0003\u0004\u0002\u0006m'A\u0003;ie\u0016\fGm]1gK\"A1QQAj\t\u0013\u00199)\u0001\npY\u0012,7\u000f^*oCB\u001c\bn\u001c;GS2,WCAAT\u0011!\u0019Y)a5\u0005\n\r\u001d\u0015A\u00057bi\u0016\u001cHo\u00158baNDw\u000e\u001e$jY\u0016D\u0011\"!\u001e\u0002T\u0012\u0005!aa$\u0016\u0005\u0005e\u0004\u0002CAR\u0003'$\taa%\u0015\t\u0005\u001d6Q\u0013\u0005\t\u0003\u001b\u001b\t\n1\u0001\u0002`!\"\u00111[BM!\u0011\tIna'\n\t\ru\u00151\u001c\u0002\u000e]>tG\u000f\u001b:fC\u0012\u001c\u0018MZ3")
public class ProducerStateManager
implements Logging {
    private final TopicPartition topicPartition;
    private volatile File logDir;
    private final int maxProducerIdExpirationMs;
    private final Map<Object, ProducerStateEntry> producers;
    private long kafka$log$ProducerStateManager$$lastMapOffset;
    private long lastSnapOffset;
    private final TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns;
    private final TreeMap<Object, TxnMetadata> unreplicatedTxns;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return ProducerStateManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Iterable<ProducerStateEntry> readSnapshot(ByteBuffer byteBuffer) {
        return ProducerStateManager$.MODULE$.readSnapshot(byteBuffer);
    }

    public static Iterable<ProducerStateEntry> readSnapshot(File file) {
        return ProducerStateManager$.MODULE$.readSnapshot(file);
    }

    public static Schema PidSnapshotMapSchema() {
        return ProducerStateManager$.MODULE$.PidSnapshotMapSchema();
    }

    public static Schema ProducerSnapshotEntrySchema() {
        return ProducerStateManager$.MODULE$.ProducerSnapshotEntrySchema();
    }

    private Logger logger$lzycompute() {
        ProducerStateManager producerStateManager = this;
        synchronized (producerStateManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private Map<Object, ProducerStateEntry> producers() {
        return this.producers;
    }

    public long kafka$log$ProducerStateManager$$lastMapOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset;
    }

    private void kafka$log$ProducerStateManager$$lastMapOffset_$eq(long x$1) {
        this.kafka$log$ProducerStateManager$$lastMapOffset = x$1;
    }

    private long lastSnapOffset() {
        return this.lastSnapOffset;
    }

    private void lastSnapOffset_$eq(long x$1) {
        this.lastSnapOffset = x$1;
    }

    public TreeMap<Object, TxnMetadata> kafka$log$ProducerStateManager$$ongoingTxns() {
        return this.kafka$log$ProducerStateManager$$ongoingTxns;
    }

    private TreeMap<Object, TxnMetadata> unreplicatedTxns() {
        return this.unreplicatedTxns;
    }

    public Option<LogOffsetMetadata> firstUnstableOffset() {
        Option unreplicatedFirstOffset = Option$.MODULE$.apply(this.unreplicatedTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$4) {
                return x$4.getValue().firstOffset();
            }
        });
        Option undecidedFirstOffset = Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LogOffsetMetadata apply(Map.Entry<Object, TxnMetadata> x$5) {
                return x$5.getValue().firstOffset();
            }
        });
        return unreplicatedFirstOffset.isEmpty() ? undecidedFirstOffset : (undecidedFirstOffset.isEmpty() ? unreplicatedFirstOffset : (((LogOffsetMetadata)undecidedFirstOffset.get()).messageOffset() < ((LogOffsetMetadata)unreplicatedFirstOffset.get()).messageOffset() ? undecidedFirstOffset : unreplicatedFirstOffset));
    }

    public void onHighWatermarkUpdated(long highWatermark) {
        this.removeUnreplicatedTransactions(highWatermark);
    }

    public Option<Object> firstUndecidedOffset() {
        return Option$.MODULE$.apply(this.kafka$log$ProducerStateManager$$ongoingTxns().firstEntry()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Map.Entry<Object, TxnMetadata> x$6) {
                return x$6.getValue().firstOffset().messageOffset();
            }
        });
    }

    public long mapEndOffset() {
        return this.kafka$log$ProducerStateManager$$lastMapOffset();
    }

    public scala.collection.immutable.Map<Object, ProducerStateEntry> activeProducers() {
        return this.producers().toMap(Predef$.MODULE$.$conforms());
    }

    public boolean isEmpty() {
        return this.producers().isEmpty() && this.unreplicatedTxns().isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromSnapshot(long logStartOffset2, long currentTime) {
        Option<File> option;
        while ((option = this.latestSnapshotFile()) instanceof Some) {
            Some some = (Some)option;
            File file = (File)some.x();
            try {
                this.info((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading producer state from snapshot file '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
                Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(file).filter((Function1)new Serializable(this, currentTime){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;
                    private final long currentTime$2;

                    public final boolean apply(ProducerStateEntry producerEntry) {
                        return !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTime$2, producerEntry);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.currentTime$2 = currentTime$2;
                    }
                });
                loadedProducers.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProducerStateManager $outer;

                    public final void apply(ProducerStateEntry entry2) {
                        this.$outer.loadProducerEntry(entry2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                this.lastSnapOffset_$eq(Log$.MODULE$.offsetFromFile(file));
                this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(this.lastSnapOffset());
                return;
            }
            catch (CorruptSnapshotException corruptSnapshotException) {
                void var7_5;
                this.warn((Function0<String>)new Serializable(this, (File)var7_5, corruptSnapshotException){
                    public static final long serialVersionUID = 0L;
                    private final File file$1;
                    private final CorruptSnapshotException e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load producer snapshot from '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1, this.e$1.getMessage()}));
                    }
                    {
                        this.file$1 = file$1;
                        this.e$1 = e$1;
                    }
                });
                boolean bl = Files.deleteIfExists(var7_5.toPath());
            }
        }
        if (None$.MODULE$.equals(option)) {
            this.lastSnapOffset_$eq(logStartOffset2);
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset2);
            return;
        }
        throw new MatchError(option);
    }

    public void loadProducerEntry(ProducerStateEntry entry2) {
        long producerId = entry2.producerId();
        this.producers().put((Object)BoxesRunTime.boxToLong((long)producerId), (Object)entry2);
        entry2.currentTxnFirstOffset().foreach((Function1)new Serializable(this, producerId){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long producerId$2;

            public final TxnMetadata apply(long offset2) {
                return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)offset2), new TxnMetadata(this.producerId$2, offset2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerId$2 = producerId$2;
            }
        });
    }

    public boolean kafka$log$ProducerStateManager$$isProducerExpired(long currentTimeMs, ProducerStateEntry producerState) {
        return producerState.currentTxnFirstOffset().isEmpty() && currentTimeMs - producerState.lastTimestamp() >= (long)this.maxProducerIdExpirationMs();
    }

    public void removeExpiredProducers(long currentTimeMs) {
        this.producers().retain((Function2)new Serializable(this, currentTimeMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProducerStateManager $outer;
            private final long currentTimeMs$1;

            public final boolean apply(long x0$2, ProducerStateEntry x1$1) {
                Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)x0$2), (Object)x1$1);
                if (tuple2 != null) {
                    ProducerStateEntry lastEntry2 = (ProducerStateEntry)tuple2._2();
                    boolean bl = !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTimeMs$1, lastEntry2);
                    return bl;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.currentTimeMs$1 = currentTimeMs$1;
            }
        });
    }

    public void truncateAndReload(long logStartOffset2, long logEndOffset2, long currentTimeMs) {
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), (Function1<Object, Object>)new Serializable(this, logStartOffset2, logEndOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$1;
            private final long logEndOffset$1;

            public final boolean apply(long snapOffset) {
                return this.apply$mcZJ$sp(snapOffset);
            }

            public boolean apply$mcZJ$sp(long snapOffset) {
                return snapOffset > this.logEndOffset$1 || snapOffset <= this.logStartOffset$1;
            }
            {
                this.logStartOffset$1 = logStartOffset$1;
                this.logEndOffset$1 = logEndOffset$1;
            }
        });
        if (logEndOffset2 != this.mapEndOffset()) {
            this.producers().clear();
            this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
            this.unreplicatedTxns().clear();
            this.loadFromSnapshot(logStartOffset2, currentTimeMs);
        } else {
            this.truncateHead(logStartOffset2);
        }
    }

    public void reloadFromTieredSnapshot(long logStartOffset2, long currentTime, ByteBuffer snapshotBuffer, long snapshotOffset) {
        if (this.activeProducers().nonEmpty()) {
            throw new IllegalStateException("expected producer state to be fully truncated before reloading tiered snapshot");
        }
        try {
            Iterable loadedProducers = (Iterable)ProducerStateManager$.MODULE$.readSnapshot(snapshotBuffer).filter((Function1)new Serializable(this, currentTime){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;
                private final long currentTime$1;

                public final boolean apply(ProducerStateEntry producerEntry) {
                    return !this.$outer.kafka$log$ProducerStateManager$$isProducerExpired(this.currentTime$1, producerEntry);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.currentTime$1 = currentTime$1;
                }
            });
            this.info((Function0<String>)new Serializable(this, loadedProducers){
                public static final long serialVersionUID = 0L;
                private final Iterable loadedProducers$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"restored state for ", " producers from tiered storage"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.loadedProducers$1.size())}));
                }
                {
                    this.loadedProducers$1 = loadedProducers$1;
                }
            });
            loadedProducers.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;

                public final void apply(ProducerStateEntry entry2) {
                    this.$outer.loadProducerEntry(entry2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(snapshotOffset);
            return;
        }
        catch (CorruptSnapshotException corruptSnapshotException) {
            this.warn((Function0<String>)new Serializable(this, corruptSnapshotException){
                public static final long serialVersionUID = 0L;
                private final CorruptSnapshotException e$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to load producer snapshot from buffer: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2.getMessage()}));
                }
                {
                    this.e$2 = e$2;
                }
            });
            throw corruptSnapshotException;
        }
    }

    public ProducerAppendInfo prepareUpdate(long producerId, AppendOrigin origin) {
        ProducerStateEntry currentEntry = (ProducerStateEntry)this.lastEntry(producerId).getOrElse((Function0)new Serializable(this, producerId){
            public static final long serialVersionUID = 0L;
            private final long producerId$1;

            public final ProducerStateEntry apply() {
                return ProducerStateEntry$.MODULE$.empty(this.producerId$1);
            }
            {
                this.producerId$1 = producerId$1;
            }
        });
        return new ProducerAppendInfo(this.topicPartition(), producerId, currentEntry, origin);
    }

    public void update(ProducerAppendInfo appendInfo) {
        Option option;
        block6: {
            block5: {
                BoxedUnit boxedUnit;
                ProducerStateEntry updatedEntry;
                block4: {
                    if (appendInfo.producerId() == -1L) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid producer id ", " passed to update "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)appendInfo.producerId())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"for partition ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartition()}))).toString());
                    }
                    this.trace((Function0<String>)new Serializable(this, appendInfo){
                        public static final long serialVersionUID = 0L;
                        private final ProducerAppendInfo appendInfo$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated producer ", " state to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.appendInfo$1.producerId()), this.appendInfo$1}));
                        }
                        {
                            this.appendInfo$1 = appendInfo$1;
                        }
                    });
                    updatedEntry = appendInfo.toEntry();
                    option = this.producers().get((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()));
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    ProducerStateEntry currentEntry = (ProducerStateEntry)some.x();
                    currentEntry.update(updatedEntry);
                    boxedUnit = BoxedUnit.UNIT;
                    break block5;
                }
                if (!None$.MODULE$.equals(option)) break block6;
                boxedUnit = this.producers().put((Object)BoxesRunTime.boxToLong((long)appendInfo.producerId()), (Object)updatedEntry);
            }
            appendInfo.startedTransactions().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;

                public final TxnMetadata apply(TxnMetadata txn) {
                    return this.$outer.kafka$log$ProducerStateManager$$ongoingTxns().put(BoxesRunTime.boxToLong((long)txn.firstOffset().messageOffset()), txn);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new MatchError((Object)option);
    }

    public void updateMapEndOffset(long lastOffset) {
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(lastOffset);
    }

    public Option<ProducerStateEntry> lastEntry(long producerId) {
        return this.producers().get((Object)BoxesRunTime.boxToLong((long)producerId));
    }

    public void takeSnapshot() {
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() > this.lastSnapOffset()) {
            File snapshotFile = Log$.MODULE$.producerSnapshotFile(this.logDir(), this.kafka$log$ProducerStateManager$$lastMapOffset());
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProducerStateManager $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing producer snapshot at offset ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.kafka$log$ProducerStateManager$$lastMapOffset())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$writeSnapshot(snapshotFile, this.producers());
            this.lastSnapOffset_$eq(this.kafka$log$ProducerStateManager$$lastMapOffset());
        }
    }

    public Option<Object> latestSnapshotOffset() {
        return this.latestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        });
    }

    public Option<Object> oldestSnapshotOffset() {
        return this.oldestSnapshotFile().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        });
    }

    public void truncateHead(long logStartOffset2) {
        this.removeUnreplicatedTransactions(logStartOffset2);
        if (this.kafka$log$ProducerStateManager$$lastMapOffset() < logStartOffset2) {
            this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(logStartOffset2);
        }
        this.deleteSnapshotsBefore(logStartOffset2);
        this.lastSnapOffset_$eq(BoxesRunTime.unboxToLong((Object)this.latestSnapshotOffset().getOrElse((Function0)new Serializable(this, logStartOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$2;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.logStartOffset$2;
            }
            {
                this.logStartOffset$2 = logStartOffset$2;
            }
        })));
    }

    private void removeUnreplicatedTransactions(long offset2) {
        Iterator<Map.Entry<Object, TxnMetadata>> iterator2 = this.unreplicatedTxns().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<Object, TxnMetadata> txnEntry = iterator2.next();
            Option<Object> lastOffset = txnEntry.getValue().lastOffset();
            if (!lastOffset.exists((Function1)new Serializable(this, offset2){
                public static final long serialVersionUID = 0L;
                private final long offset$4;

                public final boolean apply(long x$7) {
                    return this.apply$mcZJ$sp(x$7);
                }

                public boolean apply$mcZJ$sp(long x$7) {
                    return x$7 < this.offset$4;
                }
                {
                    this.offset$4 = offset$4;
                }
            })) continue;
            iterator2.remove();
        }
    }

    public void truncate() {
        this.producers().clear();
        this.kafka$log$ProducerStateManager$$ongoingTxns().clear();
        this.unreplicatedTxns().clear();
        ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles(this.logDir(), ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2());
        this.lastSnapOffset_$eq(0L);
        this.kafka$log$ProducerStateManager$$lastMapOffset_$eq(0L);
    }

    public long lastStableOffset(CompletedTxn completedTxn) {
        Option nextIncompleteTxn = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.kafka$log$ProducerStateManager$$ongoingTxns().values()).asScala()).find((Function1)new Serializable(this, completedTxn){
            public static final long serialVersionUID = 0L;
            private final CompletedTxn completedTxn$1;

            public final boolean apply(TxnMetadata x$8) {
                return x$8.producerId() != this.completedTxn$1.producerId();
            }
            {
                this.completedTxn$1 = completedTxn$1;
            }
        });
        return BoxesRunTime.unboxToLong((Object)nextIncompleteTxn.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(TxnMetadata x$9) {
                return x$9.firstOffset().messageOffset();
            }
        }).getOrElse((Function0)new Serializable(this, completedTxn){
            public static final long serialVersionUID = 0L;
            private final CompletedTxn completedTxn$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.completedTxn$1.lastOffset() + 1L;
            }
            {
                this.completedTxn$1 = completedTxn$1;
            }
        }));
    }

    public void completeTxn(CompletedTxn completedTxn) {
        TxnMetadata txnMetadata = this.kafka$log$ProducerStateManager$$ongoingTxns().remove(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()));
        if (txnMetadata == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempted to complete transaction ", " on partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{completedTxn, this.topicPartition()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which was not started"})).s((Seq)Nil$.MODULE$)).toString());
        }
        txnMetadata.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)completedTxn.lastOffset())));
        this.unreplicatedTxns().put(BoxesRunTime.boxToLong((long)completedTxn.firstOffset()), txnMetadata);
    }

    public void deleteSnapshotsBefore(long offset2) {
        ProducerStateManager$.MODULE$.deleteSnapshotsBefore(this.logDir(), offset2);
    }

    private Option<File> oldestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.minBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    private Option<File> latestSnapshotFile() {
        Seq<File> files = this.listSnapshotFiles();
        return files.nonEmpty() ? new Some(files.maxBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(File file) {
                return Log$.MODULE$.offsetFromFile(file);
            }
        }, (Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
    }

    public Seq<File> listSnapshotFiles() {
        return ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir());
    }

    public Option<File> snapshotFileForOffset(long offset2) {
        return ProducerStateManager$.MODULE$.kafka$log$ProducerStateManager$$snapshotFileForOffset(this.logDir(), offset2);
    }

    public ProducerStateManager(TopicPartition topicPartition, File logDir, int maxProducerIdExpirationMs) {
        this.topicPartition = topicPartition;
        this.logDir = logDir;
        this.maxProducerIdExpirationMs = maxProducerIdExpirationMs;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[ProducerStateManager partition=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
        this.producers = Map$.MODULE$.empty();
        this.kafka$log$ProducerStateManager$$lastMapOffset = 0L;
        this.lastSnapOffset = 0L;
        this.kafka$log$ProducerStateManager$$ongoingTxns = new TreeMap();
        this.unreplicatedTxns = new TreeMap();
    }
}

