/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import kafka.log.AbstractLog;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class LogCleanerManager$
implements Logging {
    public static final LogCleanerManager$ MODULE$;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new LogCleanerManager$();
    }

    private Logger logger$lzycompute() {
        LogCleanerManager$ logCleanerManager$ = this;
        synchronized (logCleanerManager$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public boolean isCompactAndDelete(AbstractLog log) {
        return log.config().compact() && log.config().delete();
    }

    public long maxCompactionDelay(AbstractLog log, long firstDirtyOffset, long now) {
        Iterable<LogSegment> dirtyNonActiveSegments = log.localNonActiveLogSegmentsFrom(firstDirtyOffset);
        Iterable firstBatchTimestamps = (Iterable)log.getFirstBatchTimestampForSegments(dirtyNonActiveSegments).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(long x$5) {
                return this.apply$mcZJ$sp(x$5);
            }

            public boolean apply$mcZJ$sp(long x$5) {
                return x$5 > 0L;
            }
        });
        long earliestDirtySegmentTimestamp = firstBatchTimestamps.nonEmpty() ? BoxesRunTime.unboxToLong((Object)firstBatchTimestamps.min((Ordering)Ordering.Long$.MODULE$)) : Long.MAX_VALUE;
        long maxCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().maxCompactionLagMs()), 0L);
        long cleanUntilTime = now - maxCompactionLagMs;
        return earliestDirtySegmentTimestamp < cleanUntilTime ? cleanUntilTime - earliestDirtySegmentTimestamp : 0L;
    }

    public Tuple2<Object, Object> cleanableOffsets(AbstractLog log, Option<Object> lastCleanOffset, long now) {
        None$ none$;
        long l;
        long logStartOffset2 = log.logStartOffset();
        long checkpointDirtyOffset = BoxesRunTime.unboxToLong((Object)lastCleanOffset.getOrElse((Function0)new Serializable(logStartOffset2){
            public static final long serialVersionUID = 0L;
            private final long logStartOffset$1;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.logStartOffset$1;
            }
            {
                this.logStartOffset$1 = logStartOffset$1;
            }
        }));
        if (checkpointDirtyOffset < logStartOffset2) {
            if (!this.isCompactAndDelete(log)) {
                this.warn((Function0<String>)new Serializable(log, logStartOffset2, checkpointDirtyOffset){
                    public static final long serialVersionUID = 0L;
                    private final AbstractLog log$2;
                    private final long logStartOffset$1;
                    private final long checkpointDirtyOffset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resetting first dirty offset of ", " to log start offset ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), BoxesRunTime.boxToLong((long)this.logStartOffset$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"since the checkpointed offset ", " is invalid."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.checkpointDirtyOffset$1)}))).toString();
                    }
                    {
                        this.log$2 = log$2;
                        this.logStartOffset$1 = logStartOffset$1;
                        this.checkpointDirtyOffset$1 = checkpointDirtyOffset$1;
                    }
                });
            }
            l = logStartOffset2;
        } else if (checkpointDirtyOffset > log.logEndOffset()) {
            this.warn((Function0<String>)new Serializable(log, logStartOffset2, checkpointDirtyOffset){
                public static final long serialVersionUID = 0L;
                private final AbstractLog log$2;
                private final long logStartOffset$1;
                private final long checkpointDirtyOffset$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The last checkpoint dirty offset for partition ", " is ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), BoxesRunTime.boxToLong((long)this.checkpointDirtyOffset$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"which is larger than the log end offset ", ". Resetting to the log start offset ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.log$2.logEndOffset()), BoxesRunTime.boxToLong((long)this.logStartOffset$1)}))).toString();
                }
                {
                    this.log$2 = log$2;
                    this.logStartOffset$1 = logStartOffset$1;
                    this.checkpointDirtyOffset$1 = checkpointDirtyOffset$1;
                }
            });
            l = logStartOffset2;
        } else {
            l = checkpointDirtyOffset;
        }
        long firstDirtyOffset = l;
        long minCompactionLagMs = package$.MODULE$.max(Predef$.MODULE$.Long2long(log.config().compactionLagMs()), 0L);
        Option[] optionArray = new Option[3];
        optionArray[0] = log.firstUnstableOffset();
        optionArray[1] = Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)log.activeSegment().baseOffset()));
        if (minCompactionLagMs > 0L) {
            Iterable<LogSegment> dirtyNonActiveSegments = log.localNonActiveLogSegmentsFrom(firstDirtyOffset);
            none$ = dirtyNonActiveSegments.find((Function1)new Serializable(log, now, minCompactionLagMs){
                public static final long serialVersionUID = 0L;
                public final AbstractLog log$2;
                public final long now$2;
                public final long minCompactionLagMs$1;

                /*
                 * WARNING - void declaration
                 */
                public final boolean apply(LogSegment s) {
                    void var2_2;
                    boolean isUncleanable = s.largestTimestamp() > this.now$2 - this.minCompactionLagMs$1;
                    LogCleanerManager$.MODULE$.debug((Function0<String>)new Serializable(this, isUncleanable, s){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.19 $outer;
                        private final boolean isUncleanable$1;
                        private final LogSegment s$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking if log segment may be cleaned: log='", "' segment.baseOffset=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.log$2.name(), BoxesRunTime.boxToLong((long)this.s$1.baseOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"segment.largestTimestamp=", "; now - compactionLag=", "; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.s$1.largestTimestamp()), BoxesRunTime.boxToLong((long)(this.$outer.now$2 - this.$outer.minCompactionLagMs$1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is uncleanable=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)this.isUncleanable$1)}))).toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.isUncleanable$1 = isUncleanable$1;
                            this.s$1 = s$1;
                        }
                    });
                    return (boolean)var2_2;
                }
                {
                    this.log$2 = log$2;
                    this.now$2 = now$2;
                    this.minCompactionLagMs$1 = minCompactionLagMs$1;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$6) {
                    return x$6.baseOffset();
                }
            });
        } else {
            none$ = None$.MODULE$;
        }
        optionArray[2] = none$;
        long firstUncleanableDirtyOffset = BoxesRunTime.unboxToLong((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])optionArray)).flatten((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(Option<Object> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        })).min((Ordering)Ordering.Long$.MODULE$));
        this.debug((Function0<String>)new Serializable(log, lastCleanOffset, now, firstDirtyOffset, firstUncleanableDirtyOffset){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$2;
            private final Option lastCleanOffset$1;
            private final long now$2;
            private final long firstDirtyOffset$1;
            private final long firstUncleanableDirtyOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finding range of cleanable offsets for log=", ". Last clean offset=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), this.lastCleanOffset$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"now=", " => firstDirtyOffset=", " firstUncleanableOffset=", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.now$2), BoxesRunTime.boxToLong((long)this.firstDirtyOffset$1), BoxesRunTime.boxToLong((long)this.firstUncleanableDirtyOffset$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"activeSegment.baseOffset=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.log$2.activeSegment().baseOffset())}))).toString();
            }
            {
                this.log$2 = log$2;
                this.lastCleanOffset$1 = lastCleanOffset$1;
                this.now$2 = now$2;
                this.firstDirtyOffset$1 = firstDirtyOffset$1;
                this.firstUncleanableDirtyOffset$1 = firstUncleanableDirtyOffset$1;
            }
        });
        return new Tuple2.mcJJ.sp(firstDirtyOffset, package$.MODULE$.max(firstDirtyOffset, firstUncleanableDirtyOffset));
    }

    public Tuple2<Object, Object> calculateCleanableBytes(AbstractLog log, long firstDirtyOffset, long uncleanableOffset) {
        LogSegment firstUncleanableSegment = (LogSegment)log.localNonActiveLogSegmentsFrom(uncleanableOffset).headOption().getOrElse((Function0)new Serializable(log){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$1;

            public final LogSegment apply() {
                return this.log$1.activeSegment();
            }
            {
                this.log$1 = log$1;
            }
        });
        long firstUncleanableOffset = firstUncleanableSegment.baseOffset();
        long cleanableBytes = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.localLogSegments(package$.MODULE$.min(firstDirtyOffset, firstUncleanableOffset), firstUncleanableOffset).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$7) {
                return x$7.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return new Tuple2.mcJJ.sp(firstUncleanableOffset, cleanableBytes);
    }

    private LogCleanerManager$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

