/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.AbstractLog;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LogCleaner$;
import kafka.log.LogCleaner$CleanerThread$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleaningException;
import kafka.log.LogConfig;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.PreCleanStats;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.util.control.ControlThrowable;

@ScalaSignature(bytes="\u0006\u0001\rUa\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0015\u0001\u0001B\u0004\u000b\u001b!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u00059Q.\u001a;sS\u000e\u001c\u0018BA\r\u0017\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\taa]3sm\u0016\u0014\u0018BA\u0010\u001d\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0007j]&$\u0018.\u00197D_:4\u0017n\u001a\t\u0003G\u0011j\u0011AA\u0005\u0003K\t\u0011Qb\u00117fC:,'oQ8oM&<\u0007\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011\u0001\u0015\u0002\u000f1|w\rR5sgV\t\u0011\u0006E\u0002+[=j\u0011a\u000b\u0006\u0003Y)\t!bY8mY\u0016\u001cG/[8o\u0013\tq3FA\u0002TKF\u0004\"\u0001M\u001b\u000e\u0003ER!AM\u001a\u0002\u0005%|'\"\u0001\u001b\u0002\t)\fg/Y\u0005\u0003mE\u0012AAR5mK\"A\u0001\b\u0001B\u0001B\u0003%\u0011&\u0001\u0005m_\u001e$\u0015N]:!\u0011!Q\u0004A!b\u0001\n\u0003Y\u0014\u0001\u00027pON,\u0012\u0001\u0010\t\u0005\u001fuz$*\u0003\u0002?!\t!\u0001k\\8m!\t\u0001\u0005*D\u0001B\u0015\t\u00115)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u0011S!!\u0012$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0015aA8sO&\u0011\u0011*\u0011\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\t\u00193*\u0003\u0002M\u0005\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011!q\u0005A!A!\u0002\u0013a\u0014!\u00027pON\u0004\u0003\u0002\u0003)\u0001\u0005\u000b\u0007I\u0011A)\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\u0005\u0011\u0006CA\u000eT\u0013\t!FD\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0005\t-\u0002\u0011\t\u0011)A\u0005%\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0003\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\u0002\tQLW.\u001a\t\u00035rk\u0011a\u0017\u0006\u0003#\u0005K!!X.\u0003\tQKW.\u001a\u0005\u0006?\u0002!\t\u0001Y\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u0005\u00147\rZ3g!\t\u0019\u0003\u0001C\u0003\"=\u0002\u0007!\u0005C\u0003(=\u0002\u0007\u0011\u0006C\u0003;=\u0002\u0007A\bC\u0003Q=\u0002\u0007!\u000bC\u0004Y=B\u0005\t\u0019A-\t\u000f!\u0004\u0001\u0019!C\u0005S\u000611m\u001c8gS\u001e,\u0012A\t\u0005\bW\u0002\u0001\r\u0011\"\u0003m\u0003)\u0019wN\u001c4jO~#S-\u001d\u000b\u0003[B\u0004\"!\u00038\n\u0005=T!\u0001B+oSRDq!\u001d6\u0002\u0002\u0003\u0007!%A\u0002yIEBaa\u001d\u0001!B\u0013\u0011\u0013aB2p]\u001aLw\r\t\u0015\u0003eV\u0004\"!\u0003<\n\u0005]T!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0011e\u0004!\u0019!C\u0001\u0005i\fab\u00197fC:,'/T1oC\u001e,'/F\u0001|!\t\u0019C0\u0003\u0002~\u0005\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\t\r}\u0004\u0001\u0015!\u0003|\u0003=\u0019G.Z1oKJl\u0015M\\1hKJ\u0004\u0003\"CA\u0002\u0001\t\u0007I\u0011BA\u0003\u0003%!\bN]8ui2,'/\u0006\u0002\u0002\bA\u0019q\"!\u0003\n\u0007\u0005-\u0001CA\u0005UQJ|G\u000f\u001e7fe\"A\u0011q\u0002\u0001!\u0002\u0013\t9!\u0001\u0006uQJ|G\u000f\u001e7fe\u0002B!\"a\u0005\u0001\u0005\u0004%\tAAA\u000b\u0003!\u0019G.Z1oKJ\u001cXCAA\f!\u0019\tI\"a\b\u0002$5\u0011\u00111\u0004\u0006\u0004\u0003;Y\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0003C\tYBA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0003BA\u0013\u0003Oi\u0011\u0001\u0001\u0004\b\u0003S\u0001\u0001AAA\u0016\u00055\u0019E.Z1oKJ$\u0006N]3bIN!\u0011qEA\u0017!\ry\u0011qF\u0005\u0004\u0003c\u0001\"AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012D1\"!\u000e\u0002(\t\u0005\t\u0015!\u0003\u00028\u0005AA\u000f\u001b:fC\u0012LE\rE\u0002\n\u0003sI1!a\u000f\u000b\u0005\rIe\u000e\u001e\u0005\b?\u0006\u001dB\u0011AA )\u0011\t\u0019#!\u0011\t\u0011\u0005U\u0012Q\ba\u0001\u0003oA\u0001\"!\u0012\u0002(\u0011E\u0013qI\u0001\u000bY><w-\u001a:OC6,WCAA%!\u0011\tY%!\u0015\u000e\u0005\u00055#bAA(g\u0005!A.\u00198h\u0013\u0011\t\u0019&!\u0014\u0003\rM#(/\u001b8h\u0011)\t9&a\nC\u0002\u0013\u0005\u0011\u0011L\u0001\bG2,\u0017M\\3s+\t\tY\u0006E\u0002$\u0003;J1!a\u0018\u0003\u0005\u001d\u0019E.Z1oKJD\u0011\"a\u0019\u0002(\u0001\u0006I!a\u0017\u0002\u0011\rdW-\u00198fe\u0002B!\"a\u001a\u0002(\u0001\u0007I\u0011AA5\u0003%a\u0017m\u001d;Ti\u0006$8/\u0006\u0002\u0002lA\u00191%!\u001c\n\u0007\u0005=$A\u0001\u0007DY\u0016\fg.\u001a:Ti\u0006$8\u000f\u0003\u0006\u0002t\u0005\u001d\u0002\u0019!C\u0001\u0003k\nQ\u0002\\1tiN#\u0018\r^:`I\u0015\fHcA7\u0002x!I\u0011/!\u001d\u0002\u0002\u0003\u0007\u00111\u000e\u0005\n\u0003w\n9\u0003)Q\u0005\u0003W\n!\u0002\\1tiN#\u0018\r^:!Q\r\tI(\u001e\u0005\u000b\u0003\u0003\u000b9\u00031A\u0005\u0002\u0005\r\u0015!\u00057bgR\u0004&/Z\"mK\u0006t7\u000b^1ugV\u0011\u0011Q\u0011\t\u0004G\u0005\u001d\u0015bAAE\u0005\ti\u0001K]3DY\u0016\fgn\u0015;biND!\"!$\u0002(\u0001\u0007I\u0011AAH\u0003Ua\u0017m\u001d;Qe\u0016\u001cE.Z1o'R\fGo]0%KF$2!\\AI\u0011%\t\u00181RA\u0001\u0002\u0004\t)\tC\u0005\u0002\u0016\u0006\u001d\u0002\u0015)\u0003\u0002\u0006\u0006\u0011B.Y:u!J,7\t\\3b]N#\u0018\r^:!Q\r\t\u0019*\u001e\u0005\t\u00037\u000b9\u0003\"\u0003\u0002\u001e\u0006I1\r[3dW\u0012{g.\u001a\u000b\u0004[\u0006}\u0005bBAQ\u00033\u0003\raP\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o\u0011!\t)+a\n\u0005B\u0005\u001d\u0016A\u00023p/>\u00148\u000eF\u0001n\u0011!\tY+a\n\u0005\n\u00055\u0016\u0001\u0006;ss\u000ecW-\u00198GS2$\b.[3ti2{w\r\u0006\u0002\u00020B\u0019\u0011\"!-\n\u0007\u0005M&BA\u0004C_>dW-\u00198\t\u0011\u0005]\u0016q\u0005C\u0005\u0003[\u000b\u0011c\u00197fC:4\u0015\u000e\u001c;iS\u0016\u001cH\u000fT8hQ\u0019\t),a/\u0002HB)\u0011\"!0\u0002B&\u0019\u0011q\u0018\u0006\u0003\rQD'o\\<t!\r\u0019\u00131Y\u0005\u0004\u0003\u000b\u0014!\u0001\u0006'pO\u000ecW-\u00198j]\u001e,\u0005pY3qi&|gn\t\u0002\u0002B\"A\u00111ZA\u0014\t\u0013\ti-\u0001\u0005dY\u0016\fg\u000eT8h)\ri\u0017q\u001a\u0005\t\u0003#\fI\r1\u0001\u0002T\u0006I1\r\\3b]\u0006\u0014G.\u001a\t\u0004G\u0005U\u0017bAAl\u0005\tQAj\\4U_\u000ecW-\u00198\t\u0011\u0005m\u0017q\u0005C\u0001\u0003;\f1B]3d_J$7\u000b^1ugRYQ.a8\u0002d\u0006M\u0018Q B\u0001\u0011!\t\t/!7A\u0002\u0005]\u0012AA5e\u0011!\t)/!7A\u0002\u0005\u001d\u0018\u0001\u00028b[\u0016\u0004B!!;\u0002p:\u0019\u0011\"a;\n\u0007\u00055(\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\n\tPC\u0002\u0002n*A\u0001\"!>\u0002Z\u0002\u0007\u0011q_\u0001\u0005MJ|W\u000eE\u0002\n\u0003sL1!a?\u000b\u0005\u0011auN\\4\t\u0011\u0005}\u0018\u0011\u001ca\u0001\u0003o\f!\u0001^8\t\u0011\t\r\u0011\u0011\u001ca\u0001\u0003W\nQa\u001d;biND\u0001Ba\u0002\u0001A\u0003%\u0011qC\u0001\nG2,\u0017M\\3sg\u0002B\u0001Ba\u0003\u0001\t\u0003\u0011!QB\u0001\u0010I\u0016\fG\r\u00165sK\u0006$7i\\;oiV\u0011\u0011q\u0007\u0005\b\u0005#\u0001A\u0011AAT\u0003\u001d\u0019H/\u0019:ukBDqA!\u0006\u0001\t\u0003\t9+\u0001\u0005tQV$Hm\\<o\u0011\u001d\u0011I\u0002\u0001C!\u00057\tQC]3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0006\u0002\u0003\u001eA)!Fa\b\u0002h&\u0019!\u0011E\u0016\u0003\u0007M+G\u000fC\u0004\u0003&\u0001!\tEa\n\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tGcA7\u0003*!A!1\u0006B\u0012\u0001\u0004\u0011i#A\u0005oK^\u001cuN\u001c4jOB\u00191Da\f\n\u0007\tEBDA\u0006LC\u001a\\\u0017mQ8oM&<\u0007b\u0002B\u001b\u0001\u0011\u0005#qG\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\rF\u0003n\u0005s\u0011i\u0004\u0003\u0005\u0003<\tM\u0002\u0019\u0001B\u0017\u0003%yG\u000eZ\"p]\u001aLw\r\u0003\u0005\u0003,\tM\u0002\u0019\u0001B\u0017\u0011\u001d\u0011\t\u0005\u0001C\u0001\u0005\u0007\nQ\"\u00192peR\u001cE.Z1oS:<GcA7\u0003F!9\u0011\u0011\u0015B \u0001\u0004y\u0004b\u0002B%\u0001\u0011\u0005!1J\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cHcA7\u0003N!9!q\nB$\u0001\u0004y\u0013a\u00023bi\u0006$\u0015N\u001d\u0005\b\u0005'\u0002A\u0011\u0001B+\u0003I\tG\u000e^3s\u0007\",7m\u001b9pS:$H)\u001b:\u0015\u000f5\u00149F!\u0017\u0003^!9\u0011\u0011\u0015B)\u0001\u0004y\u0004b\u0002B.\u0005#\u0002\raL\u0001\rg>,(oY3M_\u001e$\u0015N\u001d\u0005\b\u0005?\u0012\t\u00061\u00010\u0003)!Wm\u001d;M_\u001e$\u0015N\u001d\u0005\b\u0005G\u0002A\u0011\u0001B3\u0003MA\u0017M\u001c3mK2{w\rR5s\r\u0006LG.\u001e:f)\ri'q\r\u0005\t\u0005S\u0012\t\u00071\u0001\u0002h\u0006\u0019A-\u001b:\t\u000f\t5\u0004\u0001\"\u0001\u0003p\u00059R.Y=cKR\u0013XO\\2bi\u0016\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\b[\nE$1\u000fB;\u0011\u001d\u0011yEa\u001bA\u0002=Bq!!)\u0003l\u0001\u0007q\b\u0003\u0005\u0003x\t-\u0004\u0019AA|\u0003\u0019ygMZ:fi\"9!1\u0010\u0001\u0005\u0002\tu\u0014!F1c_J$\u0018I\u001c3QCV\u001cXm\u00117fC:Lgn\u001a\u000b\u0004[\n}\u0004bBAQ\u0005s\u0002\ra\u0010\u0005\b\u0005\u0007\u0003A\u0011\u0001BC\u00039\u0011Xm];nK\u000ecW-\u00198j]\u001e$2!\u001cBD\u0011!\u0011II!!A\u0002\t-\u0015a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\\:\u0011\t)\u0012iiP\u0005\u0004\u0005\u001f[#\u0001C%uKJ\f'\r\\3\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\u0006a\u0011m^1ji\u000ecW-\u00198fIRA\u0011q\u0016BL\u00053\u0013Y\nC\u0004\u0002\"\nE\u0005\u0019A \t\u0011\t]$\u0011\u0013a\u0001\u0003oD!B!(\u0003\u0012B\u0005\t\u0019AA|\u0003%i\u0017\r_,bSRl5\u000fC\u0004\u0003\"\u0002!\tAa)\u0002MA\fWo]3DY\u0016\fg.\u001b8h\r>\u0014hj\u001c8D_6\u0004\u0018m\u0019;fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0002\u0003&B)!F!$\u0003(B)\u0011B!+@\u0015&\u0019!1\u0016\u0006\u0003\rQ+\b\u000f\\33\u0011\u001d\u0011y\u000b\u0001C\u0001\t%\fQbY;se\u0016tGoQ8oM&<\u0007\u0002\u0003BZ\u0001\u0011\u0005!A!\u0004\u0002\u0019\rdW-\u00198fe\u000e{WO\u001c;\t\u0013\t]\u0006!%A\u0005\u0002\te\u0016AF1xC&$8\t\\3b]\u0016$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tm&\u0006BA|\u0005{[#Aa0\u0011\t\t\u0005'1Z\u0007\u0003\u0005\u0007TAA!2\u0003H\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u0013T\u0011AC1o]>$\u0018\r^5p]&!!Q\u001aBb\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0004\b\u0005#\u0014\u0001\u0012\u0001Bj\u0003)aunZ\"mK\u0006tWM\u001d\t\u0004G\tUgAB\u0001\u0003\u0011\u0003\u00119nE\u0002\u0003V\"Aqa\u0018Bk\t\u0003\u0011Y\u000e\u0006\u0002\u0003T\"Q!q\u001cBk\u0005\u0004%\tA!9\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\u0011!1\u001d\t\u0006U\t}\u0011\u0011\n\u0005\n\u0005O\u0014)\u000e)A\u0005\u0005G\faCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7\u000f\t\u0005\t\u0005W\u0014)\u000e\"\u0001\u0003n\u0006i1\r\\3b]\u0016\u00148i\u001c8gS\u001e$2A\tBx\u0011\u001dA'\u0011\u001ea\u0001\u0005[A\u0001Ba=\u0003V\u0012\u0005!Q_\u0001\u0018GJ,\u0017\r^3OK^\u001cE.Z1oK\u0012\u001cVmZ7f]R$\u0002Ba>\u0003~\n}8\u0011\u0002\t\u0004G\te\u0018b\u0001B~\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\t%$\u0011\u001fa\u0001_!A1\u0011\u0001By\u0001\u0004\u0019\u0019!A\u0005m_\u001e\u001cuN\u001c4jOB\u00191e!\u0002\n\u0007\r\u001d!AA\u0005M_\u001e\u001cuN\u001c4jO\"A11\u0002By\u0001\u0004\t90\u0001\u0006cCN,wJ\u001a4tKRD!ba\u0004\u0003VF\u0005I\u0011AB\t\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u001111\u0003\u0016\u00043\nu\u0006")
public class LogCleaner
implements KafkaMetricsGroup,
BrokerReconfigurable {
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, AbstractLog> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private volatile CleanerConfig kafka$log$LogCleaner$$config;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final ArrayBuffer<CleanerThread> cleaners;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    public static LogSegment createNewCleanedSegment(File file, LogConfig logConfig, long l) {
        return LogCleaner$.MODULE$.createNewCleanedSegment(file, logConfig, l);
    }

    public static CleanerConfig cleanerConfig(KafkaConfig kafkaConfig) {
        return LogCleaner$.MODULE$.cleanerConfig(kafkaConfig);
    }

    public static Set<String> ReconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, AbstractLog> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public CleanerConfig kafka$log$LogCleaner$$config() {
        return this.kafka$log$LogCleaner$$config;
    }

    private void kafka$log$LogCleaner$$config_$eq(CleanerConfig x$1) {
        this.kafka$log$LogCleaner$$config = x$1;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public ArrayBuffer<CleanerThread> cleaners() {
        return this.cleaners;
    }

    public int deadThreadCount() {
        return this.cleaners().count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CleanerThread x$10) {
                return x$10.isThreadFailed();
            }
        });
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.kafka$log$LogCleaner$$config().numThreads()).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleaner $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                CleanerThread cleaner = this.$outer.new CleanerThread(i);
                this.$outer.cleaners().$plus$eq((Object)cleaner);
                cleaner.start();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$11) {
                x$11.shutdown();
            }
        });
        this.cleaners().clear();
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return LogCleaner$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        CleanerConfig newCleanerConfig = LogCleaner$.MODULE$.cleanerConfig(newConfig);
        int numThreads = newCleanerConfig.numThreads();
        int currentThreads = this.kafka$log$LogCleaner$$config().numThreads();
        if (numThreads < 1) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads should be at least 1"})).s((Seq)Nil$.MODULE$));
        }
        if (numThreads < currentThreads / 2) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads cannot be reduced to less than half the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentThreads)})));
        }
        if (numThreads > currentThreads * 2) {
            throw new ConfigException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleaner threads cannot be increased to more than double the current value ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)currentThreads)})));
        }
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        this.kafka$log$LogCleaner$$config_$eq(LogCleaner$.MODULE$.cleanerConfig(newConfig));
        this.shutdown();
        this.startup();
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void alterCheckpointDir(TopicPartition topicPartition, File sourceLogDir, File destLogDir) {
        this.cleanerManager().alterCheckpointDir(topicPartition, sourceLogDir, destLogDir);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset2) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset2);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(Iterable<TopicPartition> topicPartitions2) {
        this.cleanerManager().resumeCleaning(topicPartitions2);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset2, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset2) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset2);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    public Iterable<Tuple2<TopicPartition, AbstractLog>> pauseCleaningForNonCompactedPartitions() {
        return this.cleanerManager().pauseCleaningForNonCompactedPartitions();
    }

    public CleanerConfig currentConfig() {
        return this.kafka$log$LogCleaner$$config();
    }

    public int cleanerCount() {
        return this.cleaners().size();
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(this, offset$1){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(long x$12) {
                return this.apply$mcZJ$sp(x$12);
            }

            public boolean apply$mcZJ$sp(long x$12) {
                return x$12 >= this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        }));
    }

    public LogCleaner(CleanerConfig initialConfig, Seq<File> logDirs, Pool<TopicPartition, AbstractLog> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$log$LogCleaner$$config = initialConfig;
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(this.kafka$log$LogCleaner$$config().maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.cleaners = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$1) {
                        return x$1.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$2) {
                        return (double)100 * x$2.bufferUtilization();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                ArrayBuffer stats = (ArrayBuffer)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$3) {
                        return x$3.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$4) {
                        return x$4.bytesWritten();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$5) {
                        return x$5.bytesRead();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$6) {
                        return x$6.lastStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$7) {
                        return x$7.elapsedSecs();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-compaction-delay-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return Math.max(0, (int)(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)this.$outer.cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final PreCleanStats apply(CleanerThread x$8) {
                        return x$8.lastPreCleanStats();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(PreCleanStats x$9) {
                        return x$9.maxCompactionDelayMs();
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) / 1000L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("DeadThreadCount", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return this.$outer.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private volatile PreCleanStats lastPreCleanStats;

        @Override
        public String loggerName() {
            return LogCleaner.class.getName();
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        public PreCleanStats lastPreCleanStats() {
            return this.lastPreCleanStats;
        }

        public void lastPreCleanStats_$eq(PreCleanStats x$1) {
            this.lastPreCleanStats = x$1;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicPartition topicPartition) {
            if (this.isRunning()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            boolean cleaned = this.tryCleanFilthiestLog();
            if (!cleaned) {
                this.pause(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().backOffMs(), TimeUnit.MILLISECONDS);
            }
        }

        private boolean tryCleanFilthiestLog() {
            boolean bl;
            try {
                bl = this.cleanFilthiestLog();
            }
            catch (LogCleaningException logCleaningException) {
                this.warn((Function0<String>)new Serializable(this, logCleaningException){
                    public static final long serialVersionUID = 0L;
                    private final LogCleaningException e$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected exception thrown when cleaning log ", ". Marking its partition (", ") as uncleanable"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.log(), this.e$1.log().topicPartition()}));
                    }
                    {
                        this.e$1 = e$1;
                    }
                }, (Function0<Throwable>)new Serializable(this, logCleaningException){
                    public static final long serialVersionUID = 0L;
                    private final LogCleaningException e$1;

                    public final LogCleaningException apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().markPartitionUncleanable(logCleaningException.log().dir().getParent(), logCleaningException.log().topicPartition());
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private boolean cleanFilthiestLog() throws LogCleaningException {
            Option<LogToClean> option;
            block11: {
                boolean bl;
                block10: {
                    PreCleanStats preCleanStats;
                    block9: {
                        preCleanStats = new PreCleanStats();
                        option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time, preCleanStats);
                        if (!None$.MODULE$.equals(option)) break block9;
                        bl = false;
                        break block10;
                    }
                    if (!(option instanceof Some)) break block11;
                    Some some = (Some)option;
                    LogToClean cleanable = (LogToClean)some.x();
                    this.lastPreCleanStats_$eq(preCleanStats);
                    try {
                        this.cleanLog(cleanable);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        boolean bl2 = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                        if (bl2) {
                            throw throwable2;
                        }
                        if (throwable2 instanceof Exception) {
                            Exception exception = (Exception)throwable2;
                            throw new LogCleaningException(cleanable.log(), exception.getMessage(), exception);
                        }
                        throw throwable;
                    }
                }
                boolean cleaned = bl;
                Iterable<Tuple2<TopicPartition, AbstractLog>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
                try {
                    void var2_6;
                    this.maybeDeleteOldSegments$1(deletable);
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)deletable.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicPartition apply(Tuple2<TopicPartition, AbstractLog> x$13) {
                            return (TopicPartition)x$13._1();
                        }
                    }, Iterable$.MODULE$.canBuildFrom())));
                    return (boolean)var2_6;
                }
                catch (Throwable throwable) {
                    void var12_7;
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting((Iterable<TopicPartition>)((Iterable)var12_7.map((Function1)new /* invalid duplicate definition of identical inner class */, Iterable$.MODULE$.canBuildFrom())));
                    throw throwable;
                }
            }
            throw new MatchError(option);
        }

        private void cleanLog(LogToClean cleanable) {
            block8: {
                long endOffset = cleanable.firstDirtyOffset();
                try {
                    try {
                        Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                        if (tuple2 != null) {
                            Tuple2 tuple22;
                            long nextDirtyOffset = tuple2._1$mcJ$sp();
                            CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                            long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                            CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                            this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                            endOffset = nextDirtyOffset2;
                            break block8;
                        }
                        throw new MatchError(tuple2);
                    }
                    catch (IOException iOException) {
                        String logDirectory = cleanable.log().dir().getParent();
                        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to clean up log for ", " in dir ", " due to IOException"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.topicPartition(), logDirectory}));
                        this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(logDirectory, (Function0<String>)new Serializable(this, msg){
                            public static final long serialVersionUID = 0L;
                            private final String msg$1;

                            public final String apply() {
                                return this.msg$1;
                            }
                            {
                                this.msg$1 = msg$1;
                            }
                        }, iOException);
                    }
                    catch (KafkaStorageException kafkaStorageException) {
                    }
                    catch (LogCleaningAbortedException logCleaningAbortedException) {}
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                }
            }
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            if (this.lastPreCleanStats().delayedPartitions() > 0) {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ CleanerThread $outer;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tCleanable partitions: %d, Delayed partitions: %d, max delay: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.lastPreCleanStats().cleanablePartitions()), BoxesRunTime.boxToInteger((int)this.$outer.lastPreCleanStats().delayedPartitions()), BoxesRunTime.boxToLong((long)this.$outer.lastPreCleanStats().maxCompactionDelayMs())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)new Serializable(this, stats){
                    public static final long serialVersionUID = 0L;
                    private final CleanerStats stats$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.stats$1.invalidMessagesRead())}));
                    }
                    {
                        this.stats$1 = stats$1;
                    }
                });
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final void maybeDeleteOldSegments$1(Iterable deletableLogs2) {
            NonLocalReturnControl nonLocalReturnControl2;
            block2: {
                Object object = new Object();
                try {
                    IntRef total = IntRef.create((int)0);
                    deletableLogs2.foreach((Function1)new Serializable(this, total, object){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CleanerThread $outer;
                        public final IntRef total$1;
                        private final Object nonLocalReturnKey1$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final void apply(Tuple2<TopicPartition, AbstractLog> x0$1) {
                            Tuple2<TopicPartition, AbstractLog> tuple2 = x0$1;
                            if (tuple2 == null) throw new MatchError(tuple2);
                            AbstractLog log = (AbstractLog)tuple2._2();
                            if (this.total$1.elem >= this.$outer.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()) {
                                this.$outer.debug((Function0<String>)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ CleanerThread$$anonfun$maybeDeleteOldSegments$1$1 $outer;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log cleanup reached the limit of maximum segments that can be deleted limit "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ", ", " files deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleaner$CleanerThread$$anonfun$$$outer().kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun()), BoxesRunTime.boxToInteger((int)this.$outer.total$1.elem)}))).toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                                throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                            }
                            this.$outer.debug((Function0<String>)new Serializable(this, log){
                                public static final long serialVersionUID = 0L;
                                private final AbstractLog log$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Garbage collecting '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$1.name()}));
                                }
                                {
                                    this.log$1 = log$1;
                                }
                            });
                            try {
                                int limit = this.$outer.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$config().logDeletionMaxSegmentsPerRun() - this.total$1.elem;
                                this.total$1.elem += log.deleteOldSegments(limit);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                boolean bl = throwable2 instanceof ThreadShutdownException ? true : throwable2 instanceof ControlThrowable;
                                if (bl) {
                                    throw throwable2;
                                }
                                if (!(throwable2 instanceof Exception)) throw throwable;
                                Exception exception = (Exception)throwable2;
                                throw new LogCleaningException(log, exception.getMessage(), exception);
                            }
                        }

                        public /* synthetic */ CleanerThread kafka$log$LogCleaner$CleanerThread$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.total$1 = total$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                catch (NonLocalReturnControl nonLocalReturnControl2) {
                    if (nonLocalReturnControl2.key() != object) break block2;
                    nonLocalReturnControl2.value$mcV$sp();
                }
                return;
            }
            throw nonLocalReturnControl2;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-log-cleaner-thread-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)threadId)})), false);
            if (LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferSize() / (long)LogCleaner.this.kafka$log$LogCleaner$$config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.kafka$log$LogCleaner$$config().hashAlgorithm()), LogCleaner.this.kafka$log$LogCleaner$$config().ioBufferSize() / LogCleaner.this.kafka$log$LogCleaner$$config().numThreads() / 2, LogCleaner.this.kafka$log$LogCleaner$$config().maxMessageSize(), LogCleaner.this.kafka$log$LogCleaner$$config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CleanerThread $outer;

                public final void apply(TopicPartition topicPartition) {
                    this.$outer.kafka$log$LogCleaner$CleanerThread$$checkDone(topicPartition);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.lastPreCleanStats = new PreCleanStats();
        }
    }
}

