/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.LogSegmentOffsetOverflowException;
import kafka.log.AbortedTxn;
import kafka.log.AbstractLog;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner$;
import kafka.log.Cleaner$$anonfun$kafka$log$Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.LastRecord;
import kafka.log.LogCleaner;
import kafka.log.LogCleaner$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.log.TransactionIndex;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.BufferSupplier;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\tud!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005\"\u0002.\u0001\t#Z\u0016A\u00037pO\u001e,'OT1nKV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\rM#(/\u001b8h\u0011\u001d)\u0007\u00011A\u0005\n\u0019\f!B]3bI\n+hMZ3s+\u00059\u0007C\u00015l\u001b\u0005I'B\u00016a\u0003\rq\u0017n\\\u0005\u0003Y&\u0014!BQ=uK\n+hMZ3s\u0011\u001dq\u0007\u00011A\u0005\n=\faB]3bI\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002Ka\"9\u0011/\\A\u0001\u0002\u00049\u0017a\u0001=%c!11\u000f\u0001Q!\n\u001d\f1B]3bI\n+hMZ3sA!9Q\u000f\u0001a\u0001\n\u00131\u0017aC<sSR,')\u001e4gKJDqa\u001e\u0001A\u0002\u0013%\u00010A\bxe&$XMQ;gM\u0016\u0014x\fJ3r)\tQ\u0015\u0010C\u0004rm\u0006\u0005\t\u0019A4\t\rm\u0004\u0001\u0015)\u0003h\u000319(/\u001b;f\u0005V4g-\u001a:!\u0011\u001di\bA1A\u0005\ny\f1\u0004Z3d_6\u0004(/Z:tS>t')\u001e4gKJ\u001cV\u000f\u001d9mS\u0016\u0014X#A@\u0011\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u00029\u0003\u0019\u0011XmY8sI&!\u0011\u0011BA\u0002\u00059\u0011UO\u001a4feN+\b\u000f\u001d7jKJDq!!\u0004\u0001A\u0003%q0\u0001\u000feK\u000e|W\u000e\u001d:fgNLwN\u001c\"vM\u001a,'oU;qa2LWM\u001d\u0011\t\u0011\u0005E\u0001\u0001\"\u0001\u0003\u0003'\tQa\u00197fC:$B!!\u0006\u0002(A9\u0001\"a\u0006\u0002\u001c\u0005\u0005\u0012bAA\r\u0013\t1A+\u001e9mKJ\u00022\u0001CA\u000f\u0013\r\ty\"\u0003\u0002\u0005\u0019>tw\rE\u0002!\u0003GI1!!\n\u0003\u00051\u0019E.Z1oKJ\u001cF/\u0019;t\u0011!\tI#a\u0004A\u0002\u0005-\u0012!C2mK\u0006t\u0017M\u00197f!\r\u0001\u0013QF\u0005\u0004\u0003_\u0011!A\u0003'pOR{7\t\\3b]\"A\u00111\u0007\u0001\u0005\u0002\t\t)$A\u0004e_\u000ecW-\u00198\u0015\r\u0005U\u0011qGA\u001d\u0011!\tI#!\rA\u0002\u0005-\u0002\u0002CA\u001e\u0003c\u0001\r!a\u0007\u0002\u001f\u0011,G.\u001a;f\u0011>\u0014\u0018N_8o\u001bND\u0001\"a\u0010\u0001\t\u0003\u0011\u0011\u0011I\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015\u001b)\u000b\u0019%a\u0013\u0002b\u0005\u0015\u0014qMA6\u0011\u001d\u0019\u0011Q\ba\u0001\u0003\u000b\u00022\u0001IA$\u0013\r\tIE\u0001\u0002\f\u0003\n\u001cHO]1di2{w\r\u0003\u0005\u0002N\u0005u\u0002\u0019AA(\u0003!\u0019XmZ7f]R\u001c\bCBA)\u0003/\nY&\u0004\u0002\u0002T)\u0019\u0011QK\u0005\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002Z\u0005M#aA*fcB\u0019\u0001%!\u0018\n\u0007\u0005}#A\u0001\u0006M_\u001e\u001cVmZ7f]RDq!a\u0019\u0002>\u0001\u0007q$A\u0002nCBD\u0001\"a\u000f\u0002>\u0001\u0007\u00111\u0004\u0005\t\u0003S\ni\u00041\u0001\u0002\"\u0005)1\u000f^1ug\"A\u0011QNA\u001f\u0001\u0004\ty'A\nue\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rE\u0002!\u0003cJ1!a\u001d\u0003\u0005i\u0019E.Z1oK\u0012$&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b\u0011!\t9\b\u0001C\u0001\u0005\u0005e\u0014!C2mK\u0006t\u0017J\u001c;p)MQ\u00151PA@\u0003\u0013\u000bi)a$\u0002\u001a\u0006u\u0015qTA\\\u0011\u001d\ti(!\u001eA\u0002\u0019\u000ba\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002\u0002\u0006U\u0004\u0019AAB\u00035\u0019x.\u001e:dKJ+7m\u001c:egB!\u0011\u0011AAC\u0013\u0011\t9)a\u0001\u0003\u0017\u0019KG.\u001a*fG>\u0014Hm\u001d\u0005\t\u0003\u0017\u000b)\b1\u0001\u0002\\\u0005!A-Z:u\u0011\u001d\t\u0019'!\u001eA\u0002}A\u0001\"!%\u0002v\u0001\u0007\u00111S\u0001\u001be\u0016$\u0018-\u001b8EK2,G/Z:B]\u0012$\u0006P\\'be.,'o\u001d\t\u0004\u0011\u0005U\u0015bAAL\u0013\t9!i\\8mK\u0006t\u0007bBAN\u0003k\u0002\raF\u0001\u0012[\u0006DHj\\4NKN\u001c\u0018mZ3TSj,\u0007\u0002CA7\u0003k\u0002\r!a\u001c\t\u0011\u0005\u0005\u0016Q\u000fa\u0001\u0003G\u000bA\u0004\\1tiJ+7m\u001c:eg>3\u0017i\u0019;jm\u0016\u0004&o\u001c3vG\u0016\u00148\u000f\u0005\u0005\u0002&\u0006-\u00161DAY\u001d\rA\u0011qU\u0005\u0004\u0003SK\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002.\u0006=&aA'ba*\u0019\u0011\u0011V\u0005\u0011\u0007\u0001\n\u0019,C\u0002\u00026\n\u0011!\u0002T1tiJ+7m\u001c:e\u0011!\tI'!\u001eA\u0002\u0005\u0005\u0002bBA^\u0001\u0011%\u0011QX\u0001\u0012OJ|wOQ;gM\u0016\u00148o\u0014:GC&dG#\u0003&\u0002@\u0006\u0005\u0017QYAd\u0011!\t\t)!/A\u0002\u0005\r\u0005bBAb\u0003s\u0003\raF\u0001\ta>\u001c\u0018\u000e^5p]\"9\u00111TA]\u0001\u00049\u0002\u0002CAe\u0003s\u0003\r!a3\u0002\u001b5,Wn\u001c:z%\u0016\u001cwN\u001d3t!\u0011\t\t!!4\n\t\u0005=\u00171\u0001\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\u0006\u00112\u000f[8vY\u0012$\u0015n]2be\u0012\u0014\u0015\r^2i)!\t\u0019*a6\u0002b\u0006\r\b\u0002CAm\u0003#\u0004\r!a7\u0002\u000b\t\fGo\u00195\u0011\t\u0005\u0005\u0011Q\\\u0005\u0005\u0003?\f\u0019AA\u0006SK\u000e|'\u000f\u001a\"bi\u000eD\u0007\u0002CA7\u0003#\u0004\r!a\u001c\t\u0011\u0005\u0015\u0018\u0011\u001ba\u0001\u0003'\u000b\u0001C]3uC&tG\u000b\u001f8NCJ\\WM]:\t\u000f\u0005%\b\u0001\"\u0003\u0002l\u0006\u00112\u000f[8vY\u0012\u0014V\r^1j]J+7m\u001c:e)1\t\u0019*!<\u0002p\u0006M\u0018Q_A\u007f\u0011\u001d\t\u0019'a:A\u0002}A\u0001\"!=\u0002h\u0002\u0007\u00111S\u0001\u000ee\u0016$\u0018-\u001b8EK2,G/Z:\t\u0011\u0005e\u0017q\u001da\u0001\u00037D\u0001\"!\u0002\u0002h\u0002\u0007\u0011q\u001f\t\u0005\u0003\u0003\tI0\u0003\u0003\u0002|\u0006\r!A\u0002*fG>\u0014H\r\u0003\u0005\u0002j\u0005\u001d\b\u0019AA\u0011\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007\t1b\u001a:po\n+hMZ3sgR\u0019!J!\u0002\t\u000f\u0005m\u0015q a\u0001/!9!\u0011\u0002\u0001\u0005\u0002\t-\u0011A\u0004:fgR|'/\u001a\"vM\u001a,'o\u001d\u000b\u0002\u0015\"A!q\u0002\u0001\u0005\u0002\t\u0011\t\"A\nhe>,\boU3h[\u0016tGo\u001d\"z'&TX\r\u0006\u0006\u0003\u0014\t-\"1\u0007B\u001c\u0005w\u0001bA!\u0006\u0003&\u0005=c\u0002\u0002B\f\u0005CqAA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;)\u0012A\u0002\u001fs_>$h(C\u0001\u000b\u0013\r\u0011\u0019#C\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u00119C!\u000b\u0003\t1K7\u000f\u001e\u0006\u0004\u0005GI\u0001\u0002CA'\u0005\u001b\u0001\rA!\f\u0011\r\u0005E#qFA.\u0013\u0011\u0011\t$a\u0015\u0003\u0011%#XM]1cY\u0016DqA!\u000e\u0003\u000e\u0001\u0007q#A\u0004nCb\u001c\u0016N_3\t\u000f\te\"Q\u0002a\u0001/\u0005aQ.\u0019=J]\u0012,\u0007pU5{K\"A!Q\bB\u0007\u0001\u0004\tY\"\u0001\fgSJ\u001cH/\u00168dY\u0016\fg.\u00192mK>3gm]3u\u0011\u001d\u0011\t\u0005\u0001C\u0005\u0005\u0007\n\u0011\u0004\\1ti>3gm]3u\r>\u0014h)\u001b:tiN+w-\\3oiR1\u00111\u0004B#\u0005\u0017B\u0001Ba\u0012\u0003@\u0001\u0007!\u0011J\u0001\u0005g\u0016<7\u000f\u0005\u0004\u0003\u0016\t\u0015\u00121\f\u0005\t\u0005{\u0011y\u00041\u0001\u0002\u001c!A!q\n\u0001\u0005\u0002\t\u0011\t&\u0001\bck&dGm\u00144gg\u0016$X*\u00199\u0015\u0017)\u0013\u0019F!\u0016\u0003Z\tu#q\f\u0005\b\u0007\t5\u0003\u0019AA#\u0011!\u00119F!\u0014A\u0002\u0005m\u0011!B:uCJ$\b\u0002\u0003B.\u0005\u001b\u0002\r!a\u0007\u0002\u0007\u0015tG\rC\u0004\u0002d\t5\u0003\u0019A\u0010\t\u0011\u0005%$Q\na\u0001\u0003CAqAa\u0019\u0001\t\u0013\u0011)'\u0001\rck&dGm\u00144gg\u0016$X*\u00199G_J\u001cVmZ7f]R$\"#a%\u0003h\t%$Q\u000eB8\u0005g\u00129H!\u001f\u0003|!9\u0011Q\u0010B1\u0001\u00041\u0005\u0002\u0003B6\u0005C\u0002\r!a\u0017\u0002\u000fM,w-\\3oi\"9\u00111\rB1\u0001\u0004y\u0002\u0002\u0003B9\u0005C\u0002\r!a\u0007\u0002\u0017M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\t\u0005k\u0012\t\u00071\u0001\u0002\u001c\u00051b.\u001a=u'\u0016<W.\u001a8u'R\f'\u000f^(gMN,G\u000fC\u0004\u0002\u001c\n\u0005\u0004\u0019A\f\t\u0011\u00055$\u0011\ra\u0001\u0003_B\u0001\"!\u001b\u0003b\u0001\u0007\u0011\u0011\u0005")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    public final Function1<TopicPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer writeBuffer;
    private final BufferSupplier decompressionBufferSupplier;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return LogCleaner.class.getName();
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    private BufferSupplier decompressionBufferSupplier() {
        return this.decompressionBufferSupplier;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            block3: {
                block2: {
                    option = cleanable.log().localLogSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    if (!None$.MODULE$.equals(option)) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(cleanable.log().config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            return this.doClean(cleanable, deleteHorizonMs);
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<Object, CleanerStats> doClean(LogToClean cleanable, long deleteHorizonMs) {
        this.info((Function0<String>)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        });
        AbstractLog log = cleanable.log();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        this.info((Function0<String>)new Serializable(this, cleanable){
            public static final long serialVersionUID = 0L;
            private final LogToClean cleanable$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
            }
            {
                this.cleanable$1 = cleanable$1;
            }
        });
        long upperBoundOffset = cleanable.firstUncleanableOffset();
        this.buildOffsetMap(log, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
        long endOffset = this.offsetMap().latestOffset() + 1L;
        stats.indexDone();
        long cleanableHorizonMs = BoxesRunTime.unboxToLong((Object)log.localLogSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$15) {
                return x$15.lastModified();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }));
        this.info((Function0<String>)new Serializable(this, deleteHorizonMs, log, cleanableHorizonMs){
            public static final long serialVersionUID = 0L;
            private final long deleteHorizonMs$1;
            private final AbstractLog log$2;
            private final long cleanableHorizonMs$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), new Date(this.cleanableHorizonMs$1), new Date(this.deleteHorizonMs$1)}));
            }
            {
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$2 = log$2;
                this.cleanableHorizonMs$1 = cleanableHorizonMs$1;
            }
        });
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<Seq<LogSegment>> groupedSegments = this.groupSegmentsBySize(log.localLogSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log.config().segmentSize()), Predef$.MODULE$.Integer2int(log.config().maxIndexSize()), cleanable.firstUncleanableOffset());
        groupedSegments.foreach((Function1)new Serializable(this, deleteHorizonMs, log, stats, transactionMetadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final long deleteHorizonMs$1;
            private final AbstractLog log$2;
            private final CleanerStats stats$2;
            private final CleanedTransactionMetadata transactionMetadata$1;

            public final void apply(Seq<LogSegment> group) {
                this.$outer.cleanSegments(this.log$2, group, this.$outer.offsetMap(), this.deleteHorizonMs$1, this.stats$2, this.transactionMetadata$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deleteHorizonMs$1 = deleteHorizonMs$1;
                this.log$2 = log$2;
                this.stats$2 = stats$2;
                this.transactionMetadata$1 = transactionMetadata$1;
            }
        });
        stats.bufferUtilization_$eq(this.offsetMap().utilization());
        stats.allDone();
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public void cleanSegments(AbstractLog log, Seq<LogSegment> segments, OffsetMap map, long deleteHorizonMs, CleanerStats stats, CleanedTransactionMetadata transactionMetadata) {
        LogSegment cleaned = LogCleaner$.MODULE$.createNewCleanedSegment(log.dir(), log.config(), ((LogSegment)segments.head()).baseOffset());
        transactionMetadata.cleanedIndex_$eq((Option<TransactionIndex>)new Some((Object)cleaned.txnIndex()));
        try {
            Iterator iter = segments.iterator();
            Some currentSegmentOpt = new Some(iter.next());
            Map<Object, LastRecord> lastOffsetOfActiveProducers = log.lastRecordsOfActiveProducers();
            while (currentSegmentOpt.isDefined()) {
                LogSegment currentSegment = (LogSegment)currentSegmentOpt.get();
                None$ nextSegmentOpt = iter.hasNext() ? new Some(iter.next()) : None$.MODULE$;
                long startOffset = currentSegment.baseOffset();
                long upperBoundOffset = BoxesRunTime.unboxToLong((Object)nextSegmentOpt.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$16) {
                        return x$16.baseOffset();
                    }
                }).getOrElse((Function0)new Serializable(this, map){
                    public static final long serialVersionUID = 0L;
                    private final OffsetMap map$2;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return this.map$2.latestOffset() + 1L;
                    }
                    {
                        this.map$2 = map$2;
                    }
                }));
                List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(startOffset, upperBoundOffset);
                transactionMetadata.addAbortedTransactions(abortedTransactions);
                boolean retainDeletesAndTxnMarkers = currentSegment.lastModified() > deleteHorizonMs;
                this.info((Function0<String>)new Serializable(this, log, deleteHorizonMs, cleaned, currentSegment, retainDeletesAndTxnMarkers){
                    public static final long serialVersionUID = 0L;
                    private final AbstractLog log$4;
                    private final long deleteHorizonMs$2;
                    private final LogSegment cleaned$1;
                    private final LogSegment currentSegment$1;
                    private final boolean retainDeletesAndTxnMarkers$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaning ", " in log ", " into ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentSegment$1, this.log$4.name(), BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with deletion horizon ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.deleteHorizonMs$2)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " deletes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.retainDeletesAndTxnMarkers$1 ? "retaining" : "discarding"}))).toString();
                    }
                    {
                        this.log$4 = log$4;
                        this.deleteHorizonMs$2 = deleteHorizonMs$2;
                        this.cleaned$1 = cleaned$1;
                        this.currentSegment$1 = currentSegment$1;
                        this.retainDeletesAndTxnMarkers$1 = retainDeletesAndTxnMarkers$1;
                    }
                });
                this.cleanInto(log.topicPartition(), currentSegment.log(), cleaned, map, retainDeletesAndTxnMarkers, Predef$.MODULE$.Integer2int(log.config().maxMessageSize()), transactionMetadata, lastOffsetOfActiveProducers, stats);
                currentSegmentOpt = nextSegmentOpt;
            }
            cleaned.onBecomeInactiveSegment();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)new Serializable(this, log, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final AbstractLog log$4;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Swapping in cleaned segment ", " for segment(s) ", " in log ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleaned$1, this.segments$1, this.log$4}));
                }
                {
                    this.log$4 = log$4;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            });
            log.replaceSegments((Seq<LogSegment>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{cleaned})), segments, log.replaceSegments$default$3());
            return;
            catch (LogSegmentOffsetOverflowException logSegmentOffsetOverflowException) {
                void var15_11;
                this.info((Function0<String>)new Serializable(this, logSegmentOffsetOverflowException){
                    public static final long serialVersionUID = 0L;
                    private final LogSegmentOffsetOverflowException e$2;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Caught segment overflow error during cleaning: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$2.getMessage()}));
                    }
                    {
                        this.e$2 = e$2;
                    }
                });
                log.splitOverflowedSegment((LogSegment)var15_11);
                throw new LogCleaningAbortedException();
            }
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            try {
                try {
                    cleaned.deleteIfExists();
                }
                catch (Exception exception) {
                    logCleaningAbortedException.addSuppressed(exception);
                }
            }
            finally {
                throw logCleaningAbortedException;
            }
        }
    }

    public void cleanInto(TopicPartition topicPartition, FileRecords sourceRecords, LogSegment dest, OffsetMap map, boolean retainDeletesAndTxnMarkers, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, Map<Object, LastRecord> lastRecordsOfActiveProducers2, CleanerStats stats) {
        MemoryRecords.RecordFilter logCleanerFilter = new MemoryRecords.RecordFilter(this, map, retainDeletesAndTxnMarkers, transactionMetadata, lastRecordsOfActiveProducers2, stats){
            private boolean discardBatchRecords;
            private final /* synthetic */ Cleaner $outer;
            private final OffsetMap map$3;
            private final boolean retainDeletesAndTxnMarkers$2;
            private final CleanedTransactionMetadata transactionMetadata$2;
            private final Map lastRecordsOfActiveProducers$1;
            private final CleanerStats stats$4;

            private boolean discardBatchRecords() {
                return this.discardBatchRecords;
            }

            private void discardBatchRecords_$eq(boolean x$1) {
                this.discardBatchRecords = x$1;
            }

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                this.discardBatchRecords_$eq(this.$outer.kafka$log$Cleaner$$shouldDiscardBatch(batch, this.transactionMetadata$2, this.retainDeletesAndTxnMarkers$2));
                return batch.hasProducerId() && this.isBatchLastRecordOfProducer$1(batch) ? MemoryRecords.RecordFilter.BatchRetention.RETAIN_EMPTY : (this.discardBatchRecords() ? MemoryRecords.RecordFilter.BatchRetention.DELETE : MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY);
            }

            public boolean shouldRetainRecord(RecordBatch batch, Record record2) {
                return this.discardBatchRecords() ? false : this.$outer.kafka$log$Cleaner$$shouldRetainRecord(this.map$3, this.retainDeletesAndTxnMarkers$2, batch, record2, this.stats$4);
            }

            private final boolean isBatchLastRecordOfProducer$1(RecordBatch batch$1) {
                return this.lastRecordsOfActiveProducers$1.get((Object)BoxesRunTime.boxToLong((long)batch$1.producerId())).exists((Function1)new Serializable(this, batch$1){
                    public static final long serialVersionUID = 0L;
                    private final RecordBatch batch$1;

                    public final boolean apply(LastRecord lastRecord) {
                        Option<Object> option;
                        block4: {
                            boolean bl;
                            block3: {
                                block2: {
                                    option = lastRecord.lastDataOffset();
                                    if (!(option instanceof Some)) break block2;
                                    Some some = (Some)option;
                                    long offset2 = BoxesRunTime.unboxToLong((Object)some.x());
                                    bl = this.batch$1.lastOffset() == offset2;
                                    break block3;
                                }
                                if (!None$.MODULE$.equals(option)) break block4;
                                bl = this.batch$1.isControlBatch() && this.batch$1.producerEpoch() == lastRecord.producerEpoch();
                            }
                            return bl;
                        }
                        throw new MatchError(option);
                    }
                    {
                        this.batch$1 = batch$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.map$3 = map$3;
                this.retainDeletesAndTxnMarkers$2 = retainDeletesAndTxnMarkers$2;
                this.transactionMetadata$2 = transactionMetadata$2;
                this.lastRecordsOfActiveProducers$1 = lastRecordsOfActiveProducers$1;
                this.stats$4 = stats$4;
            }
        };
        int position = 0;
        while (position < sourceRecords.sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.writeBuffer().clear();
            sourceRecords.readInto(this.kafka$log$Cleaner$$readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.kafka$log$Cleaner$$readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result = records.filterTo(topicPartition, logCleanerFilter, this.writeBuffer(), maxLogMessageSize, this.decompressionBufferSupplier());
            stats.readMessages(result.messagesRead(), result.bytesRead());
            stats.recopyMessages(result.messagesRetained(), result.bytesRetained());
            position += result.bytesRead();
            ByteBuffer outputBuffer = result.outputBuffer();
            if (outputBuffer.position() > 0) {
                outputBuffer.flip();
                MemoryRecords retained = MemoryRecords.readableRecords((ByteBuffer)outputBuffer);
                dest.append(result.maxOffset(), result.maxTimestamp(), result.shallowOffsetOfMaxTimestamp(), retained);
                this.throttler.maybeThrottle(outputBuffer.limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || result.bytesRead() != 0) continue;
            this.growBuffersOrFail(sourceRecords, position, maxLogMessageSize, records);
        }
        this.restoreBuffers();
    }

    private void growBuffersOrFail(FileRecords sourceRecords, int position, int maxLogMessageSize, MemoryRecords memoryRecords) {
        int n;
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxLogMessageSize) {
            Integer nextBatchSize = memoryRecords.firstBatchSize();
            String logDesc = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log segment ", " at position ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceRecords.file(), BoxesRunTime.boxToInteger((int)position)}));
            if (nextBatchSize == null) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not determine next batch size for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logDesc})));
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= 0) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid batch size ", " for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextBatchSize, logDesc})));
            }
            if (Predef$.MODULE$.Integer2int(nextBatchSize) <= this.kafka$log$Cleaner$$readBuffer().capacity()) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch size ", " < buffer size ", ", but not processed for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextBatchSize, BoxesRunTime.boxToInteger((int)this.kafka$log$Cleaner$$readBuffer().capacity()), logDesc})));
            }
            long bytesLeft = sourceRecords.channel().size() - (long)position;
            if ((long)Predef$.MODULE$.Integer2int(nextBatchSize) > bytesLeft) {
                throw new CorruptRecordException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log segment may be corrupt, batch size ", " > ", " bytes left in segment for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nextBatchSize, BoxesRunTime.boxToLong((long)bytesLeft), logDesc})));
            }
            n = nextBatchSize;
        } else {
            n = maxLogMessageSize;
        }
        int maxSize = n;
        this.growBuffers(maxSize);
    }

    public boolean kafka$log$Cleaner$$shouldDiscardBatch(RecordBatch batch, CleanedTransactionMetadata transactionMetadata, boolean retainTxnMarkers) {
        boolean canDiscardBatch;
        boolean canDiscardControlBatch;
        boolean bl = batch.isControlBatch() ? (canDiscardControlBatch = transactionMetadata.onControlBatchRead(batch)) && !retainTxnMarkers : (canDiscardBatch = transactionMetadata.onBatchRead(batch));
        return bl;
    }

    public boolean kafka$log$Cleaner$$shouldRetainRecord(OffsetMap map, boolean retainDeletes, RecordBatch batch, Record record2, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = record2.offset() > map.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (record2.hasKey()) {
            boolean isRetainedValue;
            ByteBuffer key = record2.key();
            long foundOffset = map.get(key);
            boolean latestOffsetForKey = record2.offset() >= foundOffset;
            boolean bl3 = isRetainedValue = record2.hasValue() || retainDeletes;
            bl = latestOffsetForKey && isRetainedValue;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Growing cleaner I/O buffers from ", " bytes to ", " bytes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Cleaner$$readBuffer().capacity()), BoxesRunTime.boxToInteger((int)this.newSize$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize, long firstUncleanableOffset) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            long indexSize = ((LogSegment)segs.head()).offsetIndex().sizeInBytes();
            long timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + (long)((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes() <= (long)maxIndexSize && timeIndexSize + (long)((LogSegment)segs.head()).timeIndex().sizeInBytes() <= (long)maxIndexSize && this.lastOffsetForFirstSegment((List<LogSegment>)segs, firstUncleanableOffset) - ((LogSegment)group.last()).baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += (long)((LogSegment)segs.head()).size();
                indexSize += (long)((LogSegment)segs.head()).offsetIndex().sizeInBytes();
                timeIndexSize += (long)((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    private long lastOffsetForFirstSegment(List<LogSegment> segs, long firstUncleanableOffset) {
        return segs.size() > 1 ? ((LogSegment)segs.apply(1)).baseOffset() - 1L : firstUncleanableOffset - 1L;
    }

    public void buildOffsetMap(AbstractLog log, long start2, long end, OffsetMap map, CleanerStats stats) {
        map.clear();
        Buffer dirty = log.localLogSegments(start2, end).toBuffer();
        ListBuffer nextSegmentStartOffsets = new ListBuffer();
        if (dirty.nonEmpty()) {
            ((IterableLike)dirty.tail()).foreach((Function1)new Serializable(this, nextSegmentStartOffsets){
                public static final long serialVersionUID = 0L;
                private final ListBuffer nextSegmentStartOffsets$1;

                public final void apply(LogSegment nextSegment) {
                    this.nextSegmentStartOffsets$1.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{nextSegment.baseOffset()}));
                }
                {
                    this.nextSegmentStartOffsets$1 = nextSegmentStartOffsets$1;
                }
            });
            nextSegmentStartOffsets.append((Seq)Predef$.MODULE$.wrapLongArray(new long[]{end}));
        }
        this.info((Function0<String>)new Serializable(this, log, start2, end, dirty){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$3;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name(), BoxesRunTime.boxToInteger((int)this.dirty$1.size()), BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}));
            }
            {
                this.log$3 = log$3;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        });
        CleanedTransactionMetadata transactionMetadata = new CleanedTransactionMetadata();
        List<AbortedTxn> abortedTransactions = log.collectAbortedTransactions(start2, end);
        transactionMetadata.addAbortedTransactions(abortedTransactions);
        BooleanRef full = BooleanRef.create((boolean)false);
        ((TraversableLike)dirty.zip((GenIterable)nextSegmentStartOffsets, Buffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<LogSegment, Object> check$ifrefutable$1) {
                Tuple2<LogSegment, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(Tuple2<LogSegment, Object> x$18) {
                Tuple2<LogSegment, Object> tuple2 = x$18;
                if (tuple2 != null) {
                    boolean bl = !this.full$1.elem;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.full$1 = full$1;
            }
        }).foreach((Function1)new Serializable(this, log, start2, map, stats, dirty, transactionMetadata, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final AbstractLog log$3;
            private final long start$1;
            private final OffsetMap map$1;
            private final CleanerStats stats$3;
            public final Buffer dirty$1;
            private final CleanedTransactionMetadata transactionMetadata$3;
            private final BooleanRef full$1;

            public final void apply(Tuple2<LogSegment, Object> x$19) {
                Tuple2<LogSegment, Object> tuple2 = x$19;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    LogSegment segment = (LogSegment)tuple2._1();
                    long nextSegmentStartOffset = tuple2._2$mcJ$sp();
                    this.$outer.kafka$log$Cleaner$$checkDone.apply((Object)this.log$3.topicPartition());
                    this.full$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$3.topicPartition(), segment, this.map$1, this.start$1, nextSegmentStartOffset, Predef$.MODULE$.Integer2int(this.log$3.config().maxMessageSize()), this.transactionMetadata$3, this.stats$3);
                    if (this.full$1.elem) {
                        this.$outer.debug((Function0<String>)new Serializable(this, segment){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$buildOffsetMap$5 $outer;
                            private final LogSegment segment$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.dirty$1.indexOf((Object)this.segment$1)), BoxesRunTime.boxToLong((long)this.segment$1.baseOffset())}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.segment$1 = segment$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$3 = log$3;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.stats$3 = stats$3;
                this.dirty$1 = dirty$1;
                this.transactionMetadata$3 = transactionMetadata$3;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final AbstractLog log$3;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name()}));
            }
            {
                this.log$3 = log$3;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean kafka$log$Cleaner$$buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map, long startOffset, long nextSegmentStartOffset, int maxLogMessageSize, CleanedTransactionMetadata transactionMetadata, CleanerStats stats) {
        boolean bl;
        Object object = new Object();
        try {
            int position = segment.offsetIndex().lookup(startOffset).position();
            int maxDesiredMapSize = (int)((double)map.slots() * this.dupBufferLoadFactor);
            while (true) {
                if (position >= segment.log().sizeInBytes()) {
                    map.updateLatestOffset(nextSegmentStartOffset - 1L);
                    this.restoreBuffers();
                    return false;
                }
                this.kafka$log$Cleaner$$checkDone.apply((Object)topicPartition);
                this.kafka$log$Cleaner$$readBuffer().clear();
                try {
                    segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
                }
                catch (Exception exception) {
                    throw new KafkaException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to read from segment ", " of partition ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{segment, topicPartition}))).append((Object)"while loading offset map").toString(), (Throwable)exception);
                }
                MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.kafka$log$Cleaner$$readBuffer());
                this.throttler.maybeThrottle(records.sizeInBytes());
                int startPosition = position;
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1)new Serializable(this, map, startOffset, transactionMetadata, stats, maxDesiredMapSize, object){
                    public static final long serialVersionUID = 0L;
                    public final OffsetMap map$4;
                    public final long startOffset$1;
                    private final CleanedTransactionMetadata transactionMetadata$4;
                    public final CleanerStats stats$5;
                    public final int maxDesiredMapSize$1;
                    public final Object nonLocalReturnKey2$1;

                    public final void apply(MutableRecordBatch batch) {
                        if (batch.isControlBatch()) {
                            this.transactionMetadata$4.onControlBatchRead((RecordBatch)batch);
                            this.stats$5.indexMessagesRead(1);
                        } else {
                            boolean isAborted = this.transactionMetadata$4.onBatchRead((RecordBatch)batch);
                            if (isAborted) {
                                this.stats$5.indexMessagesRead(Predef$.MODULE$.Integer2int(batch.countOrNull()));
                            } else {
                                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$kafka$log$Cleaner$$buildOffsetMapForSegment$1 $outer;

                                    public final void apply(Record record2) {
                                        if (record2.hasKey() && record2.offset() >= this.$outer.startOffset$1) {
                                            if (this.$outer.map$4.size() < this.$outer.maxDesiredMapSize$1) {
                                                this.$outer.map$4.put(record2.key(), record2.offset());
                                            } else {
                                                throw new NonLocalReturnControl.mcZ.sp(this.$outer.nonLocalReturnKey2$1, true);
                                            }
                                        }
                                        this.$outer.stats$5.indexMessagesRead(1);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                    }
                                });
                            }
                        }
                        if (batch.lastOffset() >= this.startOffset$1) {
                            this.map$4.updateLatestOffset(batch.lastOffset());
                        }
                    }
                    {
                        this.map$4 = map$4;
                        this.startOffset$1 = startOffset$1;
                        this.transactionMetadata$4 = transactionMetadata$4;
                        this.stats$5 = stats$5;
                        this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                int bytesRead = records.validBytes();
                stats.indexBytesRead(bytesRead);
                if ((position += bytesRead) != startPosition) continue;
                this.growBuffersOrFail(segment.log(), position, maxLogMessageSize, records);
            }
        }
        catch (NonLocalReturnControl nonLocalReturnControl22) {
            if (nonLocalReturnControl22.key() != object) throw nonLocalReturnControl22;
            bl = nonLocalReturnControl22.value$mcZ$sp();
        }
        return bl;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cleaner ", ": "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        this.decompressionBufferSupplier = BufferSupplier.create();
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
            }
        });
    }
}

