/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import kafka.controller.ControllerContext;
import kafka.controller.DeletionClient;
import kafka.controller.NonExistentPartition$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflinePartition$;
import kafka.controller.OfflineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.PartitionStateMachine;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.TopicDeletionManager$;
import kafka.log.LogConfig;
import kafka.server.KafkaConfig;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.state.TierPartitionState;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RetriableException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005-e\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u000511m\u001c8gS\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0003\u0002\rM,'O^3s\u0013\tY\u0002DA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\u0002C\u000f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0005\u0002 A5\t!!\u0003\u0002\"\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n1C]3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016\u0004\"aH\u0013\n\u0005\u0019\u0012!a\u0005*fa2L7-Y*uCR,W*Y2iS:,\u0007\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002+A\f'\u000f^5uS>t7\u000b^1uK6\u000b7\r[5oKB\u0011qDK\u0005\u0003W\t\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0003\u0019\u0019G.[3oiB\u0011qdL\u0005\u0003a\t\u0011a\u0002R3mKRLwN\\\"mS\u0016tG\u000f\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003M!\u0018.\u001a:U_BL7-T1oC\u001e,'o\u00149u!\rIAGN\u0005\u0003k)\u0011aa\u00149uS>t\u0007CA\u001c=\u001b\u0005A$BA\u001d;\u0003\u0015!x\u000e]5d\u0015\tYD!\u0001\u0003uS\u0016\u0014\u0018BA\u001f9\u0005A!\u0016.\u001a:U_BL7-T1oC\u001e,'\u000fC\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\b\u0003\n\u001bE)\u0012$H!\ty\u0002\u0001C\u0003\u0016}\u0001\u0007a\u0003C\u0003\u001e}\u0001\u0007a\u0004C\u0003$}\u0001\u0007A\u0005C\u0003)}\u0001\u0007\u0011\u0006C\u0003.}\u0001\u0007a\u0006C\u00033}\u0001\u00071\u0007C\u0004J\u0001\t\u0007I\u0011\u0001&\u0002)%\u001cH)\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3e+\u0005Y\u0005CA\u0005M\u0013\ti%BA\u0004C_>dW-\u00198\t\r=\u0003\u0001\u0015!\u0003L\u0003UI7\u000fR3mKR,Gk\u001c9jG\u0016s\u0017M\u00197fI\u0002BQ!\u0015\u0001\u0005\u0002I\u000bA!\u001b8jiR\u00191KV3\u0011\u0005%!\u0016BA+\u000b\u0005\u0011)f.\u001b;\t\u000b]\u0003\u0006\u0019\u0001-\u00021%t\u0017\u000e^5bYR{\u0007/[2t)>\u0014U\rR3mKR,G\rE\u0002Z9zk\u0011A\u0017\u0006\u00037*\t!bY8mY\u0016\u001cG/[8o\u0013\ti&LA\u0002TKR\u0004\"a\u00182\u000f\u0005%\u0001\u0017BA1\u000b\u0003\u0019\u0001&/\u001a3fM&\u00111\r\u001a\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005T\u0001\"\u00024Q\u0001\u0004A\u0016AI5oSRL\u0017\r\u001c+pa&\u001c7/\u00138fY&<\u0017N\u00197f\r>\u0014H)\u001a7fi&|g\u000eC\u0003i\u0001\u0011\u0005\u0011.\u0001\tuef$v\u000e]5d\t\u0016dW\r^5p]R\t1\u000bC\u0003l\u0001\u0011\u0005A.\u0001\rf]F,X-^3U_BL7m\u001d$pe\u0012+G.\u001a;j_:$\"aU7\t\u000b9T\u0007\u0019\u0001-\u0002\rQ|\u0007/[2t\u0011\u0015\u0001\b\u0001\"\u0001r\u0003]\u0011Xm];nK\u0012+G.\u001a;j_:4uN\u001d+pa&\u001c7\u000f\u0006\u0002Te\"9an\u001cI\u0001\u0002\u0004A\u0006\"\u0002;\u0001\t\u0003)\u0018a\u00054bS2\u0014V\r\u001d7jG\u0006$U\r\\3uS>tGCA*w\u0011\u001598\u000f1\u0001y\u0003!\u0011X\r\u001d7jG\u0006\u001c\bcA-]sB\u0011qD_\u0005\u0003w\n\u00111\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006DQ! \u0001\u0005\u0002y\fa$\\1sWR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\tM{\u0018\u0011\u0001\u0005\u0006]r\u0004\r\u0001\u0017\u0005\t\u0003\u0007aH\u00111\u0001\u0002\u0006\u00051!/Z1t_:\u0004B!CA\u0004=&\u0019\u0011\u0011\u0002\u0006\u0003\u0011q\u0012\u0017P\\1nKzBq!!\u0004\u0001\t\u0013\ty!\u0001\u000fjgR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007-\u000b\t\u0002\u0003\u0004:\u0003\u0017\u0001\rA\u0018\u0005\b\u0003+\u0001A\u0011BA\f\u0003eI7\u000fV8qS\u000e$U\r\\3uS>t\u0017J\u001c)s_\u001e\u0014Xm]:\u0015\u0007-\u000bI\u0002\u0003\u0004:\u0003'\u0001\rA\u0018\u0005\b\u0003;\u0001A\u0011AA\u0010\u0003iI7\u000fV8qS\u000e\fV/Z;fIV\u0003hi\u001c:EK2,G/[8o)\rY\u0015\u0011\u0005\u0005\u0007s\u0005m\u0001\u0019\u00010\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u000592m\\7qY\u0016$XMU3qY&\u001c\u0017\rR3mKRLwN\u001c\u000b\u0004'\u0006%\u0002BB<\u0002$\u0001\u0007\u0001\u0010C\u0004\u0002.\u0001!I!a\f\u00025%\u001cHk\u001c9jG\u0016c\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\u0007-\u000b\t\u0004\u0003\u0004:\u0003W\u0001\rA\u0018\u0005\b\u0003k\u0001A\u0011BA\u001c\u0003\t\u0012X\r\u001e:z\t\u0016dW\r^5p]\u001a{'/\u00138fY&<\u0017N\u00197f%\u0016\u0004H.[2bgR\u00191+!\u000f\t\r9\f\u0019\u00041\u0001Y\u0011\u001d\ti\u0004\u0001C\u0005\u0003\u007f\tA\u0003^5fe\u0016$G)\u001a7fi&|gNT3fI\u0016$GcA&\u0002B!1\u0011(a\u000fA\u0002yCq!!\u0012\u0001\t\u0013\t9%\u0001\fbgft7\rR3mKR,G+[3sK\u0012$v\u000e]5d)\r\u0019\u0016\u0011\n\u0005\u0007s\u0005\r\u0003\u0019\u00010\t\u000f\u00055\u0003\u0001\"\u0003\u0002P\u0005Q\u0002O]3qCJ,7i\\7qY\u0016$X\rR3mKR,Gk\u001c9jGR\u00191+!\u0015\t\re\nY\u00051\u0001_\u0011\u001d\t)\u0006\u0001C\u0001\u0003/\n\u0011CZ5oSNDGk\u001c9jG\u0012+G.\u001a;f)\r\u0019\u0016\u0011\f\u0005\u0007s\u0005M\u0003\u0019\u00010\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\u0005yqN\u001c+pa&\u001cG)\u001a7fi&|g\u000eF\u0002T\u0003CBaA\\A.\u0001\u0004A\u0006bBA3\u0001\u0011%\u0011qM\u0001\u0014_:\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0004'\u0006%\u0004bBA6\u0003G\u0002\r\u0001W\u0001\u0012i>\u0004\u0018nY:U_\n+G)\u001a7fi\u0016$\u0007BBA8\u0001\u0011%\u0011.A\bsKN,X.\u001a#fY\u0016$\u0018n\u001c8t\u0011%\t\u0019\bAI\u0001\n\u0003\t)(A\u0011sKN,X.\u001a#fY\u0016$\u0018n\u001c8G_J$v\u000e]5dg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002x)\u001a\u0001,!\u001f,\u0005\u0005m\u0004\u0003BA?\u0003\u000fk!!a \u000b\t\u0005\u0005\u00151Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\"\u000b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\u000byHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class TopicDeletionManager
implements Logging {
    private final KafkaConfig config;
    public final ControllerContext kafka$controller$TopicDeletionManager$$controllerContext;
    private final ReplicaStateMachine replicaStateMachine;
    private final PartitionStateMachine partitionStateMachine;
    public final DeletionClient kafka$controller$TopicDeletionManager$$client;
    private final Option<TierTopicManager> tierTopicManagerOpt;
    private final boolean isDeleteTopicEnabled;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void init(Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.info((Function0<String>)new Serializable(this, initialTopicsToBeDeleted, initialTopicsIneligibleForDeletion){
            public static final long serialVersionUID = 0L;
            private final Set initialTopicsToBeDeleted$1;
            private final Set initialTopicsIneligibleForDeletion$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initializing manager with initial deletions: ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsToBeDeleted$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"initial ineligible deletions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsIneligibleForDeletion$1}))).toString();
            }
            {
                this.initialTopicsToBeDeleted$1 = initialTopicsToBeDeleted$1;
                this.initialTopicsIneligibleForDeletion$1 = initialTopicsIneligibleForDeletion$1;
            }
        });
        if (this.isDeleteTopicEnabled()) {
            this.kafka$controller$TopicDeletionManager$$controllerContext.queueTopicDeletion(initialTopicsToBeDeleted);
            this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)initialTopicsIneligibleForDeletion.$amp(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted()));
        } else {
            this.info((Function0<String>)new Serializable(this, initialTopicsToBeDeleted){
                public static final long serialVersionUID = 0L;
                private final Set initialTopicsToBeDeleted$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing ", " since delete topic is disabled"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.initialTopicsToBeDeleted$1}));
                }
                {
                    this.initialTopicsToBeDeleted$1 = initialTopicsToBeDeleted$1;
                }
            });
            this.kafka$controller$TopicDeletionManager$$client.deleteTopicDeletions((Seq<String>)initialTopicsToBeDeleted.toSeq(), this.kafka$controller$TopicDeletionManager$$controllerContext.epochZkVersion());
        }
    }

    public void tryTopicDeletion() {
        if (this.isDeleteTopicEnabled()) {
            this.resumeDeletions();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (this.isDeleteTopicEnabled()) {
            this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionBeingCompleted().$minus$minus$eq(topics);
            this.kafka$controller$TopicDeletionManager$$controllerContext.queueTopicDeletion(topics);
            this.resumeDeletions();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (this.isDeleteTopicEnabled() && (topicsToResumeDeletion = (Set)topics.$amp(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted())).nonEmpty()) {
            this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().$minus$minus$eq((TraversableOnce)topicsToResumeDeletion);
            this.resumeDeletions();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (this.isDeleteTopicEnabled() && (replicasThatFailedToDelete = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        })).nonEmpty()) {
            Set topics = (Set)replicasThatFailedToDelete.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$2) {
                    return x$2.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion failed for replicas ", ". Halting deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            });
            this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasThatFailedToDelete.toSeq(), ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion((Set<String>)topics, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "replica deletion failure";
                }
            });
            this.resumeDeletions();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics, Function0<String> reason) {
        if (this.isDeleteTopicEnabled()) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted().$amp(topics);
            this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().$plus$plus$eq((TraversableOnce)newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.nonEmpty()) {
                this.info((Function0<String>)new Serializable(this, reason, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final Function0 reason$1;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Halted deletion of topics ", " due to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newTopicsToHaltDeletion$1.mkString(","), this.reason$1.apply()}));
                    }
                    {
                        this.reason$1 = reason$1;
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                });
            }
        }
    }

    private boolean isTopicIneligibleForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controllerContext.topicsIneligibleForDeletion().contains((Object)topic) : true;
    }

    private boolean isTopicDeletionInProgress(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return this.isDeleteTopicEnabled() ? this.kafka$controller$TopicDeletionManager$$controllerContext.isTopicQueuedUpForDeletion(topic) : false;
    }

    public void completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.debug((Function0<String>)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion successfully completed for replicas ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        });
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)successfullyDeletedReplicas.toSeq(), ReplicaDeletionSuccessful$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.resumeDeletions();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.kafka$controller$TopicDeletionManager$$controllerContext.isTopicQueuedUpForDeletion(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic) && !this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionBeingCompleted().contains((Object)topic);
    }

    private void retryDeletionForIneligibleReplicas(Set<String> topics) {
        Set failedReplicas = (Set)topics.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<PartitionAndReplica> apply(String x$3) {
                return this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.replicasInState(x$3, ReplicaDeletionIneligible$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)new Serializable(this, topics, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;
            private final Set failedReplicas$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying deletion of topics ", " since replicas ", " were not successfully deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topics$2.mkString(","), this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
                this.failedReplicas$1 = failedReplicas$1;
            }
        });
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)failedReplicas.toSeq(), OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
    }

    private boolean tieredDeletionNeeded(String topic) {
        LogConfig topicConfig;
        return Predef$.MODULE$.Boolean2boolean(this.config.tierFeature()) ? Predef$.MODULE$.Boolean2boolean((topicConfig = this.kafka$controller$TopicDeletionManager$$client.topicConfig(topic, this.config)).tierEnable()) && !topicConfig.compact() : false;
    }

    private void asyncDeleteTieredTopic(String topic) {
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        TierTopicManager tierTopicManager = (TierTopicManager)this.tierTopicManagerOpt.get();
        UUID topicId = (UUID)this.kafka$controller$TopicDeletionManager$$controllerContext.topicIds().apply((Object)topic);
        scala.collection.immutable.Set partitionsForDeletedTopic = ((TraversableOnce)replicasForDeletedTopic.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(PartitionAndReplica x$4) {
                return x$4.topicPartition();
            }
        }, Set$.MODULE$.canBuildFrom())).toSet();
        ListBuffer appendResults = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionsForDeletedTopic.foreach((Function1)new Serializable(this, topic, tierTopicManager, topicId, appendResults){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final String topic$2;
            private final TierTopicManager tierTopicManager$1;
            private final UUID topicId$1;
            private final ListBuffer appendResults$1;

            public final ListBuffer<CompletableFuture<TierPartitionState.AppendResult>> apply(TopicPartition partition) {
                TopicIdPartition topicIdPartition = new TopicIdPartition(this.topic$2, this.topicId$1, partition.partition());
                TierPartitionDeleteInitiate deleteInitiate = new TierPartitionDeleteInitiate(topicIdPartition, this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.epoch(), UUID.randomUUID());
                return this.appendResults$1.$plus$eq(this.tierTopicManager$1.addMetadata(deleteInitiate));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.tierTopicManager$1 = tierTopicManager$1;
                this.topicId$1 = topicId$1;
                this.appendResults$1 = appendResults$1;
            }
        });
        CompletableFuture<Void> futures = CompletableFuture.allOf((CompletableFuture[])appendResults.toArray(ClassTag$.MODULE$.apply(CompletableFuture.class)));
        futures.whenComplete((BiConsumer)new BiConsumer<Void, Throwable>(this, topic, appendResults){
            private final /* synthetic */ TopicDeletionManager $outer;
            public final String topic$2;
            private final ListBuffer appendResults$1;

            public void accept(Void result, Throwable t) {
                NonLocalReturnControl nonLocalReturnControl2;
                block6: {
                    Object object = new Object();
                    try {
                        if (t == null) {
                            ListBuffer results = (ListBuffer)this.appendResults$1.map((Function1)new Serializable(this, object){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anon$1 $outer;
                                private final Object nonLocalReturnKey1$1;

                                public final TierPartitionState.AppendResult apply(CompletableFuture<TierPartitionState.AppendResult> appendResult) {
                                    try {
                                        return appendResult.get();
                                    }
                                    catch (Exception exception) {
                                        this.$outer.kafka$controller$TopicDeletionManager$$anon$$$outer().kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(exception, this.$outer.topic$2);
                                        throw new NonLocalReturnControl.mcV.sp(this.nonLocalReturnKey1$1, BoxedUnit.UNIT);
                                    }
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                                }
                            }, ListBuffer$.MODULE$.canBuildFrom());
                            if (results.forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(TierPartitionState.AppendResult x$5) {
                                    TierPartitionState.AppendResult appendResult = x$5;
                                    TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
                                    return !(appendResult != null ? !((Object)((Object)appendResult)).equals((Object)((Object)appendResult2)) : appendResult2 != null);
                                }
                            })) {
                                this.$outer.kafka$controller$TopicDeletionManager$$client.completeDeleteTopic(this.topic$2);
                            } else {
                                this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected result ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{results}))), this.topic$2);
                            }
                        } else {
                            this.$outer.kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(t, this.topic$2);
                        }
                    }
                    catch (NonLocalReturnControl nonLocalReturnControl2) {
                        if (nonLocalReturnControl2.key() != object) break block6;
                        nonLocalReturnControl2.value$mcV$sp();
                    }
                    return;
                }
                throw nonLocalReturnControl2;
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topic$2 = topic$2;
                this.appendResults$1 = appendResults$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$prepareCompleteDeleteTopic(String topic) {
        this.kafka$controller$TopicDeletionManager$$client.mutePartitionModifications(topic);
        this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionBeingCompleted().$plus$eq((Object)topic);
        if (this.tieredDeletionNeeded(topic)) {
            this.asyncDeleteTieredTopic(topic);
        } else {
            this.finishTopicDelete(topic);
        }
    }

    public void finishTopicDelete(String topic) {
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)replicasForDeletedTopic.toSeq(), NonExistentReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted().$minus$eq((Object)topic);
        this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionStarted().$minus$eq((Object)topic);
        this.kafka$controller$TopicDeletionManager$$client.deleteTopic(topic, this.kafka$controller$TopicDeletionManager$$controllerContext.epochZkVersion());
        this.kafka$controller$TopicDeletionManager$$controllerContext.removeTopic(topic);
        this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionBeingCompleted().$minus$eq((Object)topic);
        this.info((Function0<String>)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " successfully completed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1}));
            }
            {
                this.topic$1 = topic$1;
            }
        });
    }

    private void onTopicDeletion(Set<String> topics) {
        Set unseenTopicsForDeletion = (Set)topics.$minus$minus(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionStarted());
        if (unseenTopicsForDeletion.nonEmpty()) {
            Set unseenPartitionsForDeletion = (Set)unseenTopicsForDeletion.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicPartition> apply(String topic) {
                    return this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom());
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), OfflinePartition$.MODULE$);
            this.partitionStateMachine.handleStateChanges((Seq<TopicPartition>)unseenPartitionsForDeletion.toSeq(), NonExistentPartition$.MODULE$);
            this.kafka$controller$TopicDeletionManager$$controllerContext.beginTopicDeletion((Set<String>)unseenTopicsForDeletion);
        }
        this.kafka$controller$TopicDeletionManager$$client.sendMetadataUpdate((Set<TopicPartition>)((Set)topics.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicPartition> apply(String topic) {
                return this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())));
        this.onPartitionDeletion(topics);
    }

    private void onPartitionDeletion(Set<String> topicsToBeDeleted) {
        ListBuffer allDeadReplicas = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer allReplicasForDeletionRetry = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.mutable.Set allTopicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        topicsToBeDeleted.foreach((Function1)new Serializable(this, allDeadReplicas, allReplicasForDeletionRetry, allTopicsIneligibleForDeletion){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final ListBuffer allDeadReplicas$1;
            private final ListBuffer allReplicasForDeletionRetry$1;
            private final scala.collection.mutable.Set allTopicsIneligibleForDeletion$1;

            public final Object apply(String topic) {
                Tuple2 tuple2 = this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.replicasForTopic(topic).partition((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$onPartitionDeletion$1 $outer;

                    public final boolean apply(PartitionAndReplica r) {
                        return this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$controllerContext.isReplicaOnline(r.replica(), r.topicPartition(), this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$controllerContext.isReplicaOnline$default$3());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    Tuple2 tuple22;
                    Set aliveReplicas = (Set)tuple2._1();
                    Set deadReplicas = (Set)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)aliveReplicas, (Object)deadReplicas);
                    Set aliveReplicas2 = (Set)tuple23._1();
                    Set deadReplicas2 = (Set)tuple23._2();
                    Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                    Set replicasForDeletionRetry = (Set)aliveReplicas2.$minus$minus(successfullyDeletedReplicas);
                    this.allDeadReplicas$1.$plus$plus$eq((TraversableOnce)deadReplicas2);
                    this.allReplicasForDeletionRetry$1.$plus$plus$eq((TraversableOnce)replicasForDeletionRetry);
                    if (deadReplicas2.nonEmpty()) {
                        this.$outer.debug((Function0<String>)new Serializable(this, deadReplicas2, topic){
                            public static final long serialVersionUID = 0L;
                            private final Set deadReplicas$1;
                            private final String topic$3;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Dead Replicas (", ") found for topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadReplicas$1.mkString(","), this.topic$3}));
                            }
                            {
                                this.deadReplicas$1 = deadReplicas$1;
                                this.topic$3 = topic$3;
                            }
                        });
                        boxedUnit = this.allTopicsIneligibleForDeletion$1.$plus$eq((Object)topic);
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                throw new MatchError((Object)tuple2);
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.allDeadReplicas$1 = allDeadReplicas$1;
                this.allReplicasForDeletionRetry$1 = allReplicasForDeletionRetry$1;
                this.allTopicsIneligibleForDeletion$1 = allTopicsIneligibleForDeletion$1;
            }
        });
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allDeadReplicas, ReplicaDeletionIneligible$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, OfflineReplica$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        this.replicaStateMachine.handleStateChanges((Seq<PartitionAndReplica>)allReplicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, this.replicaStateMachine.handleStateChanges$default$3());
        if (allTopicsIneligibleForDeletion.nonEmpty()) {
            this.markTopicIneligibleForDeletion((Set<String>)allTopicsIneligibleForDeletion, (Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "offline replicas";
                }
            });
        }
    }

    private void resumeDeletions() {
        Set topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsToBeDeleted());
        scala.collection.mutable.Set topicsEligibleForRetry = scala.collection.mutable.Set$.MODULE$.empty();
        scala.collection.mutable.Set topicsEligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty();
        if (topicsQueuedForDeletion.nonEmpty()) {
            this.info((Function0<String>)new Serializable(this, topicsQueuedForDeletion){
                public static final long serialVersionUID = 0L;
                private final Set topicsQueuedForDeletion$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Handling deletion for topics ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicsQueuedForDeletion$1.mkString(",")}));
                }
                {
                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                }
            });
        }
        topicsQueuedForDeletion.diff(this.kafka$controller$TopicDeletionManager$$controllerContext.topicsWithDeletionBeingCompleted()).foreach((Function1)new Serializable(this, topicsEligibleForRetry, topicsEligibleForDeletion){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final scala.collection.mutable.Set topicsEligibleForRetry$1;
            private final scala.collection.mutable.Set topicsEligibleForDeletion$1;

            public final Object apply(String topic) {
                BoxedUnit boxedUnit;
                Object object;
                if (this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.areAllReplicasInState(topic, ReplicaDeletionSuccessful$.MODULE$)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All replicas for ", " have been successfully deleted. Preparing to complete topic deletion."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                    this.$outer.kafka$controller$TopicDeletionManager$$prepareCompleteDeleteTopic(topic);
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.isAnyReplicaInState(topic, ReplicaDeletionStarted$.MODULE$) ? BoxedUnit.UNIT : (this.$outer.kafka$controller$TopicDeletionManager$$controllerContext.isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$) ? this.topicsEligibleForRetry$1.$plus$eq((Object)topic) : BoxedUnit.UNIT);
                }
                if (this.$outer.kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                    this.$outer.info((Function0<String>)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$4;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deletion of topic ", " (re)started"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$4}));
                        }
                        {
                            this.topic$4 = topic$4;
                        }
                    });
                    boxedUnit = this.topicsEligibleForDeletion$1.$plus$eq((Object)topic);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicsEligibleForRetry$1 = topicsEligibleForRetry$1;
                this.topicsEligibleForDeletion$1 = topicsEligibleForDeletion$1;
            }
        });
        if (topicsEligibleForRetry.nonEmpty()) {
            this.retryDeletionForIneligibleReplicas((Set<String>)topicsEligibleForRetry);
        }
        if (topicsEligibleForDeletion.nonEmpty()) {
            this.onTopicDeletion((Set<String>)topicsEligibleForDeletion);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void kafka$controller$TopicDeletionManager$$maybeRetryDeletion$1(Throwable t, String topic$2) {
        Throwable throwable = t;
        boolean bl = throwable instanceof RetriableException ? true : throwable.getCause() != null && throwable.getCause() instanceof RetriableException;
        boolean isRetriable = bl;
        if (!isRetriable) {
            this.error((Function0<String>)new Serializable(this, topic$2){
                public static final long serialVersionUID = 0L;
                private final String topic$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting tiered topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                }
                {
                    this.topic$2 = topic$2;
                }
            }, (Function0<Throwable>)new Serializable(this, t){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            });
            return;
        }
        this.info((Function0<String>)new Serializable(this, topic$2){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrying topic deletion for tiered topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
            }
            {
                this.topic$2 = topic$2;
            }
        }, (Function0<Throwable>)new Serializable(this, t){
            public static final long serialVersionUID = 0L;
            private final Throwable t$1;

            public final Throwable apply() {
                return this.t$1;
            }
            {
                this.t$1 = t$1;
            }
        });
        try {
            this.kafka$controller$TopicDeletionManager$$client.retryDeletion();
            return;
        }
        catch (Exception exception) {
            this.error((Function0<String>)new Serializable(this, topic$2){
                public static final long serialVersionUID = 0L;
                private final String topic$2;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deleting tiered topic ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$2}));
                }
                {
                    this.topic$2 = topic$2;
                }
            }, (Function0<Throwable>)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            });
        }
    }

    public TopicDeletionManager(KafkaConfig config, ControllerContext controllerContext, ReplicaStateMachine replicaStateMachine, PartitionStateMachine partitionStateMachine, DeletionClient client, Option<TierTopicManager> tierTopicManagerOpt) {
        this.config = config;
        this.kafka$controller$TopicDeletionManager$$controllerContext = controllerContext;
        this.replicaStateMachine = replicaStateMachine;
        this.partitionStateMachine = partitionStateMachine;
        this.kafka$controller$TopicDeletionManager$$client = client;
        this.tierTopicManagerOpt = tierTopicManagerOpt;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[Topic Deletion Manager ", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokerId())})));
        this.isDeleteTopicEnabled = Predef$.MODULE$.Boolean2boolean(config.deleteTopicEnable());
    }
}

