/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.typesafe.scalalogging.Logger;
import kafka.controller.ControllerContext;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.TopicPartition;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000193Q!\u0001\u0002\u0002\u0002\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003E\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\t\u0003/ai\u0011AA\u0005\u00033\t\u0011\u0011cQ8oiJ|G\u000e\\3s\u0007>tG/\u001a=u\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\u0011QD\b\t\u0003/\u0001AQ!\u0006\u000eA\u0002YAQ\u0001\t\u0001\u0005\u0002\u0005\nqa\u001d;beR,\b\u000fF\u0001#!\tI1%\u0003\u0002%\u0015\t!QK\\5u\u0011\u00151\u0003\u0001\"\u0001\"\u0003!\u0019\b.\u001e;e_^t\u0007\"\u0002\u0015\u0001\t\u0013\t\u0013AF5oSRL\u0017\r\\5{KJ+\u0007\u000f\\5dCN#\u0018\r^3\t\u000b)\u0002a\u0011A\u0016\u0002%!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u000b\u0005E1:D\bC\u0003.S\u0001\u0007a&\u0001\u0005sKBd\u0017nY1t!\ry#\u0007N\u0007\u0002a)\u0011\u0011GC\u0001\u000bG>dG.Z2uS>t\u0017BA\u001a1\u0005\r\u0019V-\u001d\t\u0003/UJ!A\u000e\u0002\u0003'A\u000b'\u000f^5uS>t\u0017I\u001c3SKBd\u0017nY1\t\u000baJ\u0003\u0019A\u001d\u0002\u0017Q\f'oZ3u'R\fG/\u001a\t\u0003/iJ!a\u000f\u0002\u0003\u0019I+\u0007\u000f\\5dCN#\u0018\r^3\t\u000fuJ\u0003\u0013!a\u0001}\u0005\u00192m\u001c8uC&t7/\u00117m%\u0016\u0004H.[2bgB\u0011\u0011bP\u0005\u0003\u0001*\u0011qAQ8pY\u0016\fg\u000eC\u0004C\u0001E\u0005I\u0011A\"\u00029!\fg\u000e\u001a7f'R\fG/Z\"iC:<Wm\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\tAI\u000b\u0002?\u000b.\na\t\u0005\u0002H\u00196\t\u0001J\u0003\u0002J\u0015\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u0017*\t!\"\u00198o_R\fG/[8o\u0013\ti\u0005JA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public abstract class ReplicaStateMachine
implements Logging {
    public final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Initializing replica state";
            }
        });
        this.initializeReplicaState();
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Triggering online replica state changes";
            }
        });
        Tuple2<Set<PartitionAndReplica>, Set<PartitionAndReplica>> tuple2 = this.kafka$controller$ReplicaStateMachine$$controllerContext.onlineAndOfflineReplicas();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Set onlineReplicas = (Set)tuple2._1();
            Set offlineReplicas = (Set)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)onlineReplicas, (Object)offlineReplicas);
            Set onlineReplicas2 = (Set)tuple23._1();
            Set offlineReplicas2 = (Set)tuple23._2();
            this.handleStateChanges((Seq<PartitionAndReplica>)onlineReplicas2.toSeq(), OnlineReplica$.MODULE$, true);
            this.info((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Triggering offline replica state changes";
                }
            });
            this.handleStateChanges((Seq<PartitionAndReplica>)offlineReplicas2.toSeq(), OfflineReplica$.MODULE$, this.handleStateChanges$default$3());
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaStateMachine $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Started replica state machine with initial state -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.replicaStates()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            return;
        }
        throw new MatchError(tuple2);
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Stopped replica state machine";
            }
        });
    }

    private void initializeReplicaState() {
        this.kafka$controller$ReplicaStateMachine$$controllerContext.allPartitions().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaStateMachine $outer;

            public final void apply(TopicPartition partition) {
                Seq<Object> replicas = this.$outer.kafka$controller$ReplicaStateMachine$$controllerContext.partitionReplicaAssignment(partition);
                replicas.foreach((Function1)new Serializable(this, partition){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$initializeReplicaState$1 $outer;
                    private final TopicPartition partition$4;

                    public final void apply(int replicaId) {
                        this.apply$mcVI$sp(replicaId);
                    }

                    public void apply$mcVI$sp(int replicaId) {
                        PartitionAndReplica partitionAndReplica = new PartitionAndReplica(this.partition$4, replicaId);
                        if (this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext.isReplicaOnline(replicaId, this.partition$4, this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext.isReplicaOnline$default$3())) {
                            this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext.putReplicaState(partitionAndReplica, OnlineReplica$.MODULE$);
                        } else {
                            this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext.putReplicaState(partitionAndReplica, ReplicaDeletionIneligible$.MODULE$);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.partition$4 = partition$4;
                    }
                });
            }

            public /* synthetic */ ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public abstract void handleStateChanges(Seq<PartitionAndReplica> var1, ReplicaState var2, boolean var3);

    public boolean handleStateChanges$default$3() {
        return false;
    }

    public ReplicaStateMachine(ControllerContext controllerContext) {
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controllerContext;
        Logging$class.$init$(this);
    }
}

