/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.util.List;
import java.util.Optional;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Observer$;
import kafka.cluster.Observer$$anonfun$validateAssignment$1$;
import kafka.cluster.Observer$$anonfun$validateReassignment$1$;
import kafka.common.TopicPlacement;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Observer$ {
    public static final Observer$ MODULE$;

    static {
        new Observer$();
    }

    public Map<Object, ReplicaAssignment> getReplicaAssignment(Seq<BrokerMetadata> brokers, Option<TopicPlacement> topicPlacement, int numPartitions2, int replicationFactor, int fixedStartIndex, int startPartitionId) {
        Tuple2 tuple2 = (Tuple2)topicPlacement.map((Function1)new Serializable(brokers){
            public static final long serialVersionUID = 0L;
            private final Seq brokers$1;

            public final Tuple2<Seq<Tuple2<Object, Seq<BrokerMetadata>>>, Seq<Tuple2<Object, Seq<BrokerMetadata>>>> apply(TopicPlacement topicPlacement) {
                return new Tuple2(Observer$.MODULE$.partitionBrokersByConstraint((Seq<BrokerMetadata>)this.brokers$1, (Seq<TopicPlacement.ConstraintCount>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.replicas()).asScala())), Observer$.MODULE$.partitionBrokersByConstraint((Seq<BrokerMetadata>)this.brokers$1, (Seq<TopicPlacement.ConstraintCount>)((Seq)JavaConverters$.MODULE$.asScalaBufferConverter(topicPlacement.observers()).asScala())));
            }
            {
                this.brokers$1 = brokers$1;
            }
        }).getOrElse((Function0)new Serializable(brokers, replicationFactor){
            public static final long serialVersionUID = 0L;
            private final Seq brokers$1;
            private final int replicationFactor$1;

            public final Tuple2<Seq<Tuple2<Object, Seq<BrokerMetadata>>>, Seq<Nothing$>> apply() {
                return new Tuple2((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.replicationFactor$1)), (Object)this.brokers$1)})), (Object)Seq$.MODULE$.empty());
            }
            {
                this.brokers$1 = brokers$1;
                this.replicationFactor$1 = replicationFactor$1;
            }
        });
        if (tuple2 != null) {
            Tuple2 tuple22;
            Seq replicationAndSyncEligible = (Seq)tuple2._1();
            Seq replicationAndObserverEligible = (Seq)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)replicationAndSyncEligible, (Object)replicationAndObserverEligible);
            Seq replicationAndSyncEligible2 = (Seq)tuple23._1();
            Seq replicationAndObserverEligible2 = (Seq)tuple23._2();
            this.validatePartitioning((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)((Seq)replicationAndSyncEligible2.$plus$plus((GenTraversableOnce)replicationAndObserverEligible2, Seq$.MODULE$.canBuildFrom())));
            return this.partitionReplicaAssignment((Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndSyncEligible2, numPartitions2, fixedStartIndex, startPartitionId), (Map<Object, Seq<Object>>)this.assignReplicasToPartitions((Seq<Tuple2<Object, Seq<BrokerMetadata>>>)replicationAndObserverEligible2, numPartitions2, fixedStartIndex, startPartitionId));
        }
        throw new MatchError((Object)tuple2);
    }

    public int getReplicaAssignment$default$5() {
        return -1;
    }

    public int getReplicaAssignment$default$6() {
        return -1;
    }

    private scala.collection.mutable.Map<Object, Seq<Object>> assignReplicasToPartitions(Seq<Tuple2<Object, Seq<BrokerMetadata>>> replicationAndBrokers, int partitions, int fixedStartIndex, int startPartitionId) {
        return (scala.collection.mutable.Map)((TraversableOnce)replicationAndBrokers.map((Function1)new Serializable(partitions, fixedStartIndex, startPartitionId){
            public static final long serialVersionUID = 0L;
            private final int partitions$1;
            private final int fixedStartIndex$1;
            private final int startPartitionId$1;

            public final Map<Object, Seq<Object>> apply(Tuple2<Object, Seq<BrokerMetadata>> x0$1) {
                Tuple2<Object, Seq<BrokerMetadata>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int replication = tuple2._1$mcI$sp();
                    Seq brokerList = (Seq)tuple2._2();
                    Map<Object, Seq<Object>> map = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokerList, this.partitions$1, replication, this.fixedStartIndex$1, this.startPartitionId$1);
                    return map;
                }
                throw new MatchError(tuple2);
            }
            {
                this.partitions$1 = partitions$1;
                this.fixedStartIndex$1 = fixedStartIndex$1;
                this.startPartitionId$1 = startPartitionId$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Map$.MODULE$.empty(), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.mutable.Map<Object, Seq<Object>> apply(scala.collection.mutable.Map<Object, Seq<Object>> mergedAssignment, Map<Object, Seq<Object>> currentAssignment) {
                return Observer$.MODULE$.mergeAssignmentMap(mergedAssignment, currentAssignment);
            }
        });
    }

    private Map<Object, ReplicaAssignment> partitionReplicaAssignment(Map<Object, Seq<Object>> syncReplicas, Map<Object, Seq<Object>> observerReplicas) {
        if (observerReplicas.nonEmpty()) {
            Set set = syncReplicas.keySet();
            Set set2 = observerReplicas.keySet();
            if (set == null ? set2 != null : !set.equals(set2)) {
                int syncSize = syncReplicas.keySet().size();
                int observerSize = observerReplicas.keySet().size();
                throw new InvalidConfigurationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Must assign observers to all or none of the partitions. ", " partitions with sync replicas. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)syncSize)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " partitions with observers."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)observerSize)}))).toString());
            }
        }
        return (Map)syncReplicas.map((Function1)new Serializable(observerReplicas){
            public static final long serialVersionUID = 0L;
            private final Map observerReplicas$1;

            public final Tuple2<Object, ReplicaAssignment> apply(Tuple2<Object, Seq<Object>> x0$2) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$2;
                if (tuple2 != null) {
                    int partition = tuple2._1$mcI$sp();
                    Seq replicas = (Seq)tuple2._2();
                    Seq observerAssignment = (Seq)this.observerReplicas$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)partition), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Nothing$> apply() {
                            return (Seq)Seq$.MODULE$.empty();
                        }
                    });
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)((Seq)replicas.$plus$plus((GenTraversableOnce)observerAssignment, Seq$.MODULE$.canBuildFrom())), (Seq<Object>)observerAssignment));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.observerReplicas$1 = observerReplicas$1;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionBrokersByConstraint(Seq<BrokerMetadata> brokers, Seq<TopicPlacement.ConstraintCount> constraints) {
        return (Seq)constraints.map((Function1)new Serializable(brokers){
            public static final long serialVersionUID = 0L;
            private final Seq brokers$2;

            public final Tuple2<Object, Seq<BrokerMetadata>> apply(TopicPlacement.ConstraintCount constraint) {
                Seq matchedBrokers = (Seq)this.brokers$2.filter((Function1)new Serializable(this, constraint){
                    public static final long serialVersionUID = 0L;
                    private final TopicPlacement.ConstraintCount constraint$1;

                    public final boolean apply(BrokerMetadata broker) {
                        return Observer$.MODULE$.brokerMatchesPlacementConstraint(broker, this.constraint$1);
                    }
                    {
                        this.constraint$1 = constraint$1;
                    }
                });
                if (matchedBrokers.size() < constraint.count()) {
                    throw new InvalidConfigurationException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Number of broker found (", ") matching "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)matchedBrokers.size())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"constraint ", " is less than required count ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{constraint, BoxesRunTime.boxToInteger((int)constraint.count())}))).toString());
                }
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)constraint.count()), (Object)matchedBrokers);
            }
            {
                this.brokers$2 = brokers$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void validatePartitioning(Seq<Tuple2<Object, Seq<BrokerMetadata>>> partitionedBrokers) {
        Tuple2 tuple2 = (Tuple2)partitionedBrokers.foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)Predef$.MODULE$.Set().empty()), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, scala.collection.immutable.Set<BrokerMetadata>> apply(Tuple2<Object, scala.collection.immutable.Set<BrokerMetadata>> acc, Tuple2<Object, Seq<BrokerMetadata>> current) {
                Tuple2<Object, scala.collection.immutable.Set<BrokerMetadata>> tuple2 = acc;
                if (tuple2 != null) {
                    Tuple2 tuple22;
                    int count = tuple2._1$mcI$sp();
                    scala.collection.immutable.Set allBrokers = (scala.collection.immutable.Set)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)count), (Object)allBrokers);
                    int count2 = tuple23._1$mcI$sp();
                    scala.collection.immutable.Set allBrokers2 = (scala.collection.immutable.Set)tuple23._2();
                    Tuple2<Object, Seq<BrokerMetadata>> tuple24 = current;
                    if (tuple24 != null) {
                        Seq brokers = (Seq)tuple24._2();
                        Seq seq = brokers;
                        Seq brokers2 = seq;
                        if (brokers2.toSet().size() != brokers2.size()) {
                            throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate eligible brokers ", " match a placement constraints."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{brokers2})));
                        }
                        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)(count2 + brokers2.size())), (Object)allBrokers2.$plus$plus((GenTraversableOnce)brokers2));
                    }
                    throw new MatchError(tuple24);
                }
                throw new MatchError(tuple2);
            }
        });
        if (tuple2 != null) {
            scala.collection.immutable.Set allBrokers;
            int count = tuple2._1$mcI$sp();
            scala.collection.immutable.Set allBrokers2 = (scala.collection.immutable.Set)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)count), (Object)allBrokers2);
            Tuple2 tuple23 = tuple22;
            int count2 = tuple23._1$mcI$sp();
            if (count2 != (allBrokers = (scala.collection.immutable.Set)tuple23._2()).size()) {
                throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some brokers satisfy more than one placement constraints: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionedBrokers})));
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public scala.collection.mutable.Map<Object, Seq<Object>> mergeAssignmentMap(scala.collection.mutable.Map<Object, Seq<Object>> mergedAssignment, Map<Object, Seq<Object>> currentAssignment) {
        return mergedAssignment.$plus$plus((GenTraversableOnce)currentAssignment.map((Function1)new Serializable(mergedAssignment){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map mergedAssignment$1;

            public final Tuple2<Object, Seq<Object>> apply(Tuple2<Object, Seq<Object>> x0$3) {
                Tuple2<Object, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    int partitionId = tuple2._1$mcI$sp();
                    Seq replicaIds = (Seq)tuple2._2();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), Observer$.MODULE$.mergeReplicaLists((Seq<Object>)((Seq)this.mergedAssignment$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)partitionId), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<Nothing$> apply() {
                            return (Seq)Seq$.MODULE$.empty();
                        }
                    })), (Seq<Object>)replicaIds));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.mergedAssignment$1 = mergedAssignment$1;
            }
        }, scala.collection.Map$.MODULE$.canBuildFrom()));
    }

    public Seq<Object> mergeReplicaLists(Seq<Object> brokerList1, Seq<Object> brokerList2) {
        SeqView commonReplicas = brokerList1.view().intersect(brokerList2);
        if (commonReplicas.nonEmpty()) {
            throw new InvalidConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replica with ids (", ") satisfy more than one placement constraints."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{commonReplicas.force(Seq$.MODULE$.canBuildFrom())})));
        }
        return (Seq)brokerList1.$plus$plus(brokerList2, Seq$.MODULE$.canBuildFrom());
    }

    public boolean brokerMatchesPlacementConstraint(BrokerMetadata broker, TopicPlacement.ConstraintCount constraint) {
        scala.collection.immutable.Map properties = Option$.MODULE$.option2Iterable(broker.rack().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(String rack) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rack"), (Object)rack);
            }
        })).toMap(Predef$.MODULE$.$conforms());
        return constraint.matches((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)properties).asJava());
    }

    public Option<ApiError> validateAssignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment.Assignment assignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return this.validateAssignmentStructure(assignment).orElse((Function0)new Serializable(topicPlacement, assignment, liveBrokerAttributes){
            public static final long serialVersionUID = 0L;
            private final Option topicPlacement$1;
            public final ReplicaAssignment.Assignment assignment$1;
            public final Map liveBrokerAttributes$1;

            public final Option<ApiError> apply() {
                return this.topicPlacement$1.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.validateAssignment.1 $outer;

                    public final Option<ApiError> apply(TopicPlacement placementConstraint) {
                        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.$outer.assignment$1.syncReplicas().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$validateAssignment$1$$anonfun$apply$2 $outer;

                            public final TopicPlacement.Replica apply(int id) {
                                return TopicPlacement.Replica.of(id, Optional.of(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.$outer.kafka$cluster$Observer$$anonfun$$anonfun$$$outer().liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final scala.collection.immutable.Map<String, Nothing$> apply() {
                                        return scala.collection.Map$.MODULE$.empty();
                                    }
                                })).asJava()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.$outer.assignment$1.observers().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$validateAssignment$1$$anonfun$apply$2 $outer;

                            public final TopicPlacement.Replica apply(int id) {
                                return TopicPlacement.Replica.of(id, Optional.of(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.$outer.kafka$cluster$Observer$$anonfun$$anonfun$$$outer().liveBrokerAttributes$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final scala.collection.immutable.Map<String, Nothing$> apply() {
                                        return scala.collection.Map$.MODULE$.empty();
                                    }
                                })).asJava()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava()))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ApiError apply(String message) {
                                return new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message);
                            }
                        });
                    }

                    public /* synthetic */ anonfun.validateAssignment.1 kafka$cluster$Observer$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topicPlacement$1 = topicPlacement$1;
                this.assignment$1 = assignment$1;
                this.liveBrokerAttributes$1 = liveBrokerAttributes$1;
            }
        });
    }

    public Option<ApiError> validateAssignmentStructure(ReplicaAssignment.Assignment assignment) {
        Some some;
        Seq<Object> replicas = assignment.replicas();
        scala.collection.immutable.Set replicaSet = replicas.toSet();
        if (replicas.isEmpty() || replicas.size() != replicaSet.size()) {
            some = new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Duplicate replicas not allowed in partition assignment: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(", ")}))));
        } else if (replicas.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return x$4 < 0;
            }
        })) {
            some = new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid replica id in partition assignment: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replicas.mkString(", ")}))));
        } else if (assignment.replicas().endsWith(assignment.observers())) {
            some = None$.MODULE$;
        } else {
            String observerMsg = assignment.observers().mkString(", ");
            some = new Some((Object)new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Assignment contains observers (", ") and the replicas' (", ") "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{observerMsg, replicas.mkString(", ")}))).append((Object)"suffix doesn't match observers.").toString()));
        }
        return some;
    }

    public Option<ApiError> validateReassignment(Option<TopicPlacement> topicPlacement, ReplicaAssignment reassignment, Map<Object, Map<String, String>> liveBrokerAttributes) {
        return reassignment.targetAssignment().flatMap((Function1)new Serializable(topicPlacement, reassignment, liveBrokerAttributes){
            public static final long serialVersionUID = 0L;
            private final Option topicPlacement$2;
            public final ReplicaAssignment reassignment$1;
            public final Map liveBrokerAttributes$2;

            public final Option<ApiError> apply(ReplicaAssignment.Assignment assignment) {
                return this.topicPlacement$2.flatMap((Function1)new Serializable(this, assignment){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.validateReassignment.1 $outer;
                    private final ReplicaAssignment.Assignment assignment$2;

                    public final Option<ApiError> apply(TopicPlacement placementConstraint) {
                        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(TopicPlacement.validateAssignment(placementConstraint, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.assignment$2.syncReplicas().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$validateReassignment$1$$anonfun$apply$8 $outer;

                            public final TopicPlacement.Replica apply(int id) {
                                return TopicPlacement.Replica.of(id, Optional.of(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)this.$outer.kafka$cluster$Observer$$anonfun$$anonfun$$$outer().liveBrokerAttributes$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)id), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final scala.collection.immutable.Map<String, Nothing$> apply() {
                                        return scala.collection.Map$.MODULE$.empty();
                                    }
                                })).asJava()));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.assignment$2.observers().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$validateReassignment$1$$anonfun$apply$8 $outer;

                            public final TopicPlacement.Replica apply(int id) {
                                Option attributes = this.$outer.kafka$cluster$Observer$$anonfun$$anonfun$$$outer().liveBrokerAttributes$2.get((Object)BoxesRunTime.boxToInteger((int)id));
                                Option attributes2 = this.$outer.kafka$cluster$Observer$$anonfun$$anonfun$$$outer().reassignment$1.originAssignment().replicas().contains((Object)BoxesRunTime.boxToInteger((int)id)) ? attributes : attributes.orElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Some<scala.collection.immutable.Map<String, Nothing$>> apply() {
                                        return new Some((Object)scala.collection.Map$.MODULE$.empty());
                                    }
                                });
                                return TopicPlacement.Replica.of(id, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(attributes2.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final java.util.Map<String, String> apply(Map<String, String> x$5) {
                                        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(x$5).asJava();
                                    }
                                }))));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).asJava()))).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final ApiError apply(String message) {
                                return new ApiError(Errors.INVALID_REPLICA_ASSIGNMENT, message);
                            }
                        });
                    }

                    public /* synthetic */ anonfun.validateReassignment.1 kafka$cluster$Observer$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.assignment$2 = assignment$2;
                    }
                });
            }
            {
                this.topicPlacement$2 = topicPlacement$2;
                this.reassignment$1 = reassignment$1;
                this.liveBrokerAttributes$2 = liveBrokerAttributes$2;
            }
        });
    }

    private Observer$() {
        MODULE$ = this;
    }
}

