/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.ZkSecurityMigrator;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.client.ZKClientConfig;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ZkSecurityMigrator$
implements Logging {
    public static final ZkSecurityMigrator$ MODULE$;
    private final String usageMessage;
    private final String tlsConfigFileOption;
    private final Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ZkSecurityMigrator$();
    }

    private Logger logger$lzycompute() {
        ZkSecurityMigrator$ zkSecurityMigrator$ = this;
        synchronized (zkSecurityMigrator$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return Logging$class.loggerName(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String usageMessage() {
        return this.usageMessage;
    }

    public String tlsConfigFileOption() {
        return this.tlsConfigFileOption;
    }

    /*
     * WARNING - void declaration
     */
    public void run(String[] args) {
        void var2_2;
        block4: {
            void var3_3;
            block7: {
                boolean bl;
                ZKClientConfig zkClientConfig;
                ZkSecurityMigrator.ZkSecurityMigratorOptions opts;
                block6: {
                    String string;
                    block5: {
                        String jaasFile = System.getProperty("java.security.auth.login.config");
                        opts = new ZkSecurityMigrator.ZkSecurityMigratorOptions(args);
                        CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, this.usageMessage());
                        zkClientConfig = (ZKClientConfig)this.createZkClientConfigFromOption(opts.options(), opts.zkTlsConfigFile()).getOrElse((Function0)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final ZKClientConfig apply() {
                                return new ZKClientConfig();
                            }
                        });
                        boolean tlsClientAuthEnabled = KafkaConfig$.MODULE$.zkTlsClientAuthEnabled(zkClientConfig);
                        if (jaasFile == null && !tlsClientAuthEnabled) {
                            String errorMsg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No JAAS configuration file has been specified and no TLS client certificate has been specified. Please make sure that you set "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the system property ", " or provide a ZooKeeper client TLS configuration via --", " <filename> "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"java.security.auth.login.config", this.tlsConfigFileOption()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"identifying at least ", ", ", ", and ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{KafkaConfig$.MODULE$.ZkSslClientEnableProp(), KafkaConfig$.MODULE$.ZkClientCnxnSocketProp(), KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()}))).toString();
                            System.err.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
                            throw new IllegalArgumentException("Incorrect configuration");
                        }
                        if (!tlsClientAuthEnabled && !JaasUtils.isZkSaslEnabled()) break block4;
                        string = (String)opts.options().valueOf(opts.zkAclOpt());
                        if (!"secure".equals(string)) break block5;
                        this.info((Function0<String>)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "zookeeper.acl option is secure";
                            }
                        });
                        bl = true;
                        break block6;
                    }
                    if (!"unsecure".equals(string)) break block7;
                    this.info((Function0<String>)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "zookeeper.acl option is unsecure";
                        }
                    });
                    bl = false;
                }
                boolean zkAcl = bl;
                String zkUrl = (String)opts.options().valueOf(opts.zkUrlOpt());
                int zkSessionTimeout = (Integer)opts.options().valueOf(opts.zkSessionTimeoutOpt());
                int zkConnectionTimeout = (Integer)opts.options().valueOf(opts.zkConnectionTimeoutOpt());
                String x$1 = zkUrl;
                boolean x$2 = zkAcl;
                int x$3 = zkSessionTimeout;
                int x$4 = zkConnectionTimeout;
                int x$5 = Integer.MAX_VALUE;
                Time x$6 = Time.SYSTEM;
                Some x$7 = new Some((Object)zkClientConfig);
                String x$8 = KafkaZkClient$.MODULE$.apply$default$7();
                String x$9 = KafkaZkClient$.MODULE$.apply$default$8();
                Option<String> x$10 = KafkaZkClient$.MODULE$.apply$default$9();
                KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$9, x$10, (Option<ZKClientConfig>)x$7);
                boolean enablePathCheck = opts.options().has((OptionSpec)opts.enablePathCheckOpt());
                ZkSecurityMigrator migrator = new ZkSecurityMigrator(zkClient);
                migrator.kafka$admin$ZkSecurityMigrator$$run(enablePathCheck);
                return;
            }
            throw CommandLineUtils$.MODULE$.printUsageAndDie(var3_3.parser(), this.usageMessage());
        }
        String errorMsg = new StringOps(Predef$.MODULE$.augmentString("Security isn't enabled, most likely the file isn't set properly: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2}));
        System.out.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errorMsg})));
        throw new IllegalArgumentException("Incorrect configuration");
    }

    public void main(String[] args) {
        try {
            this.run(args);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZKClientConfig createZkClientConfigFromFile(String filename) {
        void var3_3;
        Properties zkTlsConfigFileProps = Utils.loadProps((String)filename, (List)((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().toList()).asJava()));
        ZKClientConfig zkClientConfig = new ZKClientConfig();
        this.info((Function0<String>)new Serializable(filename, zkTlsConfigFileProps){
            public static final long serialVersionUID = 0L;
            private final String filename$1;
            private final Properties zkTlsConfigFileProps$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " ZooKeeper client configuration properties in file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.zkTlsConfigFileProps$1.size()), this.filename$1}));
            }
            {
                this.filename$1 = filename$1;
                this.zkTlsConfigFileProps$1 = zkTlsConfigFileProps$1;
            }
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(zkTlsConfigFileProps.entrySet()).asScala()).foreach((Function1)new Serializable(zkClientConfig){
            public static final long serialVersionUID = 0L;
            private final ZKClientConfig zkClientConfig$1;

            public final void apply(Map.Entry<Object, Object> entry2) {
                String key = entry2.getKey().toString();
                ZkSecurityMigrator$.MODULE$.info((Function0<String>)new Serializable(this, key){
                    public static final long serialVersionUID = 0L;
                    private final String key$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Setting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$1}));
                    }
                    {
                        this.key$1 = key$1;
                    }
                });
                KafkaConfig$.MODULE$.setZooKeeperClientProperty(this.zkClientConfig$1, key, entry2.getValue().toString());
            }
            {
                this.zkClientConfig$1 = zkClientConfig$1;
            }
        });
        return var3_3;
    }

    public Option<ZKClientConfig> createZkClientConfigFromOption(OptionSet options, ArgumentAcceptingOptionSpec<String> option) {
        return options.has(option) ? new Some((Object)this.createZkClientConfigFromFile((String)options.valueOf(option))) : None$.MODULE$;
    }

    private ZkSecurityMigrator$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.usageMessage = "ZooKeeper Migration Tool Help. This tool updates the ACLs of znodes as part of the process of setting up ZooKeeper authentication.";
        this.tlsConfigFileOption = "zk-tls-config-file";
    }
}

