/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.ClientTagAwareStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.DefaultStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignorFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class StandbyTaskAssignorFactoryTest {
    @Rule
    public MockitoRule rule = MockitoJUnit.rule().strictness(Strictness.LENIENT);
    private static final long ACCEPTABLE_RECOVERY_LAG = 0L;
    private static final int MAX_WARMUP_REPLICAS = 1;
    private static final int NUMBER_OF_STANDBY_REPLICAS = 1;
    private static final long PROBING_REBALANCE_INTERVAL_MS = 60000L;
    private RackAwareTaskAssignor rackAwareTaskAssignor;
    @Parameterized.Parameter
    public State state;

    @Parameterized.Parameters(name="RackAwareTaskAssignor={0}")
    public static Collection<State> parameters() {
        return Arrays.asList(State.DISABLED, State.ENABLED, State.NULL);
    }

    @Before
    public void setUp() {
        if (this.state == State.ENABLED) {
            this.rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.mock(RackAwareTaskAssignor.class);
            Mockito.when((Object)this.rackAwareTaskAssignor.validClientRack()).thenReturn((Object)true);
        } else if (this.state == State.DISABLED) {
            this.rackAwareTaskAssignor = (RackAwareTaskAssignor)Mockito.mock(RackAwareTaskAssignor.class);
            Mockito.when((Object)this.rackAwareTaskAssignor.validClientRack()).thenReturn((Object)false);
        } else {
            this.rackAwareTaskAssignor = null;
        }
    }

    @Test
    public void shouldReturnClientTagAwareStandbyTaskAssignorWhenRackAwareAssignmentTagsIsSet() {
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignorConfiguration.AssignmentConfigs)StandbyTaskAssignorFactoryTest.newAssignmentConfigs(Collections.singletonList("az")), (RackAwareTaskAssignor)this.rackAwareTaskAssignor);
        Assert.assertTrue((boolean)(standbyTaskAssignor instanceof ClientTagAwareStandbyTaskAssignor));
        if (this.state != State.NULL) {
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.never())).racksForProcess();
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.never())).validClientRack();
        }
    }

    @Test
    public void shouldReturnDefaultOrRackAwareStandbyTaskAssignorWhenRackAwareAssignmentTagsIsEmpty() {
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignorConfiguration.AssignmentConfigs)StandbyTaskAssignorFactoryTest.newAssignmentConfigs(Collections.emptyList()), (RackAwareTaskAssignor)this.rackAwareTaskAssignor);
        if (this.state == State.ENABLED) {
            Assert.assertTrue((boolean)(standbyTaskAssignor instanceof ClientTagAwareStandbyTaskAssignor));
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.times((int)1))).racksForProcess();
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.times((int)1))).validClientRack();
        } else if (this.state == State.DISABLED) {
            Assert.assertTrue((boolean)(standbyTaskAssignor instanceof DefaultStandbyTaskAssignor));
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.never())).racksForProcess();
            ((RackAwareTaskAssignor)Mockito.verify((Object)this.rackAwareTaskAssignor, (VerificationMode)Mockito.times((int)1))).validClientRack();
        } else {
            Assert.assertTrue((boolean)(standbyTaskAssignor instanceof DefaultStandbyTaskAssignor));
        }
    }

    private static AssignorConfiguration.AssignmentConfigs newAssignmentConfigs(List<String> rackAwareAssignmentTags) {
        return new AssignorConfiguration.AssignmentConfigs(Long.valueOf(0L), Integer.valueOf(1), Integer.valueOf(1), Long.valueOf(60000L), rackAwareAssignmentTags);
    }

    static enum State {
        DISABLED,
        ENABLED,
        NULL;

    }
}

