/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.InternalTopicManager;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.apache.kafka.streams.processor.internals.assignment.AssignorConfiguration;
import org.apache.kafka.streams.processor.internals.assignment.ClientState;
import org.apache.kafka.streams.processor.internals.assignment.ClientTagAwareStandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.RackAwareTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignor;
import org.apache.kafka.streams.processor.internals.assignment.StandbyTaskAssignorFactory;
import org.apache.kafka.test.MockClientSupplier;
import org.apache.kafka.test.MockInternalTopicManager;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class RackAwareTaskAssignorTest {
    private final MockTime time = new MockTime();
    private final StreamsConfig streamsConfig = new StreamsConfig(AssignmentTestUtils.configProps(true));
    private final MockClientSupplier mockClientSupplier = new MockClientSupplier();
    private int trafficCost;
    private int nonOverlapCost;
    @Parameterized.Parameter
    public boolean stateful;
    private final MockInternalTopicManager mockInternalTopicManager;

    public RackAwareTaskAssignorTest() {
        this.mockInternalTopicManager = new MockInternalTopicManager((Time)this.time, this.streamsConfig, this.mockClientSupplier.restoreConsumer, false);
    }

    @Parameterized.Parameters(name="stateful={0}")
    public static Collection<Object[]> getParamStoreType() {
        return Arrays.asList({true}, {false});
    }

    @Before
    public void setUp() {
        if (this.stateful) {
            this.trafficCost = 10;
            this.nonOverlapCost = 1;
        } else {
            this.trafficCost = 1;
            this.nonOverlapCost = 0;
        }
    }

    private AssignorConfiguration.AssignmentConfigs getRackAwareEnabledConfig() {
        return new AssignorConfiguration(new StreamsConfig(AssignmentTestUtils.configProps(true)).originals()).assignmentConfigs();
    }

    private AssignorConfiguration.AssignmentConfigs getRackAwareEnabledConfigWithStandby(int replicaNum) {
        return new AssignorConfiguration(new StreamsConfig(AssignmentTestUtils.configProps(true, replicaNum)).originals()).assignmentConfigs();
    }

    private AssignorConfiguration.AssignmentConfigs getRackAwareDisabledConfig() {
        return new AssignorConfiguration(new StreamsConfig(AssignmentTestUtils.configProps(false)).originals()).assignmentConfigs();
    }

    @Test
    public void shouldDisableAssignorFromConfig() {
        RackAwareTaskAssignor assignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(true), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareDisabledConfig(), (Time)this.time));
        Assert.assertFalse((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.never())).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.never())).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void shouldDisableActiveWhenMissingClusterInfo() {
        RackAwareTaskAssignor assignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(true), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time));
        Assert.assertFalse((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.never())).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)true));
        Assert.assertFalse((boolean)assignor.populateTopicsToDescribe(new HashSet(), false));
    }

    @Test
    public void shouldDisableActiveWhenRackMissingInNode() {
        RackAwareTaskAssignor assignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(this.getClusterWithPartitionMissingRack(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time));
        Assert.assertFalse((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.never())).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)true));
        Assert.assertFalse((boolean)assignor.populateTopicsToDescribe(new HashSet(), false));
    }

    @Test
    public void shouldReturnInvalidClientRackWhenRackMissingInClientConsumer() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(true), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        Assert.assertFalse((boolean)assignor.validClientRack());
    }

    @Test
    public void shouldReturnFalseWhenRackMissingInProcess() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessWithNoConsumerRacks(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        Assert.assertFalse((boolean)assignor.validClientRack());
    }

    @Test
    public void shouldPopulateRacksForProcess() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        Map racksForProcess = assignor.racksForProcess();
        Assert.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)"rack1")}), (Object)racksForProcess);
    }

    @Test
    public void shouldReturnInvalidClientRackWhenRackDiffersInSameProcess() {
        HashMap<UUID, Map> processRacks = new HashMap<UUID, Map>();
        processRacks.computeIfAbsent(AssignmentTestUtils.UUID_1, k -> new HashMap()).put("consumer1", Optional.of("rack1"));
        processRacks.computeIfAbsent(AssignmentTestUtils.UUID_1, k -> new HashMap()).put("consumer2", Optional.of("rack2"));
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), processRacks, (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        Assert.assertFalse((boolean)assignor.validClientRack());
    }

    @Test
    public void shouldEnableRackAwareAssignorWithoutDescribingTopics() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
    }

    @Test
    public void shouldEnableRackAwareAssignorWithCacheResult() {
        RackAwareTaskAssignor assignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(this.getClusterForTopic0(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time));
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
        Mockito.reset((Object[])new RackAwareTaskAssignor[]{assignor});
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.never())).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void shouldEnableRackAwareAssignorWithDescribingTopics() {
        MockInternalTopicManager spyTopicManager = (MockInternalTopicManager)((Object)Mockito.spy((Object)((Object)this.mockInternalTopicManager)));
        ((MockInternalTopicManager)((Object)Mockito.doReturn(Collections.singletonMap("topic0", Collections.singletonList(new TopicPartitionInfo(0, AssignmentTestUtils.NODE_0, Arrays.asList(AssignmentTestUtils.REPLICA_1), Collections.emptyList())))).when((Object)spyTopicManager))).getTopicPartitionInfo(Collections.singleton("topic0"));
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(this.getClusterWithNoNode(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)spyTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
    }

    @Test
    public void shouldEnableRackAwareAssignorWithStandbyDescribingTopics() {
        MockInternalTopicManager spyTopicManager = (MockInternalTopicManager)((Object)Mockito.spy((Object)((Object)this.mockInternalTopicManager)));
        ((MockInternalTopicManager)((Object)Mockito.doReturn(Collections.singletonMap("topic0", Collections.singletonList(new TopicPartitionInfo(0, AssignmentTestUtils.NODE_0, Arrays.asList(AssignmentTestUtils.REPLICA_1), Collections.emptyList())))).when((Object)spyTopicManager))).getTopicPartitionInfo(Collections.singleton("topic0"));
        ((MockInternalTopicManager)((Object)Mockito.doReturn(Collections.singletonMap("store-0-changelog", Collections.singletonList(new TopicPartitionInfo(0, AssignmentTestUtils.NODE_0, Arrays.asList(AssignmentTestUtils.REPLICA_1), Collections.emptyList())))).when((Object)spyTopicManager))).getTopicPartitionInfo(Collections.singleton("store-0-changelog"));
        RackAwareTaskAssignor assignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(this.getClusterWithNoNode(), this.getTaskTopicPartitionMapForTask0(), this.getTaskChangeLogTopicPartitionMapForTask0(), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)spyTopicManager, this.getRackAwareEnabledConfigWithStandby(1), (Time)this.time));
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)true));
        Map racksForPartition = assignor.racksForPartition();
        Map expected = Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TP_0_0, (Object)Utils.mkSet((Object[])new String[]{"rack1", "rack2"})), Utils.mkEntry((Object)AssignmentTestUtils.CHANGELOG_TP_0_0, (Object)Utils.mkSet((Object[])new String[]{"rack1", "rack2"}))});
        Assert.assertEquals((Object)expected, (Object)racksForPartition);
    }

    @Test
    public void shouldDisableRackAwareAssignorWithStandbyDescribingTopicsFailure() {
        MockInternalTopicManager spyTopicManager = (MockInternalTopicManager)((Object)Mockito.spy((Object)((Object)this.mockInternalTopicManager)));
        ((MockInternalTopicManager)((Object)Mockito.doReturn(Collections.singletonMap("topic0", Collections.singletonList(new TopicPartitionInfo(0, AssignmentTestUtils.NODE_0, Arrays.asList(AssignmentTestUtils.REPLICA_1), Collections.emptyList())))).when((Object)spyTopicManager))).getTopicPartitionInfo(Collections.singleton("topic0"));
        ((MockInternalTopicManager)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException("Timeout describing topic")}).when((Object)spyTopicManager))).getTopicPartitionInfo(Collections.singleton("store-0-changelog"));
        RackAwareTaskAssignor assignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(this.getClusterWithNoNode(), this.getTaskTopicPartitionMapForTask0(), this.getTaskChangeLogTopicPartitionMapForTask0(), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)spyTopicManager, this.getRackAwareEnabledConfigWithStandby(1), (Time)this.time));
        Assert.assertFalse((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    public void shouldDisableRackAwareAssignorWithDescribingTopicsFailure() {
        MockInternalTopicManager spyTopicManager = (MockInternalTopicManager)((Object)Mockito.spy((Object)((Object)this.mockInternalTopicManager)));
        ((MockInternalTopicManager)((Object)Mockito.doThrow((Throwable[])new Throwable[]{new TimeoutException("Timeout describing topic")}).when((Object)spyTopicManager))).getTopicPartitionInfo(Collections.singleton("topic0"));
        RackAwareTaskAssignor assignor = (RackAwareTaskAssignor)Mockito.spy((Object)new RackAwareTaskAssignor(this.getClusterWithNoNode(), this.getTaskTopicPartitionMapForTask0(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), this.getProcessRacksForProcess0(), (InternalTopicManager)spyTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time));
        Assert.assertFalse((boolean)assignor.canEnableRackAwareAssignor());
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.times((int)1))).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)false));
        ((RackAwareTaskAssignor)Mockito.verify((Object)assignor, (VerificationMode)Mockito.never())).populateTopicsToDescribe(ArgumentMatchers.anySet(), ArgumentMatchers.eq((boolean)true));
        Assert.assertTrue((boolean)assignor.populateTopicsToDescribe(new HashSet(), false));
    }

    @Test
    public void shouldOptimizeEmptyActiveTasks() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState1.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}));
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)clientState1)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[0]);
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        long originalCost = assignor.activeTasksCost(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)0L, (long)originalCost);
        long cost = assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)0L, (long)cost);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}), (Object)clientState1.activeTasks());
    }

    @Test
    public void shouldOptimizeActiveTasks() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState1.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignActive(AssignmentTestUtils.TASK_1_0);
        clientState3.assignActive(AssignmentTestUtils.TASK_0_0);
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.UUID_3, (Object)clientState3)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1});
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        int expected = this.stateful ? 40 : 4;
        long originalCost = assignor.activeTasksCost(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)expected, (long)originalCost);
        expected = this.stateful ? 4 : 0;
        long cost = assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)expected, (long)cost);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0}), (Object)clientState1.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_1}), (Object)clientState2.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), (Object)clientState3.activeTasks());
    }

    @Test
    public void shouldOptimizeRandomActive() {
        int nodeSize = 30;
        int tpSize = 40;
        int partitionSize = 3;
        int clientSize = 30;
        SortedMap<TaskId, Set<TopicPartition>> taskTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(40, 3, false);
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getRandomCluster(30, 40, 3), taskTopicPartitionMap, Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getRandomProcessRacks(30, 30), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        SortedSet taskIds = (SortedSet)taskTopicPartitionMap.keySet();
        SortedMap<UUID, ClientState> clientStateMap = AssignmentTestUtils.getRandomClientState(30, 40, 3, 1, taskIds);
        Map<UUID, Integer> clientTaskCount = AssignmentTestUtils.clientTaskCount(clientStateMap, ClientState::activeTaskCount);
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        long originalCost = assignor.activeTasksCost(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        long cost = assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        MatcherAssert.assertThat((Object)cost, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(originalCost)));
        for (Map.Entry<UUID, ClientState> entry : clientStateMap.entrySet()) {
            Assert.assertEquals((long)clientTaskCount.get(entry.getKey()).intValue(), (long)entry.getValue().activeTasks().size());
        }
    }

    @Test
    public void shouldMaintainOriginalAssignment() {
        int nodeSize = 20;
        int tpSize = 40;
        int partitionSize = 3;
        int clientSize = 30;
        SortedMap<TaskId, Set<TopicPartition>> taskTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(40, 3, false);
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getRandomCluster(20, 40, 3), taskTopicPartitionMap, Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getRandomProcessRacks(30, 20), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        SortedSet taskIds = (SortedSet)taskTopicPartitionMap.keySet();
        SortedMap<UUID, ClientState> clientStateMap = AssignmentTestUtils.getRandomClientState(30, 40, 3, 1, taskIds);
        HashMap taskClientMap = new HashMap();
        for (Map.Entry<UUID, ClientState> entry : clientStateMap.entrySet()) {
            entry.getValue().activeTasks().forEach(t -> {
                UUID cfr_ignored_0 = (UUID)taskClientMap.put(t, entry.getKey());
            });
        }
        Assert.assertEquals((long)taskIds.size(), (long)taskClientMap.size());
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        long originalCost = assignor.activeTasksCost(taskIds, clientStateMap, 0, 1);
        Assert.assertEquals((long)0L, (long)originalCost);
        long cost = assignor.optimizeActiveTasks(taskIds, clientStateMap, 0, 1);
        Assert.assertEquals((long)0L, (long)cost);
        for (Map.Entry entry : taskClientMap.entrySet()) {
            ClientState clientState = (ClientState)clientStateMap.get(entry.getValue());
            Assert.assertTrue((boolean)clientState.hasAssignedTask((TaskId)entry.getKey()));
        }
    }

    @Test
    public void shouldOptimizeActiveTasksWithMoreClients() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState2.assignActive(AssignmentTestUtils.TASK_1_0);
        clientState3.assignActive(AssignmentTestUtils.TASK_0_0);
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.UUID_3, (Object)clientState3)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0});
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        long originalCost = assignor.activeTasksCost(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        int expected = this.stateful ? 20 : 2;
        Assert.assertEquals((long)expected, (long)originalCost);
        expected = this.stateful ? 2 : 0;
        long cost = assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)expected, (long)cost);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new Object[0]), (Object)clientState1.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0}), (Object)clientState2.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0}), (Object)clientState3.activeTasks());
    }

    @Test
    public void shouldOptimizeActiveTasksWithMoreClientsWithMoreThanOneTask() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState2.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0}));
        clientState3.assignActive(AssignmentTestUtils.TASK_0_0);
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.UUID_3, (Object)clientState3)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0});
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        long originalCost = assignor.activeTasksCost(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        int expected = this.stateful ? 20 : 2;
        Assert.assertEquals((long)expected, (long)originalCost);
        expected = this.stateful ? 2 : 0;
        long cost = assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)expected, (long)cost);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new Object[0]), (Object)clientState1.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1}), (Object)clientState2.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0}), (Object)clientState3.activeTasks());
    }

    @Test
    public void shouldBalanceAssignmentWithMoreCost() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState1.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignActive(AssignmentTestUtils.TASK_0_1);
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_5, (Object)clientState2)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1});
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        int expectedCost = this.stateful ? 10 : 1;
        long originalCost = assignor.activeTasksCost(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)expectedCost, (long)originalCost);
        long cost = assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost);
        Assert.assertEquals((long)expectedCost, (long)cost);
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1}), (Object)clientState1.activeTasks());
        Assert.assertEquals((Object)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1}), (Object)clientState2.activeTasks());
    }

    @Test
    public void shouldThrowIfMissingCallcanEnableRackAwareAssignor() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState1.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignActive(AssignmentTestUtils.TASK_0_1);
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_5, (Object)clientState2)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1});
        Exception exception = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost));
        Assertions.assertEquals((Object)"TopicPartition topic0-0 has no rack information. Maybe forgot to call canEnableRackAwareAssignor first", (Object)exception.getMessage());
    }

    @Test
    public void shouldThrowIfTaskInMultipleClients() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState1.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}));
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_5, (Object)clientState2)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1});
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost));
        Assertions.assertEquals((Object)"Task 1_1 assigned to multiple clients 00000000-0000-0000-0000-000000000005, 00000000-0000-0000-0000-000000000002", (Object)exception.getMessage());
    }

    @Test
    public void shouldThrowIfTaskMissingInClients() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), (InternalTopicManager)this.mockInternalTopicManager, this.getRackAwareEnabledConfig(), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1);
        clientState1.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignActive(AssignmentTestUtils.TASK_0_1);
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_5, (Object)clientState2)}));
        SortedSet taskIds = Utils.mkSortedSet((Comparable[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1});
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> assignor.optimizeActiveTasks(taskIds, clientStateMap, this.trafficCost, this.nonOverlapCost));
        Assertions.assertEquals((Object)"Task 1_0 not assigned to any client", (Object)exception.getMessage());
    }

    @Test
    public void shouldNotCrashForEmptyStandby() {
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), Utils.mkMap((Map.Entry[])new Map.Entry[0]), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), AssignmentTestUtils.mockInternalTopicManagerForChangelog(), this.getRackAwareEnabledConfigWithStandby(1), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_3);
        clientState1.assignActiveTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignActive(AssignmentTestUtils.TASK_1_0);
        clientState3.assignActive(AssignmentTestUtils.TASK_0_0);
        TreeMap clientStateMap = new TreeMap(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.UUID_3, (Object)clientState3)}));
        long originalCost = assignor.standByTasksCost(new TreeSet(), clientStateMap, 10, 1);
        Assert.assertEquals((long)0L, (long)originalCost);
        long cost = assignor.optimizeStandbyTasks(clientStateMap, 10, 1, (source, destination, task, clientStates) -> true);
        Assert.assertEquals((long)0L, (long)cost);
    }

    @Test
    public void shouldOptimizeStandbyTasksWhenTasksAllMovable() {
        int replicaCount = 2;
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), AssignmentTestUtils.getTaskChangelogMapForAllTasks(), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), AssignmentTestUtils.mockInternalTopicManagerForChangelog(), this.getRackAwareEnabledConfigWithStandby(2), (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_3);
        ClientState clientState4 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_4);
        ClientState clientState5 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_6);
        ClientState clientState6 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_7);
        TreeMap<UUID, ClientState> clientStateMap = new TreeMap<UUID, ClientState>(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.UUID_3, (Object)clientState3), Utils.mkEntry((Object)AssignmentTestUtils.UUID_4, (Object)clientState4), Utils.mkEntry((Object)AssignmentTestUtils.UUID_6, (Object)clientState5), Utils.mkEntry((Object)AssignmentTestUtils.UUID_7, (Object)clientState6)}));
        clientState1.assignActive(AssignmentTestUtils.TASK_0_0);
        clientState2.assignActive(AssignmentTestUtils.TASK_0_1);
        clientState3.assignActive(AssignmentTestUtils.TASK_1_0);
        clientState4.assignActive(AssignmentTestUtils.TASK_1_1);
        clientState5.assignActive(AssignmentTestUtils.TASK_0_2);
        clientState6.assignActive(AssignmentTestUtils.TASK_1_2);
        clientState1.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0}));
        clientState3.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2}));
        clientState4.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2}));
        clientState5.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_2}));
        clientState6.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_1}));
        TreeSet<TaskId> taskIds = new TreeSet<TaskId>(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2}));
        Map<UUID, Integer> standbyTaskCount = AssignmentTestUtils.clientTaskCount(clientStateMap, ClientState::standbyTaskCount);
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        AssignmentTestUtils.verifyStandbySatisfyRackReplica(taskIds, assignor.racksForProcess(), clientStateMap, 2, false, null);
        long originalCost = assignor.standByTasksCost(taskIds, clientStateMap, 10, 1);
        Assert.assertEquals((long)60L, (long)originalCost);
        long cost = assignor.optimizeStandbyTasks(clientStateMap, 10, 1, (source, destination, task, clients) -> true);
        Assert.assertEquals((long)20L, (long)cost);
        AssignmentTestUtils.verifyStandbySatisfyRackReplica(taskIds, assignor.racksForProcess(), clientStateMap, 2, true, standbyTaskCount);
    }

    @Test
    public void shouldOptimizeStandbyTasksWithMovingConstraint() {
        int replicaCount = 2;
        AssignorConfiguration.AssignmentConfigs assignorConfiguration = this.getRackAwareEnabledConfigWithStandby(2);
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getClusterForAllTopics(), AssignmentTestUtils.getTaskTopicPartitionMapForAllTasks(), AssignmentTestUtils.getTaskChangelogMapForAllTasks(), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getProcessRacksForAllProcess(), AssignmentTestUtils.mockInternalTopicManagerForChangelog(), assignorConfiguration, (Time)this.time);
        ClientState clientState1 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_1);
        ClientState clientState2 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_2);
        ClientState clientState3 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_3);
        ClientState clientState4 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_4);
        ClientState clientState5 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_6);
        ClientState clientState6 = new ClientState(Collections.emptySet(), Collections.emptySet(), Collections.emptyMap(), AssignmentTestUtils.EMPTY_CLIENT_TAGS, 1, AssignmentTestUtils.UUID_7);
        TreeMap<UUID, ClientState> clientStateMap = new TreeMap<UUID, ClientState>(Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)clientState1), Utils.mkEntry((Object)AssignmentTestUtils.UUID_2, (Object)clientState2), Utils.mkEntry((Object)AssignmentTestUtils.UUID_3, (Object)clientState3), Utils.mkEntry((Object)AssignmentTestUtils.UUID_4, (Object)clientState4), Utils.mkEntry((Object)AssignmentTestUtils.UUID_6, (Object)clientState5), Utils.mkEntry((Object)AssignmentTestUtils.UUID_7, (Object)clientState6)}));
        clientState1.assignActive(AssignmentTestUtils.TASK_0_0);
        clientState2.assignActive(AssignmentTestUtils.TASK_0_1);
        clientState3.assignActive(AssignmentTestUtils.TASK_1_0);
        clientState4.assignActive(AssignmentTestUtils.TASK_1_1);
        clientState5.assignActive(AssignmentTestUtils.TASK_0_2);
        clientState6.assignActive(AssignmentTestUtils.TASK_1_2);
        clientState1.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_1}));
        clientState2.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_1_0}));
        clientState3.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_2}));
        clientState4.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_1_2}));
        clientState5.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_2}));
        clientState6.assignStandbyTasks((Collection)Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_1}));
        TreeSet<TaskId> taskIds = new TreeSet<TaskId>(Utils.mkSet((Object[])new TaskId[]{AssignmentTestUtils.TASK_0_0, AssignmentTestUtils.TASK_0_1, AssignmentTestUtils.TASK_0_2, AssignmentTestUtils.TASK_1_0, AssignmentTestUtils.TASK_1_1, AssignmentTestUtils.TASK_1_2}));
        Map<UUID, Integer> standbyTaskCount = AssignmentTestUtils.clientTaskCount(clientStateMap, ClientState::standbyTaskCount);
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        AssignmentTestUtils.verifyStandbySatisfyRackReplica(taskIds, assignor.racksForProcess(), clientStateMap, 2, false, null);
        long originalCost = assignor.standByTasksCost(taskIds, clientStateMap, 10, 1);
        Assert.assertEquals((long)60L, (long)originalCost);
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignorConfiguration.AssignmentConfigs)assignorConfiguration, (RackAwareTaskAssignor)assignor);
        Assertions.assertInstanceOf(ClientTagAwareStandbyTaskAssignor.class, (Object)standbyTaskAssignor);
        long cost = assignor.optimizeStandbyTasks(clientStateMap, 10, 1, (arg_0, arg_1, arg_2, arg_3) -> ((StandbyTaskAssignor)standbyTaskAssignor).isAllowedTaskMovement(arg_0, arg_1, arg_2, arg_3));
        Assert.assertEquals((long)50L, (long)cost);
        AssignmentTestUtils.verifyStandbySatisfyRackReplica(taskIds, assignor.racksForProcess(), clientStateMap, 2, false, standbyTaskCount);
    }

    @Test
    public void shouldOptimizeRandomStandby() {
        int nodeSize = 50;
        int tpSize = 60;
        int partionSize = 3;
        int clientSize = 50;
        int replicaCount = 3;
        int maxCapacity = 3;
        SortedMap<TaskId, Set<TopicPartition>> taskTopicPartitionMap = AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, false);
        AssignorConfiguration.AssignmentConfigs assignorConfiguration = this.getRackAwareEnabledConfigWithStandby(3);
        RackAwareTaskAssignor assignor = new RackAwareTaskAssignor(AssignmentTestUtils.getRandomCluster(50, 60, 3), taskTopicPartitionMap, AssignmentTestUtils.getTaskTopicPartitionMap(60, 3, true), AssignmentTestUtils.getTopologyGroupTaskMap(), AssignmentTestUtils.getRandomProcessRacks(50, 50), AssignmentTestUtils.mockInternalTopicManagerForRandomChangelog(50, 60, 3), assignorConfiguration, (Time)this.time);
        SortedSet taskIds = (SortedSet)taskTopicPartitionMap.keySet();
        SortedMap<UUID, ClientState> clientStateMap = AssignmentTestUtils.getRandomClientState(50, 60, 3, 3, taskIds);
        StandbyTaskAssignor standbyTaskAssignor = StandbyTaskAssignorFactory.create((AssignorConfiguration.AssignmentConfigs)assignorConfiguration, (RackAwareTaskAssignor)assignor);
        Assertions.assertInstanceOf(ClientTagAwareStandbyTaskAssignor.class, (Object)standbyTaskAssignor);
        standbyTaskAssignor.assign(clientStateMap, (Set)taskIds, (Set)taskIds, assignorConfiguration);
        Map<UUID, Integer> standbyTaskCount = AssignmentTestUtils.clientTaskCount(clientStateMap, ClientState::standbyTaskCount);
        Assert.assertTrue((boolean)assignor.canEnableRackAwareAssignor());
        AssignmentTestUtils.verifyStandbySatisfyRackReplica(taskIds, assignor.racksForProcess(), clientStateMap, 3, false, null);
        long originalCost = assignor.standByTasksCost(taskIds, clientStateMap, 10, 1);
        MatcherAssert.assertThat((Object)originalCost, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        long cost = assignor.optimizeStandbyTasks(clientStateMap, 10, 1, (arg_0, arg_1, arg_2, arg_3) -> ((StandbyTaskAssignor)standbyTaskAssignor).isAllowedTaskMovement(arg_0, arg_1, arg_2, arg_3));
        MatcherAssert.assertThat((Object)cost, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(originalCost)));
        AssignmentTestUtils.verifyStandbySatisfyRackReplica(taskIds, assignor.racksForProcess(), clientStateMap, 3, false, standbyTaskCount);
    }

    private Cluster getClusterForTopic0() {
        return new Cluster("cluster", (Collection)Utils.mkSet((Object[])new Node[]{AssignmentTestUtils.NODE_0, AssignmentTestUtils.NODE_1, AssignmentTestUtils.NODE_2}), (Collection)Utils.mkSet((Object[])new PartitionInfo[]{AssignmentTestUtils.PI_0_0, AssignmentTestUtils.PI_0_1}), Collections.emptySet(), Collections.emptySet());
    }

    private Cluster getClusterWithPartitionMissingRack() {
        Node[] nodeMissingRack = new Node[]{AssignmentTestUtils.NODE_0, AssignmentTestUtils.NO_RACK_NODE};
        PartitionInfo partitionInfoMissingNode = new PartitionInfo("topic0", 0, AssignmentTestUtils.NODE_0, nodeMissingRack, nodeMissingRack);
        return new Cluster("cluster", (Collection)Utils.mkSet((Object[])new Node[]{AssignmentTestUtils.NODE_0, AssignmentTestUtils.NODE_1, AssignmentTestUtils.NODE_2}), (Collection)Utils.mkSet((Object[])new PartitionInfo[]{partitionInfoMissingNode, AssignmentTestUtils.PI_0_1}), Collections.emptySet(), Collections.emptySet());
    }

    private Cluster getClusterWithNoNode() {
        PartitionInfo noNodeInfo = new PartitionInfo("topic0", 0, null, new Node[0], new Node[0]);
        return new Cluster("cluster", (Collection)Utils.mkSet((Object[])new Node[]{AssignmentTestUtils.NODE_0, AssignmentTestUtils.NODE_1, AssignmentTestUtils.NODE_2, Node.noNode()}), Collections.singleton(noNodeInfo), Collections.emptySet(), Collections.emptySet());
    }

    private Map<UUID, Map<String, Optional<String>>> getProcessRacksForProcess0() {
        return this.getProcessRacksForProcess0(false);
    }

    private Map<UUID, Map<String, Optional<String>>> getProcessRacksForProcess0(boolean missingRack) {
        HashMap<UUID, Map<String, Optional<String>>> processRacks = new HashMap<UUID, Map<String, Optional<String>>>();
        Optional<Object> rack = missingRack ? Optional.empty() : Optional.of("rack1");
        processRacks.put(AssignmentTestUtils.UUID_1, Collections.singletonMap("consumer1", rack));
        return processRacks;
    }

    private Map<UUID, Map<String, Optional<String>>> getProcessWithNoConsumerRacks() {
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.UUID_1, (Object)Utils.mkMap((Map.Entry[])new Map.Entry[0]))});
    }

    private Map<TaskId, Set<TopicPartition>> getTaskTopicPartitionMapForTask0() {
        return this.getTaskTopicPartitionMapForTask0(false);
    }

    private Map<TaskId, Set<TopicPartition>> getTaskChangeLogTopicPartitionMapForTask0() {
        return Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)AssignmentTestUtils.TASK_0_0, (Object)Utils.mkSet((Object[])new TopicPartition[]{AssignmentTestUtils.CHANGELOG_TP_0_0}))});
    }

    private Map<TaskId, Set<TopicPartition>> getTaskTopicPartitionMapForTask0(boolean extraTopic) {
        HashSet<TopicPartition> topicPartitions = new HashSet<TopicPartition>();
        topicPartitions.add(AssignmentTestUtils.TP_0_0);
        if (extraTopic) {
            topicPartitions.add(AssignmentTestUtils.TP_1_0);
        }
        return Collections.singletonMap(AssignmentTestUtils.TASK_0_0, topicPartitions);
    }
}

