/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.PartitionGrouper;
import org.apache.kafka.streams.processor.internals.TopologyMetadata;
import org.apache.kafka.streams.processor.internals.assignment.AssignmentTestUtils;
import org.junit.Assert;
import org.junit.Test;

public class PartitionGrouperTest {
    private final List<PartitionInfo> infos = Arrays.asList(new PartitionInfo("topic1", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 1, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic1", 2, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 0, Node.noNode(), new Node[0], new Node[0]), new PartitionInfo("topic2", 1, Node.noNode(), new Node[0], new Node[0]));
    private final Cluster metadata = new Cluster("cluster", Collections.singletonList(Node.noNode()), this.infos, Collections.emptySet(), Collections.emptySet());

    @Test
    public void shouldComputeGroupingForTwoGroups() {
        PartitionGrouper grouper = new PartitionGrouper();
        HashMap<TaskId, Set> expectedPartitionsForTask = new HashMap<TaskId, Set>();
        HashMap<TopologyMetadata.Subtopology, Set> topicGroups = new HashMap<TopologyMetadata.Subtopology, Set>();
        topicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_0, Utils.mkSet((Object[])new String[]{"topic1"}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_0.nodeGroupId, 0, AssignmentTestUtils.SUBTOPOLOGY_0.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_0.nodeGroupId, 1, AssignmentTestUtils.SUBTOPOLOGY_0.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 1)}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_0.nodeGroupId, 2, AssignmentTestUtils.SUBTOPOLOGY_0.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 2)}));
        topicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_1, Utils.mkSet((Object[])new String[]{"topic2"}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_1.nodeGroupId, 0, AssignmentTestUtils.SUBTOPOLOGY_1.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_1.nodeGroupId, 1, AssignmentTestUtils.SUBTOPOLOGY_1.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic2", 1)}));
        Assert.assertEquals(expectedPartitionsForTask, (Object)grouper.partitionGroups(topicGroups, this.metadata));
    }

    @Test
    public void shouldComputeGroupingForSingleGroupWithMultipleTopics() {
        PartitionGrouper grouper = new PartitionGrouper();
        HashMap<TaskId, Set> expectedPartitionsForTask = new HashMap<TaskId, Set>();
        HashMap<TopologyMetadata.Subtopology, Set> topicGroups = new HashMap<TopologyMetadata.Subtopology, Set>();
        topicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_0, Utils.mkSet((Object[])new String[]{"topic1", "topic2"}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_0.nodeGroupId, 0, AssignmentTestUtils.SUBTOPOLOGY_0.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_0.nodeGroupId, 1, AssignmentTestUtils.SUBTOPOLOGY_0.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 1), new TopicPartition("topic2", 1)}));
        expectedPartitionsForTask.put(new TaskId(AssignmentTestUtils.SUBTOPOLOGY_0.nodeGroupId, 2, AssignmentTestUtils.SUBTOPOLOGY_0.namedTopology), Utils.mkSet((Object[])new TopicPartition[]{new TopicPartition("topic1", 2)}));
        Assert.assertEquals(expectedPartitionsForTask, (Object)grouper.partitionGroups(topicGroups, this.metadata));
    }

    @Test
    public void shouldNotCreateAnyTasksBecauseOneTopicHasUnknownPartitions() {
        PartitionGrouper grouper = new PartitionGrouper();
        HashMap<TopologyMetadata.Subtopology, Set> topicGroups = new HashMap<TopologyMetadata.Subtopology, Set>();
        topicGroups.put(AssignmentTestUtils.SUBTOPOLOGY_0, Utils.mkSet((Object[])new String[]{"topic1", "unknownTopic", "topic2"}));
        Assert.assertThrows(RuntimeException.class, () -> grouper.partitionGroups(topicGroups, this.metadata));
    }
}

