/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.Window;
import org.apache.kafka.streams.kstream.internals.SessionWindow;
import org.apache.kafka.streams.kstream.internals.TimeWindow;
import org.junit.Assert;
import org.junit.Test;

public class SessionWindowTest {
    private final long start = 50L;
    private final long end = 100L;
    private final SessionWindow window = new SessionWindow(50L, 100L);
    private final TimeWindow timeWindow = new TimeWindow(50L, 100L);

    @Test
    public void shouldNotOverlapIfOtherWindowIsBeforeThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(0L, 25L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(0L, 49L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(49L, 49L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowEndIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 50L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 51L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 99L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 50L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 51L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 99L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 100L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowContainsThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(0L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(49L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 150L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 50L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 75L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, 100L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(100L, 100L)));
    }

    @Test
    public void shouldOverlapIfOtherWindowStartIsWithinThisWindow() {
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(50L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(75L, 150L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(100L, 101L)));
        Assert.assertTrue((boolean)this.window.overlap((Window)new SessionWindow(100L, 150L)));
    }

    @Test
    public void shouldNotOverlapIsOtherWindowIsAfterThisWindow() {
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(101L, 101L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(101L, 150L)));
        Assert.assertFalse((boolean)this.window.overlap((Window)new SessionWindow(125L, 150L)));
    }

    @Test
    public void cannotCompareSessionWindowWithDifferentWindowType() {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.window.overlap((Window)this.timeWindow));
    }
}

