/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.streams.kstream.ValueTransformerWithKey;
import org.apache.kafka.streams.kstream.ValueTransformerWithKeySupplier;
import org.apache.kafka.streams.kstream.internals.KStreamFlatTransformValues;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.api.Processor;
import org.apache.kafka.streams.processor.api.Record;
import org.apache.kafka.streams.processor.internals.ForwardingDisabledProcessorContext;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class KStreamFlatTransformValuesTest {
    private Integer inputKey;
    private Integer inputValue;
    @Mock
    private ValueTransformerWithKey<Integer, Integer, Iterable<String>> valueTransformer;
    @Mock
    private InternalProcessorContext<Integer, String> context;
    private InOrder inOrder;
    private KStreamFlatTransformValues.KStreamFlatTransformValuesProcessor<Integer, Integer, String> processor;

    @Before
    public void setUp() {
        this.inputKey = 1;
        this.inputValue = 10;
        this.inOrder = Mockito.inOrder((Object[])new Object[]{this.context});
        this.processor = new KStreamFlatTransformValues.KStreamFlatTransformValuesProcessor(this.valueTransformer);
    }

    @Test
    public void shouldInitializeFlatTransformValuesProcessor() {
        this.processor.init(this.context);
        ((ValueTransformerWithKey)Mockito.verify(this.valueTransformer)).init((ProcessorContext)ArgumentMatchers.isA(ForwardingDisabledProcessorContext.class));
    }

    @Test
    public void shouldTransformInputRecordToMultipleOutputValues() {
        List<String> outputValues = Arrays.asList("Hello", "Blue", "Planet");
        this.processor.init(this.context);
        Mockito.when((Object)this.valueTransformer.transform((Object)this.inputKey, (Object)this.inputValue)).thenReturn(outputValues);
        this.processor.process(new Record((Object)this.inputKey, (Object)this.inputValue, 0L));
        for (String outputValue : outputValues) {
            ((InternalProcessorContext)this.inOrder.verify(this.context)).forward(new Record((Object)this.inputKey, (Object)outputValue, 0L));
        }
    }

    @Test
    public void shouldEmitNoRecordIfTransformReturnsEmptyList() {
        this.processor.init(this.context);
        Mockito.when((Object)this.valueTransformer.transform((Object)this.inputKey, (Object)this.inputValue)).thenReturn(Collections.emptyList());
        this.processor.process(new Record((Object)this.inputKey, (Object)this.inputValue, 0L));
        ((InternalProcessorContext)this.inOrder.verify(this.context, Mockito.never())).forward((Record)ArgumentMatchers.any());
    }

    @Test
    public void shouldEmitNoRecordIfTransformReturnsNull() {
        this.processor.init(this.context);
        Mockito.when((Object)this.valueTransformer.transform((Object)this.inputKey, (Object)this.inputValue)).thenReturn(null);
        this.processor.process(new Record((Object)this.inputKey, (Object)this.inputValue, 0L));
        ((InternalProcessorContext)this.inOrder.verify(this.context, Mockito.never())).forward((Record)ArgumentMatchers.any());
    }

    @Test
    public void shouldCloseFlatTransformValuesProcessor() {
        this.processor.close();
        ((ValueTransformerWithKey)Mockito.verify(this.valueTransformer)).close();
    }

    @Test
    public void shouldGetFlatTransformValuesProcessor() {
        ValueTransformerWithKeySupplier valueTransformerSupplier = (ValueTransformerWithKeySupplier)Mockito.mock(ValueTransformerWithKeySupplier.class);
        KStreamFlatTransformValues processorSupplier = new KStreamFlatTransformValues(valueTransformerSupplier);
        Mockito.when((Object)valueTransformerSupplier.get()).thenReturn(this.valueTransformer);
        Processor processor = processorSupplier.get();
        Assert.assertTrue((boolean)(processor instanceof KStreamFlatTransformValues.KStreamFlatTransformValuesProcessor));
    }
}

