/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.Set;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.RocksDbIterator;
import org.rocksdb.RocksIterator;

class RocksDBPrefixIterator
extends RocksDbIterator {
    private byte[] rawPrefix;

    RocksDBPrefixIterator(String name, RocksIterator newIterator, Set<KeyValueIterator<Bytes, byte[]>> openIterators, Bytes prefix) {
        super(name, newIterator, openIterators);
        this.rawPrefix = prefix.get();
        newIterator.seek(this.rawPrefix);
    }

    @Override
    public synchronized boolean hasNext() {
        if (!super.hasNext()) {
            return false;
        }
        byte[] rawNextKey = super.peekNextKey().get();
        for (int i = 0; i < this.rawPrefix.length; ++i) {
            if (i == rawNextKey.length) {
                throw new IllegalStateException("Unexpected RocksDB Key Value. Should have been skipped with seek.");
            }
            if (rawNextKey[i] == this.rawPrefix[i]) continue;
            return false;
        }
        return true;
    }
}

