/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Collections;
import org.apache.kafka.streams.kstream.internals.ConsumedInternal;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.StreamSourceNode;
import org.apache.kafka.streams.processor.ProcessorSupplier;
import org.apache.kafka.streams.processor.StateStoreSupplier;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.StoreBuilder;

class StatefulSourceNode<K, V>
extends StreamSourceNode<K, V> {
    private StateStoreSupplier<KeyValueStore> storeSupplier;
    private StoreBuilder<KeyValueStore<K, V>> storeBuilder;
    private final ProcessorSupplier<K, V> processorSupplier;
    private final String sourceName;
    private final String processorName;
    private final KTableSource<K, V> kTableSource;

    StatefulSourceNode(String predecessorNodeName, String nodeName, String sourceName, String processorName, String topic, ConsumedInternal<K, V> consumedInternal, ProcessorSupplier<K, V> processorSupplier, KTableSource<K, V> kTableSource) {
        super(predecessorNodeName, nodeName, Collections.singletonList(topic), consumedInternal);
        this.processorSupplier = processorSupplier;
        this.sourceName = sourceName;
        this.processorName = processorName;
        this.kTableSource = kTableSource;
    }

    StateStoreSupplier<KeyValueStore> storeSupplier() {
        return this.storeSupplier;
    }

    void setStoreSupplier(StateStoreSupplier<KeyValueStore> storeSupplier) {
        this.storeSupplier = storeSupplier;
    }

    StoreBuilder<KeyValueStore<K, V>> storeBuilder() {
        return this.storeBuilder;
    }

    void setStoreBuilder(StoreBuilder<KeyValueStore<K, V>> storeBuilder) {
        this.storeBuilder = storeBuilder;
    }

    ProcessorSupplier<K, V> processorSupplier() {
        return this.processorSupplier;
    }

    String sourceName() {
        return this.sourceName;
    }

    KTableSource<K, V> kTableSource() {
        return this.kTableSource;
    }

    String processorName() {
        return this.processorName;
    }

    boolean isGlobalKTable() {
        return this.kTableSource != null;
    }

    static <K, V> StatefulSourceNodeBuilder<K, V> statefulSourceNodeBuilder() {
        return new StatefulSourceNodeBuilder();
    }

    @Override
    void writeToTopology(InternalTopologyBuilder topologyBuilder) {
    }

    static final class StatefulSourceNodeBuilder<K, V> {
        private String predecessorNodeName;
        private String nodeName;
        private String sourceName;
        private String processorName;
        private String topic;
        private ConsumedInternal<K, V> consumedInternal;
        private StateStoreSupplier<KeyValueStore> storeSupplier;
        private StoreBuilder<KeyValueStore<K, V>> storeBuilder;
        private ProcessorSupplier<K, V> processorSupplier;
        private KTableSource<K, V> kTableSource;

        private StatefulSourceNodeBuilder() {
        }

        StatefulSourceNodeBuilder<K, V> withPredecessorNodeName(String predecessorNodeName) {
            this.predecessorNodeName = predecessorNodeName;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withProcessorName(String processorName) {
            this.processorName = processorName;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withTopic(String topic) {
            this.topic = topic;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withStoreSupplier(StateStoreSupplier<KeyValueStore> storeSupplier) {
            this.storeSupplier = storeSupplier;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withStoreBuilder(StoreBuilder<KeyValueStore<K, V>> storeBuilder) {
            this.storeBuilder = storeBuilder;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withConsumedInternal(ConsumedInternal<K, V> consumedInternal) {
            this.consumedInternal = consumedInternal;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withProcessorSupplier(ProcessorSupplier<K, V> processorSupplier) {
            this.processorSupplier = processorSupplier;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withKTableSource(KTableSource<K, V> kTableSource) {
            this.kTableSource = kTableSource;
            return this;
        }

        StatefulSourceNodeBuilder<K, V> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        StatefulSourceNode<K, V> build() {
            StatefulSourceNode<K, V> statefulSourceNode = new StatefulSourceNode<K, V>(this.predecessorNodeName, this.nodeName, this.sourceName, this.processorName, this.topic, this.consumedInternal, this.processorSupplier, this.kTableSource);
            statefulSourceNode.setRepartitionRequired(false);
            if (this.storeSupplier != null) {
                statefulSourceNode.setStoreSupplier(this.storeSupplier);
            } else if (this.storeBuilder != null) {
                statefulSourceNode.setStoreBuilder(this.storeBuilder);
            }
            return statefulSourceNode;
        }
    }
}

