/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import org.apache.kafka.common.message.UnAssignBrokersFromCellRequestData;
import org.apache.kafka.common.message.UnAssignBrokersFromCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.UnAssignBrokersFromCellResponse;

public class UnAssignBrokersFromCellRequest
extends AbstractRequest {
    private final UnAssignBrokersFromCellRequestData data;

    UnAssignBrokersFromCellRequest(UnAssignBrokersFromCellRequestData data, short version) {
        super(ApiKeys.UN_ASSIGN_BROKERS_FROM_CELL, version);
        this.validate(data);
        this.data = data;
    }

    @Override
    public UnAssignBrokersFromCellRequestData data() {
        return this.data;
    }

    public List<Integer> brokers() {
        return this.data.brokerIds();
    }

    public int cellId() {
        return this.data.cellId();
    }

    public boolean force() {
        return this.data.force();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        ApiError err = ApiError.fromThrowable(t);
        return new UnAssignBrokersFromCellResponse(new UnAssignBrokersFromCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static UnAssignBrokersFromCellRequest parse(Readable readable, short version, MessageContext context) {
        return new UnAssignBrokersFromCellRequest(new UnAssignBrokersFromCellRequestData(readable, version, context), version);
    }

    private void validate(UnAssignBrokersFromCellRequestData data) {
    }

    public static class Builder
    extends AbstractRequest.Builder<UnAssignBrokersFromCellRequest> {
        private final UnAssignBrokersFromCellRequestData data;

        public Builder() {
            super(ApiKeys.UN_ASSIGN_BROKERS_FROM_CELL);
            this.data = new UnAssignBrokersFromCellRequestData();
        }

        public Builder(UnAssignBrokersFromCellRequestData data) {
            super(ApiKeys.UN_ASSIGN_BROKERS_FROM_CELL);
            this.data = data;
        }

        public Builder setBrokers(List<Integer> brokers) {
            this.data.setBrokerIds(brokers);
            return this;
        }

        public Builder setCellId(int cellId) {
            this.data.setCellId(cellId);
            return this;
        }

        @Override
        public UnAssignBrokersFromCellRequest build(short version) {
            return new UnAssignBrokersFromCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

