/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.message.TriggerEvenClusterLoadResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractResponse;

public class TriggerEvenClusterLoadResponse
extends AbstractResponse {
    private final TriggerEvenClusterLoadResponseData data;

    public TriggerEvenClusterLoadResponse(TriggerEvenClusterLoadResponseData data) {
        super(ApiKeys.TRIGGER_EVEN_CLUSTER_LOAD);
        this.data = data;
    }

    @Override
    public TriggerEvenClusterLoadResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short apiVersion) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static TriggerEvenClusterLoadResponse parse(Readable readable, short version, MessageContext context) {
        return new TriggerEvenClusterLoadResponse(new TriggerEvenClusterLoadResponseData(readable, version, context));
    }
}

