/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DeleteShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteShareGroupStateResponse;

public class DeleteShareGroupStateRequest
extends AbstractRequest {
    private final DeleteShareGroupStateRequestData data;

    public DeleteShareGroupStateRequest(DeleteShareGroupStateRequestData data, short version) {
        super(ApiKeys.DELETE_SHARE_GROUP_STATE, version);
        this.data = data;
    }

    @Override
    public DeleteShareGroupStateResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ArrayList<DeleteShareGroupStateResponseData.DeleteStateResult> results = new ArrayList<DeleteShareGroupStateResponseData.DeleteStateResult>();
        this.data.topics().forEach(topicResult -> results.add(new DeleteShareGroupStateResponseData.DeleteStateResult().setTopicId(topicResult.topicId()).setPartitions(topicResult.partitions().stream().map(partitionData -> new DeleteShareGroupStateResponseData.PartitionResult().setPartition(partitionData.partition()).setErrorCode(Errors.forException(e).code())).collect(Collectors.toList()))));
        return new DeleteShareGroupStateResponse(new DeleteShareGroupStateResponseData().setResults(results));
    }

    @Override
    public DeleteShareGroupStateRequestData data() {
        return this.data;
    }

    public static DeleteShareGroupStateRequest parse(Readable readable, short version, MessageContext context) {
        return new DeleteShareGroupStateRequest(new DeleteShareGroupStateRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteShareGroupStateRequest> {
        private final DeleteShareGroupStateRequestData data;

        public Builder(DeleteShareGroupStateRequestData data) {
            super(ApiKeys.DELETE_SHARE_GROUP_STATE);
            this.data = data;
        }

        @Override
        public DeleteShareGroupStateRequest build(short version) {
            return new DeleteShareGroupStateRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

