/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelOption;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.net.ssl.SSLSession;
import org.apache.kafka.common.network.netty.AbstractStreamHandler;
import org.apache.kafka.common.network.netty.NettyHttp2ConnectionInitializer;
import org.apache.kafka.common.network.netty.NettyRawBytesStream;
import org.apache.kafka.common.network.netty.NettyStream;
import org.apache.kafka.common.network.netty.Utils;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public final class NettyHttp2Stream
extends NettyRawBytesStream {
    private final Logger log;
    private final Http2StreamChannel streamChannel;
    private final boolean flowControlEnabled;
    private final Http2Connection http2Connection;
    private Http2Stream currentStream;
    private final ChannelFutureListener fireExceptionOnFailure = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture future) {
            if (!future.isSuccess()) {
                NettyHttp2Stream.this.streamChannel.pipeline().fireExceptionCaught(future.cause());
            }
        }
    };

    public NettyHttp2Stream(Http2StreamChannel streamChannel, LogContext logContext, boolean flowControlEnabled) {
        super((Channel)streamChannel, 8192, 8192, logContext, false);
        this.streamChannel = streamChannel;
        this.http2Connection = NettyHttp2ConnectionInitializer.getHttp2Connection(streamChannel);
        this.log = logContext.logger(NettyHttp2Stream.class);
        if (flowControlEnabled) {
            this.flowControlEnabled = streamChannel.config().setOption(Http2StreamChannelOption.AUTO_STREAM_FLOW_CONTROL, (Object)false);
            if (!this.flowControlEnabled) {
                throw new IllegalArgumentException("Manual stream flow control is not supported on " + streamChannel.getClass().getName());
            }
        } else {
            this.flowControlEnabled = false;
        }
    }

    public NettyHttp2Stream(Http2StreamChannel streamChannel, LogContext logContext) {
        this(streamChannel, logContext, true);
    }

    @Override
    public String streamId() {
        return String.valueOf(this.streamChannel.stream().id());
    }

    @Override
    public NettyStream.Priority priority() {
        return NettyStream.Priority.NORMAL;
    }

    public Future<NettyHttp2Stream> sendHeaders(Http2Headers http2Headers) {
        Promise streamPromise = this.streamChannel.eventLoop().newPromise();
        ChannelFuture channelFuture = this.streamChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame(http2Headers));
        channelFuture.addListener(cFuture -> {
            if (cFuture.isSuccess()) {
                streamPromise.setSuccess((Object)this);
            } else {
                streamPromise.setFailure(cFuture.cause());
            }
        });
        return streamPromise;
    }

    @Override
    public Future<Void> send(ByteBuf data, boolean flush) {
        this.log.debug("Writing {} bytes to stream {}", (Object)data.readableBytes(), (Object)this.streamChannel);
        DefaultHttp2DataFrame http2DataFrame = new DefaultHttp2DataFrame(data);
        return this.sendMessage(http2DataFrame, flush);
    }

    @Override
    public void receiveMore() {
        if (!this.flowControlEnabled) {
            this.log.debug("This stream {} is not using HTTP/2 flow control, skipping", (Object)this.streamChannel);
            return;
        }
        this.runOnEventLoop(() -> {
            try {
                Http2LocalFlowController inboundFlowController = (Http2LocalFlowController)this.http2Connection.local().flowController();
                int unconsumedBytes = inboundFlowController.unconsumedBytes(this.http2Stream());
                if (unconsumedBytes > 0) {
                    DefaultHttp2WindowUpdateFrame windowUpdateFrame = new DefaultHttp2WindowUpdateFrame(unconsumedBytes).stream(this.streamChannel.stream());
                    this.streamChannel.parent().writeAndFlush((Object)windowUpdateFrame).addListener((GenericFutureListener)this.fireExceptionOnFailure);
                    this.log.debug("Refilled flow control window for stream {} with increment: {}", (Object)this.streamChannel, (Object)unconsumedBytes);
                } else {
                    this.log.debug("No unconsumed bytes for stream {}, skip refilling", (Object)this.streamChannel);
                }
            }
            catch (Throwable e) {
                this.log.error("Failed to update flow control window for stream {}, closing stream", (Object)this.streamChannel, (Object)e);
                this.streamChannel.pipeline().fireExceptionCaught(e);
            }
        }, false);
    }

    public boolean flowControlEnabled() {
        return this.flowControlEnabled;
    }

    public Http2Connection connection() {
        return this.http2Connection;
    }

    public Http2Stream http2Stream() {
        if (this.currentStream == null) {
            this.currentStream = this.http2Connection.stream(this.streamChannel.stream().id());
        }
        return this.currentStream;
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return Utils.sslSession(this.streamChannel.parent());
    }

    public static class NettyHttp2StreamHandler
    extends AbstractStreamHandler<Http2StreamFrame> {
        private final Logger log;
        private final NettyStream nettyStream;
        private final BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator;

        NettyHttp2StreamHandler(NettyStream nettyStream, BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator, NettyStream.StreamHandler handler, LogContext logContext) {
            super(nettyStream, handler, logContext);
            this.nettyStream = nettyStream;
            this.handlerCreator = handlerCreator;
            this.log = logContext.logger(NettyRawBytesStream.NettyRawBytesStreamHandler.class);
        }

        public NettyHttp2StreamHandler(NettyStream nettyStream, BiFunction<NettyStream, Http2Headers, NettyStream.StreamHandler> handlerCreator, LogContext logContext) {
            this(nettyStream, handlerCreator, null, logContext);
        }

        public NettyHttp2StreamHandler(NettyStream nettyStream, NettyStream.StreamHandler handler, LogContext logContext) {
            this(nettyStream, null, handler, logContext);
        }

        protected void channelRead0(ChannelHandlerContext ctx, Http2StreamFrame frame) throws Exception {
            if (frame instanceof Http2HeadersFrame) {
                this.onHeadersRead(ctx, (Http2HeadersFrame)frame);
            } else if (frame instanceof Http2DataFrame) {
                this.onDataRead(ctx, (Http2DataFrame)frame);
            } else {
                this.log.error("Received unexpected frame: {}", (Object)frame);
            }
        }

        private void onHeadersRead(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
            if (headersFrame.headers().status() != null) {
                this.log.debug("Received response with status: {}", (Object)headersFrame.headers().status());
            }
            if (this.streamHandler() != null) {
                this.log.warn("Handler is already initialized, ignoring headers frame on stream {}", (Object)headersFrame.stream().id());
                return;
            }
            try {
                if (this.handlerCreator != null) {
                    this.log.debug("Creating handler for stream {}", (Object)this.nettyStream);
                    NettyStream.StreamHandler streamHandler = this.handlerCreator.apply(this.nettyStream, headersFrame.headers());
                    if (this.streamHandler() == null) {
                        this.streamHandler(streamHandler);
                    }
                }
            }
            catch (Throwable t) {
                this.log.error("Failed to create stream handler, closing channel", t);
                ctx.channel().close();
            }
        }

        private void onDataRead(ChannelHandlerContext ctx, Http2DataFrame dataFrame) {
            this.log.debug("Received buffer size {}, initFlowControl {} on stream {}", new Object[]{dataFrame.content().readableBytes(), dataFrame.initialFlowControlledBytes(), this.nettyStream});
            NettyStream.StreamHandler handler = this.streamHandler();
            if (handler == null) {
                this.log.error("Stream handler is not initialized, cannot handle data frame, closing channel");
                ctx.channel().close();
                return;
            }
            try {
                handler.handleData(dataFrame.content());
            }
            catch (Throwable t) {
                this.log.error("Failed to handle data frame", t);
                handler.handleException(t);
            }
        }
    }
}

