/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.ResolveOffsetRangeOptions;
import org.apache.kafka.clients.admin.ResolveOffsetRangeResult;
import org.apache.kafka.clients.admin.ResolveOffsetRangeSpec;
import org.apache.kafka.clients.admin.TieredFragmentType;
import org.apache.kafka.clients.admin.internals.AdminApiFuture;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AdminApiLookupStrategy;
import org.apache.kafka.clients.admin.internals.TopicIdPartitionLeaderStrategy;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdAndPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.message.ResolveOffsetRangeRequestData;
import org.apache.kafka.common.message.ResolveOffsetRangeResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ResolveOffsetRangeRequest;
import org.apache.kafka.common.requests.ResolveOffsetRangeResponse;
import org.apache.kafka.common.utils.LogContext;
import org.slf4j.Logger;

public class ResolveOffsetRangeHandler
extends AdminApiHandler.Batched<TopicIdAndPartition, ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo> {
    private final Map<TopicIdAndPartition, ResolveOffsetRangeSpec> rangeSpecByPartition;
    private final ResolveOffsetRangeOptions options;
    private final Logger log;
    private final AdminApiLookupStrategy<TopicIdAndPartition> lookupStrategy;

    public ResolveOffsetRangeHandler(Map<TopicIdAndPartition, ResolveOffsetRangeSpec> rangeSpecByPartition, ResolveOffsetRangeOptions options, LogContext logContext) {
        this.rangeSpecByPartition = rangeSpecByPartition;
        this.options = options;
        this.log = logContext.logger(ResolveOffsetRangeHandler.class);
        this.lookupStrategy = new TopicIdPartitionLeaderStrategy(logContext, false);
    }

    @Override
    public String apiName() {
        return "resolveOffsetRange";
    }

    @Override
    public AdminApiLookupStrategy<TopicIdAndPartition> lookupStrategy() {
        return this.lookupStrategy;
    }

    ResolveOffsetRangeRequest.Builder buildBatchedRequest(int brokerId, Set<TopicIdAndPartition> keys) {
        HashMap<Uuid, ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic> topicsById = new HashMap<Uuid, ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic>();
        for (TopicIdAndPartition tp : keys) {
            ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic topicData = topicsById.computeIfAbsent(tp.topicId(), topicId -> new ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic().setTopicId((Uuid)topicId));
            topicData.partitions().add(new ResolveOffsetRangeRequestData.ResolveOffsetRangePartition().setPartitionIndex(tp.partition()).setStartOffset(this.rangeSpecByPartition.get(tp).startOffset()));
        }
        return new ResolveOffsetRangeRequest.Builder(this.options.isolationLevel(), this.options.maxNumRanges()).setRanges(new ArrayList<ResolveOffsetRangeRequestData.ResolveOffsetRangeTopic>(topicsById.values()));
    }

    @Override
    public AdminApiHandler.ApiResult<TopicIdAndPartition, ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo> handleResponse(Node broker, Set<TopicIdAndPartition> keys, AbstractResponse abstractResponse) {
        ResolveOffsetRangeResponse response = (ResolveOffsetRangeResponse)abstractResponse;
        Set<Uuid> topicIds = ResolveOffsetRangeHandler.topicIds(this.rangeSpecByPartition.keySet());
        HashMap<TopicIdAndPartition, ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo> completed = new HashMap<TopicIdAndPartition, ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo>();
        HashMap<TopicIdAndPartition, Throwable> failed = new HashMap<TopicIdAndPartition, Throwable>();
        ArrayList<TopicIdAndPartition> unmapped = new ArrayList<TopicIdAndPartition>();
        HashSet<TopicIdAndPartition> retriable = new HashSet<TopicIdAndPartition>();
        for (ResolveOffsetRangeResponseData.ResolveOffsetRangeTopicResponse topic : response.topics()) {
            for (ResolveOffsetRangeResponseData.ResolveOffsetPartitionResponse partition : topic.partitions()) {
                if (!topicIds.contains(topic.topicId())) {
                    this.log.warn("ResolveOffsetRange response includes unknown topic id {}", (Object)topic.topicId());
                    continue;
                }
                TopicIdAndPartition topicPartition = new TopicIdAndPartition(topic.topicId(), partition.partitionIndex());
                Errors error = Errors.forCode(partition.errorCode());
                if (error == Errors.NONE) {
                    Optional<Long> brokerStartOffset = Optional.ofNullable(partition.brokerRange()).map(ResolveOffsetRangeResponseData.BrokerMetadata::startOffset);
                    Optional<Long> brokerEndOffset = Optional.ofNullable(partition.brokerRange()).map(ResolveOffsetRangeResponseData.BrokerMetadata::endOffset);
                    completed.put(topicPartition, new ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo(ResolveOffsetRangeHandler.tieredSegmentMetadataToRanges(partition.tieredSegmentRange()), brokerStartOffset, brokerEndOffset));
                    continue;
                }
                this.handlePartitionError(topicPartition, error, partition.errorMessage(), failed, unmapped, retriable);
            }
        }
        for (TopicIdAndPartition topicPartition : keys) {
            if (!unmapped.isEmpty() || completed.containsKey(topicPartition) || failed.containsKey(topicPartition) || retriable.contains(topicPartition)) continue;
            ApiException sanityCheckException = new ApiException("The response from broker " + broker.id() + " did not contain a result for topic partition " + String.valueOf(topicPartition));
            this.log.error("ResolveOffsetRange request for topic partition {} failed sanity check", (Object)topicPartition, (Object)sanityCheckException);
            failed.put(topicPartition, sanityCheckException);
        }
        return new AdminApiHandler.ApiResult<TopicIdAndPartition, ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo>(completed, failed, unmapped);
    }

    private static List<ResolveOffsetRangeResult.TieredRange> tieredSegmentMetadataToRanges(List<ResolveOffsetRangeResponseData.TieredSegmentMetadata> tieredSegmentRange) {
        if (tieredSegmentRange == null || tieredSegmentRange.isEmpty()) {
            return Collections.emptyList();
        }
        return tieredSegmentRange.stream().map(ResolveOffsetRangeHandler::segmentMetadataToRange).collect(Collectors.toList());
    }

    private static ResolveOffsetRangeResult.TieredRange segmentMetadataToRange(ResolveOffsetRangeResponseData.TieredSegmentMetadata segmentMetadata) {
        ResolveOffsetRangeResult.TieredFile segmentFile = null;
        ResolveOffsetRangeResult.TieredFile offsetIndex = null;
        Optional<ResolveOffsetRangeResult.TieredFile> transactionIndex = Optional.empty();
        block5: for (ResolveOffsetRangeResponseData.SegmentFileMetadata segmentFileMetadata : segmentMetadata.segmentFiles()) {
            ResolveOffsetRangeResult.TieredFile tieredFile = new ResolveOffsetRangeResult.TieredFile(segmentFileMetadata.locator(), segmentFileMetadata.startBytePosition(), segmentFileMetadata.endBytePosition(), TieredFragmentType.toType(segmentFileMetadata.fragmentTypeByte()));
            switch (tieredFile.fragmentType()) {
                case SEGMENT: {
                    segmentFile = tieredFile;
                    continue block5;
                }
                case OFFSET_INDEX: {
                    offsetIndex = tieredFile;
                    continue block5;
                }
                case TRANSACTION_INDEX: {
                    transactionIndex = Optional.of(tieredFile);
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unexpected fragment type byte " + segmentFileMetadata.fragmentTypeByte());
        }
        if (segmentFile == null) {
            throw new IllegalArgumentException("Segment file is missing");
        }
        if (offsetIndex == null) {
            throw new IllegalArgumentException("Offset index is missing");
        }
        return new ResolveOffsetRangeResult.TieredRange(segmentMetadata.startOffset(), segmentMetadata.endOffset(), segmentFile, offsetIndex, transactionIndex);
    }

    private void handlePartitionError(TopicIdAndPartition topicPartition, Errors error, String errorMessage, Map<TopicIdAndPartition, Throwable> failed, List<TopicIdAndPartition> unmapped, Set<TopicIdAndPartition> retriable) {
        if (error == Errors.NOT_LEADER_OR_FOLLOWER || error == Errors.LEADER_NOT_AVAILABLE) {
            this.log.debug("ResolveOffsetRange request for topic partition {} will be retried due to invalid leader metadata {}", (Object)topicPartition, (Object)error);
            unmapped.add(topicPartition);
        } else if (error.exception() instanceof RetriableException) {
            this.log.debug("ResolveOffsetRange request for topic partition {} will be retried due to {}", (Object)topicPartition, (Object)error);
            retriable.add(topicPartition);
        } else {
            this.log.error("ResolveOffsetRange request for topic partition {} failed due to an unexpected error {}", (Object)topicPartition, (Object)error);
            failed.put(topicPartition, error.exception(errorMessage));
        }
    }

    private static Set<Uuid> topicIds(Set<TopicIdAndPartition> partitions) {
        return partitions.stream().map(TopicIdAndPartition::topicId).collect(Collectors.toSet());
    }

    public static AdminApiFuture.SimpleAdminApiFuture<TopicIdAndPartition, ResolveOffsetRangeResult.ResolveOffsetRangeResultInfo> newFuture(Collection<TopicIdAndPartition> topicIdPartitions) {
        return AdminApiFuture.forKeys(new HashSet<TopicIdAndPartition>(topicIdPartitions));
    }
}

