/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ReadShareGroupStateResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class ReadShareGroupStateResponse
extends AbstractResponse {
    private final ReadShareGroupStateResponseData data;

    public ReadShareGroupStateResponse(ReadShareGroupStateResponseData data) {
        super(ApiKeys.READ_SHARE_GROUP_STATE);
        this.data = data;
    }

    @Override
    public ReadShareGroupStateResponseData data() {
        return this.data;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        this.data.results().forEach(result -> result.partitions().forEach(partitionResult -> ReadShareGroupStateResponse.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    @Override
    public int throttleTimeMs() {
        return 0;
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
    }

    public static ReadShareGroupStateResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ReadShareGroupStateResponse(new ReadShareGroupStateResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    public static ReadShareGroupStateResponseData toResponseData(Uuid topicId, int partition, long startOffset, int stateEpoch, List<ReadShareGroupStateResponseData.StateBatch> stateBatches) {
        return new ReadShareGroupStateResponseData().setResults(Collections.singletonList(new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicId).setPartitions(Collections.singletonList(new ReadShareGroupStateResponseData.PartitionResult().setPartition(partition).setStartOffset(startOffset).setStateEpoch(stateEpoch).setStateBatches(stateBatches)))));
    }

    public static ReadShareGroupStateResponseData toErrorResponseData(Uuid topicId, int partitionId, Errors error, String errorMessage) {
        return new ReadShareGroupStateResponseData().setResults(Collections.singletonList(new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicId).setPartitions(Collections.singletonList(new ReadShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage)))));
    }

    public static ReadShareGroupStateResponseData.PartitionResult toErrorResponsePartitionResult(int partitionId, Errors error, String errorMessage) {
        return new ReadShareGroupStateResponseData.PartitionResult().setPartition(partitionId).setErrorCode(error.code()).setErrorMessage(errorMessage);
    }

    public static ReadShareGroupStateResponseData.ReadStateResult toResponseReadStateResult(Uuid topicId, List<ReadShareGroupStateResponseData.PartitionResult> partitionResults) {
        return new ReadShareGroupStateResponseData.ReadStateResult().setTopicId(topicId).setPartitions(partitionResults);
    }
}

