/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.kafka.common.message.DeleteClusterLinksRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteClusterLinksResponse;

public class DeleteClusterLinksRequest
extends AbstractRequest {
    private final DeleteClusterLinksRequestData data;

    public DeleteClusterLinksRequest(DeleteClusterLinksRequestData data, short version) {
        super(ApiKeys.DELETE_CLUSTER_LINKS, version);
        this.data = data;
    }

    public Collection<String> linkNames() {
        return this.data.linkNames();
    }

    public boolean validateOnly() {
        return this.data.validateOnly();
    }

    public boolean force() {
        return this.data.force();
    }

    public int timeoutMs() {
        return this.data.timeoutMs();
    }

    public boolean deleteMetadata() {
        return this.data.deleteMetadata();
    }

    @Override
    public DeleteClusterLinksResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DeleteClusterLinksResponse(this.data.linkNames(), throttleTimeMs, e);
    }

    @Override
    public DeleteClusterLinksRequestData data() {
        return this.data;
    }

    public static DeleteClusterLinksRequest parse(Readable readable, short version, MessageContext context) {
        return new DeleteClusterLinksRequest(new DeleteClusterLinksRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DeleteClusterLinksRequest> {
        private final DeleteClusterLinksRequestData data;

        public Builder(Collection<String> linkNames, boolean validateOnly, boolean force, int timeoutMs) {
            this(linkNames, validateOnly, force, false, timeoutMs);
        }

        public Builder(Collection<String> linkNames, boolean validateOnly, boolean force, boolean deleteMetadata, int timeoutMs) {
            super(ApiKeys.DELETE_CLUSTER_LINKS);
            this.data = new DeleteClusterLinksRequestData().setLinkNames(new ArrayList<String>(linkNames)).setValidateOnly(validateOnly).setForce(force).setDeleteMetadata(deleteMetadata).setTimeoutMs(timeoutMs);
        }

        public Builder(DeleteClusterLinksRequestData data) {
            super(ApiKeys.DELETE_CLUSTER_LINKS);
            this.data = data;
        }

        @Override
        public DeleteClusterLinksRequest build(short version) {
            return new DeleteClusterLinksRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

