/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.AssignTenantsToCellResponse;

public class AssignTenantsToCellRequest
extends AbstractRequest {
    private final AssignTenantsToCellRequestData data;

    AssignTenantsToCellRequest(AssignTenantsToCellRequestData data, short version) {
        super(ApiKeys.ASSIGN_TENANTS_TO_CELL, version);
        this.data = data;
    }

    @Override
    public AssignTenantsToCellRequestData data() {
        return this.data;
    }

    public List<AssignTenantsToCellRequestData.TenantToCellAssignment> tenantsToAssign() {
        return this.data.tenantsToAssign();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t2) {
        ApiError err = ApiError.fromThrowable(t2);
        return new AssignTenantsToCellResponse(new AssignTenantsToCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(err.error().code()).setErrorMessage(err.message()));
    }

    public static AssignTenantsToCellRequest parse(Readable readable, short version, MessageContext context) {
        return new AssignTenantsToCellRequest(new AssignTenantsToCellRequestData(readable, version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AssignTenantsToCellRequest> {
        private final AssignTenantsToCellRequestData data;

        public Builder() {
            super(ApiKeys.ASSIGN_TENANTS_TO_CELL);
            this.data = new AssignTenantsToCellRequestData();
        }

        public Builder(AssignTenantsToCellRequestData data) {
            super(ApiKeys.ASSIGN_TENANTS_TO_CELL);
            this.data = data;
        }

        public Builder(AssignTenantsToCellRequestData data, short version) {
            super(ApiKeys.ASSIGN_TENANTS_TO_CELL, version);
            this.data = data;
        }

        public Builder setTenants(List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments) {
            this.data.setTenantsToAssign(assignments);
            return this;
        }

        @Override
        public AssignTenantsToCellRequest build(short version) {
            return new AssignTenantsToCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

