/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.AddPartitionsToTxnResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class AddPartitionsToTxnResponse
extends AbstractResponse {
    private final AddPartitionsToTxnResponseData data;
    public static final String V3_AND_BELOW_TXN_ID = "";

    public AddPartitionsToTxnResponse(AddPartitionsToTxnResponseData data) {
        super(ApiKeys.ADD_PARTITIONS_TO_TXN);
        this.data = data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    public Map<String, Map<TopicPartition, Errors>> errors() {
        HashMap<String, Map<TopicPartition, Errors>> errorsMap = new HashMap<String, Map<TopicPartition, Errors>>();
        if (!this.data.resultsByTopicV3AndBelow().isEmpty()) {
            errorsMap.put(V3_AND_BELOW_TXN_ID, AddPartitionsToTxnResponse.errorsForTransaction(this.data.resultsByTopicV3AndBelow()));
        }
        for (AddPartitionsToTxnResponseData.AddPartitionsToTxnResult result : this.data.resultsByTransaction()) {
            errorsMap.put(result.transactionalId(), AddPartitionsToTxnResponse.errorsForTransaction(result.topicResults()));
        }
        return errorsMap;
    }

    private static AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicCollectionForErrors(Map<TopicPartition, Errors> errors) {
        HashMap<String, AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection> resultMap = new HashMap<String, AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection>();
        for (Map.Entry<TopicPartition, Errors> entry : errors.entrySet()) {
            TopicPartition topicPartition = entry.getKey();
            String topicName = topicPartition.topic();
            AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult partitionResult = new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult().setPartitionErrorCode(entry.getValue().code()).setPartitionIndex(topicPartition.partition());
            AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection partitionResultCollection = resultMap.getOrDefault(topicName, new AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection());
            partitionResultCollection.add(partitionResult);
            resultMap.put(topicName, partitionResultCollection);
        }
        AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicCollection = new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection();
        for (Map.Entry entry : resultMap.entrySet()) {
            topicCollection.add(new AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult().setName((String)entry.getKey()).setResultsByPartition((AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResultCollection)entry.getValue()));
        }
        return topicCollection;
    }

    public static AddPartitionsToTxnResponseData.AddPartitionsToTxnResult resultForTransaction(String transactionalId, Map<TopicPartition, Errors> errors) {
        return new AddPartitionsToTxnResponseData.AddPartitionsToTxnResult().setTransactionalId(transactionalId).setTopicResults(AddPartitionsToTxnResponse.topicCollectionForErrors(errors));
    }

    public AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection getTransactionTopicResults(String transactionalId) {
        return this.data.resultsByTransaction().find(transactionalId).topicResults();
    }

    public static Map<TopicPartition, Errors> errorsForTransaction(AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResultCollection topicCollection) {
        HashMap<TopicPartition, Errors> topicResults = new HashMap<TopicPartition, Errors>();
        for (AddPartitionsToTxnResponseData.AddPartitionsToTxnTopicResult topicResult : topicCollection) {
            for (AddPartitionsToTxnResponseData.AddPartitionsToTxnPartitionResult partitionResult : topicResult.resultsByPartition()) {
                topicResults.put(new TopicPartition(topicResult.name(), partitionResult.partitionIndex()), Errors.forCode(partitionResult.partitionErrorCode()));
            }
        }
        return topicResults;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        ArrayList<Errors> allErrors = new ArrayList<Errors>();
        if (this.data.resultsByTopicV3AndBelow().isEmpty()) {
            allErrors.add(Errors.forCode(this.data.errorCode()));
        }
        this.errors().forEach((txnId, errors) -> allErrors.addAll(errors.values()));
        return AddPartitionsToTxnResponse.errorCounts(allErrors);
    }

    @Override
    public AddPartitionsToTxnResponseData data() {
        return this.data;
    }

    public static AddPartitionsToTxnResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AddPartitionsToTxnResponse(new AddPartitionsToTxnResponseData(new ByteBufferAccessor(buffer), version, context));
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 1;
    }
}

