/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RemoveBrokersResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    List<RemoveBrokerResponse> brokersToRemove;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public RemoveBrokersResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RemoveBrokersResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.brokersToRemove = new ArrayList<RemoveBrokerResponse>(0);
    }

    @Override
    public short apiKey() {
        return 10001;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 1;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString(length);
        }
        int arrayLength = _readable.readInt();
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field brokersToRemove was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<RemoveBrokerResponse> newCollection = new ArrayList<RemoveBrokerResponse>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new RemoveBrokerResponse(_readable, _version, _context));
        }
        this.brokersToRemove = newCollection;
        this._unknownTaggedFields = null;
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            _stringBytes = _cache.getSerializedValue(this.errorMessage);
            _writable.writeShort((short)((byte[])_stringBytes).length);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _writable.writeInt(this.brokersToRemove.size());
        _stringBytes = this.brokersToRemove.iterator();
        while (_stringBytes.hasNext()) {
            RemoveBrokerResponse brokersToRemoveElement = (RemoveBrokerResponse)_stringBytes.next();
            brokersToRemoveElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(2);
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        _size.addBytes(4);
        for (RemoveBrokerResponse brokersToRemoveElement : this.brokersToRemove) {
            brokersToRemoveElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RemoveBrokersResponseData)) {
            return false;
        }
        RemoveBrokersResponseData other = (RemoveBrokersResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.brokersToRemove == null ? other.brokersToRemove != null : !this.brokersToRemove.equals(other.brokersToRemove)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.brokersToRemove == null ? 0 : this.brokersToRemove.hashCode());
        return hashCode;
    }

    @Override
    public RemoveBrokersResponseData duplicate() {
        RemoveBrokersResponseData _duplicate = new RemoveBrokersResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        ArrayList<RemoveBrokerResponse> newBrokersToRemove = new ArrayList<RemoveBrokerResponse>(this.brokersToRemove.size());
        for (RemoveBrokerResponse _element : this.brokersToRemove) {
            newBrokersToRemove.add(_element.duplicate());
        }
        _duplicate.brokersToRemove = newBrokersToRemove;
        return _duplicate;
    }

    public String toString() {
        return "RemoveBrokersResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", brokersToRemove=" + MessageUtil.deepToString(this.brokersToRemove.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public List<RemoveBrokerResponse> brokersToRemove() {
        return this.brokersToRemove;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RemoveBrokersResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public RemoveBrokersResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public RemoveBrokersResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public RemoveBrokersResponseData setBrokersToRemove(List<RemoveBrokerResponse> v) {
        this.brokersToRemove = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code"), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."), new Field("brokers_to_remove", new ArrayOf(RemoveBrokerResponse.SCHEMA_0), "Response for the broker removal requests."));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class RemoveBrokerResponse
    implements Message {
        int brokerId;
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public RemoveBrokerResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public RemoveBrokerResponse() {
            this.brokerId = 0;
            this.errorCode = 0;
            this.errorMessage = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 1;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of RemoveBrokerResponse");
            }
            this.brokerId = _readable.readInt();
            this.errorCode = _readable.readShort();
            short length = _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.brokerId);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of RemoveBrokerResponse");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this.errorMessage == null) {
                _size.addBytes(2);
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RemoveBrokerResponse)) {
                return false;
            }
            RemoveBrokerResponse other = (RemoveBrokerResponse)obj;
            if (this.brokerId != other.brokerId) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.brokerId;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        @Override
        public RemoveBrokerResponse duplicate() {
            RemoveBrokerResponse _duplicate = new RemoveBrokerResponse();
            _duplicate.brokerId = this.brokerId;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "RemoveBrokerResponse(brokerId=" + this.brokerId + ", errorCode=" + this.errorCode + ", errorMessage=" + (String)(this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public int brokerId() {
            return this.brokerId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public RemoveBrokerResponse setBrokerId(int v) {
            this.brokerId = v;
            return this;
        }

        public RemoveBrokerResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public RemoveBrokerResponse setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("broker_id", Type.INT32, "The Broker ID for which the removal was requested"), new Field("error_code", Type.INT16, "The error code for the removal request."), new Field("error_message", Type.NULLABLE_STRING, "The error message, or null if there was no error."));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

