/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeClusterRequestData
implements ApiMessage {
    boolean includeClusterAuthorizedOperations;
    byte endpointType;
    boolean includeFencedBrokers;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_1 = new Schema(new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), new Field("endpoint_type", Type.INT8, "The endpoint type to describe. 1=brokers, 2=controllers."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema SCHEMA_2 = new Schema(new Field("include_cluster_authorized_operations", Type.BOOLEAN, "Whether to include cluster authorized operations."), new Field("endpoint_type", Type.INT8, "The endpoint type to describe. 1=brokers, 2=controllers."), new Field("include_fenced_brokers", Type.BOOLEAN, "Whether to include fenced brokers when listing brokers."), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public DescribeClusterRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeClusterRequestData() {
        this.includeClusterAuthorizedOperations = false;
        this.endpointType = 1;
        this.includeFencedBrokers = false;
    }

    @Override
    public short apiKey() {
        return 60;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.includeClusterAuthorizedOperations = _readable.readByte() != 0;
        this.endpointType = _version >= 1 ? _readable.readByte() : (byte)1;
        this.includeFencedBrokers = _version >= 2 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeByte(this.includeClusterAuthorizedOperations ? (byte)1 : 0);
        if (_version >= 1) {
            _writable.writeByte(this.endpointType);
        } else if (this.endpointType != 1) {
            throw new UnsupportedVersionException("Attempted to write a non-default endpointType at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeByte(this.includeFencedBrokers ? (byte)1 : 0);
        } else if (this.includeFencedBrokers) {
            throw new UnsupportedVersionException("Attempted to write a non-default includeFencedBrokers at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(1);
        if (_version >= 1) {
            _size.addBytes(1);
        }
        if (_version >= 2) {
            _size.addBytes(1);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeClusterRequestData)) {
            return false;
        }
        DescribeClusterRequestData other = (DescribeClusterRequestData)obj;
        if (this.includeClusterAuthorizedOperations != other.includeClusterAuthorizedOperations) {
            return false;
        }
        if (this.endpointType != other.endpointType) {
            return false;
        }
        if (this.includeFencedBrokers != other.includeFencedBrokers) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.includeClusterAuthorizedOperations ? 1231 : 1237);
        hashCode = 31 * hashCode + this.endpointType;
        hashCode = 31 * hashCode + (this.includeFencedBrokers ? 1231 : 1237);
        return hashCode;
    }

    @Override
    public DescribeClusterRequestData duplicate() {
        DescribeClusterRequestData _duplicate = new DescribeClusterRequestData();
        _duplicate.includeClusterAuthorizedOperations = this.includeClusterAuthorizedOperations;
        _duplicate.endpointType = this.endpointType;
        _duplicate.includeFencedBrokers = this.includeFencedBrokers;
        return _duplicate;
    }

    public String toString() {
        return "DescribeClusterRequestData(includeClusterAuthorizedOperations=" + (this.includeClusterAuthorizedOperations ? "true" : "false") + ", endpointType=" + this.endpointType + ", includeFencedBrokers=" + (this.includeFencedBrokers ? "true" : "false") + ")";
    }

    public boolean includeClusterAuthorizedOperations() {
        return this.includeClusterAuthorizedOperations;
    }

    public byte endpointType() {
        return this.endpointType;
    }

    public boolean includeFencedBrokers() {
        return this.includeFencedBrokers;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeClusterRequestData setIncludeClusterAuthorizedOperations(boolean v) {
        this.includeClusterAuthorizedOperations = v;
        return this;
    }

    public DescribeClusterRequestData setEndpointType(byte v) {
        this.endpointType = v;
        return this;
    }

    public DescribeClusterRequestData setIncludeFencedBrokers(boolean v) {
        this.includeFencedBrokers = v;
        return this;
    }
}

