/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.util;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanId;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.util.concurrent.Callable;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.requests.RequestHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryManager {
    private static Logger logger = LoggerFactory.getLogger(OpenTelemetryManager.class);
    public static Tracer tracer = GlobalOpenTelemetry.getTracer("org.apache.kafka");

    public static Context extractContext(RequestHeader header) {
        if (header.traceContext() == null) {
            return Context.current();
        }
        RequestHeaderData.TraceContext tc = header.traceContext();
        if (!OpenTelemetryManager.isValid(tc)) {
            logger.debug("extract invalid telemetry context from request: " + header.apiKey().name);
            return Context.current();
        }
        SpanContext spCtx = SpanContext.createFromRemoteParent(OpenTelemetryManager.extractStringTraceId(tc), OpenTelemetryManager.extractStringSpanId(tc), OpenTelemetryManager.extractTraceFlags(tc), TraceState.getDefault());
        Span sp = Span.wrap(spCtx);
        Context ctx = Context.root().with(sp);
        logger.debug("extract telemetry context: " + ctx.toString() + ", request: " + header.apiKey().name);
        return ctx;
    }

    public static void injectContext(Context ctx, RequestHeader header) {
        SpanContext spc = Span.fromContext(ctx).getSpanContext();
        if (!spc.isValid()) {
            return;
        }
        RequestHeaderData.TraceContext tc = new RequestHeaderData.TraceContext().setTraceId(spc.getTraceIdBytes()).setParentSpanId(spc.getSpanIdBytes()).setTraceFlags(spc.getTraceFlags().asByte());
        header.data().setTraceContext(tc);
        logger.debug("inject telemetry context: " + ctx.toString() + ", request: " + header.apiKey().name);
    }

    public static boolean isValid(RequestHeaderData.TraceContext tc) {
        return TraceId.isValid(OpenTelemetryManager.extractStringTraceId(tc)) && SpanId.isValid(OpenTelemetryManager.extractStringSpanId(tc));
    }

    private static String extractStringTraceId(RequestHeaderData.TraceContext tc) {
        return TraceId.fromBytes(tc.traceId());
    }

    private static String extractStringSpanId(RequestHeaderData.TraceContext tc) {
        return SpanId.fromBytes(tc.parentSpanId());
    }

    private static TraceFlags extractTraceFlags(RequestHeaderData.TraceContext tc) {
        return TraceFlags.fromByte(tc.traceFlags());
    }

    public static Span createSpanIfParentsExist(String spanName, Context context) {
        Span sp = Span.fromContextOrNull(context);
        if (sp == null || sp.equals(Span.getInvalid())) {
            return Span.getInvalid();
        }
        return tracer.spanBuilder(spanName).setParent(context).startSpan();
    }

    public static Span createSpan(String spanName, Context context) {
        return tracer.spanBuilder(spanName).setParent(context).startSpan();
    }

    public static <T> T trace(Span span, Callable<T> call) throws Exception {
        try {
            T t2;
            block9: {
                Scope scope = span.makeCurrent();
                try {
                    t2 = call.call();
                    if (scope == null) break block9;
                    scope.close();
                }
                catch (Throwable throwable) {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            return t2;
        }
        finally {
            span.end();
        }
    }
}

