/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackCompletedEvent;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;

public interface MembershipManager
extends RequestManager {
    public String groupId();

    public Optional<String> groupInstanceId();

    public String memberId();

    public int memberEpoch();

    public MemberState state();

    public void onHeartbeatSuccess(ConsumerGroupHeartbeatResponseData var1);

    public void onHeartbeatFailure();

    public void onHeartbeatRequestSent();

    public void onHeartbeatRequestSkipped();

    public Optional<String> serverAssignor();

    public LocalAssignment currentAssignment();

    public void transitionToFenced();

    public void transitionToFatal();

    public CompletableFuture<Void> leaveGroup();

    public boolean shouldHeartbeatNow();

    public boolean shouldSkipHeartbeat();

    public void onSubscriptionUpdated();

    public void consumerRebalanceListenerCallbackCompleted(ConsumerRebalanceListenerCallbackCompletedEvent var1);

    public void transitionToJoining();

    public void transitionToSendingLeaveGroup(boolean var1);

    public void registerStateListener(MemberStateListener var1);

    public boolean isLeavingGroup();

    public void maybeRejoinStaleMember();

    public static final class LocalAssignment {
        public static final long NONE_EPOCH = -1L;
        public static final LocalAssignment NONE = new LocalAssignment(-1L, Collections.emptyMap());
        public final long localEpoch;
        public final Map<Uuid, SortedSet<Integer>> partitions;

        public LocalAssignment(long localEpoch, Map<Uuid, SortedSet<Integer>> partitions) {
            this.localEpoch = localEpoch;
            this.partitions = partitions;
            if (localEpoch == -1L && !partitions.isEmpty()) {
                throw new IllegalArgumentException("Local epoch must be set if there are partitions");
            }
        }

        public LocalAssignment(long localEpoch, SortedSet<TopicIdPartition> topicIdPartitions) {
            this.localEpoch = localEpoch;
            this.partitions = new HashMap<Uuid, SortedSet<Integer>>();
            if (localEpoch == -1L && !topicIdPartitions.isEmpty()) {
                throw new IllegalArgumentException("Local epoch must be set if there are partitions");
            }
            topicIdPartitions.forEach(topicIdPartition -> {
                Uuid topicId = topicIdPartition.topicId();
                this.partitions.computeIfAbsent(topicId, k -> new TreeSet()).add(topicIdPartition.partition());
            });
        }

        public String toString() {
            return "LocalAssignment{localEpoch=" + this.localEpoch + ", partitions=" + this.partitions + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalAssignment that = (LocalAssignment)o;
            return this.localEpoch == that.localEpoch && Objects.equals(this.partitions, that.partitions);
        }

        public int hashCode() {
            return Objects.hash(this.localEpoch, this.partitions);
        }

        public boolean isNone() {
            return this.localEpoch == -1L;
        }

        Optional<LocalAssignment> updateWith(ConsumerGroupHeartbeatResponseData.Assignment assignment) {
            if (this.localEpoch != -1L && this.partitions.size() == assignment.topicPartitions().size() && assignment.topicPartitions().stream().allMatch(tp -> this.partitions.containsKey(tp.topicId()) && this.partitions.get(tp.topicId()).size() == tp.partitions().size() && this.partitions.get(tp.topicId()).containsAll(tp.partitions()))) {
                return Optional.empty();
            }
            long nextLocalEpoch = this.localEpoch + 1L;
            HashMap<Uuid, SortedSet<Integer>> partitions = new HashMap<Uuid, SortedSet<Integer>>();
            assignment.topicPartitions().forEach(topicPartitions -> {
                SortedSet cfr_ignored_0 = partitions.put(topicPartitions.topicId(), new TreeSet<Integer>(topicPartitions.partitions()));
            });
            return Optional.of(new LocalAssignment(nextLocalEpoch, partitions));
        }
    }
}

