/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.Arrays;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Percentile;
import org.apache.kafka.common.metrics.stats.Percentiles;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class MetricsBench {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long iters = Long.parseLong(args[0]);
        try (Metrics metrics = new Metrics();){
            Sensor parent = metrics.sensor("parent");
            Sensor child = metrics.sensor("child", new Sensor[]{parent});
            for (Sensor sensor : Arrays.asList(parent, child)) {
                sensor.add(metrics.metricName(sensor.name() + ".avg", "grp1"), (MeasurableStat)new Avg());
                sensor.add(metrics.metricName(sensor.name() + ".count", "grp1"), (MeasurableStat)new WindowedCount());
                sensor.add(metrics.metricName(sensor.name() + ".max", "grp1"), (MeasurableStat)new Max());
                sensor.add((CompoundStat)new Percentiles(1024, 0.0, (double)iters, Percentiles.BucketSizing.CONSTANT, new Percentile[]{new Percentile(metrics.metricName(sensor.name() + ".median", "grp1"), 50.0), new Percentile(metrics.metricName(sensor.name() + ".p_99", "grp1"), 99.0)}));
            }
            long start = System.nanoTime();
            int i = 0;
            while ((long)i < iters) {
                parent.record((double)i);
                ++i;
            }
            double elapsed = (double)(System.nanoTime() - start) / (double)iters;
            System.out.println(String.format("%.2f ns per metric recording.", elapsed));
        }
    }
}

