/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer.internals.unsecured;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import org.apache.kafka.common.security.authenticator.TestJaasConfig;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerConfigException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerIllegalTokenException;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredJws;
import org.apache.kafka.common.security.oauthbearer.internals.unsecured.OAuthBearerUnsecuredValidatorCallbackHandler;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerUnsecuredValidatorCallbackHandlerTest {
    private static final String UNSECURED_JWT_HEADER_JSON = "{" + OAuthBearerUnsecuredValidatorCallbackHandlerTest.claimOrHeaderText("alg", "none") + "}";
    private static final Time MOCK_TIME = new MockTime();
    private static final String QUOTE = "\"";
    private static final String PRINCIPAL_CLAIM_VALUE = "username";
    private static final String PRINCIPAL_CLAIM_TEXT = OAuthBearerUnsecuredValidatorCallbackHandlerTest.claimOrHeaderText("principal", "username");
    private static final String SUB_CLAIM_TEXT = OAuthBearerUnsecuredValidatorCallbackHandlerTest.claimOrHeaderText("sub", "username");
    private static final String BAD_PRINCIPAL_CLAIM_TEXT = OAuthBearerUnsecuredValidatorCallbackHandlerTest.claimOrHeaderText("principal", 1);
    private static final long LIFETIME_SECONDS_TO_USE = 3600000L;
    private static final String EXPIRATION_TIME_CLAIM_TEXT = OAuthBearerUnsecuredValidatorCallbackHandlerTest.expClaimText(3600000L);
    private static final String TOO_EARLY_EXPIRATION_TIME_CLAIM_TEXT = OAuthBearerUnsecuredValidatorCallbackHandlerTest.expClaimText(0L);
    private static final String ISSUED_AT_CLAIM_TEXT = OAuthBearerUnsecuredValidatorCallbackHandlerTest.claimOrHeaderText("iat", (double)MOCK_TIME.milliseconds() / 1000.0);
    private static final String SCOPE_CLAIM_TEXT = OAuthBearerUnsecuredValidatorCallbackHandlerTest.claimOrHeaderText("scope", "scope1");
    private static final Map<String, String> MODULE_OPTIONS_MAP_NO_SCOPE_REQUIRED;
    private static final Map<String, String> MODULE_OPTIONS_MAP_REQUIRE_EXISTING_SCOPE;
    private static final Map<String, String> MODULE_OPTIONS_MAP_REQUIRE_ADDITIONAL_SCOPE;

    @Test
    public void validToken() {
        for (boolean includeOptionalIssuedAtClaim : new boolean[]{true, false}) {
            String claimsJson = "{" + PRINCIPAL_CLAIM_TEXT + OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(EXPIRATION_TIME_CLAIM_TEXT) + (includeOptionalIssuedAtClaim ? OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(ISSUED_AT_CLAIM_TEXT) : "") + "}";
            Object validationResult = OAuthBearerUnsecuredValidatorCallbackHandlerTest.validationResult(UNSECURED_JWT_HEADER_JSON, claimsJson, MODULE_OPTIONS_MAP_NO_SCOPE_REQUIRED);
            Assertions.assertTrue((boolean)(validationResult instanceof OAuthBearerValidatorCallback));
            Assertions.assertTrue((boolean)(((OAuthBearerValidatorCallback)validationResult).token() instanceof OAuthBearerUnsecuredJws));
        }
    }

    @Test
    public void badOrMissingPrincipal() {
        for (boolean exists : new boolean[]{true, false}) {
            String claimsJson = "{" + EXPIRATION_TIME_CLAIM_TEXT + (exists ? OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(BAD_PRINCIPAL_CLAIM_TEXT) : "") + "}";
            OAuthBearerUnsecuredValidatorCallbackHandlerTest.confirmFailsValidation(UNSECURED_JWT_HEADER_JSON, claimsJson, MODULE_OPTIONS_MAP_NO_SCOPE_REQUIRED);
        }
    }

    @Test
    public void tooEarlyExpirationTime() {
        String claimsJson = "{" + PRINCIPAL_CLAIM_TEXT + OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(ISSUED_AT_CLAIM_TEXT) + OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(TOO_EARLY_EXPIRATION_TIME_CLAIM_TEXT) + "}";
        OAuthBearerUnsecuredValidatorCallbackHandlerTest.confirmFailsValidation(UNSECURED_JWT_HEADER_JSON, claimsJson, MODULE_OPTIONS_MAP_NO_SCOPE_REQUIRED);
    }

    @Test
    public void includesRequiredScope() {
        String claimsJson = "{" + SUB_CLAIM_TEXT + OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(EXPIRATION_TIME_CLAIM_TEXT) + OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(SCOPE_CLAIM_TEXT) + "}";
        Object validationResult = OAuthBearerUnsecuredValidatorCallbackHandlerTest.validationResult(UNSECURED_JWT_HEADER_JSON, claimsJson, MODULE_OPTIONS_MAP_REQUIRE_EXISTING_SCOPE);
        Assertions.assertTrue((boolean)(validationResult instanceof OAuthBearerValidatorCallback));
        Assertions.assertTrue((boolean)(((OAuthBearerValidatorCallback)validationResult).token() instanceof OAuthBearerUnsecuredJws));
    }

    @Test
    public void missingRequiredScope() {
        String claimsJson = "{" + SUB_CLAIM_TEXT + OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(EXPIRATION_TIME_CLAIM_TEXT) + OAuthBearerUnsecuredValidatorCallbackHandlerTest.comma(SCOPE_CLAIM_TEXT) + "}";
        OAuthBearerUnsecuredValidatorCallbackHandlerTest.confirmFailsValidation(UNSECURED_JWT_HEADER_JSON, claimsJson, MODULE_OPTIONS_MAP_REQUIRE_ADDITIONAL_SCOPE, "[scope1, scope2]");
    }

    private static void confirmFailsValidation(String headerJson, String claimsJson, Map<String, String> moduleOptionsMap) throws OAuthBearerConfigException, OAuthBearerIllegalTokenException {
        OAuthBearerUnsecuredValidatorCallbackHandlerTest.confirmFailsValidation(headerJson, claimsJson, moduleOptionsMap, null);
    }

    private static void confirmFailsValidation(String headerJson, String claimsJson, Map<String, String> moduleOptionsMap, String optionalFailureScope) throws OAuthBearerConfigException, OAuthBearerIllegalTokenException {
        Object validationResultObj = OAuthBearerUnsecuredValidatorCallbackHandlerTest.validationResult(headerJson, claimsJson, moduleOptionsMap);
        Assertions.assertTrue((boolean)(validationResultObj instanceof OAuthBearerValidatorCallback));
        OAuthBearerValidatorCallback callback = (OAuthBearerValidatorCallback)validationResultObj;
        Assertions.assertNull((Object)callback.token());
        Assertions.assertNull((Object)callback.errorOpenIDConfiguration());
        if (optionalFailureScope == null) {
            Assertions.assertEquals((Object)"invalid_token", (Object)callback.errorStatus());
            Assertions.assertNull((Object)callback.errorScope());
        } else {
            Assertions.assertEquals((Object)"insufficient_scope", (Object)callback.errorStatus());
            Assertions.assertEquals((Object)optionalFailureScope, (Object)callback.errorScope());
        }
    }

    private static Object validationResult(String headerJson, String claimsJson, Map<String, String> moduleOptionsMap) {
        Base64.Encoder urlEncoderNoPadding = Base64.getUrlEncoder().withoutPadding();
        try {
            String tokenValue = String.format("%s.%s.", urlEncoderNoPadding.encodeToString(headerJson.getBytes(StandardCharsets.UTF_8)), urlEncoderNoPadding.encodeToString(claimsJson.getBytes(StandardCharsets.UTF_8)));
            OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(tokenValue);
            OAuthBearerUnsecuredValidatorCallbackHandlerTest.createCallbackHandler(moduleOptionsMap).handle(new Callback[]{callback});
            return callback;
        }
        catch (Exception e) {
            return e;
        }
    }

    private static OAuthBearerUnsecuredValidatorCallbackHandler createCallbackHandler(Map<String, String> options) {
        TestJaasConfig config = new TestJaasConfig();
        config.createOrUpdateEntry("KafkaClient", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule", options);
        OAuthBearerUnsecuredValidatorCallbackHandler callbackHandler = new OAuthBearerUnsecuredValidatorCallbackHandler();
        callbackHandler.configure(Collections.emptyMap(), "OAUTHBEARER", Arrays.asList(config.getAppConfigurationEntry("KafkaClient")[0]));
        return callbackHandler;
    }

    private static String comma(String value) {
        return "," + value;
    }

    private static String claimOrHeaderText(String claimName, Number claimValue) {
        return QUOTE + claimName + QUOTE + ":" + claimValue;
    }

    private static String claimOrHeaderText(String claimName, String claimValue) {
        return QUOTE + claimName + QUOTE + ":" + QUOTE + claimValue + QUOTE;
    }

    private static String expClaimText(long lifetimeSeconds) {
        return OAuthBearerUnsecuredValidatorCallbackHandlerTest.claimOrHeaderText("exp", (double)MOCK_TIME.milliseconds() / 1000.0 + (double)lifetimeSeconds);
    }

    static {
        HashMap<String, String> tmp = new HashMap<String, String>();
        tmp.put("unsecuredValidatorPrincipalClaimName", "principal");
        tmp.put("unsecuredValidatorAllowableClockSkewMs", "1");
        MODULE_OPTIONS_MAP_NO_SCOPE_REQUIRED = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put("unsecuredValidatorRequiredScope", "scope1");
        MODULE_OPTIONS_MAP_REQUIRE_EXISTING_SCOPE = Collections.unmodifiableMap(tmp);
        tmp = new HashMap();
        tmp.put("unsecuredValidatorRequiredScope", "scope1 scope2");
        MODULE_OPTIONS_MAP_REQUIRE_ADDITIONAL_SCOPE = Collections.unmodifiableMap(tmp);
    }
}

