/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.Collections;
import java.util.Set;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerValidatorCallback;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerValidatorCallbackTest {
    private static final OAuthBearerToken TOKEN = new OAuthBearerToken(){

        public String value() {
            return "value";
        }

        public Long startTimeMs() {
            return null;
        }

        public Set<String> scope() {
            return Collections.emptySet();
        }

        public String principalName() {
            return "principalName";
        }

        public long lifetimeMs() {
            return 0L;
        }
    };

    @Test
    public void testError() {
        String errorStatus = "errorStatus";
        String errorScope = "errorScope";
        String errorOpenIDConfiguration = "errorOpenIDConfiguration";
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(TOKEN.value());
        callback.error(errorStatus, errorScope, errorOpenIDConfiguration);
        Assertions.assertEquals((Object)errorStatus, (Object)callback.errorStatus());
        Assertions.assertEquals((Object)errorScope, (Object)callback.errorScope());
        Assertions.assertEquals((Object)errorOpenIDConfiguration, (Object)callback.errorOpenIDConfiguration());
        Assertions.assertNull((Object)callback.token());
    }

    @Test
    public void testToken() {
        OAuthBearerValidatorCallback callback = new OAuthBearerValidatorCallback(TOKEN.value());
        callback.token(TOKEN);
        Assertions.assertSame((Object)TOKEN, (Object)callback.token());
        Assertions.assertNull((Object)callback.errorStatus());
        Assertions.assertNull((Object)callback.errorScope());
        Assertions.assertNull((Object)callback.errorOpenIDConfiguration());
    }
}

