/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.DefaultEventHandler;
import org.apache.kafka.clients.consumer.internals.NoopBackgroundEvent;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.NoopApplicationEvent;
import org.apache.kafka.common.internals.ClusterResourceListeners;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class DefaultEventHandlerTest {
    private final Properties properties = new Properties();

    @BeforeEach
    public void setup() {
        this.properties.put("key.deserializer", StringDeserializer.class);
        this.properties.put("value.deserializer", StringDeserializer.class);
        this.properties.put("retry.backoff.ms", "100");
    }

    @Test
    @Timeout(value=1L)
    public void testBasicPollAndAddWithNoopEvent() {
        MockTime time = new MockTime(1L);
        LogContext logContext = new LogContext();
        SubscriptionState subscriptions = new SubscriptionState(new LogContext(), OffsetResetStrategy.NONE);
        ConsumerMetadata metadata = DefaultEventHandlerTest.newConsumerMetadata(false, subscriptions);
        MockClient client = new MockClient((Time)time, (Metadata)metadata);
        ConsumerNetworkClient consumerClient = new ConsumerNetworkClient(logContext, (KafkaClient)client, (Metadata)metadata, (Time)time, 100L, 1000, 100);
        LinkedBlockingQueue aq = new LinkedBlockingQueue();
        LinkedBlockingQueue bq = new LinkedBlockingQueue();
        DefaultEventHandler handler = new DefaultEventHandler((Time)time, new ConsumerConfig(this.properties), logContext, aq, bq, subscriptions, metadata, consumerClient);
        Assertions.assertTrue((boolean)client.active());
        Assertions.assertTrue((boolean)handler.isEmpty());
        handler.add((ApplicationEvent)new NoopApplicationEvent(bq, "testBasicPollAndAddWithNoopEvent"));
        while (handler.isEmpty()) {
            time.sleep(100L);
        }
        Optional poll = handler.poll();
        Assertions.assertTrue((boolean)poll.isPresent());
        Assertions.assertTrue((boolean)(poll.get() instanceof NoopBackgroundEvent));
        Assertions.assertFalse((boolean)client.hasInFlightRequests());
    }

    private static ConsumerMetadata newConsumerMetadata(boolean includeInternalTopics, SubscriptionState subscriptions) {
        long refreshBackoffMs = 50L;
        long expireMs = 50000L;
        return new ConsumerMetadata(50L, 50000L, includeInternalTopics, false, subscriptions, new LogContext(), new ClusterResourceListeners());
    }
}

