/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.clients.consumer.internals.DefaultBackgroundThread;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.NoopApplicationEvent;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class DefaultBackgroundThreadTest {
    private static final long REFRESH_BACK_OFF_MS = 100L;
    private final Properties properties = new Properties();
    private MockTime time;
    private SubscriptionState subscriptions;
    private ConsumerMetadata metadata;
    private LogContext context;
    private ConsumerNetworkClient consumerClient;
    private Metrics metrics;
    private BlockingQueue<BackgroundEvent> backgroundEventsQueue;
    private BlockingQueue<ApplicationEvent> applicationEventsQueue;

    @BeforeEach
    public void setup() {
        this.time = new MockTime();
        this.subscriptions = (SubscriptionState)Mockito.mock(SubscriptionState.class);
        this.metadata = (ConsumerMetadata)Mockito.mock(ConsumerMetadata.class);
        this.context = new LogContext();
        this.consumerClient = (ConsumerNetworkClient)Mockito.mock(ConsumerNetworkClient.class);
        this.metrics = (Metrics)Mockito.mock(Metrics.class);
        this.applicationEventsQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        this.backgroundEventsQueue = (BlockingQueue)Mockito.mock(BlockingQueue.class);
        this.properties.put("key.deserializer", StringDeserializer.class);
        this.properties.put("value.deserializer", StringDeserializer.class);
        this.properties.put("retry.backoff.ms", (Object)100L);
    }

    @Test
    public void testStartupAndTearDown() throws InterruptedException {
        MockClient client = new MockClient((Time)this.time, (Metadata)this.metadata);
        this.consumerClient = new ConsumerNetworkClient(this.context, (KafkaClient)client, (Metadata)this.metadata, (Time)this.time, 100L, 1000, 100);
        this.applicationEventsQueue = new LinkedBlockingQueue<ApplicationEvent>();
        DefaultBackgroundThread backgroundThread = this.setupMockHandler();
        backgroundThread.start();
        Assertions.assertTrue((boolean)client.active());
        backgroundThread.close();
        Assertions.assertFalse((boolean)client.active());
    }

    @Test
    public void testInterruption() throws InterruptedException {
        MockClient client = new MockClient((Time)this.time, (Metadata)this.metadata);
        this.consumerClient = new ConsumerNetworkClient(this.context, (KafkaClient)client, (Metadata)this.metadata, (Time)this.time, 100L, 1000, 100);
        this.applicationEventsQueue = new LinkedBlockingQueue<ApplicationEvent>();
        DefaultBackgroundThread backgroundThread = this.setupMockHandler();
        backgroundThread.start();
        Assertions.assertTrue((boolean)client.active());
        backgroundThread.close();
        Assertions.assertFalse((boolean)client.active());
    }

    @Test
    void testWakeup() {
        this.time = new MockTime(0L);
        MockClient client = new MockClient((Time)this.time, (Metadata)this.metadata);
        this.consumerClient = new ConsumerNetworkClient(this.context, (KafkaClient)client, (Metadata)this.metadata, (Time)this.time, 100L, 1000, 100);
        Mockito.when((Object)this.applicationEventsQueue.isEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.applicationEventsQueue.isEmpty()).thenReturn((Object)true);
        DefaultBackgroundThread runnable = this.setupMockHandler();
        client.poll(0L, this.time.milliseconds());
        runnable.wakeup();
        Assertions.assertThrows(WakeupException.class, () -> ((DefaultBackgroundThread)runnable).runOnce());
        runnable.close();
    }

    @Test
    void testNetworkAndBlockingQueuePoll() {
        this.time = new MockTime(100L);
        DefaultBackgroundThread runnable = this.setupMockHandler();
        runnable.runOnce();
        Mockito.when((Object)this.applicationEventsQueue.isEmpty()).thenReturn((Object)false);
        Mockito.when(this.applicationEventsQueue.poll()).thenReturn((Object)new NoopApplicationEvent(this.backgroundEventsQueue, "nothing"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.applicationEventsQueue, this.consumerClient});
        Assertions.assertFalse((boolean)((BlockingQueue)inOrder.verify(this.applicationEventsQueue)).isEmpty());
        ((BlockingQueue)inOrder.verify(this.applicationEventsQueue)).poll();
        ((ConsumerNetworkClient)inOrder.verify((Object)this.consumerClient)).poll((Timer)ArgumentMatchers.any(Timer.class));
        runnable.close();
    }

    private DefaultBackgroundThread setupMockHandler() {
        return new DefaultBackgroundThread((Time)this.time, new ConsumerConfig(this.properties), new LogContext(), this.applicationEventsQueue, this.backgroundEventsQueue, this.subscriptions, this.metadata, this.consumerClient, this.metrics);
    }
}

