/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.internals.AdminApiHandler;
import org.apache.kafka.clients.admin.internals.AlterConsumerGroupOffsetsHandler;
import org.apache.kafka.clients.admin.internals.CoordinatorKey;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AlterConsumerGroupOffsetsHandlerTest {
    private final LogContext logContext = new LogContext();
    private final String groupId = "group-id";
    private final TopicPartition t0p0 = new TopicPartition("t0", 0);
    private final TopicPartition t0p1 = new TopicPartition("t0", 1);
    private final TopicPartition t1p0 = new TopicPartition("t1", 0);
    private final TopicPartition t1p1 = new TopicPartition("t1", 1);
    private final Map<TopicPartition, OffsetAndMetadata> partitions = new HashMap<TopicPartition, OffsetAndMetadata>();
    private final long offset = 1L;
    private final Node node = new Node(1, "host", 1234);

    @BeforeEach
    public void setUp() {
        this.partitions.put(this.t0p0, new OffsetAndMetadata(1L));
        this.partitions.put(this.t0p1, new OffsetAndMetadata(1L));
        this.partitions.put(this.t1p0, new OffsetAndMetadata(1L));
        this.partitions.put(this.t1p1, new OffsetAndMetadata(1L));
    }

    @Test
    public void testBuildRequest() {
        AlterConsumerGroupOffsetsHandler handler = new AlterConsumerGroupOffsetsHandler("group-id", this.partitions, this.logContext);
        OffsetCommitRequest request = (OffsetCommitRequest)handler.buildBatchedRequest(-1, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id"))).build();
        Assertions.assertEquals((Object)"group-id", (Object)request.data().groupId());
        Assertions.assertEquals((int)2, (int)request.data().topics().size());
        Assertions.assertEquals((int)2, (int)((OffsetCommitRequestData.OffsetCommitRequestTopic)request.data().topics().get(0)).partitions().size());
        Assertions.assertEquals((long)1L, (long)((OffsetCommitRequestData.OffsetCommitRequestPartition)((OffsetCommitRequestData.OffsetCommitRequestTopic)request.data().topics().get(0)).partitions().get(0)).committedOffset());
    }

    @Test
    public void testHandleSuccessfulResponse() {
        AlterConsumerGroupOffsetsHandler handler = new AlterConsumerGroupOffsetsHandler("group-id", this.partitions, this.logContext);
        Map<TopicPartition, Errors> responseData = Collections.singletonMap(this.t0p0, Errors.NONE);
        OffsetCommitResponse response = new OffsetCommitResponse(0, responseData);
        AdminApiHandler.ApiResult result = handler.handleResponse(this.node, Collections.singleton(CoordinatorKey.byGroupId((String)"group-id")), (AbstractResponse)response);
        this.assertCompleted((AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>>)result, responseData);
    }

    @Test
    public void testHandleRetriableResponse() {
        this.assertUnmappedKey(this.partitionErrors(Errors.NOT_COORDINATOR));
        this.assertUnmappedKey(this.partitionErrors(Errors.COORDINATOR_NOT_AVAILABLE));
        this.assertRetriableError(this.partitionErrors(Errors.COORDINATOR_LOAD_IN_PROGRESS));
        this.assertRetriableError(this.partitionErrors(Errors.REBALANCE_IN_PROGRESS));
    }

    @Test
    public void testHandleErrorResponse() {
        this.assertFatalError(this.partitionErrors(Errors.TOPIC_AUTHORIZATION_FAILED));
        this.assertFatalError(this.partitionErrors(Errors.GROUP_AUTHORIZATION_FAILED));
        this.assertFatalError(this.partitionErrors(Errors.INVALID_GROUP_ID));
        this.assertFatalError(this.partitionErrors(Errors.UNKNOWN_TOPIC_OR_PARTITION));
        this.assertFatalError(this.partitionErrors(Errors.OFFSET_METADATA_TOO_LARGE));
        this.assertFatalError(this.partitionErrors(Errors.ILLEGAL_GENERATION));
        this.assertFatalError(this.partitionErrors(Errors.UNKNOWN_MEMBER_ID));
        this.assertFatalError(this.partitionErrors(Errors.INVALID_COMMIT_OFFSET_SIZE));
        this.assertFatalError(this.partitionErrors(Errors.UNKNOWN_SERVER_ERROR));
    }

    @Test
    public void testHandleMultipleErrorsResponse() {
        HashMap<TopicPartition, Errors> partitionErrors = new HashMap<TopicPartition, Errors>();
        partitionErrors.put(this.t0p0, Errors.UNKNOWN_TOPIC_OR_PARTITION);
        partitionErrors.put(this.t0p1, Errors.INVALID_COMMIT_OFFSET_SIZE);
        partitionErrors.put(this.t1p0, Errors.TOPIC_AUTHORIZATION_FAILED);
        partitionErrors.put(this.t1p1, Errors.OFFSET_METADATA_TOO_LARGE);
        this.assertFatalError(partitionErrors);
    }

    private AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> handleResponse(CoordinatorKey groupKey, Map<TopicPartition, OffsetAndMetadata> partitions, Map<TopicPartition, Errors> partitionResults) {
        AlterConsumerGroupOffsetsHandler handler = new AlterConsumerGroupOffsetsHandler(groupKey.idValue, partitions, this.logContext);
        OffsetCommitResponse response = new OffsetCommitResponse(0, partitionResults);
        return handler.handleResponse(this.node, Collections.singleton(groupKey), (AbstractResponse)response);
    }

    private Map<TopicPartition, Errors> partitionErrors(Errors error) {
        HashMap<TopicPartition, Errors> partitionErrors = new HashMap<TopicPartition, Errors>();
        this.partitions.keySet().forEach(partition -> partitionErrors.put((TopicPartition)partition, error));
        return partitionErrors;
    }

    private void assertFatalError(Map<TopicPartition, Errors> partitionResults) {
        CoordinatorKey groupKey = CoordinatorKey.byGroupId((String)"group-id");
        AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result = this.handleResponse(groupKey, this.partitions, partitionResults);
        Assertions.assertEquals(Collections.singleton(groupKey), result.completedKeys.keySet());
        Assertions.assertEquals(partitionResults, result.completedKeys.get(groupKey));
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
    }

    private void assertRetriableError(Map<TopicPartition, Errors> partitionResults) {
        CoordinatorKey groupKey = CoordinatorKey.byGroupId((String)"group-id");
        AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result = this.handleResponse(groupKey, this.partitions, partitionResults);
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.emptyMap(), (Object)result.failedKeys);
    }

    private void assertUnmappedKey(Map<TopicPartition, Errors> partitionResults) {
        CoordinatorKey groupKey = CoordinatorKey.byGroupId((String)"group-id");
        AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result = this.handleResponse(groupKey, this.partitions, partitionResults);
        Assertions.assertEquals(Collections.emptySet(), result.completedKeys.keySet());
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.singletonList(CoordinatorKey.byGroupId((String)"group-id")), (Object)result.unmappedKeys);
    }

    private void assertCompleted(AdminApiHandler.ApiResult<CoordinatorKey, Map<TopicPartition, Errors>> result, Map<TopicPartition, Errors> expected) {
        CoordinatorKey key = CoordinatorKey.byGroupId((String)"group-id");
        Assertions.assertEquals(Collections.emptySet(), result.failedKeys.keySet());
        Assertions.assertEquals(Collections.emptyList(), (Object)result.unmappedKeys);
        Assertions.assertEquals(Collections.singleton(key), result.completedKeys.keySet());
        Assertions.assertEquals(expected, result.completedKeys.get(key));
    }
}

