/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MetadataResponseTest {
    @Test
    void buildClusterTest() {
        Uuid zeroUuid = new Uuid(0L, 0L);
        Uuid randomUuid = Uuid.randomUuid();
        MetadataResponseData.MetadataResponseTopic topicMetadata1 = new MetadataResponseData.MetadataResponseTopic().setName("topic1").setErrorCode(Errors.NONE.code()).setPartitions(Collections.emptyList()).setIsInternal(false);
        MetadataResponseData.MetadataResponseTopic topicMetadata2 = new MetadataResponseData.MetadataResponseTopic().setName("topic2").setErrorCode(Errors.NONE.code()).setTopicId(zeroUuid).setPartitions(Collections.emptyList()).setIsInternal(false);
        MetadataResponseData.MetadataResponseTopic topicMetadata3 = new MetadataResponseData.MetadataResponseTopic().setName("topic3").setErrorCode(Errors.NONE.code()).setTopicId(randomUuid).setPartitions(Collections.emptyList()).setIsInternal(false);
        MetadataResponseData.MetadataResponseTopicCollection topics = new MetadataResponseData.MetadataResponseTopicCollection();
        topics.add(topicMetadata1);
        topics.add(topicMetadata2);
        topics.add(topicMetadata3);
        MetadataResponse metadataResponse = new MetadataResponse(new MetadataResponseData().setTopics(topics), ApiKeys.METADATA.latestVersion());
        Cluster cluster = metadataResponse.buildCluster();
        Assertions.assertNull((Object)cluster.topicName(Uuid.ZERO_UUID));
        Assertions.assertNull((Object)cluster.topicName(zeroUuid));
        Assertions.assertEquals((Object)"topic3", (Object)cluster.topicName(randomUuid));
    }
}

